/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.sca.mservice.costcalc.action.StdCostCalcHelper;
import org.apache.commons.lang3.StringUtils;

public class MatCalcTailDiffFunction
extends GroupReduceFunction {
    private int amtScale = 0;
    private static final long serialVersionUID = 1L;

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }

    public MatCalcTailDiffFunction(int amtScale) {
        this.amtScale = amtScale;
    }

    public void reduce(Iterable<RowX> iter, Collector col) {
        ArrayList allRowX = Lists.newArrayList();
        boolean isFromEffect = true;
        BigDecimal qty = BigDecimal.ZERO;
        int i = 0;
        for (RowX rowX : iter) {
            allRowX.add(rowX);
            if (i == 0) {
                if (StringUtils.isEmpty((CharSequence)rowX.getString(this.getSourceRowMeta().getFieldIndex("datatype_sub")))) {
                    isFromEffect = false;
                }
                qty = rowX.getBigDecimal(this.getSourceRowMeta().getFieldIndex("qty"));
            }
            BigDecimal stdPrice = rowX.getBigDecimal(this.getResultRowMeta().getFieldIndex("amount_sub"));
            rowX.set(this.getResultRowMeta().getFieldIndex("tmpamt"), (Object)qty.multiply(stdPrice).setScale(this.amtScale, RoundingMode.HALF_UP));
            ++i;
        }
        if (isFromEffect) {
            StdCostCalcHelper.effectTailDiff(qty, Lists.newArrayList((Object[])allRowX.toArray()), this.amtScale, "datatype_sub", "subelement_sub", "amount_sub", "tmpamt", this.getSourceRowMeta());
        }
        for (RowX rowX : allRowX) {
            col.collect(rowX);
        }
    }
}

