/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CadListUtils;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.MfgUnAbsorbFeeHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CalcResultMfgEntryRow;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.helper.ProAllocStdHelper;
import kd.macc.sca.mservice.costcalc.ProAllocHelper;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.action.task.CalcPartitionTaskAction;
import kd.macc.sca.mservice.costcalc.action.task.CalcTaskActionParam;
import kd.macc.sca.mservice.costcalc.groupkey.UnAbsorbFeeGroupKey;

public class MfgUnAbsorbFeeCalcAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(MfgUnAbsorbFeeCalcAction.class);
    private static final String LOAD_CAD_MFGFEE_ALLOCCO = "load_cad_mfgfeeallocco";
    private static final String LOAD_SCA_CALCRESULT_SUBELEMENT_MFGFEEAL = "load_sca_calcresult_subelement_mfgfeeal";
    private static final String LOAD_SCA_UNABSORB_DIFF_SUBELEMENT = "load_sca_unabsorbdiff_subelement";
    private static final String DEL_SCA_TOTAL_MFGFEE = "del_sca_totalmfgfee";
    private static final String DEL_SCA_UNABSORB_DIFF = "del_sca_unabsorb_diff";
    private static final String SQL_UPDATE_CALC_RESULT = "update t_sca_calcresult set forgid = ? where fid = ?";
    public CostCalcArgs args;
    public Set<Object> currCostObjectIds = new HashSet<Object>();
    public boolean isOtherCostObjectIds = false;
    private Map<UnAbsorbFeeGroupKey, BigDecimal> totalDiffs = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>(32);
    private Map<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow> createdMfgEntryRow = new HashMap<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow>(32);
    private List<DynamicObject> saveUnAbsorbDiffList = new ArrayList<DynamicObject>();
    private List<DynamicObject> saveMfgfeeList = new ArrayList<DynamicObject>();
    private Map<Long, Set<Long>> unabsorbCostObjectIds = new HashMap<Long, Set<Long>>();
    private Map<Long, Long> elementDetails = null;
    private Set<Long> unabsorbDiffIds_voucher;
    public Set<Long> expireObjectIds = new HashSet<Long>();
    private Set<Long> needGenCalcResultObjectIds = new HashSet<Long>();

    @Override
    public Long getDetailTaskConfigId() {
        if (this.getContext().isFinishCalc()) {
            return 0L;
        }
        return TaskHelper.PDENDENTRY_COSTCENTERCALC_TASKID;
    }

    public MfgUnAbsorbFeeCalcAction() {
    }

    public MfgUnAbsorbFeeCalcAction(CostCalcArgs args, Set<Object> currCostObjectIds, Set<Long> expireObjectIds, boolean isOtherCostObjectIds, Map<Long, Long> elementDetails) {
        this.totalDiffs.clear();
        this.createdMfgEntryRow.clear();
        this.currCostObjectIds.clear();
        this.args = args;
        this.currCostObjectIds = currCostObjectIds;
        this.expireObjectIds = expireObjectIds;
        this.isOtherCostObjectIds = isOtherCostObjectIds;
        this.elementDetails = elementDetails;
    }

    private Map<Long, Long> getElementDetails() {
        HashMap<Long, Long> elementIds = new HashMap<Long, Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadElementDetail", (String)"cad_elementdetail", (String)"subelement, element", null, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                elementIds.put(row.getLong("subelement"), row.getLong("element"));
            }
        }
        return elementIds;
    }

    @Override
    protected void doExecute() {
        this.args = this.getContext().getInputArgs();
        if (!this.args.isCalc().booleanValue()) {
            return;
        }
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "2");
        }
        logger.info("\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\uff1a\u5f00\u59cb");
        this.totalDiffs.clear();
        this.createdMfgEntryRow.clear();
        this.saveUnAbsorbDiffList.clear();
        this.saveMfgfeeList.clear();
        this.needGenCalcResultObjectIds.clear();
        this.currCostObjectIds.clear();
        this.currCostObjectIds.addAll(this.getSingleBatchContext().getCostObjectIds());
        this.elementDetails = this.getElementDetails();
        if (!this.currCostObjectIds.isEmpty()) {
            this.unAbsorbCalc();
        }
        if (this.getSingleBatchContext().getCurrBatchSeq() == 1) {
            Set<Object> otherUnAbCostObjectIds = this.loadOtherCostObjectIds();
            if (this.getContext().getUnAbsorbFactCostobjectIds() == null) {
                this.getContext().setUnAbsorbFactCostobjectIds(new HashSet<Long>(10));
            }
            Set<Long> unAbsorbFactCostobjectIds = this.getContext().getUnAbsorbFactCostobjectIds();
            for (Object id : otherUnAbCostObjectIds) {
                unAbsorbFactCostobjectIds.add((Long)id);
            }
            if (!otherUnAbCostObjectIds.isEmpty()) {
                List splitLists;
                logger.info("otherUnAbCostObjectIds:size={},info={}", (Object)otherUnAbCostObjectIds.size(), otherUnAbCostObjectIds);
                this.isOtherCostObjectIds = true;
                if (!this.needGenCalcResultObjectIds.isEmpty()) {
                    this.genCalcResultObject();
                }
                boolean isMfgUnAbsorbConcurrency = CadBgParamUtils.getCadParamForInt((String)"isMfgUnAbsorbConcurrency", (int)0) == 1;
                int otherMfgUnAbsorbBatch = CadBgParamUtils.getCadParamForInt((String)"otherMfgUnAbsorbBatch", (int)500);
                if (isMfgUnAbsorbConcurrency) {
                    splitLists = CadListUtils.splitLists(new ArrayList<Object>(otherUnAbCostObjectIds), (int)otherMfgUnAbsorbBatch);
                    this.executeByTask(splitLists);
                } else {
                    splitLists = CadListUtils.splitLists(new ArrayList<Object>(otherUnAbCostObjectIds), (int)otherMfgUnAbsorbBatch);
                    for (List curCostObjects : splitLists) {
                        this.totalDiffs.clear();
                        this.createdMfgEntryRow.clear();
                        this.currCostObjectIds.clear();
                        this.currCostObjectIds.addAll(curCostObjects);
                        this.getFinishCalcResult(curCostObjects);
                        logger.info("other unAbCostObjectIds, size = {}", (Object)curCostObjects.size());
                        this.unAbsorbCalc();
                    }
                }
            }
        }
        for (Map.Entry<Long, Set<Long>> entry : this.unabsorbCostObjectIds.entrySet()) {
            Integer count = this.getResultManager().getUnAbsorbCoCounts().computeIfAbsent(entry.getKey(), s -> 0);
            count = count + entry.getValue().size();
            this.getResultManager().getUnAbsorbCoCounts().put(entry.getKey(), count);
        }
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(this.getDetailTaskConfigId(), "2");
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "4");
        }
        logger.info("\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\uff1a\u7ed3\u675f");
    }

    private void executeByTask(List<List<Object>> splitLists) {
        String taskName = String.format(ResManager.loadKDString((String)"\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\u5206\u6279\u751f\u4ea7\u7ec4\u7ec7:%s", (String)"MfgUnAbsorbFeeCalcAction_33", (String)"macc-sca-mservice", (Object[])new Object[0]), this.args.getManuOrgId());
        HashSet<String> taskIds = new HashSet<String>(16);
        int batchIndex = 0;
        for (int i = 0; i < splitLists.size(); ++i) {
            List<Object> singleCostObjectList = splitLists.get(i);
            StringBuilder coIdstr = new StringBuilder();
            for (Object str : singleCostObjectList) {
                coIdstr.append(str).append(",");
            }
            logger.info("\u672a\u5438\u6536\u8d39\u7528\u8ba1\u7b97\u5206\u6279\u751f\u4ea7\u7ec4\u7ec7: " + this.args.getManuOrgId() + " total task currBatchDm:" + coIdstr);
            CalcTaskActionParam params = new CalcTaskActionParam();
            params.setInputArgs(this.args);
            params.setCostObjectIdList(singleCostObjectList);
            params.setTaskType(this.getContext().getTaskType());
            params.setCurrBatchSeq(i + 1);
            params.setBatchCount(splitLists.size());
            taskIds.add(this.sendTask(taskName, params, splitLists.size(), batchIndex++));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", taskIds);
            completedFilter.and("status", "in", CalcPartitionTaskAction.completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            int executedNum = runningTasks.size();
            int totalNum = taskIds.size();
            if (executedNum == totalNum) {
                QFilter failTaskFilter = new QFilter("id", "in", taskIds);
                failTaskFilter.and("status", "=", (Object)"FAILED");
                failTaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTaskFilter.toArray());
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)failTasks)) {
                    throw new KDBizException(taskName + "task\uff0cPartitionTaskService.execute failed\u3002");
                }
                return;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                continue;
            }
            break;
        }
    }

    private String sendTask(String taskName, CalcTaskActionParam params, int totalBatch, int currbatch) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        try {
            jobParams.put("param", JSONUtils.toString((Object)params));
            jobParams.put("expireObjectIds", JSONUtils.toString(this.expireObjectIds));
            jobParams.put("args", JSONUtils.toString((Object)this.args));
            jobParams.put("elementDetails", JSONUtils.toString(this.elementDetails));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String OpName = ResManager.loadKDString((String)"\u3010{0}\u3011\uff0c\u7b2c\u3010{1}\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:{2}", (String)"MfgUnAbsorbFeeCalcAction_34", (String)"macc-sca-mservice", (Object[])new Object[0]);
        OpName = MessageFormat.format(OpName, taskName + ",TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("sca");
        job.setTaskClassname("kd.macc.sca.mservice.costcalc.action.task.MfgUnAbsorbFeeCalcTaskAction");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }

    public void unAbsorbCalc() {
        boolean isAdjectBill;
        this.clearVariable();
        this.delCostAdjustByUnabsorbdiff();
        this.delUnabsorbDiff();
        this.delTotalMfgfee();
        if (this.isOtherCostObjectIds) {
            this.currCostObjectIds.removeAll(this.expireObjectIds);
            if (this.currCostObjectIds.isEmpty()) {
                return;
            }
        }
        this.loadPrePeriodMfgFee();
        this.loadTotalMfgFeeal();
        this.loadSubElementMfgFeeal();
        this.loadSubElementUnAbsorb();
        this.doCalculate();
        if (this.isOtherCostObjectIds) {
            CalcResultHeader value;
            Map<Long, CalcResultHeader> finResults = this.getSingleBatchResultManager().getFinResults();
            ArrayList saveCalcMfgEntryRows = new ArrayList(10);
            for (Map.Entry<Long, CalcResultHeader> entry : finResults.entrySet()) {
                value = entry.getValue();
                saveCalcMfgEntryRows.addAll(value.getMfgEntryRows());
            }
            if (!saveCalcMfgEntryRows.isEmpty()) {
                String absobEntrySql = "insert into T_SCA_UNABSORBENTRY(fentryid,fid,fseq,ftype,felementid,fsubelementid,fpdstartqty,fpdstartamt,fpdcurrqty,fpdcurramt,fpdendqty,fpdendamt,fpddiffqty,fpddiffamt,ftotaldiffqty,ftotaldiffamt,fsourceinfo,fmfgobjid,fmfgprotype) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                List list = Lists.partition(saveCalcMfgEntryRows, (int)2000);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                for (List list2 : list) {
                    for (CalcResultMfgEntryRow row : list2) {
                        Object[] paramArr = new Object[]{row.getEntryId(), row.getId(), row.getSeq(), row.getType(), row.getMfgElement(), row.getMfgSubElement(), row.getMfgPdStartQty(), row.getMfgPdStartAmt(), row.getMfgPdCurrQty(), row.getMfgPdCurrAmt(), row.getMfgPdEndQty(), row.getMfgPdEndAmt(), row.getMfgPdDiffQty(), row.getMfgPdDiffAmt(), row.getMfgTotalDiffQty(), row.getMfgTotalDiffAmt(), row.getMfgSourceInfo(), row.getCostObjectId(), row.getProductType()};
                        paramList.add(paramArr);
                    }
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
                        this.executeBatch(absobEntrySql, paramList);
                    }
                    paramList.clear();
                }
            }
            for (Map.Entry entry : finResults.entrySet()) {
                value = (CalcResultHeader)entry.getValue();
                value.getMfgEntryRows().clear();
            }
        }
        if (!this.saveUnAbsorbDiffList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.saveUnAbsorbDiffList.toArray(new DynamicObject[0]));
            logger.info(String.format("\u751f\u6210\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355 %s \u5f20", this.saveUnAbsorbDiffList.size()));
        }
        if (!this.saveMfgfeeList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])this.saveMfgfeeList.toArray(new DynamicObject[0]));
            logger.info(String.format("\u751f\u6210\u5b50\u8981\u7d20\u603b\u5236\u9020\u8d39\u7528\u5355 %s \u5f20", this.saveMfgfeeList.size()));
        }
        if (isAdjectBill = MfgUnAbsorbFeeCalcAction.isAdjectBill(this.args)) {
            String param = CostCalcArgs.toJSONString((CostCalcArgs)this.args);
            CalcDataArgs oldVarArgs = FinishCalcHelper.getCalcDataArgs((String)param);
            Set<Long> set = this.getSingleBatchContext().getMfgMainSideObjIds(this.currCostObjectIds);
            oldVarArgs.setCostObjects(new HashSet<Long>(set));
            oldVarArgs.setUnAbCostObjects(new HashSet<Long>(set));
            MfgUnAbsorbFeeHelper.unabsorbFeeToCalNotCheck((CalcDataArgs)oldVarArgs);
        }
    }

    private static boolean isAdjectBill(CostCalcArgs args) {
        Long orgId = Long.valueOf(String.valueOf(args.getOrgId()));
        Long costAccountId = Long.valueOf(String.valueOf(args.getCostAccountId()));
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"sca");
        QFilter qfStrategy = new QFilter("reductstrategy", "=", (Object)"ITEMIZED_REDUCT");
        return !QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfAppNum, qfStrategy});
    }

    private void saveFinishCalcResult() {
        ArrayList<CalcResultHeader> saveCalcResultHeaders = new ArrayList<CalcResultHeader>(10);
        ArrayList<CalcResultEntryRow> saveCalcResultEntryRows = new ArrayList<CalcResultEntryRow>(10);
        Long userId = RequestContext.get().getCurrUserId();
        Date modifyTime = TimeServiceHelper.now();
        if (!CadEmptyUtils.isEmpty(this.getSingleBatchResultManager().getNeedGenCalcResult())) {
            for (CalcResultHeader calcResult : this.getSingleBatchResultManager().getNeedGenCalcResult()) {
                saveCalcResultHeaders.add(calcResult);
                this.getResultManager().getCalcResultIds().add(calcResult.getId());
                calcResult.setModifier(userId.longValue());
                calcResult.setModifyTime(modifyTime);
                for (int i = 0; i < calcResult.getEntryRows().size(); ++i) {
                    CalcResultEntryRow entryRow = (CalcResultEntryRow)calcResult.getEntryRows().get(i);
                    entryRow.setSeq(i + 1);
                    saveCalcResultEntryRows.add(entryRow);
                }
            }
        }
        if (!saveCalcResultHeaders.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)CalcResultHeader.getDataEntityType(), (Object[])saveCalcResultHeaders.toArray());
        }
        if (!saveCalcResultEntryRows.isEmpty()) {
            String entryInsertSql = "insert into t_sca_calcresultentry(fentryid,fid,fseq,fdatatype,fcaltype,fdifftype,felementid,fsubelementid,fresourceid,fcalcbasis,fcostlevel,fcostobjectid,fproducttype,fmaterialid,fauxpty,fmatversionid,fkeycol,fkeycolid,fpdstartqty,fpdstartamount,fpdcurrtqty,fpdcurramount,fpdcompqty,fpdcompanount,fpdendqty,fpdendamount,ftotalqty,ftotalamount,fstdqty,fstdamount,fdiffqty,fdiff,fcostupdatediff,fcostupdatediffamt,fsourceinfo) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            List splitLists = Lists.partition(saveCalcResultEntryRows, (int)1000);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (List list : splitLists) {
                for (CalcResultEntryRow row : list) {
                    if (row.getDataType() == null) continue;
                    Object[] paramArr = new Object[]{row.getEntryId(), row.getId(), row.getSeq(), row.getDataType(), row.getCalType(), this.getDbStr(row.getDiffType()), row.getElement(), row.getSubElement(), row.getResource(), this.getDbStr(row.getCalcbasis()), this.getDbStr(row.getCostLevel()), row.getCostObject(), row.getProductType(), row.getMaterial(), row.getAuxpty(), row.getMatVersion(), this.getDbStr(row.getKeycol()), row.getKeycolId(), row.getPdStartQty(), row.getPdStartAmount(), row.getPdCurrQty(), row.getPdCurrAmount(), row.getPdCompQty(), row.getPdCompAmount(), row.getPdEndQty(), row.getPdEndAmount(), row.getTotalQty(), row.getTotalAmount(), row.getStdQty(), row.getStdAmount(), row.getDiffQty(), row.getDiffAmount(), row.getCostUpdateDiffQty(), row.getCostUpdateDiffAmount(), row.getSourceInfo()};
                    paramList.add(paramArr);
                }
                try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
                    this.executeBatch(entryInsertSql, paramList);
                }
                paramList.clear();
            }
        }
    }

    private String getDbStr(String key) {
        if (key == null) {
            return " ";
        }
        return key;
    }

    private void loadPrePeriodMfgFee() {
        ArrayList qFilterList = Lists.newArrayList();
        qFilterList.add(new QFilter("org", "=", (Object)this.args.getOrgId()));
        qFilterList.add(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        qFilterList.add(new QFilter("period", "=", (Object)this.args.getPrePeriodId()));
        if (!CadEmptyUtils.isEmpty((List)this.args.getCostCenterIds())) {
            qFilterList.add(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
        }
        qFilterList.add(new QFilter("unabsorbentry.mfgType", "=", (Object)"1"));
        qFilterList.add(new QFilter("costobject", "in", this.getSingleBatchContext().getMfgMainSideObjIds(this.currCostObjectIds)));
        String selectedFields = "costobject,costcenter,period,unabsorbentry.mfgtype as mfgtype,0 as type,unabsorbentry.mfgsubelement subelement,unabsorbentry.mfgpdendqty pdendqty,unabsorbentry.mfgpdendamt amount,unabsorbentry.mfgtotaldiffqty totaldiffqty,unabsorbentry.mfgtotaldiffamt totaldiffamt,unabsorbentry.mfgobj belongobj,unabsorbentry.mfgprotype producttype";
        int rowCount = 0;
        try (DataSet preCalcResultDs = QueryServiceHelper.queryDataSet((String)"mfgUnAbsorbFeeCalcAction.loadPrePeriodMfgFee", (String)"sca_calcresult", (String)selectedFields, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"id desc,unabsorbentry.mfgtype desc");){
            while (preCalcResultDs.hasNext()) {
                Row entryRow = preCalcResultDs.next();
                BigDecimal preEndAmt = entryRow.getBigDecimal("amount");
                BigDecimal preEndQty = entryRow.getBigDecimal("pdendqty");
                ++rowCount;
                Long subElementId = entryRow.getLong("subelement");
                UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(entryRow.getLong("costcenter"), entryRow.getLong("costobject"), entryRow.getLong("belongobj"), entryRow.getString("producttype"), entryRow.getLong("subelement"), entryRow.getInteger("type"));
                CalcResultMfgEntryRow mfgEntryRow = this.createdMfgEntryRow.computeIfAbsent(key, s -> new CalcResultMfgEntryRow());
                if (!CadEmptyUtils.isEmpty((Long)subElementId)) {
                    mfgEntryRow.setMfgElement(this.elementDetails.get(subElementId).longValue());
                }
                mfgEntryRow.setMfgSubElement(subElementId.longValue());
                mfgEntryRow.setMfgPdStartQty(preEndQty);
                mfgEntryRow.setMfgPdStartAmt(preEndAmt);
                mfgEntryRow.addTaskValInfo("this", "", String.format("PreEndAmt %s", preEndAmt), "PdStartAmt", preEndAmt);
                mfgEntryRow.setMfgPreTotalDiffQty(entryRow.getBigDecimal("totaldiffqty"));
                mfgEntryRow.setMfgPreTotalDiffAmt(entryRow.getBigDecimal("totaldiffamt"));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u4e0a\u671f\u8ba1\u7b97\u7ed3\u679c\u5355\uff08sca_calcresult\uff09\u5236\u8d39\u672a\u5438\u6536\u6570\u636e\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilterList)));
    }

    private void clearVariable() {
        this.totalDiffs.clear();
        this.saveUnAbsorbDiffList.clear();
        this.saveMfgfeeList.clear();
        this.unabsorbDiffIds_voucher = null;
    }

    private void doCalculate() {
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> subTotalMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>();
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>();
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> costobjectUnAbsorbMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>();
        HashMap<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> subTotalResultMap = new HashMap();
        HashMap<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> unAbsorbResultMap = new HashMap();
        HashMap<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow> sumRowMap = new HashMap<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow>(8);
        this.totalSubtractAbsorb(unAbsorbMap, subTotalMap);
        Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap = this.getSingleBatchContext().getMfgObjectInfosMap(this.currCostObjectIds);
        if (CadEmptyUtils.isEmpty(objectInfosMap)) {
            logger.info("\u672a\u67e5\u8be2\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4fe1\u606f\uff0c\u8df3\u8fc7");
            return;
        }
        this.unAbsorbProAlloc(unAbsorbMap, objectInfosMap);
        this.addMainJoinRow(unAbsorbMap, objectInfosMap);
        this.addExtraRow();
        this.addMainJoinSumRow(sumRowMap, objectInfosMap);
        if (CadEmptyUtils.isEmpty(unAbsorbMap)) {
            return;
        }
        this.removeVoucher(unAbsorbMap);
        this.totalCostObjectUnAbsorbAmount(unAbsorbMap, costobjectUnAbsorbMap);
        unAbsorbResultMap = this.getResultAbsorbMap(unAbsorbMap);
        subTotalResultMap = this.getResultAbsorbMap(subTotalMap);
        this.insetUnabsorb(unAbsorbResultMap, costobjectUnAbsorbMap);
        this.insetTotalMfgFee(subTotalResultMap);
    }

    public void addExtraRow() {
        if (!this.createdMfgEntryRow.isEmpty()) {
            for (Map.Entry<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow> extraRow : this.createdMfgEntryRow.entrySet()) {
                UnAbsorbFeeGroupKey key = extraRow.getKey();
                Long costObjectId = key.getCostObjectId();
                CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(costObjectId);
                if (calcResultHeader == null) {
                    calcResultHeader = this.getSingleBatchResultManager().getFinResults().get(costObjectId);
                }
                if (calcResultHeader == null) {
                    DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
                    this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61:", (String)"MfgUnAbsorbFeeCalcAction_25", (String)"macc-sca-mservice", (Object[])new Object[0]).concat(costObjectDy == null ? "" : costObjectDy.getString("name")).concat(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u7ed3\u679c\u5355\u3002", (String)"MfgUnAbsorbFeeCalcAction_26", (String)"macc-sca-mservice", (Object[])new Object[0])));
                    continue;
                }
                CalcResultMfgEntryRow joinRow = this.createdMfgEntryRow.get(key);
                CalcResultMfgEntryRow entryRow = calcResultHeader.addMfgFeeEntry("1");
                entryRow.setCostObjectId(key.getBelongObjectId());
                entryRow.setProductType(key.getProductType());
                entryRow.setMfgPdDiffQty(joinRow.getMfgPdDiffQty());
                entryRow.setMfgPdDiffAmt(joinRow.getMfgPdDiffAmt());
                entryRow.setMfgPdStartQty(joinRow.getMfgPdStartQty());
                entryRow.setMfgPdStartAmt(joinRow.getMfgPdStartAmt());
                entryRow.setMfgPdCurrQty(joinRow.getMfgPdCurrQty());
                entryRow.setMfgPdCurrAmt(joinRow.getMfgPdCurrAmt());
                entryRow.setMfgPdEndQty(joinRow.getMfgPdEndQty());
                entryRow.setMfgPdEndAmt(joinRow.getMfgPdStartAmt());
                entryRow.setMfgElement(joinRow.getMfgElement());
                entryRow.setMfgSubElement(joinRow.getMfgSubElement());
                entryRow.addMfgTotalDiffQty(joinRow.getMfgPreTotalDiffQty());
                entryRow.addMfgTotalDiffAmt(joinRow.getMfgPreTotalDiffAmt());
                entryRow.addAllTaskValInfos(joinRow, "PdStartQty");
                entryRow.addAllTaskValInfos(joinRow, "PdStartAmount");
                entryRow.addAllTaskValInfos(joinRow, "PdCurrQty");
                entryRow.addAllTaskValInfos(joinRow, "PdCurrAmount");
                entryRow.addAllTaskValInfos(joinRow, "DiffAmount");
                entryRow.addAllTaskValInfos(joinRow, "PdEndQty");
                entryRow.addAllTaskValInfos(joinRow, "PdEndAmount");
                entryRow.addAllTaskValInfos(joinRow, "DiffQty");
                entryRow.addAllTaskValInfos(joinRow, "DiffAmt");
                entryRow.addAllTaskValInfos(joinRow, "TotalDiffQty");
                entryRow.addAllTaskValInfos(joinRow, "TotalDiffAmt");
            }
        }
    }

    public void getFinishCalcResult(List<Object> batchObjIds) {
        CostCalcArgs inputArgs = this.getContext().getInputArgs();
        Long orgId = inputArgs.getOrgId();
        Long costAccountId = inputArgs.getCostAccountId();
        Long periodId = inputArgs.getPeriodId();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)periodId);
        if (!CadEmptyUtils.isEmpty(batchObjIds)) {
            HashSet<Long> costObjectIds = new HashSet<Long>(batchObjIds.size());
            for (Object currentObjId : batchObjIds) {
                costObjectIds.add(Long.parseLong(String.valueOf(currentObjId)));
            }
            periodQf.and("costobject", "in", costObjectIds);
        }
        QFilter bizStatusQf = new QFilter("bizstatus", "=", (Object)"B");
        HashSet<Long> resultIds = new HashSet<Long>(64);
        Object[] objectArray = null;
        try (DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"MfgUnAbsorbFeeCalcAction_getFinishCalcResult", (String)"sca_calcresult", (String)"id", (QFilter[])new QFilter[]{orgQf, costAccountQf, periodQf, bizStatusQf}, (String)"id desc");){
            while (calcDataSet.hasNext()) {
                Row row = calcDataSet.next();
                resultIds.add(row.getLong("id"));
            }
        }
        catch (Throwable row) {
            objectArray = row;
            throw row;
        }
        if (!CadEmptyUtils.isEmpty(resultIds)) {
            Object[] calcResults = BusinessDataServiceHelper.load((String)"sca_calcresult", (String)"id,billno,org.id,costaccount.id,costcenter.id,currency.id,period.id,costobject.id,bizdate,billstatus,bizstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", resultIds)});
            if (!CadEmptyUtils.isEmpty((Object[])calcResults)) {
                for (Object calcResult : calcResults) {
                    CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getFinResults().computeIfAbsent(calcResult.getLong("costobject.id"), s -> new CalcResultHeader());
                    calcResultHeader.setId(calcResult.getLong("id"));
                    calcResultHeader.setBillNo(calcResult.getString("billno"));
                    calcResultHeader.setOrg(calcResult.getLong("org.id"));
                    calcResultHeader.setCostAccount(calcResult.getLong("costaccount.id"));
                    calcResultHeader.setCostCenter(calcResult.getLong("costcenter.id"));
                    calcResultHeader.setCurrency(calcResult.getLong("currency.id"));
                    calcResultHeader.setPeriod(calcResult.getLong("period.id"));
                    calcResultHeader.setCostObject(calcResult.getLong("costobject.id"));
                    calcResultHeader.setBizDate(calcResult.getDate("bizdate"));
                    calcResultHeader.setBillStatus(calcResult.getString("billstatus"));
                    calcResultHeader.setBizStatus(calcResult.getString("bizstatus"));
                }
            }
            DBRoute dbRoute = new DBRoute("cal");
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)periodId)});){
                List allList = Lists.partition((List)Lists.newArrayList(resultIds), (int)10000);
                for (List list : allList) {
                    this.deleteUnAbsorbEntryData(dbRoute, list);
                }
            }
        }
    }

    private void deleteUnAbsorbEntryData(DBRoute dbRoute, List<Long> list) {
        String deleteSql = "delete from t_sca_unabsorbentry where fid in " + MfgUnAbsorbFeeCalcAction.getInStringFromSet2(list) + "";
        DB.execute((DBRoute)dbRoute, (String)deleteSql);
    }

    public static String getInStringFromSet2(List<Long> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuilder in = new StringBuilder();
        in.append(" (");
        Iterator<Long> iter = list.iterator();
        while (iter.hasNext()) {
            in.append(((Object)iter.next()).toString());
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    private void genCalcResultObject() {
        this.expireCalcResult(this.needGenCalcResultObjectIds);
        CostCalcArgs inputArgs = this.getContext().getInputArgs();
        Long orgId = inputArgs.getOrgId();
        Long costAccountId = inputArgs.getCostAccountId();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter bizStatusQf = new QFilter("bizstatus", "=", (Object)"B");
        bizStatusQf.and("costobject", "in", this.needGenCalcResultObjectIds);
        HashSet<Long> resultIds = new HashSet<Long>(64);
        DataSet calcDataSet = QueryServiceHelper.queryDataSet((String)"MfgUnAbsorbFeeCalcAction_getFinishCalcResult", (String)"sca_calcresult", (String)"id,costobject,period", (QFilter[])new QFilter[]{orgQf, costAccountQf, bizStatusQf}, null);
        calcDataSet = calcDataSet.groupBy(new String[]{"costobject"}).maxP("period", "id").finish();
        for (Row row : calcDataSet) {
            resultIds.add(row.getLong("id"));
        }
        if (CadEmptyUtils.isEmpty(resultIds)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_calcresult");
        Object[] calcResults = BusinessDataServiceHelper.load((Object[])resultIds.toArray(new Object[0]), (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty((Object[])calcResults)) {
            return;
        }
        for (Object calcResult : calcResults) {
            Long costobjectId = calcResult.getLong("costobject.id");
            if (this.getSingleBatchResultManager().getFinResults().containsKey(costobjectId)) continue;
            CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getFinResults().computeIfAbsent(costobjectId, s -> new CalcResultHeader());
            this.getSingleBatchResultManager().getNeedGenCalcResult().add(calcResultHeader);
            calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
            calcResultHeader.setBillNo("NO.WQ." + System.currentTimeMillis());
            calcResultHeader.setOrg(calcResult.getLong("org.id"));
            calcResultHeader.setCostAccount(calcResult.getLong("costaccount.id"));
            calcResultHeader.setCostCenter(calcResult.getLong("costcenter.id"));
            calcResultHeader.setCurrency(calcResult.getLong("currency.id"));
            calcResultHeader.setPeriod(inputArgs.getPeriodId().longValue());
            calcResultHeader.setCostObject(calcResult.getLong("costobject.id"));
            Object bizDate = TimeUtils.compareToEndDate((Date)this.getContext().getInputArgs().getEndDate());
            if (bizDate != null) {
                if (bizDate instanceof Date) {
                    calcResultHeader.setBizDate((Date)bizDate);
                } else if (bizDate instanceof Calendar) {
                    calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
                }
            }
            calcResultHeader.setBillStatus(calcResult.getString("billstatus"));
            calcResultHeader.setBizStatus(calcResult.getString("bizstatus"));
            DynamicObjectCollection calcResultEntry = calcResult.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : calcResultEntry) {
                CalcResultEntryRow entryRow = calcResultHeader.addNew();
                entryRow.setResource(entry.getLong("resource.id"));
                entryRow.setCostLevel(entry.getString("costlevel"));
                entryRow.setCalcbasis(entry.getString("calcbasis"));
                entryRow.setElement(entry.getLong("element.id"));
                entryRow.setSubElement(entry.getLong("subelement.id"));
                entryRow.setMaterial(entry.getLong("material.id"));
                entryRow.setAuxpty(entry.getLong("auxpty.id"));
                entryRow.setMatVersion(entry.getLong("matversion.id"));
                entryRow.setCostObject(entry.getLong("obj.id"));
                entryRow.setProductType(entry.getString("producttype"));
                entryRow.setDataType(entry.getString("datatype"));
                entryRow.setCalType(entry.getString("caltype"));
                entryRow.setDiffType(entry.getString("difftype"));
                entryRow.setStdAmount(entry.getBigDecimal("stdamount"));
                entryRow.setStdQty(entry.getBigDecimal("stdqty"));
                entryRow.setTotalAmount(entry.getBigDecimal("totalamount"));
                entryRow.setTotalQty(entry.getBigDecimal("totalqty"));
                entryRow.setCostUpdateDiffAmount(entry.getBigDecimal("costupdatediffamt"));
                entryRow.setCostUpdateDiffQty(entry.getBigDecimal("costupdatediffqty"));
            }
            DynamicObjectCollection calcMftEntry = calcResult.getDynamicObjectCollection("unabsorbentry");
            for (DynamicObject mftentry : calcMftEntry) {
                String mfgType = mftentry.getString("mfgType");
                if (!"1".equals(mfgType)) continue;
                Long subelementId = mftentry.getLong("mfgsubelement.id");
                UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(calcResult.getLong("costcenter.id"), calcResult.getLong("costobject.id"), mftentry.getLong("mfgobj.id"), mftentry.getString("mfgprotype"), subelementId, mftentry.getInt("mfgtype"));
                CalcResultMfgEntryRow mfgEntryRow = this.createdMfgEntryRow.computeIfAbsent(key, s -> new CalcResultMfgEntryRow());
                if (!CadEmptyUtils.isEmpty((Long)subelementId)) {
                    mfgEntryRow.setMfgElement(this.elementDetails.get(subelementId).longValue());
                }
                mfgEntryRow.setMfgSubElement(subelementId.longValue());
                mfgEntryRow.setMfgPdStartQty(mftentry.getBigDecimal("mfgpdendqty"));
                mfgEntryRow.setMfgPdStartAmt(mftentry.getBigDecimal("mfgpdendamt"));
                mfgEntryRow.setMfgPreTotalDiffQty(mftentry.getBigDecimal("mfgtotaldiffqty"));
                mfgEntryRow.setMfgPreTotalDiffAmt(mftentry.getBigDecimal("mfgtotaldiffamt"));
            }
        }
        this.saveFinishCalcResult();
    }

    private void expireCalcResult(Set<Long> resultObjectIds) {
        ArrayList<Object> costobjectIds = new ArrayList<Object>();
        costobjectIds.addAll(resultObjectIds);
        QFilter filter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, costobjectIds, true, true, true);
        HashSet<Long> calcResultIds = new HashSet<Long>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"calcResult", (String)"sca_calcresult", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                calcResultIds.add(row.getLong(0));
            }
        }
        catch (Throwable row) {
            object = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)object).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (calcResultIds == null || calcResultIds.isEmpty()) {
            return;
        }
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(calcResultIds.size());
        for (Long id : calcResultIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("org", -5, (Object)999999L), new SqlParameter("id", -5, (Object)id)};
            paramsList.add(params);
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)SQL_UPDATE_CALC_RESULT, paramsList);
        }
    }

    private void addMainJoinSumRow(Map<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow> sumRowMap, Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap) {
        if (!this.isOtherCostObjectIds) {
            this.addSumRowByHeader(this.getSingleBatchResultManager().getCalcResults(), sumRowMap, objectInfosMap);
        } else {
            this.addSumRowByHeader(this.getSingleBatchResultManager().getFinResults(), sumRowMap, objectInfosMap);
        }
    }

    private void addSumRowByHeader(Map<Long, CalcResultHeader> resultMap, Map<UnAbsorbFeeGroupKey, CalcResultMfgEntryRow> sumRowMap, Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap) {
        for (Object object : this.currCostObjectIds) {
            Long costObjectId = Long.parseLong(String.valueOf(object));
            if (!resultMap.containsKey(costObjectId)) continue;
            CalcResultHeader header = resultMap.get(costObjectId);
            long costObject = header.getCostObject();
            long costCenter = header.getCostCenter();
            List mfgEntryRows = header.getMfgEntryRows();
            for (CalcResultMfgEntryRow mfgEntryRow : mfgEntryRows) {
                long belongObjId = mfgEntryRow.getCostObjectId();
                String productType = mfgEntryRow.getProductType();
                UnAbsorbFeeGroupKey sumKey = new UnAbsorbFeeGroupKey(costCenter, costObject, belongObjId, productType, 0L, 0);
                CalcResultMfgEntryRow sumRow = sumRowMap.computeIfAbsent(sumKey, s -> new CalcResultMfgEntryRow());
                if (!CadEmptyUtils.isEmpty(objectInfosMap)) {
                    CalcResultObjectInfo objectInfo;
                    Map<Long, CalcResultObjectInfo> objectInfoMap = objectInfosMap.get(costObject);
                    if (!CadEmptyUtils.isEmpty(objectInfoMap) && (objectInfo = objectInfoMap.get(belongObjId)) != null) {
                        BigDecimal startQty = objectInfo.getStartQty();
                        BigDecimal planQty = objectInfo.getPlanQty();
                        BigDecimal finishQty = objectInfo.getFinishQty();
                        sumRow.setMfgPdStartQty(startQty);
                        sumRow.setMfgPdCurrQty(planQty);
                        sumRow.setMfgPdDiffQty(finishQty);
                        sumRow.setMfgPdEndQty(startQty.add(planQty).subtract(finishQty));
                    }
                } else {
                    sumRow.setMfgPdStartQty(mfgEntryRow.getMfgPdStartQty());
                    sumRow.setMfgPdCurrQty(mfgEntryRow.getMfgPdCurrQty());
                    sumRow.setMfgPdDiffQty(mfgEntryRow.getMfgPdDiffQty());
                    sumRow.setMfgPdEndQty(mfgEntryRow.getMfgPdEndQty());
                }
                sumRow.addMfgPdStartAmt(mfgEntryRow.getMfgPdStartAmt());
                sumRow.addMfgPdCurrAmt(mfgEntryRow.getMfgPdCurrAmt());
                sumRow.addMfgPdEndAmt(mfgEntryRow.getMfgPdEndAmt());
                sumRow.addMfgPdDiffAmt(mfgEntryRow.getMfgPdDiffAmt());
                sumRow.setMfgTotalDiffQty(mfgEntryRow.getMfgTotalDiffQty());
                sumRow.addMfgTotalDiffAmt(mfgEntryRow.getMfgTotalDiffAmt());
            }
        }
        if (!CadEmptyUtils.isEmpty(sumRowMap)) {
            for (Map.Entry entry : sumRowMap.entrySet()) {
                UnAbsorbFeeGroupKey key = (UnAbsorbFeeGroupKey)entry.getKey();
                Long costObjectId = key.getCostObjectId();
                long belongObjectId = key.getBelongObjectId();
                String productType = key.getProductType();
                CalcResultMfgEntryRow sumRow = (CalcResultMfgEntryRow)entry.getValue();
                CalcResultHeader calcResultHeader = resultMap.get(costObjectId);
                if (calcResultHeader == null) {
                    return;
                }
                CalcResultMfgEntryRow mfgSumRow = calcResultHeader.addMfgFeeEntry("5");
                mfgSumRow.setCostObjectId(belongObjectId);
                mfgSumRow.setProductType(productType);
                mfgSumRow.setMfgPdStartQty(sumRow.getMfgPdStartQty());
                mfgSumRow.setMfgPdStartAmt(sumRow.getMfgPdStartAmt());
                mfgSumRow.setMfgPdCurrQty(sumRow.getMfgPdCurrQty());
                mfgSumRow.setMfgPdCurrAmt(sumRow.getMfgPdCurrAmt());
                mfgSumRow.setMfgPdEndQty(sumRow.getMfgPdEndQty());
                mfgSumRow.setMfgPdEndAmt(sumRow.getMfgPdEndAmt());
                mfgSumRow.setMfgPdDiffQty(sumRow.getMfgPdDiffQty());
                mfgSumRow.setMfgPdDiffAmt(sumRow.getMfgPdDiffAmt());
                mfgSumRow.setMfgTotalDiffQty(sumRow.getMfgTotalDiffQty());
                mfgSumRow.setMfgTotalDiffAmt(sumRow.getMfgTotalDiffAmt());
            }
        }
        sumRowMap.clear();
    }

    private void addMainJoinRow(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap, Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap) {
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> joinMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>(16);
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbEntry : unAbsorbMap.entrySet()) {
            UnAbsorbFeeGroupKey key = unAbsorbEntry.getKey();
            Long costObjectId = key.getCostObjectId();
            CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(costObjectId);
            if (calcResultHeader == null) {
                calcResultHeader = this.getSingleBatchResultManager().getFinResults().get(costObjectId);
            }
            if (calcResultHeader == null) {
                DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"name");
                this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), key.getCostCenterid(), ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61:", (String)"MfgUnAbsorbFeeCalcAction_25", (String)"macc-sca-mservice", (Object[])new Object[0]).concat(costObjectDy == null ? "" : costObjectDy.getString("name")).concat(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8ba1\u7b97\u7ed3\u679c\u5355\u3002", (String)"MfgUnAbsorbFeeCalcAction_26", (String)"macc-sca-mservice", (Object[])new Object[0])));
                continue;
            }
            Map<Long, CalcResultObjectInfo> objectInfoMap = objectInfosMap.get(costObjectId);
            if (objectInfoMap == null || objectInfoMap.isEmpty()) continue;
            for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objectInfoMap.entrySet()) {
                CalcResultObjectInfo objectInfo = objectInfoEntry.getValue();
                String productType = objectInfo.getProductType();
                long joinSideCostObjectId = objectInfo.getCostObjectId();
                UnAbsorbFeeGroupKey joinSideKey = new UnAbsorbFeeGroupKey(key.getCostCenterid(), key.getCostObjectId(), joinSideCostObjectId, productType, key.getSubelementId(), key.getSourceType());
                if (!this.createdMfgEntryRow.containsKey(joinSideKey)) continue;
                CalcResultMfgEntryRow joinRow = this.createdMfgEntryRow.remove(joinSideKey);
                CalcResultMfgEntryRow entryRow = calcResultHeader.addMfgFeeEntry("1");
                entryRow.setCostObjectId(joinSideCostObjectId);
                entryRow.setProductType(productType);
                entryRow.setMfgPdDiffQty(joinRow.getMfgPdDiffQty());
                entryRow.setMfgPdDiffAmt(joinRow.getMfgPdDiffAmt());
                entryRow.setMfgPdStartQty(joinRow.getMfgPdStartQty());
                entryRow.setMfgPdStartAmt(joinRow.getMfgPdStartAmt());
                entryRow.setMfgPdCurrQty(joinRow.getMfgPdCurrQty());
                entryRow.setMfgPdCurrAmt(joinRow.getMfgPdCurrAmt());
                entryRow.setMfgPdEndQty(joinRow.getMfgPdEndQty());
                entryRow.setMfgPdEndAmt(joinRow.getMfgPdEndAmt());
                entryRow.setMfgElement(joinRow.getMfgElement());
                entryRow.setMfgSubElement(joinRow.getMfgSubElement());
                entryRow.addMfgTotalDiffQty(joinRow.getMfgTotalDiffQty());
                entryRow.addMfgTotalDiffAmt(joinRow.getMfgTotalDiffAmt());
                entryRow.addAllTaskValInfos(joinRow, "PdStartQty");
                entryRow.addAllTaskValInfos(joinRow, "PdStartAmount");
                entryRow.addAllTaskValInfos(joinRow, "PdCurrQty");
                entryRow.addAllTaskValInfos(joinRow, "PdCurrAmount");
                entryRow.addAllTaskValInfos(joinRow, "DiffAmount");
                entryRow.addAllTaskValInfos(joinRow, "PdEndQty");
                entryRow.addAllTaskValInfos(joinRow, "PdEndAmount");
                entryRow.addAllTaskValInfos(joinRow, "DiffQty");
                entryRow.addAllTaskValInfos(joinRow, "DiffAmt");
                entryRow.addAllTaskValInfos(joinRow, "TotalDiffQty");
                entryRow.addAllTaskValInfos(joinRow, "TotalDiffAmt");
                if (unAbsorbMap.containsKey(joinSideKey) || joinMap.containsKey(joinSideKey)) continue;
                joinMap.put(joinSideKey, entryRow.getMfgPdDiffAmt());
            }
        }
        if (!CadEmptyUtils.isEmpty(joinMap)) {
            unAbsorbMap.putAll(joinMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void unAbsorbProAlloc(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap, Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap) {
        Map unAbsorbAllocStdMap = ProAllocStdHelper.getUnAbsorbAllocStdMap((Long)this.getContext().getInputArgs().getOrgId(), (Long)this.getContext().getInputArgs().getCostAccountId());
        if (CadEmptyUtils.isEmpty((Map)unAbsorbAllocStdMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\uff0c\u5236\u8d39\u672a\u5438\u6536\u5728\u4ea7\u5206\u644a\u5931\u8d25\u3002", (String)"MfgUnAbsorbFeeCalcAction_32", (String)"macc-sca-mservice", (Object[])new Object[0]));
        }
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbEntry : unAbsorbMap.entrySet()) {
            UnAbsorbFeeGroupKey key = unAbsorbEntry.getKey();
            Long costObjectId = key.getCostObjectId();
            Long costCenterId = key.getCostCenterid();
            Long subElementId = key.getSubelementId();
            String proAllocStd = null;
            proAllocStd = this.isOtherCostObjectIds ? "0" : ProAllocStdHelper.getProAllocStd((Map)unAbsorbAllocStdMap, (long)this.getContext().getInputArgs().getCostAccountId(), (long)costCenterId, (long)subElementId);
            if (StringUtils.isEmpty((CharSequence)proAllocStd)) {
                DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter", (String)"id,name");
                DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)subElementId, (String)"cad_subelement", (String)"name");
                String errDesc = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5b50\u8981\u7d20\u201c%2$s\u201d\u672a\u627e\u5230\u201c\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u201d\u3002", (String)"MfgUnAbsorbFeeCalcAction_27", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(subElementDy));
                logger.info(errDesc);
                this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), costCenterId, errDesc);
                continue;
            }
            CalcResultMfgEntryRow entryRow = this.createdMfgEntryRow.computeIfAbsent(key, s -> new CalcResultMfgEntryRow());
            Map<Long, CalcResultObjectInfo> objectInfoMap = objectInfosMap.get(costObjectId);
            if (CadEmptyUtils.isEmpty(objectInfoMap)) {
                DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
                String errDesc = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u201c%s\u201d\u5bf9\u8c61\u4fe1\u606f\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"MfgUnAbsorbFeeCalcAction_28", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costObjectDy));
                logger.info(errDesc);
                this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), costCenterId, errDesc);
                continue;
            }
            entryRow.setCostObjectId(costObjectId.longValue());
            entryRow.setProductType("C");
            BigDecimal proEndQty = ProAllocHelper.getMainAndJoinEndQty(objectInfosMap.get(costObjectId));
            BigDecimal proFinishQty = ProAllocHelper.getMainAndJoinFinQty(objectInfosMap.get(costObjectId));
            BigDecimal mfgPdStartQty = entryRow.getMfgPdStartQty();
            BigDecimal mfgPdStartAmt = entryRow.getMfgPdStartAmt();
            BigDecimal mfgPdCurrQty = entryRow.getMfgPdCurrQty();
            BigDecimal mfgPdCurrAmt = entryRow.getMfgPdCurrAmt();
            BigDecimal pdendqty = BigDecimal.ZERO;
            BigDecimal pdendamount = BigDecimal.ZERO;
            BigDecimal diffQty = BigDecimal.ZERO;
            BigDecimal diffAmt = BigDecimal.ZERO;
            if (this.isOtherCostObjectIds) {
                diffQty = mfgPdStartQty.add(mfgPdCurrQty);
                entryRow.addTaskValInfo("this", "", String.format("Std:Fin,PdStartQty %s + PdCurrQty %s", mfgPdStartQty, mfgPdCurrQty), "DiffQty", diffQty);
                diffAmt = mfgPdStartAmt.add(mfgPdCurrAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                entryRow.addTaskValInfo("this", "", String.format("Std:Fin,PdStartAmount %s + PdCurrAmount %s", mfgPdStartAmt, mfgPdCurrAmt), "DiffAmount", diffAmt);
                unAbsorbEntry.setValue(diffAmt);
            } else if (proFinishQty.compareTo(BigDecimal.ZERO) == 0) {
                pdendqty = mfgPdStartQty.add(mfgPdCurrQty);
                entryRow.addTaskValInfo("this", "", String.format("Std:FinQty=0,PdStartQty %s + PdCurrQty %s", mfgPdStartQty, mfgPdCurrQty), "PdEndQty", pdendqty);
                pdendamount = mfgPdStartAmt.add(mfgPdCurrAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                entryRow.addTaskValInfo("this", "", String.format("Std:FinQty=0,PdStartAmount %s + PdCurrAmount %s", mfgPdStartAmt, mfgPdCurrAmt), "PdEndAmount", pdendamount);
                unAbsorbEntry.setValue(BigDecimal.ZERO);
            } else if ("0".equals(proAllocStd) || proEndQty.compareTo(BigDecimal.ZERO) <= 0) {
                diffQty = mfgPdStartQty.add(mfgPdCurrQty);
                entryRow.addTaskValInfo("this", "", String.format("Std:0/EndQty=0,PdStartQty %s + PdCurrQty %s", mfgPdStartQty, mfgPdCurrQty), "DiffQty", diffQty);
                diffAmt = mfgPdStartAmt.add(mfgPdCurrAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                entryRow.addTaskValInfo("this", "", String.format("Std:0/EndQty=0,PdStartAmount %s + PdCurrAmount %s", mfgPdStartAmt, mfgPdCurrAmt), "DiffAmount", diffAmt);
                unAbsorbEntry.setValue(diffAmt);
            } else if ("5".equals(proAllocStd)) {
                pdendqty = mfgPdStartQty.add(mfgPdCurrQty);
                entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartQty %s + PdCurrQty %s ", mfgPdStartQty, mfgPdCurrQty), "PdEndQty", pdendqty);
                pdendamount = mfgPdStartAmt.add(mfgPdCurrAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                entryRow.addTaskValInfo("this", "", String.format("Std:5,PdStartAmount %s + PdCurrAmount %s ", mfgPdStartAmt, mfgPdCurrAmt), "PdEndAmount", pdendamount);
                unAbsorbEntry.setValue(BigDecimal.ZERO);
            } else if ("1".equals(proAllocStd) || "2".equals(proAllocStd)) {
                BigDecimal equivalent = BigDecimal.ONE;
                if ("2".equals(proAllocStd) && (equivalent = ScaCalcHelper.getCostobjectEquivalent(this.getSingleBatchContext().getEquivalentMap(), (Long)this.getSingleBatchContext().getContext().getInputArgs().getCostAccountId(), (Long)this.getSingleBatchContext().getContext().getInputArgs().getManuOrgId(), (Long)key.getCostCenterid(), (Long)key.getCostObjectId(), (Long)key.getSubelementId())) == null) {
                    DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostCenterid(), (String)"bos_costcenter", (String)"id,name");
                    DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
                    DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                    String errDesc = String.format(ResManager.loadKDString((String)"\u5728\u4ea7\u54c1\u5206\u914d\u5931\u8d25\uff0c\u6210\u672c\u4e2d\u5fc3\u201c%1$s\u201d\u6210\u672c\u5bf9\u8c61\u201c%2$s\u201d\u5b50\u8981\u7d20\u201c%3$s\u201d\u672a\u8bbe\u7f6e\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"MfgUnAbsorbFeeCalcAction_29", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(costObjectDy), this.getDynamicObjectName(subElementDy));
                    logger.info(errDesc);
                    this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), costCenterId, errDesc);
                    continue;
                }
                BigDecimal divider = proEndQty.multiply(equivalent).add(proFinishQty);
                if (divider.compareTo(BigDecimal.ZERO) == 0) {
                    DynamicObject costCenterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostCenterid(), (String)"bos_costcenter", (String)"id,name");
                    DynamicObject costObjectDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getCostObjectId(), (String)"cad_costobject", (String)"name");
                    DynamicObject subElementDy = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                    String string = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3:%1$s ,\u5b50\u8981\u7d20: %2$s , \u6210\u672c\u6838\u7b97\u5bf9\u8c61 :%3$s , \u671f\u672b\u5728\u4ea7\u54c1\u6570\u91cf*\u7ea6\u5f53\u7cfb\u6570+\u5b8c\u5de5\u5165\u5e93\u6570\u91cf=0\u3002", (String)"MfgUnAbsorbFeeCalcAction_30", (String)"macc-sca-mservice", (Object[])new Object[0]), this.getDynamicObjectName(costCenterDy), this.getDynamicObjectName(costObjectDy), this.getDynamicObjectName(subElementDy));
                    logger.info(string);
                    this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), costCenterId, string);
                    continue;
                }
                BigDecimal totalQty = mfgPdStartQty.add(mfgPdCurrQty);
                BigDecimal totalAmt = mfgPdStartAmt.add(mfgPdCurrAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                diffQty = totalQty.multiply(proFinishQty).divide(divider, 10, 4).setScale(10, 4);
                diffAmt = totalAmt.multiply(proFinishQty).divide(divider, this.getContext().getCurrencyAmtScale(), 4);
                pdendqty = totalQty.subtract(diffQty);
                pdendamount = totalAmt.subtract(diffAmt);
                entryRow.addTaskValInfo("this", "", String.format("Std:1/2,(PdStartQty %s + PdCurrQty %s )* ProFinQty %s /(ProEndQty %s* Equivalent %s + ProFinQty %s)", mfgPdStartQty, mfgPdCurrQty, proFinishQty, proEndQty, equivalent, proFinishQty), "DiffQty", diffQty);
                entryRow.addTaskValInfo("this", "", String.format("Std:1/2,(PdStartAmt %s + PdCurrAmt %s )* ProFinQty %s /(ProEndQty %s* Equivalent %s + ProFinQty %s)", mfgPdStartAmt, mfgPdCurrAmt, proFinishQty, proEndQty, equivalent, proFinishQty), "DiffAmount", diffAmt);
                entryRow.addTaskValInfo("this", "", String.format("Std:1/2,(PdStartQty %s + PdCurrQty %s ) -DiffQty %s", mfgPdStartQty, mfgPdCurrQty, diffQty), "PdEndQty", pdendqty);
                entryRow.addTaskValInfo("this", "", String.format("Std:1/2,(PdStartAmt %s + PdCurrAmt %s ) -DiffAmount %s", mfgPdStartAmt, mfgPdCurrAmt, diffAmt), "PdEndAmount", pdendamount);
                unAbsorbEntry.setValue(diffAmt);
            }
            entryRow.addMfgPdEndQty(pdendqty);
            entryRow.addMfgPdEndAmt(pdendamount);
            if (ScaCalcHelper.isContainsProductFacted(objectInfoMap, (String)"A") && (BigDecimal.ZERO.compareTo(diffQty) != 0 || BigDecimal.ZERO.compareTo(diffAmt) != 0)) {
                void var28_38;
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u5b58\u5728\u8054\u4ea7\u54c1\u5b8c\u5de5\u9700\u8981\u6309\u6743\u91cd\u5206\u644a\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02");
                Map<Long, CalcResultObjectInfo> objInfoMap = objectInfosMap.get(costObjectId);
                BigDecimal totalRatio = BigDecimal.ZERO;
                BigDecimal maxRatio = null;
                boolean isAllFinQtyZero = true;
                for (Map.Entry entry : objInfoMap.entrySet()) {
                    BigDecimal finQty;
                    CalcResultObjectInfo objectInfo = (CalcResultObjectInfo)entry.getValue();
                    if ("B".equals(objectInfo.getProductType()) || BigDecimal.ZERO.compareTo(finQty = objectInfo.getFinishQty()) == 0) continue;
                    isAllFinQtyZero = false;
                    BigDecimal weight = objectInfo.getWeight();
                    BigDecimal finRatio = finQty.multiply(weight);
                    totalRatio = totalRatio.add(finRatio);
                    if (maxRatio != null && maxRatio.compareTo(finRatio.abs()) >= 0) continue;
                    maxRatio = finRatio.abs();
                }
                if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && maxRatio != null) {
                    totalRatio = maxRatio;
                }
                if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && !isAllFinQtyZero) {
                    DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"costcenter,name");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)key.getSubelementId(), (String)"cad_subelement", (String)"name");
                    String errDesc = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\uff0c\u5b50\u8981\u7d20\u3010%3$s\u3011\u3002", (String)"MfgUnAbsorbFeeCalcAction_31", (String)"macc-sca-mservice", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", dynamicObject != null ? dynamicObject.getString("name") : "");
                    logger.info(errDesc);
                    this.getResultManager().getTaskRecorder().insertCalcErrorInfo(this.getDetailTaskConfigId(), costCenterId, errDesc);
                    continue;
                }
                BigDecimal diffFinQty = diffQty;
                BigDecimal bigDecimal = diffAmt;
                CalcResultMfgEntryRow allocMaxRow = null;
                boolean isContainMainFact = false;
                boolean isContainJoinFact = false;
                for (Map.Entry<Long, CalcResultObjectInfo> entry : objectInfoMap.entrySet()) {
                    CalcResultObjectInfo objectInfo = entry.getValue();
                    if ("B".equals(objectInfo.getProductType())) continue;
                    BigDecimal qty = objectInfo.getFinishQty();
                    BigDecimal weight = objectInfo.getWeight();
                    BigDecimal finRatio = qty.multiply(weight);
                    BigDecimal ratio = BigDecimal.ZERO;
                    if (totalRatio.compareTo(BigDecimal.ZERO) != 0) {
                        ratio = finRatio.divide(totalRatio, 10, RoundingMode.HALF_UP);
                    }
                    BigDecimal allocAmt = ratio.multiply(diffAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                    BigDecimal allocQty = ratio.multiply(diffQty).setScale(10, RoundingMode.HALF_UP);
                    diffFinQty = diffFinQty.subtract(allocQty);
                    BigDecimal bigDecimal2 = var28_38.subtract(allocAmt);
                    if ("C".equals(objectInfo.getProductType())) {
                        entryRow.addMfgPdDiffAmt(allocAmt);
                        entryRow.addTaskValInfo("this", "", String.format("DiffAmt %s * FinRatio %s / TotalRatio %s", diffAmt, finRatio, totalRatio), "DiffAmt", allocAmt);
                        entryRow.addMfgPdDiffQty(allocQty);
                        entryRow.addTaskValInfo("this", "", String.format("DiffQty %s * FinRatio %s / TotalRatio %s", diffQty, finRatio, totalRatio), "DiffQty", allocQty);
                        if (allocMaxRow == null || allocMaxRow.getMfgPdDiffAmt().compareTo(allocAmt) < 0) {
                            allocMaxRow = entryRow;
                        }
                        isContainMainFact = true;
                        continue;
                    }
                    String productType = objectInfo.getProductType();
                    long joinCostObjectId = objectInfo.getCostObjectId();
                    UnAbsorbFeeGroupKey joinKey = new UnAbsorbFeeGroupKey(key.getCostCenterid(), key.getCostObjectId(), joinCostObjectId, productType, key.getSubelementId(), key.getSourceType());
                    CalcResultMfgEntryRow joinRow = this.createdMfgEntryRow.computeIfAbsent(joinKey, s -> new CalcResultMfgEntryRow());
                    joinRow.setCostObjectId(joinCostObjectId);
                    joinRow.setProductType(productType);
                    joinRow.setMfgElement(entryRow.getMfgElement());
                    joinRow.setMfgSubElement(entryRow.getMfgSubElement());
                    joinRow.addMfgPdDiffQty(allocQty);
                    joinRow.addTaskValInfo("this", "", String.format("DiffQty %s * FinRatio %s / TotalRatio %s", diffQty, finRatio, totalRatio), "DiffQty", allocQty);
                    joinRow.addMfgPdDiffAmt(allocAmt);
                    joinRow.addTaskValInfo("this", "", String.format("DiffAmt %s * FinRatio %s / TotalRatio %s", diffAmt, finRatio, totalRatio), "DiffAmt", allocAmt);
                    joinRow.addMfgTotalDiffAmt(allocAmt);
                    joinRow.addTaskValInfo("this", "", String.format("MfgTotalDiffAmt %s + DiffAmt %s", joinRow.getMfgTotalDiffAmt(), allocAmt), "TotalDiffAmt", joinRow.getMfgTotalDiffAmt());
                    if (allocMaxRow == null || allocMaxRow.getMfgPdDiffAmt().compareTo(allocAmt) < 0) {
                        allocMaxRow = joinRow;
                    }
                    isContainJoinFact = true;
                }
                if (diffFinQty.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                    allocMaxRow.addMfgPdDiffQty(diffFinQty);
                }
                if (var28_38.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                    allocMaxRow.addMfgPdDiffAmt((BigDecimal)var28_38);
                }
                if (!isContainMainFact && isContainJoinFact) {
                    entryRow.addMfgPdDiffAmt(BigDecimal.ZERO);
                    entryRow.addTaskValInfo("this", "", "Not exists mainProduct finishQty", "DiffQty", BigDecimal.ZERO);
                    entryRow.addMfgPdDiffQty(BigDecimal.ZERO);
                    entryRow.addTaskValInfo("this", "", "Not exists mainProduct finishQty", "DiffAmt", BigDecimal.ZERO);
                }
            } else {
                entryRow.addMfgPdDiffQty(diffQty);
                entryRow.addMfgPdDiffAmt(diffAmt);
            }
            unAbsorbEntry.setValue(entryRow.getMfgPdDiffAmt());
            BigDecimal mfgPreTotalDiffQty = entryRow.getMfgPreTotalDiffQty();
            BigDecimal mfgPdDiffQty = entryRow.getMfgPdDiffQty();
            BigDecimal totalDiffQty = mfgPreTotalDiffQty.add(mfgPdDiffQty);
            entryRow.addMfgTotalDiffQty(totalDiffQty);
            entryRow.addTaskValInfo("this", "", String.format("PreTotalDiffQty %s + DiffQty %s ", mfgPreTotalDiffQty, mfgPreTotalDiffQty), "TotalDiffQty", totalDiffQty);
            BigDecimal mfgPreTotalDiffAmt = entryRow.getMfgPreTotalDiffAmt();
            BigDecimal mfgPdDiffAmt = entryRow.getMfgPdDiffAmt();
            BigDecimal bigDecimal = mfgPreTotalDiffAmt.add(mfgPdDiffAmt);
            entryRow.addMfgTotalDiffAmt(bigDecimal);
            entryRow.addTaskValInfo("this", "", String.format("PreTotalDiffAmount %s + DiffAmt %s ", mfgPreTotalDiffAmt, mfgPdDiffAmt), "TotalDiffAmt", bigDecimal);
        }
    }

    private String getDynamicObjectName(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("name");
    }

    private void loadTotalMfgFeeal() {
        String totalSelect = "entryentity.costobject.costcenter as costcenter,entryentity.costobject.mainproobj costobject,entryentity.costobject belongobj,entryentity.costobject.producttype producttype,subelement,entryentity.allocamt as amount,1 as type";
        QFilter[] qFilters = this.getQfilters(LOAD_CAD_MFGFEE_ALLOCCO);
        int rowCount = 0;
        try (DataSet totalDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadTotalMfgFeeal"), (String)"cad_mfgfeeallocco", (String)totalSelect, (QFilter[])qFilters, null);){
            while (totalDataSet.hasNext()) {
                Row row = totalDataSet.next();
                ++rowCount;
                this.addTotalDiffs(row);
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u603b\u5236\u9020\u8d39\u7528(sca_mfgfeeallocco)\u6570\u636e\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
    }

    private void loadSubElementMfgFeeal() {
        if (this.isOtherCostObjectIds) {
            String absorbSelect = "costcenter,costobject,entryentity.obj belongobj,entryentity.producttype producttype,entryentity.subelement as subelement,entryentity.pdcurramount as amount,2 as type";
            QFilter[] qFilters = this.getQfilters(LOAD_SCA_CALCRESULT_SUBELEMENT_MFGFEEAL);
            int rowCount = 0;
            try (DataSet absorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementMfgFeeal"), (String)"sca_calcresult", (String)absorbSelect, (QFilter[])qFilters, null);){
                while (absorbDataSet.hasNext()) {
                    Row row = absorbDataSet.next();
                    ++rowCount;
                    this.addTotalDiffs(row);
                }
            }
            logger.info(String.format("\u8bfb\u53d6\u5b50\u8981\u7d20\u5438\u6536\u5236\u9020\u8d39\u7528\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
        } else {
            HashSet<String> calTypes = new HashSet<String>(2);
            calTypes.add("2");
            calTypes.add("4");
            int rowCount = 0;
            for (Object costObjectId : this.currCostObjectIds) {
                CalcResultHeader calcResult = this.getSingleBatchResultManager().getCalcResults().get((Long)costObjectId);
                if (calcResult == null) continue;
                for (CalcResultEntryRow entryRow : calcResult.getEntryRows()) {
                    if (!calTypes.contains(entryRow.getCalType()) || !StringUtils.equals((CharSequence)"3", (CharSequence)entryRow.getDataType())) continue;
                    UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(calcResult.getCostCenter(), calcResult.getCostObject(), entryRow.getCostObject(), entryRow.getProductType(), entryRow.getSubElement(), 2);
                    BigDecimal sum = this.totalDiffs.computeIfAbsent(key, s -> BigDecimal.ZERO);
                    sum = sum.add(entryRow.getPdCurrAmount());
                    this.totalDiffs.put(key, sum);
                    ++rowCount;
                }
            }
            logger.info(String.format("\u8bfb\u53d6\u5b50\u8981\u7d20\u5438\u6536\u5236\u9020\u8d39\u7528\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c", rowCount));
        }
    }

    private void loadSubElementUnAbsorb() {
        String unAbsorbSelect = "costcenter,costobject.mainproobj costobject,costobject belongobj,costobject.producttype producttype,entryentity.subelement as subelement,entryentity.amount as amount,3 as type";
        QFilter[] qFilters = this.getQfilters(LOAD_SCA_UNABSORB_DIFF_SUBELEMENT);
        int rowCount = 0;
        try (DataSet unAbsorbDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadSubElementUnAbsorb"), (String)"sca_unabsorbdiff", (String)unAbsorbSelect, (QFilter[])qFilters, null);){
            while (unAbsorbDataSet.hasNext()) {
                Row row = unAbsorbDataSet.next();
                ++rowCount;
                this.addTotalDiffs(row);
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u5b50\u8981\u7d20\u672a\u5438\u6536\u8d39\u7528\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
    }

    private void addTotalDiffs(Row row) {
        Long costCenterId = row.getLong("costcenter");
        Long costObjectId = row.getLong("costobject");
        Long belongObjId = row.getLong("belongobj");
        String productType = row.getString("producttype");
        Long subelementId = row.getLong("subelement");
        Integer sourceType = row.getInteger("type");
        if (CadEmptyUtils.isEmpty((Long)belongObjId) && !CadEmptyUtils.isEmpty((Long)costObjectId)) {
            belongObjId = costObjectId;
            productType = "C";
        }
        if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
            costObjectId = belongObjId;
        }
        UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(costCenterId, costObjectId, belongObjId, productType, subelementId, sourceType);
        BigDecimal sum = this.totalDiffs.computeIfAbsent(key, s -> BigDecimal.ZERO);
        sum = sum.add(this.getBigDecimal(row.getBigDecimal("amount")));
        this.totalDiffs.put(key, sum);
    }

    private void totalSubtractAbsorb(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap, Map<UnAbsorbFeeGroupKey, BigDecimal> subTotalMap) {
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> absorbMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>(16);
        Set<Map.Entry<UnAbsorbFeeGroupKey, BigDecimal>> totalEntrySet = this.totalDiffs.entrySet();
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> totalentry : totalEntrySet) {
            UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(totalentry.getKey().getCostCenterid(), totalentry.getKey().getCostObjectId(), totalentry.getKey().getBelongObjectId(), totalentry.getKey().getProductType(), totalentry.getKey().getSubelementId(), 0);
            if (1 == totalentry.getKey().getSourceType()) {
                subTotalMap.put(key, totalentry.getValue());
            }
            if (2 != totalentry.getKey().getSourceType()) continue;
            absorbMap.put(key, totalentry.getValue());
        }
        BigDecimal totalAmt = new BigDecimal(0);
        BigDecimal absorbAmt = new BigDecimal(0);
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry : subTotalMap.entrySet()) {
            Long subElementId = entry.getKey().getSubelementId();
            CalcResultMfgEntryRow entryRow = this.createdMfgEntryRow.computeIfAbsent(entry.getKey(), s -> new CalcResultMfgEntryRow());
            entryRow.setMfgElement(this.elementDetails.get(subElementId).longValue());
            entryRow.setMfgSubElement(subElementId.longValue());
            BigDecimal bigDecimal = totalAmt = entry.getValue() == null ? BigDecimal.ZERO : entry.getValue();
            if (absorbMap.containsKey(entry.getKey())) {
                absorbAmt = absorbMap.get(entry.getKey()) == null ? BigDecimal.ZERO : (BigDecimal)absorbMap.get(entry.getKey());
                BigDecimal mfgCurrAmt = totalAmt.subtract(absorbAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                unAbsorbMap.put(entry.getKey(), mfgCurrAmt);
                entryRow.addMfgPdCurrAmt(mfgCurrAmt);
                entryRow.addTaskValInfo("this", "", String.format("TotalAmt %s - AbsorbAmt %s", totalAmt, absorbAmt), "PdCurrAmount", mfgCurrAmt);
                continue;
            }
            totalAmt = totalAmt.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            unAbsorbMap.put(entry.getKey(), totalAmt);
            entryRow.addMfgPdCurrAmt(totalAmt);
            entryRow.addTaskValInfo("this", "", String.format("TotalAmt %s - AbsorbAmt %s", totalAmt, 0), "PdCurrAmount", totalAmt);
        }
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry : absorbMap.entrySet()) {
            CalcResultMfgEntryRow entryRow = this.createdMfgEntryRow.computeIfAbsent(entry.getKey(), s -> new CalcResultMfgEntryRow());
            entryRow.setMfgElement(this.elementDetails.get(entry.getKey().getSubelementId()).longValue());
            entryRow.setMfgSubElement(entry.getKey().getSubelementId().longValue());
            BigDecimal bigDecimal = absorbAmt = entry.getValue() == null ? BigDecimal.ZERO : entry.getValue();
            if (unAbsorbMap.containsKey(entry.getKey())) continue;
            BigDecimal mfgPdCurrAmt = BigDecimal.ZERO.subtract(absorbAmt).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
            unAbsorbMap.put(entry.getKey(), mfgPdCurrAmt);
            entryRow.addMfgPdCurrAmt(mfgPdCurrAmt);
            entryRow.addTaskValInfo("this", "", String.format("TotalAmt %s - AbsorbAmt %s", 0, absorbAmt), "PdCurrAmount", mfgPdCurrAmt);
        }
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry : this.createdMfgEntryRow.entrySet()) {
            UnAbsorbFeeGroupKey key = entry.getKey();
            if (unAbsorbMap.containsKey(key) || ((CalcResultMfgEntryRow)entry.getValue()).getMfgPdStartAmt() == null || BigDecimal.ZERO.compareTo(((CalcResultMfgEntryRow)entry.getValue()).getMfgPdStartAmt()) == 0) continue;
            unAbsorbMap.put(key, BigDecimal.ZERO);
        }
    }

    private void totalCostObjectUnAbsorbAmount(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap, Map<UnAbsorbFeeGroupKey, BigDecimal> costTotalMap) {
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbEntry : unAbsorbMap.entrySet()) {
            UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(unAbsorbEntry.getKey().getCostCenterid(), unAbsorbEntry.getKey().getCostObjectId(), unAbsorbEntry.getKey().getBelongObjectId(), unAbsorbEntry.getKey().getProductType(), 0L, 0);
            if (!costTotalMap.containsKey(key)) {
                costTotalMap.put(key, unAbsorbEntry.getValue());
                continue;
            }
            BigDecimal value = costTotalMap.get(key);
            value = value.add(unAbsorbEntry.getValue());
            costTotalMap.put(key, value);
        }
    }

    private void removeVoucher(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap) {
        HashMap<UnAbsorbFeeGroupKey, BigDecimal> voucherUnAbsorbMap = new HashMap<UnAbsorbFeeGroupKey, BigDecimal>(16);
        Set<Map.Entry<UnAbsorbFeeGroupKey, BigDecimal>> totalEntrySet = this.totalDiffs.entrySet();
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry : totalEntrySet) {
            if (3 != entry.getKey().getSourceType()) continue;
            UnAbsorbFeeGroupKey key = new UnAbsorbFeeGroupKey(entry.getKey().getCostCenterid(), entry.getKey().getCostObjectId(), entry.getKey().getBelongObjectId(), entry.getKey().getProductType(), entry.getKey().getSubelementId(), 0);
            voucherUnAbsorbMap.put(key, entry.getValue());
        }
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry : voucherUnAbsorbMap.entrySet()) {
            if (unAbsorbMap.containsKey(entry.getKey())) {
                BigDecimal unAbsorb = entry.getValue();
                unAbsorb = unAbsorbMap.get(entry.getKey()).subtract(unAbsorb);
                unAbsorbMap.put(entry.getKey(), unAbsorb);
                continue;
            }
            unAbsorbMap.put(entry.getKey(), entry.getValue().negate());
        }
        Iterator<Map.Entry<UnAbsorbFeeGroupKey, BigDecimal>> it = unAbsorbMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> entry = it.next();
            if (BigDecimal.ZERO.compareTo(entry.getValue()) != 0) continue;
            it.remove();
        }
    }

    private void insetTotalMfgFee(Map<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> subTotalResultMap) {
        Date now = TimeServiceHelper.now();
        for (Map.Entry<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> unAbsorbEntry : subTotalResultMap.entrySet()) {
            UnAbsorbFeeGroupKey cost = unAbsorbEntry.getKey();
            DynamicObject totalmfgfee = BusinessDataServiceHelper.newDynamicObject((String)"sca_totalmfgfee");
            StringBuilder totalSb = new StringBuilder();
            String[] totalnumberArr = CodeRuleServiceHelper.getBatchNumber((String)"sca_totalmfgfee", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_totalmfgfee"), (String)"", (int)1);
            if (totalnumberArr != null && totalnumberArr.length != 0) {
                totalSb.append(totalnumberArr[0]);
            } else {
                String number1 = UUID.randomUUID().toString().replace("-", "").substring(0, 3);
                String number2 = UUID.randomUUID().toString().replace("-", "").substring(0, 2);
                totalSb.append("ZZFEE-0").append(number1).append('-').append(number2);
            }
            Long id = DBServiceHelper.genGlobalLongId();
            this.getResultManager().getTotalMfgFeeIds().add(id);
            totalmfgfee.set("id", (Object)id);
            totalmfgfee.set("billno", (Object)totalSb.toString());
            totalmfgfee.set("period", (Object)this.args.getPeriodId());
            totalmfgfee.set("org", (Object)this.args.getOrgId());
            totalmfgfee.set("costaccount", (Object)this.args.getCostAccountId());
            totalmfgfee.set("currency", (Object)this.args.getCurrencyId());
            totalmfgfee.set("costcenter", (Object)cost.getCostCenterid());
            totalmfgfee.set("costobject", (Object)cost.getBelongObjectId());
            totalmfgfee.set("billstatus", (Object)"C");
            totalmfgfee.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            totalmfgfee.set("createtime", (Object)now);
            DynamicObjectCollection entryentity = totalmfgfee.getDynamicObjectCollection("entryentity");
            for (Map.Entry<Long, BigDecimal> unAbsorbEntity : unAbsorbEntry.getValue().entrySet()) {
                DynamicObject newEntity = entryentity.addNew();
                Long subElementId = unAbsorbEntity.getKey();
                BigDecimal amount = unAbsorbEntity.getValue();
                newEntity.set("element", (Object)this.elementDetails.get(subElementId));
                newEntity.set("subelement", (Object)subElementId);
                newEntity.set("totalproduce", (Object)amount);
            }
            this.saveMfgfeeList.add(totalmfgfee);
        }
    }

    private void insetUnabsorb(Map<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> unAbsorbResultMap, Map<UnAbsorbFeeGroupKey, BigDecimal> costobjectUnAbsorbMap) {
        int numberCount = 0;
        String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"sca_unabsorbdiff", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_unabsorbdiff"), (String)"", (int)unAbsorbResultMap.size());
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Date now = TimeServiceHelper.now();
        for (Map.Entry<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> unAbsorbEntry : unAbsorbResultMap.entrySet()) {
            UnAbsorbFeeGroupKey cost = unAbsorbEntry.getKey();
            DynamicObject unAbsorbDiff = BusinessDataServiceHelper.newDynamicObject((String)"sca_unabsorbdiff");
            StringBuilder sb = new StringBuilder();
            if (numberArr != null && numberArr.length != 0) {
                sb.append(numberArr[numberCount]);
                ++numberCount;
            } else {
                String number1 = UUID.randomUUID().toString().replace("-", "").substring(0, 3);
                String number2 = UUID.randomUUID().toString().replace("-", "").substring(0, 2);
                sb.append("WXSCYD-0").append(number1).append('-').append(number2);
            }
            Long id = DBServiceHelper.genGlobalLongId();
            this.getResultManager().getUnabsorbDiffIds().add(id);
            unAbsorbDiff.set("id", (Object)id);
            unAbsorbDiff.set("billno", (Object)sb.toString());
            unAbsorbDiff.set("period", (Object)this.args.getPeriodId());
            unAbsorbDiff.set("org", (Object)this.args.getOrgId());
            unAbsorbDiff.set("costaccount", (Object)this.args.getCostAccountId());
            unAbsorbDiff.set("currency", (Object)this.args.getCurrencyId());
            unAbsorbDiff.set("costcenter", (Object)cost.getCostCenterid());
            unAbsorbDiff.set("costobject", (Object)cost.getBelongObjectId());
            if (cost.getCostObjectId() != null) {
                unAbsorbDiff.set("manuorg", (Object)this.args.getManuOrgId());
                if (!this.isOtherCostObjectIds) {
                    unAbsorbDiff.set("proallocgen", (Object)"1");
                }
            }
            unAbsorbDiff.set("difftype", (Object)"4");
            unAbsorbDiff.set("difftotal", (Object)costobjectUnAbsorbMap.get(cost).setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP));
            unAbsorbDiff.set("vouchernum", null);
            unAbsorbDiff.set("billstatus", (Object)"C");
            unAbsorbDiff.set("creator", (Object)userId);
            unAbsorbDiff.set("createtime", (Object)now);
            unAbsorbDiff.set("modifier", (Object)userId);
            unAbsorbDiff.set("modifytime", (Object)now);
            unAbsorbDiff.set("auditor", (Object)userId);
            unAbsorbDiff.set("auditdate", (Object)now);
            DynamicObjectCollection entryentity = unAbsorbDiff.getDynamicObjectCollection("entryentity");
            int i = 0;
            for (Map.Entry<Long, BigDecimal> unAbsorbEntity : unAbsorbEntry.getValue().entrySet()) {
                Long subElementId = unAbsorbEntity.getKey();
                BigDecimal amount = unAbsorbEntity.getValue().setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                if (amount == null || BigDecimal.ZERO.compareTo(amount) == 0) continue;
                DynamicObject newEntity = entryentity.addNew();
                newEntity.set("element", (Object)this.elementDetails.get(subElementId));
                newEntity.set("subelement", (Object)subElementId);
                newEntity.set("amount", (Object)amount);
                newEntity.set("seq", (Object)i++);
            }
            if (entryentity.size() <= 0) continue;
            this.saveUnAbsorbDiffList.add(unAbsorbDiff);
            this.addUnAbsorbCostObjectCount(cost.getCostCenterid(), cost.getBelongObjectId());
        }
    }

    private void addUnAbsorbCostObjectCount(Long costCenterId, Long costObjectId) {
        if (costCenterId == null || costObjectId == null) {
            return;
        }
        Set costObjectIds = this.unabsorbCostObjectIds.computeIfAbsent(costCenterId, s -> new HashSet());
        costObjectIds.add(costObjectId);
    }

    private Map<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> getResultAbsorbMap(Map<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbMap) {
        HashMap<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>> unAbsorbRsultMap = new HashMap<UnAbsorbFeeGroupKey, Map<Long, BigDecimal>>(10);
        HashSet<UnAbsorbFeeGroupKey> unAbosrbResultSet = new HashSet<UnAbsorbFeeGroupKey>(10);
        for (Map.Entry<UnAbsorbFeeGroupKey, BigDecimal> unAbsorbEntry : unAbsorbMap.entrySet()) {
            UnAbsorbFeeGroupKey costObjectKey = new UnAbsorbFeeGroupKey(unAbsorbEntry.getKey().getCostCenterid(), unAbsorbEntry.getKey().getCostObjectId(), unAbsorbEntry.getKey().getBelongObjectId(), unAbsorbEntry.getKey().getProductType(), 0L, 0);
            long subElementId = unAbsorbEntry.getKey().getSubelementId();
            Map reMap = unAbosrbResultSet.add(costObjectKey) ? new HashMap() : (Map)unAbsorbRsultMap.get(costObjectKey);
            reMap.put(subElementId, unAbsorbEntry.getValue());
            unAbsorbRsultMap.put(costObjectKey, reMap);
        }
        return unAbsorbRsultMap;
    }

    private void delCostAdjustByUnabsorbdiff() {
        logger.info("\u53cd\u5ba1\u6838\u5e76\u5220\u9664\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff08\u6210\u672c\u8c03\u6574\u5355\uff09\uff1a\u5f00\u59cb");
        HashSet<Long> unabsorbDiffIds = new HashSet<Long>();
        QFilter[] filters_delUnabsorbDiff = this.getQfilters(DEL_SCA_UNABSORB_DIFF);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".delCostAdjustByUnabsorbdiff"), (String)"sca_unabsorbdiff", (String)"id", (QFilter[])filters_delUnabsorbDiff, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                unabsorbDiffIds.add(row.getLong("id"));
            }
        }
        logger.info("unabsorbDiffIds:size={},info={}", (Object)unabsorbDiffIds.size(), unabsorbDiffIds);
        logger.info(String.format("\u5171\u53d6\u51fa %s \u5f20\u76f8\u5173\u7684\u672a\u5438\u6536\u5dee\u5f02\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a \r\n %s", unabsorbDiffIds.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filters_delUnabsorbDiff)));
        if (unabsorbDiffIds.isEmpty()) {
            logger.info("\u6ca1\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u672a\u5438\u6536\u5dee\u5f02\u5355\uff0c\u65e0\u5173\u8054\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u9700\u8981\u88ab\u5220\u9664");
            return;
        }
        Set<Long> costAdjustIds = this.loadCostAdjustIdByUnabsorbIds(unabsorbDiffIds);
        logger.info("costAdjustIds:size={},info={}", (Object)costAdjustIds.size(), costAdjustIds);
        if (costAdjustIds.isEmpty()) {
            logger.info("\u6839\u636e\u672a\u5438\u6536\u5dee\u5f02\u5355\uff0c\u6ca1\u6709\u627e\u5230\u5173\u8054\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff0c\u4e0d\u9700\u8981\u6267\u884c\u5220\u9664");
            return;
        }
        logger.info(String.format("\u5f00\u59cb\u53cd\u5ba1\u6838\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff0c\u5171%s\u5f20\u5355", costAdjustIds.size()));
        OperateOption opr = OperateOption.create();
        opr.setVariableValue("diffAlloc", "true");
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])costAdjustIds.toArray(), (OperateOption)opr);
        try {
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)"cal_stdcostdiffbill", (Object[])costAdjustIds.toArray(), (OperateOption)opr);
        }
        catch (Exception ex) {
            logger.error("\u6267\u884c\u53cd\u63d0\u4ea4\u64cd\u4f5c\u62a5\u9519\uff1a{}", (Object)ex.getMessage());
        }
        logger.info("\u53cd\u5ba1\u6838\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u5b8c\u6bd5\uff0c\u5f00\u59cb\u6267\u884c\u5220\u9664");
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"A");
        QFilter idQf = new QFilter("id", "in", costAdjustIds);
        QFilter[] qFilters = new QFilter[]{billStatusQf, idQf};
        HashSet<Long> delCostAdjustIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".delCostAdjustByUnabsorbdiff"), (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                delCostAdjustIds.add(row.getLong("id"));
            }
        }
        if (!delCostAdjustIds.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"), (Object[])delCostAdjustIds.toArray());
        }
        logger.info(String.format("\u53cd\u5ba1\u6838\u5e76\u5220\u9664\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355(\u6210\u672c\u8c03\u6574\u5355)\uff1a\u7ed3\u675f\uff0c\u5171\u5220\u9664%s\u5f20\u5355\u636e", delCostAdjustIds.size()));
    }

    private void delUnabsorbDiff() {
        HashSet<Long> ids = new HashSet<Long>();
        QFilter[] qfFilters = this.getQfilters(DEL_SCA_UNABSORB_DIFF);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".delUnabsorbDiff"), (String)"sca_unabsorbdiff", (String)"id", (QFilter[])qfFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_unabsorbdiff"), (Object[])ids.toArray());
        }
        logger.info(String.format("\u5171\u5220\u9664%s\u5f20\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\uff0c\u5220\u9664\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(qfFilters)));
    }

    private void delTotalMfgfee() {
        HashSet<Long> ids = new HashSet<Long>();
        QFilter[] qFilters = this.getQfilters(DEL_SCA_TOTAL_MFGFEE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".delTotalMfgfee"), (String)"sca_totalmfgfee", (String)"id", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("id"));
            }
        }
        if (!ids.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_totalmfgfee"), (Object[])ids.toArray());
        }
        logger.info(String.format("\u5171\u5220\u9664 %s \u5f20\u6210\u672c\u5b50\u8981\u7d20\u603b\u5236\u9020\u8d39\u7528\u5355\uff0c\u5220\u9664\u6761\u4ef6\uff1a\r\n %s", ids.size(), this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
    }

    private Set<Object> loadOtherCostObjectIds() {
        HashSet<Object> otherCostObjectIds = new HashSet<Object>();
        QFilter orgFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
        orgFilter.and(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        QFilter newFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
        newFilter.and("costaccount", "=", (Object)this.args.getCostAccountId());
        newFilter.and("period", "=", (Object)this.args.getPeriodId());
        if (!CollectionUtils.isEmpty((Collection)this.args.getCostCenterIds())) {
            orgFilter.and(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
            newFilter.and(new QFilter("entryentity.costobject.costcenter.id", "in", (Object)this.args.getCostCenterIds()));
        }
        if (this.args.getManuOrgId() != null && this.args.getManuOrgId() > 0L) {
            orgFilter.and(new QFilter("costobject.manuorg", "=", (Object)this.args.getManuOrgId()));
            newFilter.and(new QFilter("entryentity.costobject.manuorg", "=", (Object)this.args.getManuOrgId()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadOtherCostObjectIds"), (String)"sca_calcresult", (String)"billno, costobject,bizstatus", (QFilter[])new QFilter[]{orgFilter, new QFilter("period", "=", (Object)this.args.getPeriodId())}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long costObjectId = row.getLong("costobject");
                String billNo = row.getString("billno");
                if (this.args.getCostObjectIds().contains(costObjectId) || billNo.startsWith("NO.WQ")) continue;
                otherCostObjectIds.add(costObjectId);
                if (!"A".equals(row.getString("bizstatus"))) continue;
                this.expireObjectIds.add(costObjectId);
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadOtherCostObjectIds"), (String)"cad_mfgfeeallocco", (String)"entryentity.costobject.id costobject", (QFilter[])new QFilter[]{newFilter}, null).groupBy(new String[]{"costobject"}).finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long costObjectId = row.getLong("costobject");
            if (this.args.getCostObjectIds().contains(costObjectId) || !otherCostObjectIds.add(costObjectId)) continue;
            this.needGenCalcResultObjectIds.add(costObjectId);
        }
        QFilter otherFilter = new QFilter("unabsorbentry.mfgpdendamt", "!=", (Object)BigDecimal.ZERO);
        otherFilter.and("unabsorbentry.mfgtype", "=", (Object)"5");
        Long prePeriodId = this.args.getPrePeriodId();
        DataSet startMfgDs = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadOtherCostObjectIds"), (String)"sca_calcresult", (String)"billno, costobject,bizstatus", (QFilter[])new QFilter[]{orgFilter, otherFilter, new QFilter("period", "=", (Object)prePeriodId)}, null).groupBy(new String[]{"costobject"}).finish();
        if (!startMfgDs.isEmpty()) {
            for (Row row : startMfgDs) {
                Long costObjectId = row.getLong("costobject");
                if (this.args.getCostObjectIds().contains(costObjectId) || !otherCostObjectIds.add(costObjectId)) continue;
                this.needGenCalcResultObjectIds.add(costObjectId);
            }
        }
        if (!this.expireObjectIds.isEmpty()) {
            QFilter costAccountFilter = new QFilter("costaccount", "=", (Object)this.args.getCostAccountId());
            costAccountFilter.and("costobject", "in", this.expireObjectIds);
            costAccountFilter.and("bizstatus", "=", (Object)"B");
            DataSet closeCostObjectDs = QueryServiceHelper.queryDataSet((String)"costobjectaccount", (String)"cad_costobjectaccount", (String)"costobject", (QFilter[])costAccountFilter.toArray(), null);
            Set settleCostobjectIds = ScaCalcHelper.getLongIdSetFromDs((DataSet)closeCostObjectDs, (String)"costobject", (boolean)false);
            if (!settleCostobjectIds.isEmpty()) {
                this.expireObjectIds.removeAll(settleCostobjectIds);
                otherCostObjectIds.removeAll(settleCostobjectIds);
            }
            logger.info("\u83b7\u53d6\u9700\u8981\u6e05\u7406\u672a\u5438\u6536\u5355\u7684\u6210\u672c\u5bf9\u8c61\uff1a{}\uff0c\u9700\u8981\u6392\u9664\u7684\u6210\u672c\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString(this.expireObjectIds), (Object)JSON.toJSONString((Object)settleCostobjectIds));
        }
        logger.info("\u9700\u8981\u751f\u6210\u8ba1\u7b97\u7ed3\u679c\u5355\u7684\u6210\u672c\u5bf9\u8c61\uff1a{}", (Object)JSON.toJSONString(this.needGenCalcResultObjectIds));
        logger.info(String.format("\u83b7\u53d6\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u7684\u4ea7\u751f\u4e86\u5438\u6536\u8d39\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u5171\u53d6\u51fa %s \u5f20\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", otherCostObjectIds.size(), this.getContext().getFilterBuilder().buildQFilterLogString(orgFilter)));
        return otherCostObjectIds;
    }

    private QFilter[] getQfilters(String type) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        qfList.add(new QFilter("org", "=", (Object)this.args.getOrgId()));
        qfList.add(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        qfList.add(new QFilter("period", "=", (Object)this.args.getPeriodId()));
        Set<Long> unabsorbDiffIds = null;
        Set<Long> costObjectIds = this.getSingleBatchContext().getMfgMainSideObjIds(this.currCostObjectIds);
        switch (type) {
            case "load_cad_mfgfeeallocco": {
                if (this.args.getCostCenterIds() != null && !this.args.getCostCenterIds().isEmpty()) {
                    qfList.add(new QFilter("entryentity.costobject.costcenter", "in", (Object)this.args.getCostCenterIds()));
                }
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    qfList.add(new QFilter("entryentity.costobject", "in", costObjectIds));
                }
                qfList.add(new QFilter("allocstatus", "=", (Object)"2"));
                qfList.add(new QFilter("entryentity.costobject.isactfeenocal", "=", (Object)"0"));
                break;
            }
            case "load_sca_calcresult_subelement_mfgfeeal": {
                if (this.args.getCostCenterIds() != null && !this.args.getCostCenterIds().isEmpty()) {
                    qfList.add(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
                }
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    qfList.add(new QFilter("costobject", "in", costObjectIds));
                }
                qfList.add(new QFilter("entryentity.caltype", "in", (Object)new String[]{"2", "4"}));
                qfList.add(new QFilter("entryentity.datatype", "in", (Object)"3"));
                break;
            }
            case "load_sca_unabsorbdiff_subelement": {
                QFilter voucherQf = new QFilter("vouchernum", "!=", (Object)" ");
                qfList.add(new QFilter("difftype", "=", (Object)"4"));
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    qfList.add(new QFilter("costobject", "in", costObjectIds));
                }
                if (!CadEmptyUtils.isEmpty(unabsorbDiffIds = this.loadUnabsorbDiffIds2Voucher())) {
                    voucherQf.or(new QFilter("id", "in", unabsorbDiffIds));
                }
                qfList.add(voucherQf);
                break;
            }
            case "del_sca_totalmfgfee": {
                if (this.args.getCostCenterIds() != null && !this.args.getCostCenterIds().isEmpty()) {
                    qfList.add(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
                }
                if (CadEmptyUtils.isEmpty(costObjectIds)) break;
                qfList.add(new QFilter("costobject", "in", costObjectIds));
                break;
            }
            case "del_sca_unabsorb_diff": {
                if (this.args.getCostCenterIds() != null && !this.args.getCostCenterIds().isEmpty()) {
                    qfList.add(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
                }
                if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                    qfList.add(new QFilter("costobject", "in", costObjectIds));
                }
                qfList.add(new QFilter("vouchernum", "=", (Object)" "));
                qfList.add(new QFilter("difftype", "=", (Object)"4"));
                unabsorbDiffIds = this.loadUnabsorbDiffIds2Voucher();
                if (CadEmptyUtils.isEmpty(unabsorbDiffIds)) break;
                qfList.add(new QFilter("id", "not in", unabsorbDiffIds));
            }
        }
        return qfList.toArray(new QFilter[0]);
    }

    private Set<Long> loadUnabsorbDiffIds2Voucher() {
        Set<Long> costAdjustIds;
        if (this.unabsorbDiffIds_voucher != null) {
            return this.unabsorbDiffIds_voucher;
        }
        this.unabsorbDiffIds_voucher = new HashSet<Long>(16);
        QFilter createTypeQf = new QFilter("createtype", "=", (Object)"R");
        QFilter voucherNumQf = new QFilter("vouchernum", "!=", (Object)" ");
        Date[] dates = this.getContext().getCurrPeriodDate(this.args.getPeriodId());
        QFilter bizDateQf = new QFilter("bizdate", "<=", (Object)(dates == null ? TimeServiceHelper.now() : dates[1]));
        bizDateQf.and(new QFilter("bizdate", ">=", (Object)(dates == null ? TimeServiceHelper.now() : dates[0])));
        QFilter[] filters_costAdjust = new QFilter[]{createTypeQf, voucherNumQf, bizDateQf};
        Set<Long> unabsorbDiffIds1 = this.loadUnabsorbIdByCostAdjustIds(filters_costAdjust);
        this.unabsorbDiffIds_voucher.addAll(unabsorbDiffIds1);
        logger.info(String.format("\u6839\u636e\u672c\u671f\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff0c\u53cd\u67e5\u51fa%s\u5f20\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355", unabsorbDiffIds1.size()));
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        qfList.add(new QFilter("org", "=", (Object)this.args.getOrgId()));
        qfList.add(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        qfList.add(new QFilter("period", "=", (Object)this.args.getPeriodId()));
        qfList.add(voucherNumQf);
        qfList.add(new QFilter("difftype", "=", (Object)"4"));
        Set<Object> costObjectIds = this.loadFinishCalcCostObject();
        costObjectIds.addAll(this.getSingleBatchContext().getMainSideCostObjectIds());
        if (!CadEmptyUtils.isEmpty(costObjectIds)) {
            qfList.add(new QFilter("costobject", "in", costObjectIds));
        }
        HashSet<Long> unabsorbDiffIds2 = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".getVoucherFromCal1"), (String)"sca_unabsorbdiff", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                unabsorbDiffIds2.add(row.getLong("id"));
            }
        }
        this.unabsorbDiffIds_voucher.addAll(unabsorbDiffIds2);
        logger.info(String.format("\u5171\u8bfb\u53d6 %s \u5f20\u5df2\u7ecf\u751f\u6210\u4e86\u51ed\u8bc1\u7684\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", unabsorbDiffIds2.size(), this.getContext().getFilterBuilder().buildQFilterLogString(qfList)));
        if (!unabsorbDiffIds2.isEmpty() && !(costAdjustIds = this.loadCostAdjustIdByUnabsorbIds(unabsorbDiffIds2)).isEmpty()) {
            QFilter idQf = new QFilter("id", "in", costAdjustIds);
            Set<Long> unabsorbDiffIds3 = this.loadUnabsorbIdByCostAdjustIds(new QFilter[]{idQf});
            this.unabsorbDiffIds_voucher.addAll(unabsorbDiffIds3);
            logger.info(String.format("%s\u5f20\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355\uff0c\u8054\u67e5\u5230%s\u5f20\u6210\u672c\u8c03\u6574\u5355\uff0c\u518d\u53cd\u67e5\u5230%s\u5f20\u672a\u5438\u6536\u8d39\u7528\u5dee\u5f02\u5355", unabsorbDiffIds2.size(), costAdjustIds.size(), unabsorbDiffIds3.size()));
        }
        return this.unabsorbDiffIds_voucher;
    }

    private Set<Long> loadCostAdjustIdByUnabsorbIds(Set<Long> unabsorbDiffIds) {
        HashSet<Long> costAdjustIds = new HashSet<Long>();
        if (unabsorbDiffIds == null || unabsorbDiffIds.isEmpty()) {
            return costAdjustIds;
        }
        QFilter srcBillQf = new QFilter("entryentity.srcbillid", "in", unabsorbDiffIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".loadCostAdjustIdByUnabsorbIds1"), (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{srcBillQf}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                costAdjustIds.add(row.getLong("id"));
            }
        }
        QFilter invBillQf = new QFilter("entryentity.invbillid", "in", unabsorbDiffIds);
        invBillQf = invBillQf.and(new QFilter("entryentity.srcbillid", "=", (Object)0L));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey(".loadCostAdjustIdByUnabsorbIds2"), (String)"cal_stdcostdiffbill", (String)"id", (QFilter[])new QFilter[]{invBillQf}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                costAdjustIds.add(row.getLong("id"));
            }
        }
        logger.info(String.format("\u5171\u53d6\u51fa %s \u5f20\u76f8\u5173\u7684\u6210\u672c\u8c03\u6574\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a \r\n %s", costAdjustIds.size(), this.getContext().getFilterBuilder().buildQFilterLogString(new QFilter[]{srcBillQf, invBillQf})));
        return costAdjustIds;
    }

    private Set<Long> loadUnabsorbIdByCostAdjustIds(QFilter[] filters_costAdjust) {
        HashSet<Long> unabsorbDiffIds = new HashSet<Long>();
        int rowCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("getVoucherFromCal1"), (String)"cal_stdcostdiffbill", (String)"entryentity.invbillid invbillid, entryentity.srcbillid srcbillid", (QFilter[])filters_costAdjust, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                Long invbillid = row.getLong("invbillid");
                Long srcbillid = row.getLong("srcbillid");
                if (invbillid != null && Long.compare(0L, invbillid) != 0) {
                    unabsorbDiffIds.add(invbillid);
                }
                if (srcbillid == null || Long.compare(0L, srcbillid) == 0) continue;
                unabsorbDiffIds.add(srcbillid);
            }
        }
        logger.info(String.format("\u6839\u636e\u6761\u4ef6\u8bfb\u53d6\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\uff08\u6210\u672c\u8c03\u6574\u5355\uff09\u5b8c\u6bd5\uff0c\u5171\u53d6\u51fa%s\u884c\uff0c\u5173\u8054%s\u5f20\u672a\u5438\u6536\u8d39\u7528\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, unabsorbDiffIds.size(), this.getContext().getFilterBuilder().buildQFilterLogString(filters_costAdjust)));
        return unabsorbDiffIds;
    }

    private Set<Object> loadFinishCalcCostObject() {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.args.getOrgId());
        orgFilter.and(new QFilter("costaccount", "=", (Object)this.args.getCostAccountId()));
        orgFilter.and(new QFilter("period", "=", (Object)this.args.getPeriodId()));
        orgFilter.and(new QFilter("costobject.bizstatus", "=", (Object)"B"));
        if (!CollectionUtils.isEmpty((Collection)this.args.getCostCenterIds())) {
            orgFilter.and(new QFilter("costcenter", "in", (Object)this.args.getCostCenterIds()));
        }
        DynamicObjectCollection calcResults = QueryServiceHelper.query((String)"sca_calcresult", (String)"billno,costobject", (QFilter[])new QFilter[]{orgFilter});
        HashSet<Object> costObjectIds = new HashSet<Object>(16);
        calcResults.forEach(c -> costObjectIds.add(c.getLong("costobject")));
        return costObjectIds;
    }

    protected void executeBatch(String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, entrys);
    }
}

