/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CalcResultMfgEntryRow;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

class SaveCalcResultAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(SaveCalcResultAction.class);

    SaveCalcResultAction() {
    }

    @Override
    protected void doExecute() {
        logger.info("\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\uff1a\u5f00\u59cb");
        ArrayList<CalcResultHeader> saveCalcResultHeaders = new ArrayList<CalcResultHeader>(10);
        ArrayList<CalcResultEntryRow> saveCalcResultEntryRows = new ArrayList<CalcResultEntryRow>(10);
        ArrayList<CalcResultMfgEntryRow> saveCalcMfgEntryRows = new ArrayList<CalcResultMfgEntryRow>(10);
        Map<Long, CalcResultHeader> calcResults = this.getSingleBatchResultManager().getCalcResults();
        Long userId = 0L;
        if (StringUtils.isNotBlank((CharSequence)RequestContext.get().getUserId())) {
            userId = Long.parseLong(RequestContext.get().getUserId());
        }
        Date modifyTime = TimeServiceHelper.now();
        for (Map.Entry<Long, CalcResultHeader> calcResultEntryItem : calcResults.entrySet()) {
            CalcResultHeader calcResult = calcResultEntryItem.getValue();
            saveCalcResultHeaders.add(calcResultEntryItem.getValue());
            this.getResultManager().getCalcResultIds().add(calcResult.getId());
            calcResult.setModifier(userId.longValue());
            calcResult.setModifyTime(modifyTime);
            for (int i = 0; i < calcResult.getEntryRows().size(); ++i) {
                CalcResultEntryRow entryRow = (CalcResultEntryRow)calcResult.getEntryRows().get(i);
                entryRow.setSeq(i + 1);
                saveCalcResultEntryRows.add(entryRow);
            }
            for (CalcResultMfgEntryRow mfgEntryRow : calcResult.getMfgEntryRows()) {
                saveCalcMfgEntryRows.add(mfgEntryRow);
            }
        }
        if (!saveCalcResultHeaders.isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)CalcResultHeader.getDataEntityType(), (Object[])saveCalcResultHeaders.toArray());
        }
        boolean saveLogInfo = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"scaCalcresultLogSave", (String)"0"));
        if (!saveCalcResultEntryRows.isEmpty()) {
            String entryInsertSql = "insert into t_sca_calcresultentry(fentryid,fid,fseq,fdatatype,fcaltype,fdifftype,felementid,fsubelementid,fresourceid,fcalcbasis,fcostlevel,fcostobjectid,fproducttype,fmaterialid,fauxpty,fmatversionid,fkeycol,fkeycolid,fpdstartqty,fpdstartamount,fpdcurrtqty,fpdcurramount,fpdcompqty,fpdcompanount,fpdendqty,fpdendamount,ftotalqty,ftotalamount,fstdqty,fstdamount,fdiffqty,fdiff,fcostupdatediff,fcostupdatediffamt,fsourceinfo) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            String subentryInsertSql = "insert into t_sca_calcresultsubentry(fentryid,fdetailid,fseq,fcalckeycolid,fsubcurrqty) values(?,?,?,?,?)";
            List splitLists = Lists.partition(saveCalcResultEntryRows, (int)1000);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> subparamList = new ArrayList<Object[]>(10);
            for (List list : splitLists) {
                for (CalcResultEntryRow row : list) {
                    if (row.getDataType() == null) continue;
                    Object[] paramArr = new Object[]{row.getEntryId(), row.getId(), row.getSeq(), row.getDataType(), row.getCalType(), this.getDbStr(row.getDiffType()), row.getElement(), row.getSubElement(), row.getResource(), this.getDbStr(row.getCalcbasis()), this.getDbStr(row.getCostLevel()), row.getCostObject(), row.getProductType(), row.getMaterial(), row.getAuxpty(), row.getMatVersion(), this.getDbStr(row.getKeycol()), row.getKeycolId(), row.getPdStartQty(), row.getPdStartAmount(), row.getPdCurrQty(), row.getPdCurrAmount(), row.getPdCompQty(), row.getPdCompAmount(), row.getPdEndQty(), row.getPdEndAmount(), row.getTotalQty(), row.getTotalAmount(), row.getStdQty(), row.getStdAmount(), row.getDiffQty(), row.getDiffAmount(), row.getCostUpdateDiffQty(), row.getCostUpdateDiffAmount(), saveLogInfo ? row.getSourceInfo() : ""};
                    paramList.add(paramArr);
                    if (row.getKeycolValMap() == null) continue;
                    int i = 1;
                    for (Map.Entry entry : row.getKeycolValMap().entrySet()) {
                        subparamList.add(new Object[]{row.getEntryId(), ID.genLongId(), i++, entry.getKey(), entry.getValue()});
                    }
                }
                try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
                    this.executeBatch(entryInsertSql, paramList);
                    if (!subparamList.isEmpty()) {
                        this.executeBatch(subentryInsertSql, subparamList);
                    }
                }
                paramList.clear();
                subparamList.clear();
            }
        }
        if (!saveCalcMfgEntryRows.isEmpty()) {
            String absobEntrySql = "insert into T_SCA_UNABSORBENTRY(fentryid,fid,fseq,ftype,felementid,fsubelementid,fpdstartqty,fpdstartamt,fpdcurrqty,fpdcurramt,fpdendqty,fpdendamt,fpddiffqty,fpddiffamt,ftotaldiffqty,ftotaldiffamt,fsourceinfo,fmfgobjid,fmfgprotype) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            List splitLists = Lists.partition(saveCalcMfgEntryRows, (int)1000);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            for (List list : splitLists) {
                for (CalcResultMfgEntryRow row : list) {
                    Object[] paramArr = new Object[]{row.getEntryId(), row.getId(), row.getSeq(), row.getType(), row.getMfgElement(), row.getMfgSubElement(), row.getMfgPdStartQty(), row.getMfgPdStartAmt(), row.getMfgPdCurrQty(), row.getMfgPdCurrAmt(), row.getMfgPdEndQty(), row.getMfgPdEndAmt(), row.getMfgPdDiffQty(), row.getMfgPdDiffAmt(), row.getMfgTotalDiffQty(), row.getMfgTotalDiffAmt(), saveLogInfo ? row.getMfgSourceInfo() : "", row.getCostObjectId(), row.getProductType()};
                    paramList.add(paramArr);
                }
                try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_sca_calcresult", (HintCondition[])new HintCondition[]{new HintCondition("fperiodid", "=", (Object)this.getContext().getInputArgs().getPeriodId())});){
                    this.executeBatch(absobEntrySql, paramList);
                }
                paramList.clear();
            }
        }
        logger.info(String.format("\u4fdd\u5b58\u8ba1\u7b97\u7ed3\u679c\uff1a\u7ed3\u675f\uff0c\u5171\u4fdd\u5b58 %s \u5f20, %s \u884c", saveCalcResultHeaders.size(), saveCalcResultEntryRows.size()));
    }

    private String getDbStr(String key) {
        if (key == null) {
            return " ";
        }
        return key;
    }

    protected void executeBatch(String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)sql, entrys);
    }
}

