/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.BillBaseEnum;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.costcalc.Diff2CostAdjust;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;

public class SaveFinishDiffAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(SaveFinishDiffAction.class);
    private Map<Long, List<CalcResultEntryRow>> filteredCalcResult = Maps.newHashMapWithExpectedSize((int)128);
    private Set<Long> needDelFinishDiff = Sets.newHashSetWithExpectedSize((int)128);
    private Map<Long, Set<Long>> needDelCostAdjust = Maps.newHashMapWithExpectedSize((int)128);
    private Set<Long> voucherFinishDiff = Sets.newHashSetWithExpectedSize((int)128);
    private Map<Long, Long> finishDiffNoVoucherMap = new HashMap<Long, Long>(128);
    private Map<Long, Map<Long, BigDecimal>> finishDiffNoVourcherDetail = new HashMap<Long, Map<Long, BigDecimal>>(128);
    private Map<Long, Map<Long, BigDecimal>> voucherIdDataMap = Maps.newHashMapWithExpectedSize((int)128);
    private Map<Long, Long> objIdFinishDiffMap = Maps.newHashMapWithExpectedSize((int)32);
    private Diff2CostAdjust diff2CostAdjust;
    private List<DynamicObject> finishDiffs2Cal = Lists.newArrayList();

    @Override
    protected void doExecute() {
        this.filterCalcResult();
        this.divisionFinishDiff();
        this.delFinishDiff();
        this.generateFinishDiff();
        this.voucherDataNegate();
        this.sendData2CostAdjust();
    }

    private void sendData2CostAdjust() {
        if (this.diff2CostAdjust == null) {
            this.diff2CostAdjust = new Diff2CostAdjust();
        }
        if (!CadEmptyUtils.isEmpty(this.finishDiffs2Cal)) {
            Object[] syncSuccessBills = this.diff2CostAdjust.calCostBillService(this.finishDiffs2Cal.toArray(new DynamicObject[0]), "Z");
            if (!CadEmptyUtils.isEmpty((Object[])syncSuccessBills)) {
                SaveServiceHelper.save((IDataEntityType)syncSuccessBills[0].getDataEntityType(), (Object[])syncSuccessBills);
            } else {
                logger.info("\u672a\u521b\u5efa\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355");
            }
        }
    }

    private void voucherDataNegate() {
        logger.info("\u5f00\u59cb\u5904\u7406\u9700\u8981\u53cd\u5411\u7684\u6570\u636e");
        HashMap objIdDyMap = Maps.newHashMapWithExpectedSize((int)32);
        if (!CadEmptyUtils.isEmpty(this.objIdFinishDiffMap)) {
            Collection<Long> values = this.objIdFinishDiffMap.values();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_finishdiffbill");
            Object[] finishDiffs = BusinessDataServiceHelper.load((Object[])values.toArray(), (DynamicObjectType)type);
            if (!CadEmptyUtils.isEmpty((Object[])finishDiffs)) {
                for (Object finishDiff : finishDiffs) {
                    long costObjectId = finishDiff.getLong("costobject.id");
                    objIdDyMap.put(costObjectId, finishDiff);
                }
            }
        }
        if (!CadEmptyUtils.isEmpty(this.voucherIdDataMap)) {
            ArrayList negateData = Lists.newArrayListWithExpectedSize((int)32);
            for (Map.Entry<Long, Map<Long, BigDecimal>> objIdSubEleIdAmtEntry : this.voucherIdDataMap.entrySet()) {
                DynamicObject finishDiff;
                DynamicObjectCollection entryEntity;
                Long costObjectId = objIdSubEleIdAmtEntry.getKey();
                Map<Long, BigDecimal> subEleIdAmtMap = objIdSubEleIdAmtEntry.getValue();
                if (subEleIdAmtMap.isEmpty() || !objIdDyMap.containsKey(costObjectId) || CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryEntity = (finishDiff = (DynamicObject)objIdDyMap.get(costObjectId)).getDynamicObjectCollection("entryentity")))) continue;
                Iterator iterator = entryEntity.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entryRow = (DynamicObject)iterator.next();
                    long subElementId = entryRow.getLong("subelement.id");
                    if (subEleIdAmtMap.containsKey(subElementId)) continue;
                    iterator.remove();
                }
                negateData.add(finishDiff);
            }
            for (DynamicObject finishDiff : negateData) {
                DynamicObject negateDiff = (DynamicObject)OrmUtils.clone((IDataEntityBase)finishDiff, (boolean)false, (boolean)true);
                DynamicObjectCollection entryEntity = negateDiff.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryRow : entryEntity) {
                    entryRow.set("amount", (Object)entryRow.getBigDecimal("amount").negate());
                }
                this.finishDiffs2Cal.add(negateDiff);
            }
        }
    }

    private void generateFinishDiff() {
        if (!CadEmptyUtils.isEmpty(this.filteredCalcResult)) {
            int size = this.filteredCalcResult.size();
            String[] billNos = CodeRuleServiceHelper.getBatchNumber((String)"sca_finishdiffbill", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_finishdiffbill"), (String)"", (int)size);
            int useCount = 0;
            CostCalcArgs inputArgs = this.getContext().getInputArgs();
            Map costObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])this.filteredCalcResult.keySet().toArray(), (String)"cad_costobject");
            for (Map.Entry<Long, List<CalcResultEntryRow>> calcResultEntry : this.filteredCalcResult.entrySet()) {
                DynamicObject finishDiffBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_finishdiffbill");
                Long costObjectId = calcResultEntry.getKey();
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) continue;
                finishDiffBill.set("id", (Object)ID.genLongId());
                finishDiffBill.set("period", (Object)inputArgs.getPeriodId());
                finishDiffBill.set("org", (Object)inputArgs.getOrgId());
                finishDiffBill.set("costaccount", (Object)inputArgs.getCostAccountId());
                finishDiffBill.set("costobject", (Object)costObjectId);
                finishDiffBill.set("currency", (Object)inputArgs.getCurrencyId());
                finishDiffBill.set("billno", (Object)billNos[useCount]);
                finishDiffBill.set("proallocgen", (Object)"1");
                ++useCount;
                DynamicObject costObject = (DynamicObject)costObjectMap.get(costObjectId);
                if (!CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
                    finishDiffBill.set("costcenter", (Object)costObject.getLong("costcenter.id"));
                    finishDiffBill.set("manuorg", (Object)costObject.getLong("manuorg.id"));
                    finishDiffBill.set("material", (Object)costObject.getLong("material.id"));
                    finishDiffBill.set("auxpty", (Object)costObject.getLong("auxpty.id"));
                    finishDiffBill.set("unit", (Object)costObject.getLong("material.baseunit.id"));
                }
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                Date date = TimeServiceHelper.now();
                finishDiffBill.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
                finishDiffBill.set("creator", (Object)userId);
                finishDiffBill.set("createtime", (Object)date);
                finishDiffBill.set("modifier", (Object)userId);
                finishDiffBill.set("modifytime", (Object)date);
                finishDiffBill.set("auditor", (Object)userId);
                finishDiffBill.set("auditdate", (Object)date);
                Map<Object, Object> subElementAmtMap = Maps.newHashMapWithExpectedSize((int)8);
                if (this.voucherIdDataMap.containsKey(costObjectId)) {
                    subElementAmtMap = this.voucherIdDataMap.get(costObjectId);
                }
                int entryCount = 0;
                DynamicObjectCollection entryEntity = finishDiffBill.getDynamicObjectCollection("entryentity");
                HashMap<String, DynamicObject> keyEntryMap = new HashMap<String, DynamicObject>(32);
                for (CalcResultEntryRow entryRow : calcResultEntry.getValue()) {
                    String dataType = entryRow.getDataType();
                    String calType = entryRow.getCalType();
                    if ("2".equals(dataType) && "1".equals(calType)) {
                        long subElementId = entryRow.getSubElement();
                        BigDecimal diff = entryRow.getDiffAmount();
                        if (BigDecimal.ZERO.equals(diff)) continue;
                        if (subElementAmtMap.containsKey(subElementId)) {
                            BigDecimal storedDiff = (BigDecimal)subElementAmtMap.get(subElementId);
                            if (storedDiff.compareTo(diff) != 0) {
                                diff = storedDiff.subtract(storedDiff);
                                subElementAmtMap.remove(subElementId);
                            } else {
                                subElementAmtMap.remove(subElementId);
                                continue;
                            }
                        }
                        String diffType = entryRow.getDiffType();
                        long element = entryRow.getElement();
                        long subElement = entryRow.getSubElement();
                        String key = String.format("%s@%s@%s", diffType, element, subElement);
                        if (keyEntryMap.containsKey(key)) {
                            DynamicObject entry = (DynamicObject)keyEntryMap.get(key);
                            BigDecimal amount = entry.getBigDecimal("amount");
                            entry.set("amount", (Object)amount.add(diff));
                            continue;
                        }
                        DynamicObject finishEntryRow = entryEntity.addNew();
                        finishEntryRow.set("difftype", (Object)diffType);
                        finishEntryRow.set("element", (Object)entryRow.getElement());
                        finishEntryRow.set("subelement", (Object)entryRow.getSubElement());
                        finishEntryRow.set("amount", (Object)diff);
                        keyEntryMap.put(key, finishEntryRow);
                        ++entryCount;
                        continue;
                    }
                    if (!"5".equals(calType)) continue;
                    BigDecimal diffAmount = entryRow.getDiffAmount();
                    finishDiffBill.set("diffamount", (Object)diffAmount);
                }
                Iterator iterator = entryEntity.iterator();
                while (iterator.hasNext()) {
                    DynamicObject next = (DynamicObject)iterator.next();
                    if (BigDecimal.ZERO.compareTo(next.getBigDecimal("amount")) != 0) continue;
                    iterator.remove();
                }
                DynamicObjectCollection dynaCols = finishDiffBill.getDynamicObjectCollection("entryentity");
                if (dynaCols == null || dynaCols.isEmpty()) continue;
                this.finishDiffs2Cal.add(finishDiffBill);
            }
        }
    }

    private void delFinishDiff() {
        if (!CadEmptyUtils.isEmpty(this.needDelCostAdjust)) {
            OperateOption opr = OperateOption.create();
            opr.setVariableValue("diffAlloc", "true");
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"cal_stdcostdiffbill", (Object[])this.needDelCostAdjust.keySet().toArray(), (OperateOption)opr);
            OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"cal_stdcostdiffbill", (Object[])this.needDelCostAdjust.keySet().toArray(), (OperateOption)opr);
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cal_stdcostdiffbill"), (Object[])this.needDelCostAdjust.keySet().toArray());
        }
        if (!CadEmptyUtils.isEmpty(this.needDelFinishDiff)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_finishdiffbill"), (Object[])this.needDelFinishDiff.toArray());
            logger.info("\u5171\u5220\u9664{}\u5f20\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\uff0c\u5220\u9664\u6761\u4ef6\uff1a{}", (Object)this.needDelFinishDiff.size(), (Object)SerializationUtils.toJsonString(this.needDelFinishDiff));
        }
    }

    private void divisionFinishDiff() {
        List<Object> costObjectIds = this.getSingleBatchContext().getMainSideCostObjectIds();
        CostCalcArgs inputArgs = this.getContext().getInputArgs();
        Long orgId = inputArgs.getOrgId();
        Long periodId = inputArgs.getPeriodId();
        Long costAccountId = inputArgs.getCostAccountId();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter periodQf = new QFilter("period", "=", (Object)periodId);
        QFilter costAccountQf = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter costObjectQf = new QFilter("costobject", "in", costObjectIds);
        HashSet finishDiffIds = Sets.newHashSetWithExpectedSize((int)128);
        QFilter[] finishDiffQfs = new QFilter[]{orgQf, periodQf, costAccountQf, costObjectQf};
        try (DataSet finishDiffDataSet = QueryServiceHelper.queryDataSet((String)"SaveFinishDiffAction.delExitsDiffData_0", (String)"sca_finishdiffbill", (String)"id,costobject,vouchernum,entryentity.subelement subelement,entryentity.amount amount", (QFilter[])finishDiffQfs, null);){
            while (finishDiffDataSet.hasNext()) {
                Row finishDiff = finishDiffDataSet.next();
                String voucherNum = finishDiff.getString("vouchernum");
                Long finishDiffId = finishDiff.getLong("id");
                Long costObjectId = finishDiff.getLong("costobject");
                Long subElementId = finishDiff.getLong("subelement");
                BigDecimal amount = finishDiff.getBigDecimal("amount");
                if (!CadEmptyUtils.isEmpty((String)voucherNum)) {
                    this.objIdFinishDiffMap.put(costObjectId, finishDiffId);
                    this.voucherFinishDiff.add(finishDiffId);
                    Map subEleAmtMap = this.voucherIdDataMap.computeIfAbsent(costObjectId, s -> new HashMap());
                    subEleAmtMap.put(subElementId, amount);
                } else {
                    this.finishDiffNoVoucherMap.put(finishDiffId, costObjectId);
                    this.finishDiffNoVourcherDetail.computeIfAbsent(costObjectId, s -> new HashMap()).put(subElementId, amount);
                    this.needDelFinishDiff.add(finishDiffId);
                }
                finishDiffIds.add(finishDiffId);
            }
        }
        logger.info("\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355:{}\u5f20", (Object)this.voucherFinishDiff.size());
        logger.info("\u5171\u53d6\u51fa{}\u5f20\u76f8\u5173\u7684\u672a\u5438\u6536\u5dee\u5f02\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a{}", (Object)finishDiffIds.size(), (Object)this.getContext().getFilterBuilder().buildQFilterLogString(finishDiffQfs));
        if (CadEmptyUtils.isEmpty(this.needDelFinishDiff)) {
            logger.info("\u6ca1\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5b8c\u5de5\u5dee\u5f02\u5355\uff0c\u65e0\u5173\u8054\u7684\u6807\u51c6\u6210\u672c\u5dee\u5f02\u5355\u9700\u8981\u88ab\u5220\u9664");
        } else {
            QFilter srcBillQf = new QFilter("entryentity.srcbillid", "in", this.needDelFinishDiff);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("SaveFinishDiffAction.delExitsDiffData_1"), (String)"cal_stdcostdiffbill", (String)"id,entryentity.srcbillid srcbillid,isvoucher", (QFilter[])new QFilter[]{srcBillQf}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long id = row.getLong("id");
                    Long srcBillId = row.getLong("srcbillid");
                    String isvoucher = row.getString("isvoucher");
                    if ("1".equals(isvoucher)) {
                        this.needDelFinishDiff.remove(srcBillId);
                        this.voucherFinishDiff.add(srcBillId);
                        Long costObjectId = this.finishDiffNoVoucherMap.get(srcBillId);
                        this.objIdFinishDiffMap.put(this.finishDiffNoVoucherMap.get(srcBillId), srcBillId);
                        this.voucherIdDataMap.put(costObjectId, this.finishDiffNoVourcherDetail.get(costObjectId));
                        continue;
                    }
                    this.needDelCostAdjust.computeIfAbsent(id, s -> new HashSet()).add(srcBillId);
                }
            }
        }
        logger.info("\u9700\u8981\u5220\u9664\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u5355\u636e\uff1a{}\u5f20\uff0c\u6210\u672c\u8c03\u6574\u5355:{}\u5f20", (Object)this.needDelFinishDiff.size(), (Object)this.needDelCostAdjust.size());
    }

    private void filterCalcResult() {
        logger.info("\u7b5b\u9009\u672c\u671f\u9700\u8981\u751f\u6210\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u7684\u8ba1\u7b97\u7ed3\u679c\u5355\uff1a\u5f00\u59cb");
        Map<Long, CalcResultHeader> calcResults = this.getSingleBatchResultManager().getCalcResults();
        if (!CadEmptyUtils.isEmpty(calcResults)) {
            for (Map.Entry<Long, CalcResultHeader> calResultEntry : calcResults.entrySet()) {
                CalcResultHeader header = calResultEntry.getValue();
                List entryRows = header.getEntryRows();
                if (CadEmptyUtils.isEmpty((List)entryRows)) continue;
                for (CalcResultEntryRow entryRow : entryRows) {
                    BigDecimal diffAmount = entryRow.getDiffAmount();
                    String dataType = entryRow.getDataType();
                    if (!"2".equals(dataType) && !"98".equals(dataType) && !"99".equals(dataType) || diffAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    this.filteredCalcResult.computeIfAbsent(entryRow.getCostObject(), s -> new ArrayList()).add(entryRow);
                }
            }
        }
        logger.info("\u7b5b\u9009\u51fa\uff1a{}\u6761\u672c\u671f\u9700\u8981\u751f\u6210\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u7684\u8ba1\u7b97\u7ed3\u679c\u5355", (Object)this.filteredCalcResult.size());
    }
}

