/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.common.costcalc.groupkey.MatFinalGroupKey;
import kd.macc.sca.mservice.costcalc.CalcTaskType;
import kd.macc.sca.mservice.costcalc.CostCalcContext;

public class SingleBatchContext {
    private CostCalcContext context;
    private int currBatchSeq = 1;
    private int batchCount;
    private int batchSize = 100;
    private int batchProcess = 0;
    private int useProcess = 0;
    private final Log logger = LogFactory.getLog(SingleBatchContext.class);
    private List<Object> costObjectIds = Lists.newArrayList();
    private Map<String, String> proAllocStdMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<String, BigDecimal> equivalentMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap = Maps.newHashMapWithExpectedSize((int)64);
    private Map<MatFinalGroupKey, CalcResultEntryRow> mainSideCompletionMap = new HashMap<MatFinalGroupKey, CalcResultEntryRow>(64);

    public SingleBatchContext(CostCalcContext context) {
        this.context = context;
    }

    public CostCalcContext getContext() {
        return this.context;
    }

    public void setContext(CostCalcContext context) {
        this.context = context;
    }

    public int getCurrBatchSeq() {
        return this.currBatchSeq;
    }

    public void setCurrBatchSeq(int currBatchSeq) {
        this.currBatchSeq = currBatchSeq;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public void setBatchCount(int batchCount) {
        this.batchCount = batchCount;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchProcess() {
        return this.batchProcess;
    }

    public void setBatchProcess(int batchProcess) {
        this.batchProcess = batchProcess;
    }

    public int getUseProcess() {
        return this.useProcess;
    }

    public void setUseProcess(int useProcess) {
        this.useProcess = useProcess;
    }

    public boolean isLastBatch() {
        return this.currBatchSeq >= this.batchCount;
    }

    public List<Object> getCostObjectIds() {
        return this.costObjectIds;
    }

    public void setCostObjectIds(List<Object> costObjectIds) {
        this.costObjectIds = costObjectIds;
    }

    public Map<String, String> getProAllocStdMap() {
        CostCalcArgs inputArgs;
        Map proAllocMap;
        if (CadEmptyUtils.isEmpty(this.proAllocStdMap) && !CadEmptyUtils.isEmpty((Map)(proAllocMap = ScaCalcHelper.getProAllocStd((Long)(inputArgs = this.getContext().getInputArgs()).getOrgId(), (Long)inputArgs.getCostAccountId(), (kd.macc.cad.common.constants.CalcTaskType)CalcTaskType.toCommonTaskType(this.getContext().getTaskType()))))) {
            this.proAllocStdMap.putAll(proAllocMap);
        }
        return this.proAllocStdMap;
    }

    public Map<String, BigDecimal> getEquivalentMap() {
        CostCalcArgs inputArgs;
        Map equivalentMap;
        if (CadEmptyUtils.isEmpty(this.equivalentMap) && !CadEmptyUtils.isEmpty((Map)(equivalentMap = ScaCalcHelper.getEquivalentMap((Long)(inputArgs = this.getContext().getInputArgs()).getOrgId(), (Long)inputArgs.getCostAccountId(), (Set)inputArgs.getManuOrgIds(), this.costObjectIds)))) {
            this.equivalentMap.putAll(equivalentMap);
        }
        return this.equivalentMap;
    }

    public Map<Long, Map<Long, CalcResultObjectInfo>> getObjectInfosMap() {
        if (CadEmptyUtils.isEmpty(this.objectInfosMap)) {
            CostCalcArgs inputArgs = this.getContext().getInputArgs();
            HashSet costObjects = Sets.newHashSetWithExpectedSize((int)this.costObjectIds.size());
            for (Object costObjectId : this.costObjectIds) {
                costObjects.add(Long.parseLong(costObjectId.toString()));
            }
            this.objectInfosMap = ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)inputArgs.getOrgId(), (Long)inputArgs.getCostAccountId(), (Long)inputArgs.getPeriodId(), (Long)inputArgs.getPrePeriodId(), (Set)costObjects);
        }
        return this.objectInfosMap;
    }

    public Map<MatFinalGroupKey, CalcResultEntryRow> getMainSideCompletionMap() {
        return this.mainSideCompletionMap;
    }

    public List<Object> getMainSideCostObjectIds() {
        Map<Long, Map<Long, CalcResultObjectInfo>> objectInfosMap = this.getObjectInfosMap();
        ArrayList<Object> mainJoinCostObjectIds = new ArrayList<Object>();
        if (objectInfosMap != null) {
            for (Map.Entry<Long, Map<Long, CalcResultObjectInfo>> objectInfosEntry : objectInfosMap.entrySet()) {
                Map<Long, CalcResultObjectInfo> objectInfoMap = objectInfosEntry.getValue();
                mainJoinCostObjectIds.addAll(objectInfoMap.keySet());
            }
        }
        return mainJoinCostObjectIds;
    }

    public Map<Long, Map<Long, CalcResultObjectInfo>> getMfgObjectInfosMap(Set<Object> currentObjIds) {
        CostCalcArgs inputArgs = this.getContext().getInputArgs();
        HashSet<Long> costObjectIds = new HashSet<Long>(currentObjIds.size());
        for (Object currentObjId : currentObjIds) {
            costObjectIds.add(Long.parseLong(String.valueOf(currentObjId)));
        }
        return ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)inputArgs.getOrgId(), (Long)inputArgs.getCostAccountId(), (Long)inputArgs.getPeriodId(), (Long)inputArgs.getPrePeriodId(), costObjectIds);
    }

    public Set<Long> getMfgMainSideObjIds(Set<Object> currentObjIds) {
        HashSet<Long> mainSideObjIds = new HashSet<Long>(16);
        CostCalcArgs inputArgs = this.getContext().getInputArgs();
        HashSet<Long> costObjectIds = new HashSet<Long>(currentObjIds.size());
        for (Object currentObjId : currentObjIds) {
            costObjectIds.add(Long.parseLong(String.valueOf(currentObjId)));
        }
        Map mainJoinSideCalcResultInfo = ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)inputArgs.getOrgId(), (Long)inputArgs.getCostAccountId(), (Long)inputArgs.getPeriodId(), (Long)inputArgs.getPrePeriodId(), costObjectIds);
        if (mainJoinSideCalcResultInfo != null) {
            for (Map.Entry objectInfoEntry : mainJoinSideCalcResultInfo.entrySet()) {
                mainSideObjIds.addAll(((Map)objectInfoEntry.getValue()).keySet());
            }
        }
        return mainSideObjIds;
    }
}

