/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectKey;
import org.apache.commons.lang3.time.DateUtils;

class SumAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(SumAction.class);
    private static final String ALGO_KEY_PLAN = "kd.macc.sca.mservice.costcalc.action.SumAction.sumPlanQty";
    private static final String ALGO_KEY_COMP = "kd.macc.sca.mservice.costcalc.action.SumAction.sumCompQty";
    private static final String ALGO_KEY_PRE_PERIOD = "kd.macc.sca.mservice.costcalc.action.SumAction.sumPrePeriodQty";
    private CostCalcArgs args;
    private Set<Long> finishedCostObject = null;
    private Map<CostObjectKey, CalcResultEntryRow> sumResultRows = new HashMap<CostObjectKey, CalcResultEntryRow>();
    private Map<Long, Integer> successCoCounts = new HashMap<Long, Integer>();

    SumAction() {
    }

    @Override
    public Long getDetailTaskConfigId() {
        if (this.getContext().isFinishCalc()) {
            return FinshCalcCheck.CALCTASKTOTALCALCRESULT;
        }
        return TaskHelper.PDENDENTRY_CREATEDIFFBILL_TASKID;
    }

    @Override
    protected void doExecute() {
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "2");
        }
        this.args = this.getContext().getInputArgs();
        if (this.args.getOrgId() == null || this.args.getCostAccountId() == null || this.args.getPeriodId() == null) {
            logger.info(String.format("args.isNullReqField() == false, return, orgId: %s, costAccountId: %s, periodId: %s", this.args.getOrgId(), this.args.getCostAccountId(), this.args.getPeriodId()));
            return;
        }
        logger.info("\u6c47\u603b\u8ba1\u7b97\u7ed3\u679c\uff1a\u5f00\u59cb");
        this.doCalculate();
        if (!this.getContext().getIsConcurrency().booleanValue()) {
            this.upateTaskRecordProcess(this.getDetailTaskConfigId(), "2");
            this.upateTaskRecordDetail(this.getDetailTaskConfigId(), "4");
        }
        logger.info("\u6c47\u603b\u8ba1\u7b97\u7ed3\u679c\uff1a\u7ed3\u675f");
    }

    private void doCalculate() {
        this.finishedCostObject = this.loadFinishedCostObject();
        this.sumPlanQty();
        this.sumFinishQty();
        this.sumPrePeriodQty();
        this.sumCurrAmount();
        this.addTotalRows();
        this.analysisCoscenter();
    }

    private void sumPlanQty() {
        Date[] dates = this.getContext().getCurrPeriodDate(this.args.getPeriodId());
        QFilter planBizDateFilter = new QFilter("bizDate", "<=", (Object)dates[1]);
        planBizDateFilter.and(new QFilter("bizDate", ">=", (Object)dates[0]));
        QFilter wipFilter = new QFilter("billstatus", "=", (Object)"C");
        wipFilter.and(new QFilter("accountorg", "=", (Object)this.args.getOrgId()));
        wipFilter.and(new QFilter("costobject", "in", this.getSingleBatchContext().getMainSideCostObjectIds()));
        QFilter appnumQf = new QFilter("appnum", "=", (Object)"sca");
        StringBuilder sb = new StringBuilder();
        sb.append("id, costobject.costcenter costcenterid,");
        sb.append("costobject.mainproobj costobjectid,costobject.id belongobj,costobject.producttype producttype,");
        sb.append("qty pdcurrqty");
        QFilter[] qFilters = new QFilter[]{wipFilter, planBizDateFilter, appnumQf};
        int rowCount = 0;
        try (DataSet planQty = QueryServiceHelper.queryDataSet((String)ALGO_KEY_PLAN, (String)"cad_plannedoutputbill", (String)sb.toString(), (QFilter[])qFilters, null);){
            while (planQty.hasNext()) {
                Row row = planQty.next();
                ++rowCount;
                Long costObjectId = row.getLong("costobjectid");
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
                    costObjectId = row.getLong("belongobj");
                }
                CostObjectKey key = new CostObjectKey(this.args.getOrgId(), this.args.getCostAccountId(), row.getLong("costcenterid"), null, null, costObjectId);
                key.setBelongObjectIdAndProductType(row.getLong("belongobj"), row.getString("producttype"));
                CalcResultEntryRow sumRow = this.sumResultRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                sumRow.addPdCurrQty(row.getBigDecimal("pdcurrqty"));
                sumRow.addTaskValInfo("cad_plannedoutputbill", row.getString("id"), "qty", "PdCurrQty", this.getBigDecimal(row.getBigDecimal("pdcurrqty")));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u672c\u671f\u8ba1\u5212\u6570\u91cf\u5f52\u96c6\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
    }

    private void sumFinishQty() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Date[] dates = this.getContext().getCurrPeriodDate(this.args.getPeriodId());
        filters.add(new QFilter("bookdate", ">=", (Object)dates[0]));
        filters.add(new QFilter("bookdate", "<=", (Object)dates[1]));
        this.getContext().getFilterBuilder().wrapQFilter4OrgAndCostCenter(filters, "org", "costcenter", this.args);
        this.getContext().getFilterBuilder().wrapQFilter4CostObjects(filters, "entryentity.costobject", this.getSingleBatchContext().getMainSideCostObjectIds());
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("appnum", "=", (Object)"sca"));
        StringBuilder sb = new StringBuilder();
        sb.append("id, entryentity.costobject.costcenter costcenterid,");
        sb.append("entryentity.costobject.mainproobj costobjectid,entryentity.costobject.id belongobj,entryentity.costobject.producttype producttype,");
        sb.append("entryentity.qty pdcompqty");
        int rowCount = 0;
        try (DataSet finishInputQty = QueryServiceHelper.queryDataSet((String)ALGO_KEY_COMP, (String)"cad_factnedoutputbill", (String)sb.toString(), (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (finishInputQty.hasNext()) {
                Row row = finishInputQty.next();
                ++rowCount;
                Long costObjectId = row.getLong("costobjectid");
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
                    costObjectId = row.getLong("belongobj");
                }
                CostObjectKey key = new CostObjectKey(this.args.getOrgId(), this.args.getCostAccountId(), row.getLong("costcenterid"), null, null, costObjectId);
                key.setBelongObjectIdAndProductType(row.getLong("belongobj"), row.getString("producttype"));
                CalcResultEntryRow sumRow = this.sumResultRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                sumRow.addPdCompQty(row.getBigDecimal("pdcompqty"));
                sumRow.addTaskValInfo("cad_factnedoutputbill", row.getString("id"), "qty", "PdCompQty", this.getBigDecimal(row.getBigDecimal("pdcompqty")));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u672c\u671f\u5b8c\u5de5\u6570\u91cf\u5f52\u96c6\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(filters)));
    }

    private void sumPrePeriodQty() {
        QFilter calcTypeFilter = new QFilter("entryentity.caltype", "=", (Object)"5");
        Long prePeriodId = this.args.getPrePeriodId();
        QFilter orgAndCcFilter = this.getContext().getFilterBuilder().buildCalcResultCommonFilter(this.args, null, false, false, true);
        QFilter periodFilter = new QFilter("period", "=", (Object)prePeriodId);
        QFilter coFilter = new QFilter("entryentity.obj", "in", this.getSingleBatchContext().getMainSideCostObjectIds());
        StringBuilder sb = new StringBuilder();
        sb.append("id, costcenter.masterid costcenterid,");
        sb.append("costobject costobjectid,entryentity.obj belongobj,entryentity.producttype producttype,");
        sb.append("entryentity.totalqty totalqty,");
        sb.append("entryentity.stdqty stdqty,");
        sb.append("entryentity.pdendqty pdstartqty");
        QFilter[] qFilters = new QFilter[]{orgAndCcFilter, coFilter, periodFilter, calcTypeFilter};
        int rowCount = 0;
        try (DataSet prePeriodQty = QueryServiceHelper.queryDataSet((String)ALGO_KEY_PRE_PERIOD, (String)"sca_calcresult", (String)sb.toString(), (QFilter[])qFilters, null);){
            while (prePeriodQty.hasNext()) {
                Row row = prePeriodQty.next();
                ++rowCount;
                Long costObjectId = row.getLong("costobjectid");
                if (CadEmptyUtils.isEmpty((Long)costObjectId)) {
                    costObjectId = row.getLong("belongobj");
                }
                CostObjectKey key = new CostObjectKey(this.args.getOrgId(), this.args.getCostAccountId(), row.getLong("costcenterid"), null, null, costObjectId);
                key.setBelongObjectIdAndProductType(row.getLong("belongobj"), row.getString("producttype"));
                CalcResultEntryRow sumRow = this.sumResultRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                sumRow.addTotalQty(row.getBigDecimal("totalqty"));
                sumRow.addStdQty(row.getBigDecimal("stdqty"));
                sumRow.addPdStartQty(row.getBigDecimal("pdstartqty"));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "pdendqty", "PdStartQty", this.getBigDecimal(row.getBigDecimal("pdstartqty")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "totalqty", "TotalQty", this.getBigDecimal(row.getBigDecimal("totalqty")));
                sumRow.addTaskValInfo("sca_calcresult", row.getString("id"), "stdqty", "StdQty", this.getBigDecimal(row.getBigDecimal("stdqty")));
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u4e0a\u671f\u671f\u672b\u8ba1\u7b97\u6c47\u603b\u884c\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(qFilters)));
    }

    private void sumCurrAmount() {
        for (CalcResultHeader calcResult : this.getSingleBatchResultManager().getCalcResults().values()) {
            CostObjectKey key = new CostObjectKey(calcResult.getOrg(), calcResult.getCostAccount(), calcResult.getCostCenter(), null, null, calcResult.getCostObject());
            for (CalcResultEntryRow detailRow : calcResult.getEntryRows()) {
                key.setBelongObjectIdAndProductType(detailRow.getCostObject(), detailRow.getProductType());
                if (!StringUtils.equals((CharSequence)"2", (CharSequence)detailRow.getDataType())) continue;
                CalcResultEntryRow sumRow = this.sumResultRows.computeIfAbsent(key, s -> new CalcResultEntryRow());
                sumRow.setCostObject(detailRow.getCostObject());
                sumRow.setProductType(detailRow.getProductType());
                sumRow.addPdStartAmount(detailRow.getPdStartAmount());
                sumRow.addPdCurrAmount(detailRow.getPdCurrAmount());
                sumRow.addPdCompAmount(detailRow.getPdCompAmount());
                sumRow.addPdEndAmount(detailRow.getPdEndAmount());
                sumRow.addTotalAmount(detailRow.getTotalAmount());
                sumRow.addStdAmount(detailRow.getStdAmount());
                sumRow.addDiffAmount(detailRow.getDiffAmount());
                sumRow.addCostUpdateDiffAmount(detailRow.getCostUpdateDiffAmount());
                sumRow.addAllTaskValInfos(detailRow, "PdStartAmount");
                sumRow.addAllTaskValInfos(detailRow, "PdCurrAmount");
                sumRow.addAllTaskValInfos(detailRow, "PdCompAmount");
                sumRow.addAllTaskValInfos(detailRow, "PdEndAmount");
                sumRow.addAllTaskValInfos(detailRow, "TotalAmount");
                sumRow.addAllTaskValInfos(detailRow, "StdAmount");
                sumRow.addAllTaskValInfos(detailRow, "DiffAmount");
                sumRow.addAllTaskValInfos(detailRow, "CostUpdateDiffAmount");
            }
        }
    }

    private void addTotalRows() {
        if (this.sumResultRows.isEmpty()) {
            return;
        }
        for (Map.Entry<CostObjectKey, CalcResultEntryRow> entry : this.sumResultRows.entrySet()) {
            CostObjectKey key = entry.getKey();
            CalcResultEntryRow sumRow = entry.getValue();
            this.addSuccessCount(key.getCostCenterId());
            CalcResultHeader calcResultHeader = this.getSingleBatchResultManager().getCalcResults().get(key.getCostObjectId());
            if (calcResultHeader == null) {
                calcResultHeader = this.createCalcResult(key);
                this.getSingleBatchResultManager().getCalcResults().put(calcResultHeader.getCostObject(), calcResultHeader);
            }
            this.addTotalRow(key, calcResultHeader, sumRow);
        }
    }

    private CalcResultHeader createCalcResult(CostObjectKey key) {
        CalcResultHeader calcResultHeader = new CalcResultHeader();
        calcResultHeader.setId(DBServiceHelper.genGlobalLongId());
        calcResultHeader.setBillNo("NO." + System.currentTimeMillis());
        calcResultHeader.setOrg(key.getOrgId().longValue());
        calcResultHeader.setCostAccount(key.getCostAccountId().longValue());
        calcResultHeader.setCostCenter(key.getCostCenterId().longValue());
        calcResultHeader.setCostObject(key.getCostObjectId().longValue());
        calcResultHeader.setCurrency(this.args.getCurrencyId().longValue());
        calcResultHeader.setPeriod(this.args.getPeriodId().longValue());
        Object bizDate = TimeUtils.compareToEndDate((Date)this.args.getEndDate());
        if (bizDate instanceof Date) {
            calcResultHeader.setBizDate((Date)bizDate);
        } else if (bizDate instanceof Calendar) {
            calcResultHeader.setBizDate(((Calendar)bizDate).getTime());
        }
        calcResultHeader.setBillStatus("A");
        calcResultHeader.setBizStatus("A");
        return calcResultHeader;
    }

    private CalcResultEntryRow addTotalRow(CostObjectKey key, CalcResultHeader calcResultHeader, CalcResultEntryRow sumRow) {
        CalcResultEntryRow row = calcResultHeader.addNew();
        calcResultHeader.setTotalRow(row);
        row.setCalType("5");
        if ("1".equals(this.args.getMatCalType())) {
            row.setDataType("99");
        } else {
            row.setDataType("98");
        }
        row.setCostObject(key.getBelongCostObjectId().longValue());
        row.setProductType(key.getProductType());
        row.setPdStartQty(sumRow.getPdStartQty());
        row.setPdStartAmount(sumRow.getPdStartAmount());
        row.setPdCompQty(sumRow.getPdCompQty());
        row.setPdCompAmount(sumRow.getPdCompAmount());
        row.setPdCurrQty(sumRow.getPdCurrQty());
        row.setPdCurrAmount(sumRow.getPdCurrAmount());
        row.setPdEndQty(sumRow.getPdEndQty());
        row.setPdEndAmount(sumRow.getPdEndAmount());
        row.setTotalQty(sumRow.getTotalQty());
        row.setTotalAmount(sumRow.getTotalAmount());
        row.setStdQty(sumRow.getStdQty());
        row.setStdAmount(sumRow.getStdAmount());
        row.setDiffAmount(sumRow.getDiffAmount());
        row.setCostUpdateDiffAmount(sumRow.getCostUpdateDiffAmount());
        row.addAllTaskValInfos(sumRow, null);
        row.clearTaskValInfos("PdEndQty");
        if (this.finishedCostObject.contains(key.getCostObjectId())) {
            row.setPdEndQty(BigDecimal.ZERO);
        } else {
            BigDecimal pdendqty = sumRow.getPdStartQty().add(sumRow.getPdCurrQty()).subtract(sumRow.getPdCompQty());
            row.setPdEndQty(pdendqty);
            row.addTaskValInfo("this", "", String.format("PdStartQty %s + PdCurrQty %s - PdCompQty %s", sumRow.getPdStartQty(), sumRow.getPdCurrQty(), sumRow.getPdCompQty()), "PdEndQty", pdendqty);
        }
        row.setTotalQty(sumRow.getTotalQty().add(sumRow.getPdCompQty()));
        row.addTaskValInfo("this", "", "PdCompQty", "TotalQty", sumRow.getPdCompQty());
        row.setStdQty(sumRow.getTotalQty().add(sumRow.getPdCompQty()));
        row.addTaskValInfo("this", "", "PdCompQty", "StdQty", sumRow.getPdCompQty());
        return row;
    }

    private void addSuccessCount(Long costCenterId) {
        if (!this.successCoCounts.containsKey(costCenterId)) {
            this.successCoCounts.put(costCenterId, 1);
        } else {
            Integer currSuccess = this.successCoCounts.get(costCenterId);
            currSuccess = currSuccess + 1;
            this.successCoCounts.put(costCenterId, currSuccess);
        }
    }

    private void analysisCoscenter() {
        for (Map.Entry<Long, Integer> entry : this.successCoCounts.entrySet()) {
            Long costCenterId = entry.getKey();
            Integer count = this.getResultManager().getSuccessCoCounts().computeIfAbsent(costCenterId, s -> 0);
            count = count + entry.getValue();
            this.getResultManager().getSuccessCoCounts().put(costCenterId, count);
        }
    }

    private Set<Long> loadFinishedCostObject() {
        if ("1".equals(this.getContext().getInputArgs().getMatCalType())) {
            return this.getFinishedCostobject();
        }
        return new HashSet<Long>(10);
    }

    private Set<Long> getFinishedCostobject() {
        QFilter plannedoutputFilter = new QFilter("billstatus", "=", (Object)"C");
        plannedoutputFilter.and(new QFilter("accountorg", "=", (Object)this.args.getOrgId()));
        plannedoutputFilter.and(new QFilter("costobject", "in", this.getSingleBatchContext().getMainSideCostObjectIds()));
        Date endDate = SumAction.trimDate(this.args.getEndDate());
        endDate = DateUtils.addHours((Date)endDate, (int)24);
        plannedoutputFilter.and(new QFilter("closedatetime", "<", (Object)endDate));
        plannedoutputFilter.and(new QFilter("closedatetime", ">=", (Object)this.args.getStartDate()));
        if (!CadEmptyUtils.isEmpty((Set)this.args.getManuOrgIds())) {
            plannedoutputFilter.and(new QFilter("manuorg", "in", (Object)this.args.getManuOrgIds()));
        }
        if (!CadEmptyUtils.isEmpty((List)this.args.getCostCenterIds())) {
            plannedoutputFilter.and("costcenter", "in", (Object)this.args.getCostCenterIds());
        }
        DataSet plannedoutputData = QueryServiceHelper.queryDataSet((String)"getplan", (String)"cad_plannedoutputbill", (String)"costobject.id costobjectid,closestatu,billstatus,closedatetime", (QFilter[])plannedoutputFilter.toArray(), null);
        HashSet<Long> allcostObject = new HashSet<Long>(16);
        for (Row row : plannedoutputData) {
            if (!row.getBoolean("closestatu").booleanValue() && "C".equals(row.getString("billstatus")) || row.getBoolean("closestatu").booleanValue() && row.getDate("closedatetime").after(endDate)) continue;
            allcostObject.add(row.getLong("costobjectid"));
        }
        return allcostObject;
    }

    private static Date trimDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }
}

