/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.common.costcalc.CalcResultEntryRow;
import kd.macc.sca.common.costcalc.CalcResultHeader;
import kd.macc.sca.common.costcalc.CostCalcArgs;
import kd.macc.sca.mservice.costcalc.CostCalcFilterBuilder;
import kd.macc.sca.mservice.costcalc.action.AbstractSingleBatchAction;
import kd.macc.sca.mservice.costcalc.groupkey.CostObjectKey;
import kd.macc.sca.mservice.costcalc.groupkey.UpdateDiffGroupKey;

class UpdateDiffAction
extends AbstractSingleBatchAction {
    private static final Log logger = LogFactory.getLog(UpdateDiffAction.class);
    private CostCalcArgs args;

    UpdateDiffAction() {
    }

    @Override
    protected void doExecute() {
        logger.info(String.format("\u6210\u672c\u66f4\u65b0\u5dee\u5f02\uff1a\u5f00\u59cb\uff0c\u7b2c %s/ %s\u6279\uff0c\u5171 %s \u5f20", this.getSingleBatchContext().getCurrBatchSeq(), this.getSingleBatchContext().getBatchCount(), this.getSingleBatchContext().getCostObjectIds().size()));
        this.args = this.getContext().getInputArgs();
        Map<CostObjectKey, Map<UpdateDiffGroupKey, CalcResultEntryRow>> costUpdateDiffs = this.loadCostUpdateEstablished();
        this.addUpdateDiffEntryRows(costUpdateDiffs);
        logger.info("\u6210\u672c\u66f4\u65b0\u5dee\u5f02\uff1a\u7ed3\u675f");
    }

    private Map<CostObjectKey, Map<UpdateDiffGroupKey, CalcResultEntryRow>> loadCostUpdateEstablished() {
        HashMap<CostObjectKey, Map<UpdateDiffGroupKey, CalcResultEntryRow>> costUpdateDiffs = new HashMap<CostObjectKey, Map<UpdateDiffGroupKey, CalcResultEntryRow>>();
        CostCalcFilterBuilder filterBuilder = this.getContext().getFilterBuilder();
        ArrayList<QFilter> costupdateeQF = new ArrayList<QFilter>();
        filterBuilder.wrapQFilter4OrgAndCostCenter(costupdateeQF, "productentry.org", "productentry.costcenter", this.getContext().getInputArgs());
        costupdateeQF.add(new QFilter("productentry.period", "=", (Object)this.getContext().getInputArgs().getPeriodId()));
        costupdateeQF.add(new QFilter("productentry.costaccountbook", "=", (Object)this.getContext().getInputArgs().getCostAccountId()));
        costupdateeQF.add(new QFilter("productentry.costobject", "in", this.getSingleBatchContext().getCostObjectIds()));
        String selectFields = "id, productentry.org org,productentry.costaccountbook costaccountbook,productentry.costcenter costcenter,productentry.costobject costobject,productentry.calcbasis calcbasis,productentry.procelement.masterid procelement,productentry.procsubelement.masterid procsubelement,productentry.prosubmaterial.masterid prosubmaterial,productentry.promatversion.id promatversion,productentry.proauxpty.id proauxpty,productentry.resource resource,productentry.updatediff updatediff,productentry.costlevel costlevel";
        int rowCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoKey("loadCostUpdateEstablished"), (String)"cad_costupdateestablished", (String)selectFields, (QFilter[])costupdateeQF.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ++rowCount;
                BigDecimal diffcost = this.getBigDecimal(row.getBigDecimal("updatediff"));
                if (BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
                CostObjectKey costObjectKey = new CostObjectKey(row.getLong("org"), row.getLong("costaccountbook"), row.getLong("costcenter"), row.getLong("costobject"));
                UpdateDiffGroupKey itemKey1 = this.buildGroupKey(row, "1");
                UpdateDiffGroupKey itemKey2 = this.buildGroupKey(row, "2");
                Map diffInfos = costUpdateDiffs.computeIfAbsent(costObjectKey, s -> new HashMap());
                CalcResultEntryRow row1 = diffInfos.computeIfAbsent(itemKey1, s -> new CalcResultEntryRow());
                row1.setCostLevel(row.getString("costlevel"));
                row1.addCostUpdateDiffAmount(diffcost);
                row1.addTaskValInfo("cad_costupdateestablished", row.getString("id"), "updatediff", "CostUpdateDiffAmount", diffcost);
                CalcResultEntryRow row2 = diffInfos.computeIfAbsent(itemKey2, s -> new CalcResultEntryRow());
                row2.addCostUpdateDiffAmount(diffcost);
                row2.setCostLevel(row.getString("costlevel"));
                row2.addTaskValInfo("cad_costupdateestablished", row.getString("id"), "updatediff", "CostUpdateDiffAmount", diffcost);
            }
        }
        logger.info(String.format("\u8bfb\u53d6\u6210\u672c\u66f4\u65b0\u786e\u8ba4\u5355\uff0c\u5171\u53d6\u51fa\u6570\u636e%s\u884c\uff0c\u53d6\u6570\u6761\u4ef6\uff1a\r\n %s", rowCount, this.getContext().getFilterBuilder().buildQFilterLogString(costupdateeQF)));
        return costUpdateDiffs;
    }

    private void addUpdateDiffEntryRows(Map<CostObjectKey, Map<UpdateDiffGroupKey, CalcResultEntryRow>> costUpdateDiffs) {
        Map<Long, CalcResultHeader> calcResults = this.getSingleBatchResultManager().getCalcResults();
        for (Map.Entry<Long, CalcResultHeader> calcResultEntryItem : calcResults.entrySet()) {
            CalcResultHeader calcResult = calcResultEntryItem.getValue();
            CostObjectKey costObjectKey = new CostObjectKey(calcResult.getOrg(), calcResult.getCostAccount(), calcResult.getCostCenter(), calcResult.getCostObject());
            Map<UpdateDiffGroupKey, CalcResultEntryRow> diffInfos = costUpdateDiffs.get(costObjectKey);
            if (diffInfos == null) continue;
            for (Map.Entry<UpdateDiffGroupKey, CalcResultEntryRow> diffInfoEntryItem : diffInfos.entrySet()) {
                UpdateDiffGroupKey itemKey = diffInfoEntryItem.getKey();
                CalcResultEntryRow diffEntryRow = diffInfoEntryItem.getValue();
                BigDecimal diffcost = diffEntryRow.getCostUpdateDiffAmount();
                if (diffcost == null || BigDecimal.ZERO.compareTo(diffcost) == 0) continue;
                diffcost = diffcost.setScale(this.getContext().getCurrencyAmtScale(), RoundingMode.HALF_UP);
                CalcResultEntryRow newEntry = calcResult.addNew();
                newEntry.setCalType(this.args.getMatCalType());
                newEntry.setDataType(itemKey.getDataType());
                newEntry.setDiffType("3");
                newEntry.setElement(itemKey.getElementId().longValue());
                newEntry.setSubElement(itemKey.getSubelementId().longValue());
                newEntry.setMaterial(itemKey.getMaterialId().longValue());
                newEntry.setAuxpty(itemKey.getAuxptyId().longValue());
                newEntry.setMatVersion(itemKey.getMatVersionId().longValue());
                newEntry.setResource(itemKey.getResourceId().longValue());
                newEntry.setCalcbasis("0".equals(itemKey.getCalcBasis()) ? "" : itemKey.getCalcBasis());
                newEntry.setCostLevel(diffEntryRow.getCostLevel());
                newEntry.setPdCurrAmount(diffcost);
                newEntry.setPdEndAmount(diffcost);
                newEntry.setCostUpdateDiffAmount(diffcost);
                newEntry.addAllTaskValInfos(diffEntryRow, "CostUpdateDiffAmount");
                newEntry.addTaskValInfo("this", "CostUpdateDiffAmount", "", "PdCurrAmount", diffcost);
                newEntry.addTaskValInfo("this", "CostUpdateDiffAmount", "", "PdEndAmount", diffcost);
            }
            CalcResultEntryRow totalRow = null;
            BigDecimal totalDiff = BigDecimal.ZERO;
            BigDecimal pdendTotalDiff = BigDecimal.ZERO;
            BigDecimal pdCurrTotalDiff = BigDecimal.ZERO;
            ArrayList<CalcResultEntryRow> diffEntryRows = new ArrayList<CalcResultEntryRow>();
            ArrayList<CalcResultEntryRow> subEntryRows = new ArrayList<CalcResultEntryRow>();
            for (CalcResultEntryRow entryRow : calcResult.getEntryRows()) {
                if ("3".equals(entryRow.getDiffType()) && "2".equals(entryRow.getDataType())) {
                    totalDiff = totalDiff.add(entryRow.getCostUpdateDiffAmount());
                    diffEntryRows.add(entryRow);
                }
                if ("2".equals(entryRow.getDataType())) {
                    pdendTotalDiff = pdendTotalDiff.add(entryRow.getPdEndAmount());
                    pdCurrTotalDiff = pdCurrTotalDiff.add(entryRow.getPdCurrAmount());
                    subEntryRows.add(entryRow);
                }
                if (!"5".equals(entryRow.getCalType())) continue;
                totalRow = entryRow;
            }
            if (totalRow == null) continue;
            totalRow.setCostUpdateDiffAmount(totalDiff);
            totalRow.setPdEndAmount(pdendTotalDiff);
            totalRow.setPdCurrAmount(pdCurrTotalDiff);
            totalRow.clearTaskValInfos("CostUpdateDiffAmount");
            totalRow.clearTaskValInfos("PdCurrAmount");
            totalRow.clearTaskValInfos("PdEndAmount");
            for (CalcResultEntryRow entryRow : diffEntryRows) {
                totalRow.addAllTaskValInfos(entryRow, "CostUpdateDiffAmount");
            }
            for (CalcResultEntryRow entryRow : subEntryRows) {
                totalRow.addAllTaskValInfos(entryRow, "PdCurrAmount");
                totalRow.addAllTaskValInfos(entryRow, "PdEndAmount");
            }
        }
    }

    private UpdateDiffGroupKey buildGroupKey(Row row, String dataType) {
        Long orgId = row.getLong("org");
        Long costAccountId = row.getLong("costaccountbook");
        Long costCenterId = row.getLong("costcenter");
        Long costObjectId = row.getLong("costobject");
        Long elementId = row.getLong("procelement");
        Long subelementId = row.getLong("procsubelement");
        Long materialId = row.getLong("prosubmaterial");
        Long matVersionId = row.getLong("promatversion");
        Long auxptyId = row.getLong("proauxpty");
        Long resourceId = row.getLong("resource");
        String calcBasis = "".equals(row.getString("calcbasis")) ? "0" : row.getString("calcbasis");
        UpdateDiffGroupKey key = new UpdateDiffGroupKey(orgId, costAccountId, costCenterId, costObjectId, elementId, subelementId, materialId, matVersionId, auxptyId, resourceId, calcBasis, dataType);
        return key;
    }
}

