/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.costcalc.action.task;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CadListUtils;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.mservice.costcalc.CostCalcContext;
import kd.macc.sca.mservice.costcalc.CostCalcResultManager;
import kd.macc.sca.mservice.costcalc.action.task.CalcTaskAction;
import kd.macc.sca.mservice.costcalc.action.task.CalcTaskActionParam;

public class CalcPartitionTaskAction {
    private static final Log logger = LogFactory.getLog(CalcTaskAction.class);
    public static final String TASK_STATUS_FAILED = "FAILED";
    public static final Set<String> completedTaskStatus = new HashSet<String>(16){
        private static final long serialVersionUID = 1L;
        {
            this.add("COMPLETED");
            this.add(CalcPartitionTaskAction.TASK_STATUS_FAILED);
            this.add("TIMEOUT");
            this.add("ABORTED");
            this.add("SKIP");
        }
    };

    public void partitionTask(CostCalcContext costCalcContext, int batchsize, CostCalcResultManager costCalcResultManager) {
        long taskStartTime = System.currentTimeMillis();
        String taskName = null;
        taskName = costCalcContext.isFinishCalc() ? ResManager.loadKDString((String)"\u5b8c\u5de5\u6210\u672c\u8ba1\u7b97", (String)"CalcPartitionTaskAction_0", (String)"macc-sca-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"CalcPartitionTaskAction_1", (String)"macc-sca-mservice", (Object[])new Object[0]);
        Set manuOrgs = costCalcContext.getInputArgs().getManuOrgIds();
        HashMap<Long, List> manuOrgCostObjectsMap = new HashMap<Long, List>(16);
        Set costObjectList = costCalcContext.getInputArgs().getCostObjectIds();
        HashMap manuOrgBatchMap = new HashMap(16);
        if (CadEmptyUtils.isEmpty((Set)manuOrgs)) {
            manuOrgCostObjectsMap.put(0L, new ArrayList(costObjectList));
        } else {
            QFilter filter = new QFilter("id", "in", (Object)costObjectList);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"CalcAction-costobject", (String)"cad_costobject", (String)"id,manuorg", (QFilter[])filter.toArray(), null);
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                manuOrgCostObjectsMap.computeIfAbsent(row.getLong("manuorg"), t -> new ArrayList()).add(row.getLong("id"));
            }
        }
        float totalbatch = 0.0f;
        for (Map.Entry entry : manuOrgCostObjectsMap.entrySet()) {
            List splitLists = CadListUtils.splitLists(new ArrayList((Collection)entry.getValue()), (int)batchsize);
            totalbatch += (float)splitLists.size();
            manuOrgBatchMap.put(entry.getKey(), splitLists);
        }
        int batchIndex = 1;
        HashSet<String> hashSet = new HashSet<String>(16);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - 1);
        if (totalbatch == 0.0f) {
            totalbatch = 1.0f;
        }
        float batchunit = 89.0f / totalbatch;
        Float[] batchParamArr = new Float[]{Float.valueOf(0.0f), Float.valueOf(batchunit)};
        for (Map.Entry entry : manuOrgBatchMap.entrySet()) {
            List splitLists = (List)entry.getValue();
            int costobjctSize = ((List)manuOrgCostObjectsMap.get(entry.getKey())).size();
            costCalcContext.getInputArgs().setManuOrgId((Long)entry.getKey());
            logger.info(String.format("\u5206\u6279\u8ba1\u7b97\uff1a\u5f00\u59cb\uff0c\u751f\u4ea7\u7ec4\u7ec7-%s,\u5171%s\u5f20\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u5206\u6210%s\u6279\uff0c\u6bcf\u6279%s\u5f20", entry.getKey(), costobjctSize, splitLists.size(), batchsize));
            batchIndex = 0;
            for (int i = 0; i < splitLists.size(); ++i) {
                List singleCostObjectList = (List)splitLists.get(i);
                StringBuilder coIdstr = new StringBuilder();
                for (Object str : singleCostObjectList) {
                    coIdstr.append(str).append(",");
                }
                logger.info("this-task-is: " + taskName + " total task currBatchDm:" + coIdstr);
                CalcTaskActionParam params = new CalcTaskActionParam();
                params.setInputArgs(costCalcContext.getInputArgs());
                params.setCostObjectIdList(singleCostObjectList);
                params.setTaskType(costCalcContext.getTaskType());
                params.setCurrBatchSeq(i + 1);
                params.setBatchCount(splitLists.size());
                params.setBatchProcess(CalcPartitionTaskAction.getCurrBatchProcess(batchParamArr));
                hashSet.add(this.sendTask(taskName, params, splitLists.size(), batchIndex++));
            }
        }
        logger.info("partitionTask  taskName={}, taskIds size={}, taskId={}", new Object[]{taskName, hashSet.size(), hashSet});
        while (true) {
            QFilter completedFilter = new QFilter("id", "in", hashSet);
            completedFilter.and("status", "in", completedTaskStatus);
            DynamicObjectCollection runningTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])completedFilter.toArray());
            int executedNum = runningTasks.size();
            int totalNum = hashSet.size();
            this.updateTaskRecord(costCalcResultManager, "2", executedNum, totalNum);
            this.updateTaskRecordDetail(costCalcContext, costCalcResultManager, "4", executedNum, totalNum);
            this.updateAndSaveCalcReport(costCalcContext, costCalcResultManager);
            if (executedNum == totalNum) {
                QFilter failTaskFilter = new QFilter("id", "in", hashSet);
                failTaskFilter.and("status", "=", (Object)TASK_STATUS_FAILED);
                failTaskFilter.and("runtime", ">=", (Object)calendar.getTime());
                DynamicObjectCollection failTasks = QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])failTaskFilter.toArray());
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)failTasks)) {
                    throw new KDBizException(taskName + "task\uff0cPartitionTaskService.execute failed\u3002");
                }
                this.upateTaskRecordDetailSubTime(costCalcContext, costCalcResultManager, System.currentTimeMillis() - taskStartTime);
                this.updateTaskRecordDetail(costCalcContext, costCalcResultManager, "4", executedNum, totalNum);
                return;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Throwable)e);
                continue;
            }
            break;
        }
    }

    private void updateAndSaveCalcReport(CostCalcContext costCalcContext, CostCalcResultManager costCalcResultManager) {
        int checkWay = costCalcContext.getInputArgs().getCheckWay();
        costCalcResultManager.getTaskRecorder().updateAndSaveCalcReport(checkWay);
    }

    private void updateTaskRecord(CostCalcResultManager costCalcResultManager, String status, int executedNum, int totalNum) {
        int increProgress = this.getIncrementProgess(costCalcResultManager, executedNum, totalNum);
        if (increProgress <= 0) {
            return;
        }
        costCalcResultManager.getTaskRecorder().upateTaskRecord(increProgress, status, executedNum, totalNum, costCalcResultManager.getCheckResultId());
    }

    private int getIncrementProgess(CostCalcResultManager costCalcResultManager, int executedNum, int totalNUm) {
        if (executedNum <= 0 || totalNUm <= 0) {
            return 0;
        }
        int progress = costCalcResultManager.getTaskRecorder().getTaskRecord().getProgress();
        BigDecimal a = new BigDecimal(Integer.toString(executedNum));
        BigDecimal b = new BigDecimal(Integer.toString(totalNUm));
        return a.divide(b, 2, 4).multiply(new BigDecimal(Integer.toString(100))).intValue() - progress;
    }

    private void updateTaskRecordDetail(CostCalcContext costCalcContext, CostCalcResultManager costCalcResultManager, String status, int currentCount, int totalCount) {
        costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKCLEARCALCRES, status, currentCount, totalCount);
        if (costCalcContext.isFinishCalc()) {
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKABSORBEDFEE, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKGETBEGINFEE, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKTOTALFINISHFEE, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKTOTALCALCRESULT, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(FinshCalcCheck.CALCTASKGENCOSTCONFIRM, status, currentCount, totalCount);
        } else {
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_MATALLOC_TASKID, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_MATCALC_TASKID, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_MFGCALC_TASKID, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_MFGALLOC_TASKID, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_COSTCENTERCALC_TASKID, status, currentCount, totalCount);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetail(TaskHelper.PDENDENTRY_CREATEDIFFBILL_TASKID, status, currentCount, totalCount);
        }
    }

    private void upateTaskRecordDetailSubTime(CostCalcContext costCalcContext, CostCalcResultManager costCalcResultManager, long cosTime) {
        if (costCalcContext.isFinishCalc()) {
            long averageCostTime = (long)Math.ceil((double)cosTime * 1.0 / 6.0);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKCLEARCALCRES, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKABSORBEDFEE, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKGETBEGINFEE, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKTOTALFINISHFEE, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKTOTALCALCRESULT, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKGENCOSTCONFIRM, averageCostTime);
        } else {
            long averageCostTime = (long)Math.ceil((double)cosTime * 1.0 / 7.0);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(FinshCalcCheck.CALCTASKCLEARCALCRES, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_MATALLOC_TASKID, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_MATCALC_TASKID, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_MFGCALC_TASKID, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_MFGALLOC_TASKID, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_COSTCENTERCALC_TASKID, averageCostTime);
            costCalcResultManager.getTaskRecorder().upateTaskRecordDetailSubTime(TaskHelper.PDENDENTRY_CREATEDIFFBILL_TASKID, averageCostTime);
        }
    }

    private static int getCurrBatchProcess(Float[] batchParamArr) {
        float process = batchParamArr[0].floatValue();
        int currP = (int)(process += batchParamArr[1].floatValue());
        batchParamArr[0] = Float.valueOf(process -= (float)currP);
        return currP;
    }

    private String sendTask(String taskName, CalcTaskActionParam params, int totalBatch, int currbatch) {
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("batchInfo", currbatch + "/" + totalBatch);
        try {
            jobParams.put("param", JSONUtils.toString((Object)params));
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        long timestamp = System.currentTimeMillis();
        JobInfo job = new JobInfo();
        job.setRunByLang(Lang.get());
        String OpName = ResManager.loadKDString((String)"\u3010{0}\u3011\uff0c\u7b2c\u3010{1}\u3011\u6279\uff0c\u5f00\u59cb\u6267\u884c\u64cd\u4f5c\u4eba:{2}", (String)"CalcPartitionTaskAction_2", (String)"macc-sca-mservice", (Object[])new Object[0]);
        OpName = MessageFormat.format(OpName, taskName + ",TraceId:" + RequestContext.get().getTraceId() + "/timestamp:" + timestamp, currbatch + "/" + totalBatch, RequestContext.get().getUserName());
        job.setName(OpName);
        job.setJobType(JobType.BIZ);
        job.setParams(jobParams);
        job.setAppId("sca");
        job.setTaskClassname("kd.macc.sca.mservice.costcalc.action.task.CalcTaskAction");
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        return JobClient.dispatch((JobInfo)job);
    }
}

