/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.common.plancost.PlanCostParams;

public class PomOrderSendDownEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PomOrderSendDownEvent.class);

    public Object handleEvent(KDBizEvent e) {
        EntityEvent entityEvent = (EntityEvent)e;
        List businessKeys = entityEvent.getBusinesskeys();
        String entityNumber = entityEvent.getEntityNumber();
        List<String> entityList = this.getEntityList();
        logger.info("\u8ba1\u5212\u6210\u672c\u65e5\u5fd7\u4e8b\u4ef6\u89e6\u53d1\uff0c\u5b9e\u4f53\u7f16\u7801==>{},\u53c2\u6570==\u300b{}", (Object)entityNumber, (Object)businessKeys);
        if (entityList.contains(entityNumber)) {
            List list = Lists.partition(this.idConversion(businessKeys), (int)100);
            for (List ids : list) {
                try {
                    this.addPlanCostCalcLog(entityNumber, ids);
                }
                catch (Exception exception) {
                    logger.info("\u8ba1\u5212\u6210\u672c\u65e5\u5fd7\u540c\u6b65\u5f02\u5e38==>{}", (Object)exception);
                }
            }
        }
        return e.getEventId();
    }

    private void addPlanCostCalcLog(String entityNumber, List<Long> ids) {
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        HashMap<Long, Date> idDateMap = new HashMap<Long, Date>(16);
        QFilter filter = this.getQueryOrderFilter(entityNumber, ids, idDateMap);
        HashMap<Long, List> orgOrderMap = new HashMap<Long, List>(ids.size());
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)this.getEntityNumber(entityNumber), (String)"org,id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : objectCollection) {
            orgOrderMap.computeIfAbsent(dynamicObject.getLong("org"), s -> new ArrayList()).add(dynamicObject.getLong("id"));
        }
        for (Map.Entry entry : orgOrderMap.entrySet()) {
            Long manuOrg = (Long)entry.getKey();
            List orderIds = (List)entry.getValue();
            PlanCostParams planCostParam = this.getCostTypeByOrg(manuOrg);
            if (planCostParam == null) {
                logger.info("\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u751f\u4ea7\u7ec4\u7ec7==>{}", (Object)manuOrg);
                continue;
            }
            QFilter configFilter = new QFilter("org", "=", (Object)planCostParam.getOrg());
            configFilter.and("isplancost", "=", (Object)"1");
            configFilter.and("enable", "=", (Object)"1");
            DynamicObject planConfig = QueryServiceHelper.queryOne((String)"cad_plancost_setting", (String)"filter_tag", (QFilter[])new QFilter[]{configFilter});
            if (planConfig == null) {
                logger.info("\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u8ba1\u5212\u6210\u672c\uff0c\u6682\u65f6\u8df3\u8fc7\uff0c\u6838\u7b97\u7ec4\u7ec7==>{}", (Object)planCostParam.getOrg());
                continue;
            }
            QFilter billFilters = this.getBillFilters(this.getEntityNumber(entityNumber), planConfig.getString("filter_tag"));
            if (billFilters == null) {
                billFilters = new QFilter("id", "in", (Object)orderIds);
            } else {
                billFilters.and("id", "in", (Object)orderIds);
            }
            billFilters.and("treeentryentity.producttype", "=", (Object)"C");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.getEntityNumber(entityNumber), (String)"id,org,billno,treeentryentity.seq as seq,treeentryentity.id as entryid,treeentryentity.transmittime as transmittime", (QFilter[])new QFilter[]{billFilters});
            for (DynamicObject dynamicObject : dynamicObjects) {
                for (Map map : planCostParam.getCostTypeMap()) {
                    DynamicObject planCostObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_plancostcalclog");
                    planCostObj.set("org", (Object)planCostParam.getOrg());
                    planCostObj.set("plancosttype", map.get("planCostType"));
                    planCostObj.set("accountcosttype", map.get("accountCostType"));
                    planCostObj.set("billtype", (Object)this.getEntityNumber(entityNumber));
                    planCostObj.set("syncdate", (Object)new Date());
                    Date releaseDate = null;
                    releaseDate = this.getIsStock(entityNumber) ? (Date)idDateMap.get(dynamicObject.getLong("id")) : (this.isManftech(entityNumber) ? (Date)idDateMap.get(dynamicObject.getLong("entryid")) : dynamicObject.getDate("transmittime"));
                    planCostObj.set("releasedate", (Object)releaseDate);
                    planCostObj.set("orderno", (Object)dynamicObject.getString("billno"));
                    planCostObj.set("orderentryseq", (Object)dynamicObject.getInt("seq"));
                    planCostObj.set("orderentryid", (Object)dynamicObject.getLong("entryid"));
                    planCostObj.set("status", (Object)"00");
                    planCostObj.set("lastexecdate", null);
                    planCostObj.set("trytimes", (Object)0);
                    saveList.add(planCostObj);
                }
            }
        }
        if (!saveList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    private PlanCostParams getCostTypeByOrg(Long manuOrg) {
        PlanCostParams planCostParam = new PlanCostParams();
        ArrayList result = new ArrayList(5);
        long queryOrg = 0L;
        Boolean account = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"10");
        Boolean produce = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"04");
        if (account.booleanValue() && produce.booleanValue()) {
            queryOrg = manuOrg;
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)manuOrg, (String)"10", (boolean)false);
            if (fromOrgs.isEmpty()) {
                return null;
            }
            queryOrg = (Long)fromOrgs.get(0);
        }
        QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
        filter.and("bizstatus", "=", (Object)"1");
        filter.and("effectdate", "<=", (Object)new Date());
        filter.and("invaliddate", ">", (Object)new Date());
        if (OrgHelper.isOrgEnableMultiFactory((Long)queryOrg)) {
            boolean inventOrg = OrgUnitServiceHelper.checkOrgFunction((Long)manuOrg, (String)"05");
            if (inventOrg) {
                filter.and("storageorgunit", "=", (Object)manuOrg);
            } else {
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrg, (boolean)false);
                if (allToOrg.isEmpty()) {
                    return null;
                }
                filter.and("storageorgunit", "=", allToOrg.get(0));
            }
        } else {
            filter.and("calorg", "=", (Object)queryOrg);
        }
        DynamicObjectCollection costTypeObjs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
        if (costTypeObjs.isEmpty()) {
            return null;
        }
        Set costTypeIds = costTypeObjs.stream().map(d -> d.getLong("costType")).collect(Collectors.toSet());
        logger.info("\u8ba1\u5212\u6210\u672c\u65e5\u5fd7\u81ea\u52a8\u540c\u6b65\uff0c\u6839\u636e\u751f\u4ea7\u7ec4\u7ec7\u627e\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\uff0c\u751f\u4ea7\u7ec4\u7ec7==>{},\u6210\u672c\u7c7b\u578b==>{}", (Object)manuOrg, costTypeIds);
        QFilter costTypeFilter = new QFilter("id", "in", costTypeIds);
        costTypeFilter.and("enable", "=", (Object)"1");
        costTypeFilter.and("costtypeentry.costtypeattr", "=", (Object)"2");
        DynamicObjectCollection costTypes = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype.id as planCostId", (QFilter[])new QFilter[]{costTypeFilter});
        if (costTypes.isEmpty()) {
            return null;
        }
        for (DynamicObject costType : costTypes) {
            HashMap<String, Long> map = new HashMap<String, Long>(5);
            map.put("accountCostType", costType.getLong("id"));
            map.put("planCostType", costType.getLong("planCostId"));
            result.add(map);
        }
        planCostParam.setOrg(Long.valueOf(queryOrg));
        planCostParam.setCostTypeMap(result);
        return planCostParam;
    }

    private List<String> getEntityList() {
        ArrayList<String> list = new ArrayList<String>(7);
        list.add("pom_mftorder");
        list.add("om_mftorder");
        list.add("pom_xmftstock");
        list.add("om_xmftstock");
        list.add("sfc_xmanftech");
        list.add("sfc_manftech");
        return list;
    }

    private boolean getIsStock(String entityNumber) {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("pom_xmftstock");
        list.add("om_xmftstock");
        return list.contains(entityNumber);
    }

    private String getEntityNumber(String entityNum) {
        if (this.getIsStock(entityNum)) {
            if ("pom_xmftstock".equals(entityNum)) {
                return "pom_mftorder";
            }
            return "om_mftorder";
        }
        if (this.isManftech(entityNum)) {
            return "pom_mftorder";
        }
        return entityNum;
    }

    private QFilter getQueryOrderFilter(String entityNumber, List<Long> ids, Map<Long, Date> idDateMap) {
        QFilter filter;
        block12: {
            filter = new QFilter("treeentryentity.producttype", "=", (Object)"C");
            if (this.getIsStock(entityNumber)) {
                try {
                    DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityNumber, (String)"forderid,auditdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    if (dynamicObjects.isEmpty()) {
                        filter.and("id", "=", (Object)-1L);
                        break block12;
                    }
                    ArrayList<Long> orderIds = new ArrayList<Long>(10);
                    if ("pom_xmftstock".equals(entityNumber)) {
                        DynamicObjectCollection mftDynamicObjects = QueryServiceHelper.query((String)entityNumber, (String)"stockentry.entryorderentryid entryorderentryid,auditdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                        PomOrderSendDownEvent.getMftOrderId(idDateMap, mftDynamicObjects, filter);
                        break block12;
                    }
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        orderIds.add(dynamicObject.getLong("forderid"));
                        idDateMap.put(dynamicObject.getLong("forderid"), dynamicObject.getDate("auditdate"));
                    }
                    filter.and("id", "in", orderIds);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            } else if (this.isManftech(entityNumber)) {
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityNumber, (String)"mftentryseq,auditdate", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (dynamicObjects.isEmpty()) {
                    filter.and("id", "=", (Object)-1L);
                } else {
                    ArrayList<Long> orderEntryIds = new ArrayList<Long>(10);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        orderEntryIds.add(dynamicObject.getLong("mftentryseq"));
                        idDateMap.put(dynamicObject.getLong("mftentryseq"), dynamicObject.getDate("auditdate"));
                    }
                    filter.and("treeentryentity.id", "in", orderEntryIds);
                }
            } else {
                filter.and("id", "in", ids);
            }
        }
        return filter;
    }

    private static void getMftOrderId(Map<Long, Date> idDateMap, DynamicObjectCollection dynamicObjects, QFilter filter) {
        HashSet entryorderentryIdSet = new HashSet(16);
        HashSet<Long> orderIds = new HashSet<Long>(16);
        dynamicObjects.forEach(x -> entryorderentryIdSet.add(x.getLong("entryorderentryid")));
        DynamicObjectCollection mftOrderDy = QueryServiceHelper.query((String)"pom_mftorder", (String)"id,treeentryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", entryorderentryIdSet)});
        if (mftOrderDy.isEmpty()) {
            filter.and("id", "=", (Object)-1L);
        } else {
            Map<Long, Long> mftIdMap = mftOrderDy.stream().collect(Collectors.toMap(e -> e.getLong("entryid"), e -> e.getLong("id"), (o1, o2) -> o1));
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long orderId = mftIdMap.get(dynamicObject.getLong("entryorderentryid"));
                orderIds.add(orderId);
                idDateMap.put(orderId, dynamicObject.getDate("auditdate"));
            }
            filter.and("id", "in", orderIds);
        }
    }

    private boolean isManftech(String entityNumber) {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add("sfc_xmanftech");
        list.add("sfc_manftech");
        return list.contains(entityNumber);
    }

    private List<Long> idConversion(List<String> businessKeys) {
        ArrayList<Long> ids = new ArrayList<Long>();
        businessKeys.forEach(id -> ids.add(Long.parseLong(id)));
        return ids;
    }

    private QFilter getBillFilters(String entityName, String filterTag) {
        if (StringUtils.isEmpty((String)filterTag)) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
        filterBuilder.buildFilter();
        return filterBuilder.getQFilter();
    }
}

