/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.mservice.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SettleAccountEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(SettleAccountEvent.class);

    public Object handleEvent(KDBizEvent e) {
        EntityEvent entityEvent = (EntityEvent)e;
        List businessKeys = entityEvent.getBusinesskeys();
        logger.info("\u7ed3\u8d26\u5904\u7406\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355\u51ed\u8bc1\u4e8b\u4ef6\u5904\u7406\u5f00\u59cb\u3002\u7ed3\u8d26\u65e5\u5fd7id\uff1a" + businessKeys);
        ArrayList<Long> setAccountLogIds = new ArrayList<Long>(10);
        for (String businessKey : businessKeys) {
            setAccountLogIds.add(Long.parseLong(businessKey));
        }
        try {
            this.dealVouchers(setAccountLogIds);
        }
        catch (Exception exp) {
            logger.error("\u7ed3\u8d26\u5904\u7406\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355\u51ed\u8bc1\u4e8b\u4ef6\u5904\u7406\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)exp.getMessage());
            logger.error((Throwable)exp);
            throw exp;
        }
        logger.info("\u7ed3\u8d26\u5904\u7406\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355\u51ed\u8bc1\u4e8b\u4ef6\u5904\u7406\u5b8c\u6210\u3002\u7ed3\u8d26\u65e5\u5fd7id\uff1a" + businessKeys);
        return e.getEventId();
    }

    private void dealVouchers(List<Long> setAccountLogIds) {
        QFilter filter = new QFilter("id", "in", setAccountLogIds);
        filter.and(new QFilter("settletype", "in", (Object)new String[]{"A", "B"}));
        filter.and(new QFilter("success", "in", (Object)Boolean.TRUE));
        DynamicObjectCollection logs = QueryServiceHelper.query((String)"cal_settleaccountlog", (String)"costaccount,currentperiod,expectperiod,settletype", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)logs)) {
            return;
        }
        String settletype = ((DynamicObject)logs.get(0)).getString("settletype");
        Boolean isSettle = "A".equals(settletype) ? Boolean.TRUE : Boolean.FALSE;
        HashMap<Long, Long[]> accountPeriodMap = new HashMap<Long, Long[]>(16);
        for (DynamicObject log : logs) {
            long costAccount = log.getLong("costaccount");
            if (accountPeriodMap.containsKey(costAccount)) continue;
            long currentPeriod = log.getLong("currentperiod");
            long expectPeriod = log.getLong("expectperiod");
            accountPeriodMap.put(costAccount, new Long[]{currentPeriod, expectPeriod});
        }
        if (CadEmptyUtils.isEmpty(accountPeriodMap)) {
            return;
        }
        for (Map.Entry entry : accountPeriodMap.entrySet()) {
            Long key = (Long)entry.getKey();
            Long[] value = (Long[])entry.getValue();
            if (isSettle.booleanValue()) {
                this.createOppositeVoucher(key, value[0], value[1]);
                continue;
            }
            this.deleteOppositeVoucher(key, value[0], value[1]);
        }
    }

    private void createOppositeVoucher(Long costAccount, Long currentPeriod, Long expectPeriod) {
        List<Object> produceBillIds = this.getProduceBillIds(costAccount, currentPeriod);
        List<Object> glVoucherIds = this.getGlVoucherIds(produceBillIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"voucheragainst", (String)"gl_voucher", (Object[])glVoucherIds.toArray(new Object[0]), (OperateOption)option);
        if (operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            this.updateGlVoucherBookDate(successPkIds, expectPeriod);
        }
    }

    private void deleteOppositeVoucher(Long costAccount, Long currentPeriod, Long expectPeriod) {
        List<Object> produceBillIds = this.getProduceBillIds(costAccount, expectPeriod);
        QFilter vouchFilter = new QFilter("sourcebill", "in", produceBillIds);
        vouchFilter.and(new QFilter("isreverse", "=", (Object)Boolean.TRUE));
        try {
            DeleteServiceHelper.delete((String)"gl_voucher", (QFilter[])new QFilter[]{vouchFilter});
        }
        catch (Exception e) {
            logger.error("\u53cd\u7ed3\u8d26\u4e8b\u4ef6\uff0c\u5220\u9664\u51b2\u9500\u51ed\u8bc1\u5931\u8d25\u3002\u5931\u8d25\u4fe1\u606f\uff1a", (Throwable)e);
        }
    }

    private List<Object> getProduceBillIds(Long costAccount, Long period) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccount);
        filter.and(new QFilter("period", "=", (Object)period));
        DynamicObjectCollection produceBills = QueryServiceHelper.query((String)"sca_inproducebill", (String)"id", (QFilter[])new QFilter[]{filter});
        return DynamicObjectHelper.getFieldList((DynamicObjectCollection)produceBills, (String)"id");
    }

    private List<Object> getGlVoucherIds(List<Object> ids) {
        QFilter vouchFilter = new QFilter("sourcebill", "in", ids);
        DynamicObjectCollection glVouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id", (QFilter[])new QFilter[]{vouchFilter});
        return DynamicObjectHelper.getFieldList((DynamicObjectCollection)glVouchers, (String)"id");
    }

    private void updateGlVoucherBookDate(List<Object> ids, Long expectPeriod) {
        QFilter vouchFilter = new QFilter("id", "in", ids);
        vouchFilter.and(new QFilter("ispost", "=", (Object)Boolean.TRUE));
        Object[] glVouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"bookeddate", (QFilter[])new QFilter[]{vouchFilter}, null);
        if (CadEmptyUtils.isEmpty((Object[])glVouchers)) {
            return;
        }
        Map currentPeriod = PeriodHelper.getDateByPeriod(Collections.singleton(expectPeriod));
        if (currentPeriod == null) {
            return;
        }
        Date beginDate = (Date)currentPeriod.get("begindate");
        for (Object glVoucher : glVouchers) {
            glVoucher.set("bookeddate", (Object)beginDate);
        }
        SaveServiceHelper.update((DynamicObject[])glVouchers);
    }

    private void updateProduceBillVoucherNum(List<Object> produceBillIds) {
        DynamicObjectCollection glVouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebill,billno", (QFilter[])new QFilter[]{new QFilter("sourcebill", "in", produceBillIds)}, (String)"isreverse desc");
        HashMap<Long, List> billVochNumMap = new HashMap<Long, List>(16);
        for (DynamicObject voucher : glVouchers) {
            billVochNumMap.computeIfAbsent(voucher.getLong("sourcebill"), p -> new ArrayList()).add(voucher.getString("billno"));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Map.Entry billVochNum : billVochNumMap.entrySet()) {
            Long id = (Long)billVochNum.getKey();
            List nums = (List)billVochNum.getValue();
            params.add(new Object[]{String.join((CharSequence)",", nums), id});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)"update t_sca_inproducebill set fvouchernum = ?  where fid = ? ", params);
    }
}

