/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation;

import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.ActCostCalcExecutor;
import kd.macc.sca.business.invocation.executor.AutoCalcMaterialExecutor;
import kd.macc.sca.business.invocation.executor.AutoImportMaterialExecutor;
import kd.macc.sca.business.invocation.executor.AutoPricingExecutor;
import kd.macc.sca.business.invocation.executor.AutofinishCalclogExecutor;
import kd.macc.sca.business.invocation.executor.CalcreportExecutor;
import kd.macc.sca.business.invocation.executor.ColreportExecutor;
import kd.macc.sca.business.invocation.executor.CostBomOperExecutor;
import kd.macc.sca.business.invocation.executor.CostBomSettingOperExecutor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.business.invocation.executor.CostRouterOperExecutor;
import kd.macc.sca.business.invocation.executor.CostRouterSettingOperExecutor;
import kd.macc.sca.business.invocation.executor.FactnedOutputOperExecutor;
import kd.macc.sca.business.invocation.executor.MatAllocOperExecutor;
import kd.macc.sca.business.invocation.executor.MatUseCollectOperExecutor;
import kd.macc.sca.business.invocation.executor.MfgFeeAllocExecutor;
import kd.macc.sca.business.invocation.executor.MfgFeeCcoOperExecutor;
import kd.macc.sca.business.invocation.executor.MfgFeeCollectOperExecutor;
import kd.macc.sca.business.invocation.executor.PlanCostCalcExecutor;
import kd.macc.sca.business.invocation.executor.PlannedOutputOperExecutor;
import kd.macc.sca.business.invocation.executor.PurchPriceOperExecutor;
import kd.macc.sca.business.invocation.executor.RealTimeCalcExecutor;
import kd.macc.sca.business.invocation.executor.ResourceUseOperExecutor;
import kd.macc.sca.business.invocation.executor.StdCostCalcExecutor;
import kd.macc.sca.business.invocation.executor.StdCostUpdateExecutor;
import kd.macc.sca.business.invocation.executor.WorkFeeOperExecutor;

public class InvocationDispatcher {
    private String entityName;
    private String oper;

    public InvocationDispatcher(String entityName, String oper) {
        this.entityName = entityName;
        this.oper = oper;
    }

    public Executor getExecutor() {
        Executor executor = null;
        switch (this.entityName) {
            case "cad_costobject": {
                executor = new CostObjectOperExecutor(this.oper);
                break;
            }
            case "sca_resourceuse": {
                executor = new ResourceUseOperExecutor(this.oper);
                break;
            }
            case "cad_plannedoutputbill": {
                executor = new PlannedOutputOperExecutor(this.oper);
                break;
            }
            case "cad_factnedoutputbill": {
                executor = new FactnedOutputOperExecutor(this.oper);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                executor = new MatUseCollectOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_mfgfeebill": 
            case "aca_mfgfeebill": {
                executor = new MfgFeeCollectOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_matalloc": 
            case "aca_matalloc": {
                executor = new MatAllocOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_mfgfeealloc": {
                executor = new MfgFeeAllocExecutor(this.oper);
                break;
            }
            case "cad_costbom": {
                executor = new CostBomOperExecutor(this.oper);
                break;
            }
            case "cad_bomsetting": {
                executor = new CostBomSettingOperExecutor(this.oper);
                break;
            }
            case "cad_router": {
                executor = new CostRouterOperExecutor(this.oper);
                break;
            }
            case "cad_routersetting": {
                executor = new CostRouterSettingOperExecutor(this.oper);
                break;
            }
            case "sca_purchpricediff": {
                executor = new PurchPriceOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_finishcalwizards": {
                executor = new AutofinishCalclogExecutor(this.entityName, this.oper);
                break;
            }
            case "cad_mfgfeebill": {
                executor = new MfgFeeCollectOperExecutor(this.entityName, this.oper);
                break;
            }
            case "eca_workhoursfee": {
                executor = new WorkFeeOperExecutor(this.entityName, this.oper);
                break;
            }
            case "cad_mfgfeeallocco": {
                executor = new MfgFeeCcoOperExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_plancostcalclog": {
                executor = new PlanCostCalcExecutor(this.entityName, this.oper);
                break;
            }
            case "sca_salorderstdcalclog_CALC": {
                executor = new StdCostCalcExecutor(this.oper);
                break;
            }
            case "sca_salorderstdcalclog_UPDATE": {
                executor = new StdCostUpdateExecutor(this.oper);
                break;
            }
            case "cad_purprices": 
            case "cad_resourceout": 
            case "cad_outsourceprice": {
                executor = new AutoPricingExecutor(this.entityName, this.oper);
                break;
            }
            case "aca_realtimecalclog": {
                executor = new RealTimeCalcExecutor(this.entityName, this.oper);
                break;
            }
            case "cad_autocalcmatrangelog": {
                if ("AUTO_CALCULATION_ALL".equals(this.oper) || "AUTO_CALCULATION_UNDO".equals(this.oper) || "AUTO_CALCULATION_ALL_RETRY".equals(this.oper)) {
                    executor = new AutoCalcMaterialExecutor(this.entityName, this.oper);
                    break;
                }
                if (!"AUTO_IMPORT_MATERIAL".equals(this.oper)) break;
                executor = new AutoImportMaterialExecutor(this.entityName, this.oper);
                break;
            }
            case "aca_terminalcalwizards": {
                executor = new ActCostCalcExecutor(this.entityName, this.oper);
                break;
            }
            case "colreport": {
                executor = new ColreportExecutor(this.oper);
                break;
            }
            case "calcreport": {
                executor = new CalcreportExecutor(this.oper);
            }
        }
        return executor;
    }
}

