/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class ActCostCalcExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(ActCostCalcExecutor.class);
    private static String OPR_KEY = "ACTCOSTCALC";
    private String entityName;
    private String oprKey;

    public ActCostCalcExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!OPR_KEY.equals(this.getOprKey())) {
            return false;
        }
        List orgList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (orgList.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u6267\u884c\u5931\u8d25 #execute-{}", (Object)this.entityName);
            return false;
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>();
        String calcResult = SchemeExecuteResultEnum.SUCCESS.getValue();
        if (!orgList.isEmpty()) {
            for (Long[] ids : orgList) {
                String calcStatus;
                String result;
                JSONObject resultObj;
                JSONObject calcParam;
                Long orgId = ids[0];
                Long costAccountId = ids[1];
                String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costAccountId);
                if (StringUtils.isNotEmpty((String)lockErrStr) || (calcParam = this.buildCalcParam(orgId, costAccountId)) == null || (resultObj = JSON.parseObject((String)(result = this.invokeBizService(calcParam)))) == null || !resultObj.containsKey((Object)"calcStatus") || !"3".equals(calcStatus = resultObj.getString("calcStatus"))) continue;
                calcResult = SchemeExecuteResultEnum.FAIL.getValue();
            }
        }
        String detailResult = calcResult.equals(SchemeExecuteResultEnum.FAIL.getValue()) ? ResManager.loadKDString((String)"\u5931\u8d25", (String)"ActCostCalcExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f", (String)"ActCostCalcExecutor_1", (String)"macc-sca-form", (Object[])new Object[0]);
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, calcResult, "ACTCOSTCALC", this.oprKey, detailResult, schemeLogSubDetail);
        return true;
    }

    private JSONObject buildCalcParam(Long orgId, Long costAccountId) {
        JSONObject calcParamJs = new JSONObject();
        calcParamJs.put("org", (Object)orgId);
        calcParamJs.put("costaccount", (Object)costAccountId);
        DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        if (curPeriod == null) {
            return null;
        }
        calcParamJs.put("period", (Object)curPeriod.getLong("id"));
        calcParamJs.put("startDate", (Object)DateUtils.formatDate((Date)curPeriod.getDate("begindate"), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put("endDate", (Object)DateUtils.formatDate((Date)curPeriod.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"));
        calcParamJs.put("currencyId", (Object)CurrencyHelper.getCurrency((Long)costAccountId));
        calcParamJs.put("allinvmatcalout", (Object)true);
        calcParamJs.put("calcreduct", (Object)false);
        calcParamJs.put("calccmpanal", (Object)false);
        calcParamJs.put("conversionsubdetail", (Object)false);
        calcParamJs.put("nestmatcheck", (Object)4000);
        calcParamJs.put("matlevelonecalout", (Object)true);
        calcParamJs.put("nestmatautorework", (Object)false);
        calcParamJs.put("importfacttransfer", (Object)false);
        calcParamJs.put("calcsize", (Object)1);
        calcParamJs.put("negaunitpricedeal", (Object)false);
        calcParamJs.put("calSchemeId", (Object)0L);
        return calcParamJs;
    }

    private String invokeBizService(JSONObject calcParam) {
        return (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"actPeriodEndCalc", (Object[])new Object[]{calcParam.toString()});
    }

    public String getOprKey() {
        return this.oprKey;
    }
}

