/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.mservice.AutoPricingServiceImpl;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class AutoPricingExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(AutoPricingExecutor.class);
    private static String OPR_KEY = "PURCHASEPRICING";
    private String entityName;
    private String oprKey;

    public AutoPricingExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO param) {
        if (!OPR_KEY.equals(this.oprKey)) {
            return false;
        }
        HashSet<Long> orgList = new HashSet<Long>(15);
        ArrayList<Long> accountList = new ArrayList<Long>(15);
        for (Long[] orgAccount : param.getOrgCostAccountUserList()) {
            if (!CadEmptyUtils.isEmpty((Long)orgAccount[0])) {
                orgList.add(orgAccount[0]);
            }
            if (CadEmptyUtils.isEmpty((Long)orgAccount[1])) continue;
            accountList.add(orgAccount[1]);
        }
        if (orgList.isEmpty()) {
            logger.info("\u6807\u51c6\u6210\u672c\u5377\u7b97\u4ef7\u76ee\u8868\u91c7\u8d2d\u53d6\u4ef7==>{},\u5f53\u524d\u81ea\u52a8\u6267\u884c\u65b9\u6848\u672a\u914d\u7f6e\u6838\u7b97\u7ec4\u7ec7,\u6267\u884c\u5931\u8d25", (Object)this.entityName);
            return false;
        }
        AutoPricingServiceImpl autoPricingService = new AutoPricingServiceImpl();
        Map result = autoPricingService.execute(this.entityName, new ArrayList(orgList), accountList, param.getExecutor(), null, param.getAppnum(), null);
        boolean status = (Boolean)result.get("status");
        Integer count = result.get("count") == null ? Integer.valueOf(0) : result.get("count");
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        for (Long org : orgList) {
            int subCount = (Integer)result.get(String.valueOf(org));
            schemeLogSubDetail.add(new SchemeLogSubDetail(org, Long.valueOf(0L), Long.valueOf(0L), subCount));
        }
        logger.info("\u81ea\u52a8\u6267\u884c\u65b9\u6848\u91c7\u8d2d\u53d6\u4ef7\u6784\u5efa\u65e5\u5fd7\u53c2\u6570,param==>{},status==>{}", (Object)param, (Object)status);
        ScaAutoExecShemeHelper.buildSchemeLogDetail(param, status ? SchemeExecuteResultEnum.SUCCESS.getValue() : SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.oprKey, status ? String.format(AutoExecInvEnum.SUCCESSCALCCOUNT.getName(), count) : result.get("errMsg").toString(), schemeLogSubDetail);
        return status;
    }
}

