/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.servicehelper.CostCalcServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class AutofinishCalclogExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(AutofinishCalclogExecutor.class);
    private String operKey;
    private String entityName;

    public AutofinishCalclogExecutor(String entityName, String operKey) {
        this.operKey = operKey;
        this.entityName = entityName;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        HashMap orgAccountMap = new HashMap(16);
        if (!orgCostAccountUserList.isEmpty()) {
            orgCostAccountUserList.forEach(temp -> {
                Set account = orgAccountMap.computeIfAbsent(temp[0], t -> new HashSet());
                if (temp[1] != null && temp[1] > 0L) {
                    account.add(temp[1]);
                }
            });
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        for (Map.Entry entry : orgAccountMap.entrySet()) {
            String result = CostCalcServiceHelper.autoFinishCalc((Long)((Long)entry.getKey()), new ArrayList((Collection)entry.getValue()), (String)this.operKey);
            logger.info("\u81ea\u52a8\u5b8c\u5de5\u7ed3\u7b97-\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0c\u6838\u7b97\u7ec4\u7ec7id\uff1a{}\uff0c\u6210\u672c\u8d26\u8584\uff1a{}\uff0c\u8ba1\u7b97\u7ed3\u679c\uff1a{}", new Object[]{this.operKey, entry.getKey(), entry.getValue(), result});
            HashSet calcAccounts = Sets.newHashSetWithExpectedSize((int)10);
            JSONObject jsonObject = JSON.parseObject((String)result);
            String calcExccArr = jsonObject.getString("calcExec");
            if (!StringUtils.isEmpty((String)calcExccArr)) {
                Map costexecMap = (Map)JSON.parseObject((String)calcExccArr, Map.class);
                for (Map.Entry costentry : costexecMap.entrySet()) {
                    Long accountId = Long.valueOf(costentry.getKey().toString());
                    calcAccounts.add(accountId);
                    schemeLogSubDetail.add(new SchemeLogSubDetail((Long)entry.getKey(), Long.valueOf(0L), accountId, Integer.parseInt(costentry.getValue().toString())));
                }
            }
            for (Long account : (Set)entry.getValue()) {
                if (calcAccounts.contains(account)) continue;
                schemeLogSubDetail.add(new SchemeLogSubDetail((Long)entry.getKey(), Long.valueOf(0L), account, 0));
            }
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, AutoExecInvEnum.SUCCESS.getName(), schemeLogSubDetail);
        return true;
    }
}

