/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ClearDataHelper;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class CalcreportExecutor
implements Executor {
    private String oper;

    public CalcreportExecutor(String oper) {
        this.oper = oper;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        boolean success = true;
        EntityOperEnum op = EntityOperEnum.getByValue(this.oper);
        switch (op) {
            case OPER_CLEAR_DATA: {
                success &= ClearDataHelper.clearData("sca_checkreportdetail", "calcdate", "entryentity", "bigtext_tag");
                success &= ClearDataHelper.clearData("sca_restore_calcreport", "calcdate", "entryentity", "bigtext_tag");
                success &= ClearDataHelper.clearData("aca_calcreport", "calcdate", "entryentity", "bigtext_tag");
                success &= ClearDataHelper.clearData("sca_reductreport", "starttime", "entryentity", "bigtext_tag");
                break;
            }
        }
        if (success) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "calcreport", this.oper, AutoExecInvEnum.SUCCESS.getName());
        } else {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "calcreport", this.oper, AutoExecInvEnum.FAIL.getName());
        }
        return success;
    }
}

