/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class FactnedOutputOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(FactnedOutputOperExecutor.class);
    private String operKey;

    public FactnedOutputOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            return false;
        }
        int sum = 0;
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_factnedoutputbill", this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"cad_factnedoutputbill", (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_factnedoutputbill", this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        Map<String, Map<Long, List<Long>>> orgAndManuOrgsCostCentersMap = ScaAutoExecShemeHelper.getOrgAndSysImportCostCostCenterMap(orgList, autoExecSchemeDTO.getAppnum(), "cad_factnedoutputbill");
        Map<Long, List<Long>> orgManuOrgs = orgAndManuOrgsCostCentersMap.get("manuorg");
        Map<Long, List<Long>> orgCostCenters = orgAndManuOrgsCostCentersMap.get("costcenter");
        for (Map.Entry<Long, List<Long>> entry : orgCostCenters.entrySet()) {
            if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)entry.getValue())) continue;
            List<Long> userIds = ScaAutoExecShemeHelper.getUserIdsByOrg(entry.getKey(), orgCostAccountUserList);
            Integer sucQty = 0;
            String lockId = "FactnedOutputOperExecutor" + entry.getKey();
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u81ea\u52a8\u5f52\u96c6\u9501", (String)"FactnedOutputOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
            try {
                boolean isLocked = lock.tryLock();
                if (!isLocked) continue;
                this.logger.info("\u81ea\u52a8\u6267\u884c-\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u8986\u76d6\u5bfc\u5165-\u6210\u672c\u4e2d\u5fc3\uff1a" + JSON.toJSONString(entry.getValue()));
                Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"factnedOutPutService", (String)"importCompletion", (Object[])new Object[]{null, null, Long.parseLong(entry.getKey().toString()), entry.getValue(), orgManuOrgs.get(entry.getKey()), autoExecSchemeDTO.getAppnum(), null});
                this.logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u8fd4\u56de\u503c\uff1a" + resultInfo.toString());
                Integer successQty = Integer.parseInt(resultInfo.get("successQty") != null ? (String)resultInfo.get("successQty") : "0");
                if (resultInfo != null && successQty > 0) {
                    sum += successQty.intValue();
                    sucQty = sucQty + successQty;
                }
                schemeLogSubDetail.add(new SchemeLogSubDetail(Long.valueOf(Long.parseLong(entry.getKey().toString())), Long.valueOf(0L), Long.valueOf(0L), successQty.intValue()));
            }
            catch (Exception e) {
                String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u5931\u8d25\u3002", (String)"FactnedOutputOperExecutor_5", (String)"macc-sca-form", (Object[])new Object[0]), ScaAutoExecShemeHelper.getNameById("bos_org", Long.parseLong(entry.getKey().toString())));
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, "cad_factnedoutputbill", this.operKey, detail);
                this.logger.error((Throwable)e);
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            if (userIds.isEmpty()) continue;
            SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e%s\u6761\u3002", (String)"FactnedOutputOperExecutor_6", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_factnedoutputbill", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }
}

