/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.ScaAllocEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import org.apache.commons.collections.CollectionUtils;

public class MfgFeeAllocExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private String operKey;

    public MfgFeeAllocExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (EntityOperEnum.OPER_ALLOC.getValue().equals(this.operKey)) {
            int sum = 0;
            ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
            List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
            if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_mfgfeealloc", this.operKey, AutoExecInvEnum.FAIL.getName());
                return false;
            }
            boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)"sca_mfgfeealloc", (String)"80513208000000ac");
            if (!hasPerm) {
                ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_mfgfeealloc", this.operKey, AutoExecInvEnum.NO_PERM.getName());
                return false;
            }
            List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
            List<Long> costAccountList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 1);
            Map<Long, List<Long>> orgCostAccountMap = ScaAutoExecShemeHelper.getOrgCostAccountMap(orgList, costAccountList, autoExecSchemeDTO.getAppnum());
            for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
                List<Long> costAccounts = orgCostAccount.getValue();
                if (CollectionUtils.isEmpty(costAccounts)) continue;
                for (Long costAccount : costAccounts) {
                    String orgName = ScaAutoExecShemeHelper.getNameById("bos_org", orgCostAccount.getKey());
                    String costCountName = ScaAutoExecShemeHelper.getNameById("cal_bd_costaccount", costAccount);
                    String lockId = "MatAllocOperExecutor" + orgCostAccount.getKey() + costAccount;
                    DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u5236\u9020\u8d39\u7528\u81ea\u52a8\u5206\u914d\u9501", (String)"MfgFeeAllocExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    try {
                        boolean isLocked = lock.tryLock();
                        if (!isLocked) continue;
                        List<Object> ids = this.getToAllocIds(orgCostAccount.getKey(), costAccount);
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"donothing", (String)"sca_mfgfeealloc", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                        sum += operationResult.getSuccessPkIds().size();
                        schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), Long.valueOf(0L), costAccount, operationResult.getSuccessPkIds().size()));
                    }
                    catch (Exception e) {
                        String detail = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002", (String)"MfgFeeAllocExecutor_2", (String)"macc-sca-form", (Object[])new Object[0]), orgName, costCountName);
                        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, null, "sca_mfgfeealloc", this.operKey, detail);
                        logger.error((Throwable)e);
                    }
                    finally {
                        if (lock == null) continue;
                        lock.close();
                    }
                }
            }
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "sca_mfgfeealloc", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        }
        return true;
    }

    private List<Object> getToAllocIds(Long orgId, Long cosAccount) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        orgFilter.and(new QFilter("costaccount", "=", (Object)cosAccount));
        orgFilter.and(new QFilter("allocstatus", "!=", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue()));
        orgFilter.and(new QFilter("usetype", "!=", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue()));
        orgFilter.and(new QFilter("alloctype", "!=", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue()));
        List<Object> ids = QueryServiceHelper.query((String)"sca_mfgfeealloc", (String)"id", (QFilter[])new QFilter[]{orgFilter}).stream().map(e -> e.get("id")).collect(Collectors.toList());
        return ids;
    }
}

