/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class MfgFeeCollectOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(MfgFeeCollectOperExecutor.class);
    private String entityName;
    private String operKey;

    public MfgFeeCollectOperExecutor(String entityName, String operKey) {
        this.entityName = entityName;
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            return false;
        }
        int sum = 0;
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)autoExecSchemeDTO.getExecutor(), (String)autoExecSchemeDTO.getAppnum(), (String)this.entityName, (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), this.entityName, this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        List<Long> costAccountList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 1);
        Map<Long, List<Long>> orgCostAccountMap = ScaAutoExecShemeHelper.getOrgCostAccountMap(orgList, costAccountList, autoExecSchemeDTO.getAppnum());
        for (Map.Entry<Long, List<Long>> orgCostAccount : orgCostAccountMap.entrySet()) {
            List<Long> costAccounts = orgCostAccount.getValue();
            if (CollectionUtils.isEmpty(costAccounts)) continue;
            for (Long costAccount : costAccounts) {
                List<Long> userIds = ScaAutoExecShemeHelper.getUserIdsByOrgCostAccount(orgCostAccount.getKey(), costAccount, orgCostAccountUserList);
                Integer sucQty = 0;
                String lockId = "MfgFeeCollectOperExecutor" + orgCostAccount.getKey() + costAccount;
                DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u5236\u9020\u8d39\u7528\u81ea\u52a8\u5f52\u96c6\u9501", (String)"MfgFeeCollectOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
                try {
                    boolean isLocked = lock.tryLock();
                    if (!isLocked) continue;
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                    paramMap.put("appnum", autoExecSchemeDTO.getAppnum());
                    long orgId = orgCostAccount.getKey();
                    Set<Long> costAccountSet = Collections.singleton(costAccount);
                    QFilter sysOrgQF = new QFilter("org", "=", (Object)orgId);
                    QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountSet);
                    DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.costaccount AS costaccount, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{sysOrgQF, costAccountQF});
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
                        for (DynamicObject costAccountDy : res) {
                            paramMap.put(costAccountDy.getString("costaccount"), costAccountDy.get("currentperiod"));
                        }
                    }
                    QFilter qFilter = new QFilter("accountorg", "=", (Object)orgId);
                    qFilter.and("status", "=", (Object)"C");
                    qFilter.and("enable", "=", (Object)true);
                    List costCenterIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])qFilter.toArray(), null, (int)-1);
                    costCenterIdList.add(0L);
                    ExecuteResult executeResult = MfgfeeBillImportHelper.importMfgFeeBillBySys((Long)orgId, costAccountSet, (List)costCenterIdList, paramMap, null);
                    if (executeResult.getSuccessQty() > 0) {
                        sum += executeResult.getSuccessQty();
                        sucQty = executeResult.getSuccessQty();
                    }
                    schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostAccount.getKey(), Long.valueOf(0L), costAccount, executeResult.getSuccessQty()));
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                    continue;
                }
                if (userIds.isEmpty()) continue;
                SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e%s\u6761\u3002", (String)"MfgFeeCollectOperExecutor_3", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
            }
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), this.entityName, this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }
}

