/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.utils.CadPermissionUtil;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.EntityOperEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import kd.macc.sca.common.helper.SendMessageHelper;
import org.apache.commons.collections.CollectionUtils;

public class PlannedOutputOperExecutor
implements Executor {
    private Log logger = LogFactory.getLog(PlannedOutputOperExecutor.class);
    private String operKey;

    public PlannedOutputOperExecutor(String operKey) {
        this.operKey = operKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!EntityOperEnum.OPER_SYSIMPORT.getValue().equals(this.operKey)) {
            return false;
        }
        int sum = 0;
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_plannedoutputbill", this.operKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        String orgIds = autoExecSchemeDTO.getOrgCostAccountUserList().stream().map(orgCostAccountUser -> orgCostAccountUser[0]).collect(Collectors.toList()).toString();
        boolean hasPerm = CadPermissionUtil.check((Long)autoExecSchemeDTO.getExecutor(), (String)orgIds, (boolean)true, (String)autoExecSchemeDTO.getAppnum(), (String)"cad_plannedoutputbill", (String)"47156aff000000ac");
        if (!hasPerm) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "cad_plannedoutputbill", this.operKey, AutoExecInvEnum.NO_PERM.getName());
            return false;
        }
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        Map<Long, List<Long>> orgCostCenterMap = ScaAutoExecShemeHelper.getOrgCostCenterMap(orgList);
        for (Map.Entry<Long, List<Long>> orgCostCenter : orgCostCenterMap.entrySet()) {
            List<Long> costCenters = orgCostCenter.getValue();
            if (CollectionUtils.isEmpty(costCenters)) continue;
            List<Long> userIds = ScaAutoExecShemeHelper.getUserIdsByOrg(orgCostCenter.getKey(), orgCostAccountUserList);
            Integer sucQty = 0;
            String lockId = "PlannedOutputOperExecutor" + orgCostCenter.getKey();
            DLock lock = DLock.create((String)lockId, (String)ResManager.loadKDString((String)"\u81ea\u52a8\u6267\u884c-\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u81ea\u52a8\u5f52\u96c6\u9501", (String)"PlannedOutputOperExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]));
            try {
                boolean isLocked = lock.tryLock();
                if (!isLocked) continue;
                Map<String, String> resultInfo = this.invokeBizService(orgCostCenter.getKey(), costCenters, autoExecSchemeDTO.getAppnum());
                Integer successQty = Integer.parseInt(resultInfo.get("successQty") != null ? resultInfo.get("successQty") : "0");
                if (resultInfo != null && successQty > 0) {
                    sum += successQty.intValue();
                    sucQty = sucQty + successQty;
                }
                schemeLogSubDetail.add(new SchemeLogSubDetail(orgCostCenter.getKey(), Long.valueOf(0L), Long.valueOf(0L), successQty.intValue()));
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
            finally {
                if (lock == null) continue;
                lock.close();
                continue;
            }
            if (userIds.isEmpty()) continue;
            SendMessageHelper.sendMCMessage(userIds, (String)String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u6267\u884c\u6210\u529f\uff0c\u5bfc\u5165\u6570\u636e%s\u6761\u3002", (String)"PlannedOutputOperExecutor_3", (String)"macc-sca-form", (Object[])new Object[0]), sucQty));
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "cad_plannedoutputbill", this.operKey, String.format(AutoExecInvEnum.SUCCESSIMPORTER.getName(), sum), schemeLogSubDetail);
        return true;
    }

    private Map<String, String> invokeBizService(Long key, List<Long> costCenters, String appnum) {
        Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"plannedOutputService", (String)"importPlannedOut", (Object[])new Object[]{null, key, costCenters, null, null, appnum, null});
        return resultInfo;
    }
}

