/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import net.sf.json.JSONObject;

public class RealTimeCalcExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(RealTimeCalcExecutor.class);
    private static String OPR_KEY = "REALTIMECALC";
    private String entityName;
    private String oprKey;

    public RealTimeCalcExecutor(String entityName, String oprKey) {
        this.entityName = entityName;
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!OPR_KEY.equals(this.getOprKey())) {
            return false;
        }
        List orgList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (orgList.isEmpty()) {
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u6267\u884c\u5931\u8d25 #execute-{}", (Object)this.entityName);
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "aca_realtimecalclog", this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        String result = "";
        Map<String, Object> resultMap = new HashMap<String, Object>(4);
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>();
        int totalSuccessSize = 0;
        if (!orgList.isEmpty()) {
            for (Long[] ids : orgList) {
                Integer successSize;
                Long orgId = ids[0];
                Long costAccountId = ids[1];
                JSONObject params = new JSONObject();
                params.accumulate("orgId", (Object)orgId);
                params.accumulate("costAccountId", (Object)costAccountId);
                params.accumulate("type", (Object)"0");
                logger.info("RealTimeCalcExecutor#execute-{}", (Object)this.entityName);
                String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.REALTIME_CALCULATE, (long)costAccountId);
                if (StringUtils.isNotEmpty((String)lockErrStr)) {
                    resultMap.put("isSuccess", false);
                    resultMap.put("errorMsg", lockErrStr);
                    long id = DBServiceHelper.genGlobalLongId();
                    DynamicObject realTimeLog = BusinessDataServiceHelper.newDynamicObject((String)"aca_realtimecalclog");
                    realTimeLog.set("id", (Object)id);
                    realTimeLog.set("org", (Object)orgId);
                    realTimeLog.set("costaccount", (Object)costAccountId);
                    QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
                    QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
                    DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
                    if (sysCtrlEntity != null) {
                        realTimeLog.set("period", (Object)sysCtrlEntity.getLong("currentperiod"));
                    }
                    realTimeLog.set("calctype", (Object)"0");
                    realTimeLog.set("billstatus", (Object)"A");
                    realTimeLog.set("checkdesc", (Object)lockErrStr);
                    realTimeLog.set("calcdate", (Object)new Date());
                    realTimeLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                    realTimeLog.set("createtime", (Object)new Date());
                    realTimeLog.set("traceid", (Object)RequestContext.get().getTraceId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{realTimeLog});
                    continue;
                }
                try {
                    result = this.invokeBizService(params);
                }
                catch (Exception e) {
                    logger.error("invokeBizService error", (Throwable)e);
                }
                if (!CadEmptyUtils.isEmpty((String)result)) {
                    resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                }
                if ((successSize = (Integer)resultMap.get("successSize")) == null || successSize <= 0) continue;
                totalSuccessSize += successSize.intValue();
                schemeLogSubDetail.add(new SchemeLogSubDetail(orgId, Long.valueOf(0L), costAccountId, successSize.intValue()));
            }
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "aca_realtimecalclog", this.oprKey, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f%s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"RealTimeCalcExecutor_0", (String)"macc-sca-form", (Object[])new Object[0]), totalSuccessSize), schemeLogSubDetail);
        return true;
    }

    private String invokeBizService(JSONObject params) {
        return (String)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"RealTimeCalcService", (String)"actRealTimeCalc", (Object[])new Object[]{SerializationUtils.toJsonString((Object)params)});
    }

    public String getOprKey() {
        return this.oprKey;
    }
}

