/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.invocation.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.dto.SchemeLogSubDetail;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.invocation.Executor;
import kd.macc.sca.business.invocation.executor.CostObjectOperExecutor;
import kd.macc.sca.common.enums.AutoExecInvEnum;
import kd.macc.sca.common.enums.SchemeExecuteResultEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;
import org.apache.commons.collections.CollectionUtils;

public class StdCostCalcExecutor
implements Executor {
    private static final Log logger = LogFactory.getLog(CostObjectOperExecutor.class);
    private static String OPR_KEY = "STDCOSTCALC";
    private String oprKey;

    public StdCostCalcExecutor(String oprKey) {
        this.oprKey = oprKey;
    }

    @Override
    public boolean execute(AutoExecSchemeDTO autoExecSchemeDTO) {
        if (!OPR_KEY.equals(this.getOprKey())) {
            return false;
        }
        ArrayList<SchemeLogSubDetail> schemeLogSubDetail = new ArrayList<SchemeLogSubDetail>(10);
        List orgCostAccountUserList = autoExecSchemeDTO.getOrgCostAccountUserList();
        if (CollectionUtils.isEmpty((Collection)orgCostAccountUserList)) {
            ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.FAIL.getValue(), "sca_salorderstdcalclog", this.oprKey, AutoExecInvEnum.FAIL.getName());
            return false;
        }
        HashSet<Long> orgs = new HashSet<Long>(5);
        HashMap<Long, List> orgCostAccountMap = new HashMap<Long, List>(16);
        for (Long[] orgCostAccountUser : orgCostAccountUserList) {
            Long orgId = orgCostAccountUser[0];
            orgCostAccountMap.computeIfAbsent(orgId, p -> new ArrayList()).add(orgCostAccountUser);
        }
        List<Long> orgList = ScaAutoExecShemeHelper.getTargetList(orgCostAccountUserList, 0);
        orgs.addAll(orgList);
        int sum = 0;
        try {
            List results = (List)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"StdCostService", (String)"doCalc", (Object[])new Object[]{orgs, null});
            Map<Long, List<Long>> successLogIdsMap = this.getSuccessLogIds(results);
            for (Map.Entry<Long, List<Long>> entry : successLogIdsMap.entrySet()) {
                Long org = entry.getKey();
                List<Long> logs = entry.getValue();
                List orgCostAccounts = (List)orgCostAccountMap.get(org);
                for (Long[] orgCostAccount : orgCostAccounts) {
                    schemeLogSubDetail.add(new SchemeLogSubDetail(org, Long.valueOf(0L), orgCostAccount[1], logs.size()));
                }
                sum += logs.size();
                orgs.remove(org);
            }
            for (Long org : orgs) {
                List orgCostAccounts = (List)orgCostAccountMap.get(org);
                for (Long[] orgCostAccount : orgCostAccounts) {
                    schemeLogSubDetail.add(new SchemeLogSubDetail(org, Long.valueOf(0L), orgCostAccount[1], 0));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u81ea\u52a8\u6267\u884c-\u8ddf\u8e2a\u53f7\u5377\u7b97\u5f02\u5e38\u3002", (Throwable)e);
        }
        ScaAutoExecShemeHelper.buildSchemeLogDetail(autoExecSchemeDTO, SchemeExecuteResultEnum.SUCCESS.getValue(), "sca_salorderstdcalclog", this.oprKey, String.format(AutoExecInvEnum.SUCCESSCALCCOUNT.getName(), sum), schemeLogSubDetail);
        return true;
    }

    private Map<Long, List<Long>> getSuccessLogIds(List<Long> salOrderLogIds) {
        DynamicObject[] logs;
        HashMap<Long, List<Long>> orgSalOrderIdsMap = new HashMap<Long, List<Long>>(16);
        if (CadEmptyUtils.isEmpty(salOrderLogIds)) {
            return orgSalOrderIdsMap;
        }
        QFilter filter = new QFilter("id", "in", salOrderLogIds);
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"id,org,status", (QFilter[])new QFilter[]{filter})) {
            String status = log.getString("status");
            if (!"02".equals(status)) continue;
            orgSalOrderIdsMap.computeIfAbsent(log.getLong("org.id"), p -> new ArrayList()).add(log.getLong("id"));
        }
        return orgSalOrderIdsMap;
    }

    public String getOprKey() {
        return this.oprKey;
    }
}

