/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.wipallocstd;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAllocStdService {
    private static Log logger = LogFactory.getLog(WipAllocStdService.class);
    private static final String BIZ_TYPE_RO = "RO";
    private static final String SUB_E_T_MAT = "001";

    public static String isAllowAssemblyByOrgCc(long orgId, long costCenterId, String costCenterName, String subEleType) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter costCenterQf = new QFilter("costcenter", "=", (Object)costCenterId);
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObject costObjRule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, costCenterQf, billStatusQf});
        if (costObjRule == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u6210\u672c\u4e2d\u5fc3\u672a\u83b7\u53d6\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\uff0c\u4f7f\u7528\u6838\u7b97\u7ec4\u7ec7\u83b7\u53d6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219");
            }
            costCenterQf = new QFilter("costcenter", "=", (Object)0L);
            costObjRule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"biztype", (QFilter[])new QFilter[]{orgQf, costCenterQf, billStatusQf});
        }
        if (costObjRule == null) {
            return ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6838\u7b97\u7ec4\u7ec7-\u6210\u672c\u4e2d\u5fc3\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"WipAllocStdService_0", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        String bizType = costObjRule.getString("biztype");
        if (CadEmptyUtils.isEmpty((String)subEleType)) {
            return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WipAllocStdService_1", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (!SUB_E_T_MAT.equals(subEleType)) {
            return ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u7c7b\u578b\u4e0d\u4e3a\u7269\u6599\u3002", (String)"WipAllocStdService_2", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (!BIZ_TYPE_RO.equals(bizType)) {
            return String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u672a\u5e94\u7528\u201c\u5de5\u5355\u6210\u672c\u201d\u8ba1\u7b97\u65b9\u6cd5\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u201c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u201d\u3002", (String)"WipAllocStdService_5", (String)"macc-sca-form", (Object[])new Object[0]), costCenterName);
        }
        return null;
    }

    public static Set<Long> getAllowAssemblyCC(long orgId) {
        Set<Long> costCentersByOrg = WipAllocStdService.getCostCentersByOrg(orgId);
        if (costCentersByOrg.isEmpty()) {
            return costCentersByOrg;
        }
        HashSet roCostCenters = Sets.newHashSetWithExpectedSize((int)16);
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter billStatusQf = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection objRuleCol = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"costcenter,biztype", (QFilter[])new QFilter[]{orgQf, billStatusQf});
        if (objRuleCol.isEmpty()) {
            return Collections.emptySet();
        }
        for (DynamicObject objRule : objRuleCol) {
            long costCenter = objRule.getLong("costcenter");
            String bizType = objRule.getString("biztype");
            if (!CadEmptyUtils.isEmpty((Long)costCenter)) {
                if (bizType.equals(BIZ_TYPE_RO)) {
                    roCostCenters.add(costCenter);
                    continue;
                }
                costCentersByOrg.remove(costCenter);
                continue;
            }
            if (!bizType.equals(BIZ_TYPE_RO)) {
                costCentersByOrg.clear();
                continue;
            }
            roCostCenters.addAll(costCentersByOrg);
        }
        return roCostCenters;
    }

    private static Set<Long> getCostCentersByOrg(long orgId) {
        QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        QFilter enableQf = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{orgQf, statusQf, enableQf});
        if (costCenters.isEmpty()) {
            return Collections.emptySet();
        }
        return costCenters.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
    }
}

