/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.BillBaseEnum;
import kd.macc.sca.common.helper.WipCostInitInfo;
import org.apache.commons.lang3.StringUtils;

public class AcaInitHelper {
    public static final String ENTITY_ACA_CALCRESULT = "aca_calcresult";
    private static final Log logger = LogFactory.getLog(AcaInitHelper.class);

    public static void insertOrUpdateCalcResultPeriodEndInfo(Long orgId, Map<Long, DynamicObject> costAccountIdAndStartPeriodMap, boolean isClear) {
        Set<Long> costAccountIds = costAccountIdAndStartPeriodMap.keySet();
        Set<Object> periodIds = costAccountIdAndStartPeriodMap.entrySet().stream().map(item -> ((DynamicObject)item.getValue()).getPkValue()).collect(Collectors.toSet());
        Map<String, WipCostInitInfo> qtyAmountMap = AcaInitHelper.getQtyAmount(orgId, costAccountIds);
        if (isClear) {
            AcaInitHelper.deletePrePeriodCalcResult(orgId, costAccountIds, periodIds);
            return;
        }
        AcaInitHelper.newCalcResult(orgId, qtyAmountMap);
    }

    private static void newCalcResult(Long orgId, Map<String, WipCostInitInfo> qtyAmountMap) {
        Collection<WipCostInitInfo> wipCostInitInfos = qtyAmountMap.values();
        Map<String, List<WipCostInitInfo>> wipCostInitInfoMap = AcaInitHelper.constructWipCostInitInfoMap(wipCostInitInfos);
        Map<Object, DynamicObject> costObjMap = AcaInitHelper.getCostObjInfo(wipCostInitInfos);
        ArrayList<DynamicObject> calcResultsForInsert = new ArrayList<DynamicObject>(10);
        HashMap costaccountPeriodMap = Maps.newHashMap();
        for (Map.Entry<String, List<WipCostInitInfo>> entry : wipCostInitInfoMap.entrySet()) {
            List<WipCostInitInfo> wipCostInitInfoList = entry.getValue();
            if (CadEmptyUtils.isEmpty(wipCostInitInfoList)) continue;
            long costAccountId = wipCostInitInfoList.get(0).getCostAccountId();
            long costObjId = wipCostInitInfoList.get(0).getCostObjId();
            Object previousPeriod = costaccountPeriodMap.get(costAccountId);
            if (previousPeriod == null) {
                DynamicObject periodObj = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (periodObj == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u6210\u672c\u8d26\u7c3f\u662f\u5426\u5728\u5b58\u8d27\u6838\u7b97\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"AcaInitHelper_0", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                previousPeriod = PeriodHelper.getPreviousPeriod((Object)periodObj.getPkValue());
                costaccountPeriodMap.put(costAccountId, previousPeriod);
            }
            DynamicObject calcResult = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_ACA_CALCRESULT);
            calcResult.set("billno", (Object)ID.genStringId());
            calcResult.set("org", (Object)orgId);
            calcResult.set("costobject", (Object)costObjId);
            calcResult.set("costaccount", (Object)costAccountId);
            calcResult.set("costcenter", (Object)wipCostInitInfoList.get(0).getCostCenterId());
            calcResult.set("period", previousPeriod);
            calcResult.set("bizdate", (Object)TimeServiceHelper.now());
            calcResult.set("currency", (Object)wipCostInitInfoList.get(0).getCurrencyId());
            calcResult.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_STAGED.getValue());
            calcResult.set("createtime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection entryEntity = calcResult.getDynamicObjectCollection("entryentity");
            for (WipCostInitInfo wipCostInitInfo : wipCostInitInfoList) {
                if (wipCostInitInfo.isCostObjLevel()) {
                    DynamicObject finalResultRow = entryEntity.addNew();
                    finalResultRow.set("type", (Object)"finalResult");
                    finalResultRow.set("relacostobject", (Object)costObjId);
                    finalResultRow.set("relaproducttype", (Object)"C");
                    finalResultRow.set("pdendqty", (Object)wipCostInitInfoList.get(0).getInitQty());
                    finalResultRow.set("pdendamount", (Object)wipCostInitInfoList.get(0).getInitAmount());
                    finalResultRow.set("yearpdsumqty", (Object)wipCostInitInfoList.get(0).getYearInputQty());
                    finalResultRow.set("yearpdsumamount", (Object)wipCostInitInfoList.get(0).getYearInputAmt());
                    finalResultRow.set("yearsumcomqty", (Object)wipCostInitInfoList.get(0).getYearFinishQty());
                    finalResultRow.set("yearsumcomamount", (Object)wipCostInitInfoList.get(0).getYearFinishAmt());
                    AcaInitHelper.setMaterialInfo(costObjMap, wipCostInitInfoList.get(0), finalResultRow);
                    continue;
                }
                DynamicObject detailRow = entryEntity.addNew();
                detailRow.set("type", (Object)"detail");
                detailRow.set("relacostobject", (Object)costObjId);
                detailRow.set("relaproducttype", (Object)"C");
                detailRow.set("submaterial", (Object)wipCostInitInfo.getSubMaterialId());
                detailRow.set("calckeycol", (Object)wipCostInitInfo.getCalcKeycolId());
                if (!CadEmptyUtils.isEmpty((Long)wipCostInitInfo.getSubMaterialId())) {
                    detailRow.set("feetype", (Object)"materialFee");
                } else {
                    detailRow.set("feetype", (Object)"mfgFee");
                }
                detailRow.set("outsourcetype", (Object)wipCostInitInfo.getOutsourcetype());
                detailRow.set("submatversion", (Object)wipCostInitInfo.getSubMatVersionId());
                detailRow.set("subauxpty", (Object)wipCostInitInfo.getSubMatAuxPtyId());
                detailRow.set("element", (Object)wipCostInitInfo.getElementId());
                detailRow.set("subelement", (Object)wipCostInitInfo.getSubElementId());
                detailRow.set("pdendqty", (Object)(CadEmptyUtils.isEmpty((BigDecimal)wipCostInitInfo.getSubQty()) ? Integer.valueOf(0) : wipCostInitInfo.getSubQty()));
                detailRow.set("pdendamount", (Object)wipCostInitInfo.getSubAmount());
                detailRow.set("yearpdsumqty", (Object)wipCostInitInfo.getMatYearInputQty());
                detailRow.set("yearpdsumamount", (Object)wipCostInitInfo.getMatYearInputAmt());
                detailRow.set("yearsumcomqty", (Object)wipCostInitInfo.getMatYearFinishQty());
                detailRow.set("yearsumcomamount", (Object)wipCostInitInfo.getMatYearFinishAmt());
                if (!CadEmptyUtils.isEmpty((BigDecimal)wipCostInitInfo.getMatYearFinishAmt()) && !CadEmptyUtils.isEmpty((BigDecimal)wipCostInitInfo.getMatYearFinishQty())) {
                    detailRow.set("yearsumcomunitcost", (Object)wipCostInitInfo.getMatYearFinishAmt().divide(wipCostInitInfo.getMatYearFinishQty(), 10, 4));
                }
                if (!CadEmptyUtils.isEmpty((BigDecimal)wipCostInitInfo.getMatYearFinishQty()) && !CadEmptyUtils.isEmpty((BigDecimal)wipCostInitInfoList.get(0).getYearFinishQty())) {
                    detailRow.set("yearsumcomuse", (Object)wipCostInitInfo.getMatYearFinishQty().divide(wipCostInitInfoList.get(0).getYearFinishQty(), 10, 4));
                }
                AcaInitHelper.setMaterialInfo(costObjMap, wipCostInitInfo, detailRow);
            }
            calcResultsForInsert.add(calcResult);
        }
        if (!CadEmptyUtils.isEmpty(calcResultsForInsert)) {
            SaveServiceHelper.save((DynamicObject[])calcResultsForInsert.toArray(new DynamicObject[0]));
        }
    }

    private static Map<Object, DynamicObject> getCostObjInfo(Collection<WipCostInitInfo> wipCostInitInfos) {
        Set costObjIds = wipCostInitInfos.stream().map(item -> item.getCostObjId()).collect(Collectors.toSet());
        DynamicObject[] costObjects = BusinessDataServiceHelper.load((Object[])costObjIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_costobject"));
        return Arrays.stream(costObjects).collect(Collectors.toMap(e -> e.getPkValue(), e -> e));
    }

    private static Map<String, List<WipCostInitInfo>> constructWipCostInitInfoMap(Collection<WipCostInitInfo> wipCostInitInfos) {
        HashMap<String, List<WipCostInitInfo>> wipCostInitMap = new HashMap<String, List<WipCostInitInfo>>(16);
        for (WipCostInitInfo wipCostInitInfo : wipCostInitInfos) {
            long org = wipCostInitInfo.getOrgId();
            long costAccountId = wipCostInitInfo.getCostAccountId();
            long costObjId = wipCostInitInfo.getCostObjId();
            long costCenterId = wipCostInitInfo.getCostCenterId();
            String key = org + "@" + costAccountId + "@" + costObjId + "@" + costCenterId;
            ArrayList<WipCostInitInfo> wipCostInitInfoList = (ArrayList<WipCostInitInfo>)wipCostInitMap.get(key);
            if (CadEmptyUtils.isEmpty((List)wipCostInitInfoList)) {
                wipCostInitInfoList = new ArrayList<WipCostInitInfo>(10);
                wipCostInitInfoList.add(wipCostInitInfo);
                wipCostInitMap.put(key, wipCostInitInfoList);
                continue;
            }
            wipCostInitInfoList.add(wipCostInitInfo);
        }
        return wipCostInitMap;
    }

    private static void setMaterialInfo(Map<Object, DynamicObject> costObjMap, WipCostInitInfo wipCostInitInfo, DynamicObject detailRow) {
        DynamicObject costObj = costObjMap.get(wipCostInitInfo.getCostObjId());
        if (costObj == null) {
            return;
        }
        detailRow.set("material", (Object)costObj.getDynamicObject("material"));
        detailRow.set("auxpty", (Object)costObj.getDynamicObject("auxpty"));
        detailRow.set("matversion", (Object)costObj.getDynamicObject("bomversion"));
        if (!StringUtils.isEmpty((CharSequence)wipCostInitInfo.getSubitemjson())) {
            JSONArray arr = JSON.parseArray((String)wipCostInitInfo.getSubitemjson());
            DynamicObjectCollection subdetail = detailRow.getDynamicObjectCollection("subdetail");
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                DynamicObject subitemRow = subdetail.addNew();
                subitemRow.set("selement", (Object)obj.getLong("selement"));
                subitemRow.set("ssubelement", (Object)obj.getLong("ssubelement"));
                subitemRow.set("spdendamt", (Object)obj.getBigDecimal("samount"));
                subitemRow.set("spdyearsumamt", (Object)obj.getBigDecimal("syearinamt"));
                subitemRow.set("spdyearcomamt", (Object)obj.getBigDecimal("syearcomamt"));
            }
        }
    }

    private static void deletePrePeriodCalcResult(Long orgId, Set<Long> costAccountIds, Set<Object> periodIds) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountFilter = new QFilter("costaccount", "in", costAccountIds);
        ArrayList<DynamicObject> periodObjList = new ArrayList<DynamicObject>(10);
        for (Object periodId : periodIds) {
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)periodId);
            if (previousPeriod == null) continue;
            periodObjList.add(previousPeriod);
        }
        QFilter periodIdFilter = new QFilter("period", "=", (Object)0);
        if (!CadEmptyUtils.isEmpty(periodObjList)) {
            Set previousPeriodIds = periodObjList.stream().map(item -> item.getPkValue()).collect(Collectors.toSet());
            periodIdFilter = new QFilter("period", "in", previousPeriodIds);
        }
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountFilter, periodIdFilter};
        DeleteServiceHelper.delete((String)ENTITY_ACA_CALCRESULT, (QFilter[])filters);
    }

    private static Map<String, WipCostInitInfo> getQtyAmount(Long orgId, Set<Long> costAccountIds) {
        TreeMap<String, WipCostInitInfo> qtyAmountMap = new TreeMap<String, WipCostInitInfo>();
        DataSet costInitInfo = AcaInitHelper.getCostInitInfo(orgId, costAccountIds);
        for (Row row : costInitInfo) {
            long org = row.getLong("org");
            long costAccount = row.getLong("costaccount");
            long costCenter = row.getLong("costcenter");
            long costObject = row.getLong("costobject");
            long currencyId = row.getLong("currency");
            long subMateriel = row.getLong("submateriel");
            long subMatVersion = row.getLong("submatversion");
            long subMatAuxPty = row.getLong("subauxpty");
            long calckeycol = row.getLong("calckeycol");
            long element = row.getLong("element");
            long subElement = row.getLong("subelement");
            BigDecimal amount = row.getBigDecimal("amount") == null ? BigDecimal.ZERO : row.getBigDecimal("amount");
            BigDecimal initQty = row.getBigDecimal("initqty") == null ? BigDecimal.ZERO : row.getBigDecimal("initqty");
            BigDecimal initAmt = row.getBigDecimal("initamt");
            BigDecimal subQty = row.getBigDecimal("subqty");
            BigDecimal subAmount = row.getBigDecimal("subamount") == null ? BigDecimal.ZERO : row.getBigDecimal("subamount");
            BigDecimal yearInputQty = row.getBigDecimal("yearinputqty") == null ? BigDecimal.ZERO : row.getBigDecimal("yearinputqty");
            BigDecimal yearInputAmt = row.getBigDecimal("yearinputamt") == null ? BigDecimal.ZERO : row.getBigDecimal("yearinputamt");
            BigDecimal yearFinishQty = row.getBigDecimal("yearfinishqty") == null ? BigDecimal.ZERO : row.getBigDecimal("yearfinishqty");
            BigDecimal yearFinishAmt = row.getBigDecimal("yearfinishamt") == null ? BigDecimal.ZERO : row.getBigDecimal("yearfinishamt");
            BigDecimal matYearInputQty = row.getBigDecimal("matyearinputqty") == null ? BigDecimal.ZERO : row.getBigDecimal("matyearinputqty");
            BigDecimal matYearInputAmt = row.getBigDecimal("matyearinputamt") == null ? BigDecimal.ZERO : row.getBigDecimal("matyearinputamt");
            BigDecimal matYearFinishQty = row.getBigDecimal("matyearfinishqty") == null ? BigDecimal.ZERO : row.getBigDecimal("matyearfinishqty");
            BigDecimal matYearFinishAmt = row.getBigDecimal("matyearfinishamt") == null ? BigDecimal.ZERO : row.getBigDecimal("matyearfinishamt");
            String subEleType = row.getString("subeletype");
            if (!"001".equals(subEleType) && !"002".equals(subEleType)) {
                if (BigDecimal.ZERO.compareTo(matYearInputAmt) == 0) {
                    matYearInputAmt = yearInputAmt;
                }
                if (BigDecimal.ZERO.compareTo(matYearFinishAmt) == 0) {
                    matYearFinishAmt = yearFinishAmt;
                }
                if (BigDecimal.ZERO.compareTo(subAmount) == 0) {
                    subAmount = amount;
                }
            }
            String outsourcetype = row.getString("outsourcetype");
            String subitemjson = row.getString("subitemjson");
            WipCostInitInfo wipCostInitInfoForMat = new WipCostInitInfo.Builder().orgId(org).costObjId(costObject).costAccountId(costAccount).costCenterId(costCenter).currencyId(currencyId).yearFinishQty(yearFinishQty).yearFinishAmt(yearFinishAmt).yearInputQty(yearInputQty).yearInputAmt(yearInputAmt).subMaterialId(subMateriel).subMatVersionId(subMatVersion).subMatAuxPtyId(subMatAuxPty).calcKeycolId(calckeycol).elementId(element).subElementId(subElement).initQty(initQty).initAmount(initAmt).subQty(subQty).subAmount(subAmount).amount(amount).matYearInputQty(matYearInputQty).matYearInputAmt(matYearInputAmt).matYearFinishQty(matYearFinishQty).matYearFinishAmt(matYearFinishAmt).outsourcetype(outsourcetype).subitemjson(subitemjson).build();
            String costObjKey = org + "@" + costAccount + "@" + costCenter + "@" + costObject;
            String subMaterialKey = costObjKey + "@" + subMateriel + "@" + element + "@" + subElement + "@" + calckeycol;
            qtyAmountMap.put(subMaterialKey, wipCostInitInfoForMat);
            if (qtyAmountMap.containsKey(costObjKey)) {
                WipCostInitInfo costWipInfo = (WipCostInitInfo)qtyAmountMap.get(costObjKey);
                costWipInfo.setMatYearInputAmt(costWipInfo.getMatYearInputAmt().add(matYearInputAmt));
                costWipInfo.setMatYearFinishAmt(costWipInfo.getMatYearFinishAmt().add(matYearFinishAmt));
                costWipInfo.setYearInputAmt(costWipInfo.getMatYearInputAmt());
                costWipInfo.setYearFinishAmt(costWipInfo.getMatYearFinishAmt());
                continue;
            }
            WipCostInitInfo wipCostInitInfoForCostObjLevel = new WipCostInitInfo.Builder().build();
            try {
                wipCostInitInfoForCostObjLevel = wipCostInitInfoForMat.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error((Throwable)e);
            }
            wipCostInitInfoForCostObjLevel.setCostObjLevel(true);
            qtyAmountMap.put(costObjKey, wipCostInitInfoForCostObjLevel);
        }
        return qtyAmountMap;
    }

    private static DataSet getCostInitInfo(Long orgId, Set<Long> costAccountIds) {
        String algoKey = AcaInitHelper.class.getName() + ".getCostInitInfo";
        String selectFields = "org, costaccount, costcenter, costobject, initqty, initamt, currency,yearinputqty,yearfinishqty,entryentity.outsourcetype outsourcetype,entryentity.element element,entryentity.subelement subelement,entryentity.subelement.type subeletype,entryentity.amount amount,entryentity.yearinputamt yearinputamt,entryentity.yearfinishamt yearfinishamt,entryentity.subentryentity.submateriel submateriel, entryentity.subentryentity.submatversion submatversion, entryentity.subentryentity.subauxpty subauxpty,entryentity.subentryentity.calckeycol calckeycol,entryentity.subentryentity.subqty subqty,entryentity.subentryentity.subamount subamount,entryentity.subentryentity.matyearinputqty matyearinputqty,entryentity.subentryentity.matyearinputamt matyearinputamt,entryentity.subentryentity.matyearfinishqty matyearfinishqty,entryentity.subentryentity.matyearfinishamt matyearfinishamt,entryentity.subentryentity.subitemjson_tag subitemjson";
        QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountIdsFilter = new QFilter("costaccount", "in", costAccountIds);
        QFilter[] filters = new QFilter[]{orgIdFilter, costAccountIdsFilter};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_wipcostinit", (String)selectFields, (QFilter[])filters, null, (int)-1);
        return dataSet;
    }
}

