/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.sca.opplugin.utils.CommonOp;
import org.apache.commons.lang3.StringUtils;

public class DiyCostDriverEditPlugin
extends AbstractBillPlugIn {
    private static final String BOS_COSTCENTER = "bos_costcenter";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String MATERIAL = "MATERIAL";
    private static final String MANU_ORG_CONFIRM = "manuOrgConfirm";
    private static final String COST_CENTER_CONFIRM = "costcenterconfirm";
    private static final String COST_DRIVER_CONFIRM = "costdriverconfirm";
    private static final String KEY_BARITEM_NEW = "bar_new";
    private static final String KEY_BARITEM_SAVE = "bar_save";
    private static final String KEY_BARITEM_COPY = "bar_copy";
    private static final String KEY_BARITEM_EFFECT = "bar_effect";
    private static final String KEY_BARITEM_UNEFFECT = "bar_uneffect";
    private static final String KEY_BARITEM_DELETE = "bar_delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.getModel().getValue("org") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            QFilter orgfilter = new QFilter("id", "=", (Object)0L);
            if (accountorg == null) {
                formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
                return;
            }
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId());
            orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costcent = (BasedataEdit)this.getControl("costcenter");
        costcent.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String allocClass;
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List<Object> ids = new ArrayList();
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
            DynamicObject costdriverObject = (DynamicObject)this.getModel().getValue("costdriver");
            if (!CadEmptyUtils.isEmpty((DynamicObject)costdriverObject) && COSTOBJECT.equals(allocClass = costdriverObject.getString("allocclass"))) {
                QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
                qList.add(showOrgDutyFilter);
            }
        });
        BasedataEdit costdriver = (BasedataEdit)this.getControl("costdriver");
        costdriver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            qList.add(new QFilter("issys", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("isrelatedwork", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("islinkresource", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("iscomplexcd", "=", (Object)Boolean.FALSE));
            String appnum = this.getView().getFormShowParameter().getAppId();
            qList.add(new QFilter("appnum", "=", (Object)appnum));
        });
        BasedataEdit benefcostcenter = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            DynamicObject costdriverObject = (DynamicObject)this.getModel().getValue("costdriver");
            if (!CadEmptyUtils.isEmpty((DynamicObject)costdriverObject)) {
                String allocClass = costdriverObject.getString("allocclass");
                if (COSTCENTER.equals(allocClass)) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    HashSet<Long> costcenterId = new HashSet<Long>();
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                        for (DynamicObject dynamicObject : entryEntity) {
                            DynamicObject benefCostcenter = dynamicObject.getDynamicObject("benefcostcenter");
                            if (CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter)) continue;
                            costcenterId.add(benefCostcenter.getLong("id"));
                        }
                    }
                    qList.add(new QFilter("id", "not in", costcenterId));
                } else if (COSTOBJECT.equals(allocClass)) {
                    if (this.getModel().getValue("costcenter") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"DiyCostDriverEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                    } else {
                        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
                        qList.add(new QFilter("id", "=", (Object)costCenter.getLong("id")));
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u52a8\u56e0\u3002", (String)"DiyCostDriverEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            List<Object> ids = new ArrayList();
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                qList.add(new QFilter("accountorg", "=", (Object)accountorg.getLong("id")));
            }
        });
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costcenter;
            DynamicObject costdriverDy;
            DynamicObject org;
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            boolean isMultiFactory = false;
            if (this.getModel().getValue("org") != null && OrgHelper.isOrgEnableMultiFactory((Long)(org = (DynamicObject)this.getModel().getValue("org")).getLong("id")) && !CadEmptyUtils.isEmpty((DynamicObject)(costdriverDy = (DynamicObject)this.getModel().getValue("costdriver")))) {
                isMultiFactory = Boolean.TRUE;
                if (COSTCENTER.equals(costdriverDy.getString("allocclass"))) {
                    isMultiFactory = Boolean.FALSE;
                }
            }
            if (isMultiFactory && this.getModel().getValue("manuorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u751f\u4ea7\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"DiyCostDriverEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costcenter = (DynamicObject)this.getModel().getValue("benefcostcenter", index)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u540e\u518d\u9009\u62e9\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"DiyCostDriverEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> costObjectId = new HashSet<Long>();
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject costObject = dynamicObject.getDynamicObject("costobject");
                        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) continue;
                        costObjectId.add(costObject.getLong("id"));
                    }
                }
                qList.add(new QFilter("id", "not in", costObjectId));
                DynamicObject org2 = this.getModel().getDataEntity().getDynamicObject("org");
                if (CadEmptyUtils.isEmpty((DynamicObject)org2)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                qList.add(new QFilter("org", "=", (Object)org2.getLong("id")));
                qList.add(new QFilter("billstatus", "=", (Object)"C"));
                if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                    qList.add(new QFilter("bizstatus", "=", (Object)Character.valueOf('A')));
                }
                if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                    qList.add(new QFilter("producttype", "=", (Object)"C"));
                }
                if (isMultiFactory && this.getModel().getValue("manuorg") != null) {
                    qList.add(new QFilter("manuorg", "=", (Object)((DynamicObject)this.getModel().getValue("manuorg")).getLong("id")));
                }
            }
        });
        BasedataEdit materialGrpStd = (BasedataEdit)this.getControl("materialgroupstd");
        materialGrpStd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List groupStandardSet = MaterialGroupHelper.getGroupStandard((String)"bd_material", (Long)org.getLong("id"), (boolean)Boolean.TRUE);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)groupStandardSet));
        });
        BasedataEdit materialGroup = (BasedataEdit)this.getControl("materialgroup");
        materialGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialGroupStd = (DynamicObject)this.getModel().getValue("materialgroupstd");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(org.getLong("id"));
            if (materialGroupStd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiyCostDriverEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, materialGroupStd.getPkValue(), true});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", orgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialGroupStd.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject mat = (DynamicObject)this.getModel().getValue("matnum");
            if (mat != null) {
                ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                qList.add(new QFilter("material", "=", mat.getPkValue()));
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        this.initOrgAndCostcenter(os);
        this.setVisibleByAllocClass();
        this.setColumn();
        this.setManuorgMustInput();
        this.changManuorgStatus();
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().setDataChanged(false);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (KEY_BARITEM_COPY.equals(evt.getItemKey())) {
            long sourceId = (Long)this.getModel().getValue("sourceid");
            long recordSourceId = CadEmptyUtils.isEmpty((Long)sourceId) ? (Long)this.getModel().getValue("id") : sourceId;
            this.getView().getPageCache().put("sourceId", String.valueOf(recordSourceId));
            this.getView().getPageCache().put("copyFlag", "Y");
        } else if (KEY_BARITEM_EFFECT.equals(evt.getItemKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccount.getLong("id"));
            if (org == null || costAccount == null || currentPeriod == null) {
                return;
            }
            if (this.isEnableEffectByOrg(org.getLong("id"))) {
                boolean isInCurrentPeriod = this.isInCurrentPeriod(org.getLong("id"), costAccount.getLong("id"), currentPeriod.getLong("id"), true);
                String tipMsg = isInCurrentPeriod ? ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u671f\u95f4\u4e3a\u201c%s\u201d\uff0c\u751f\u6548\u540e\u5c06\u8986\u76d6\u539f\u5355\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u751f\u6548\u3002", (String)"DiyCostDriverEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u671f\u95f4\u4e3a\u201c%s\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u751f\u6548\u3002", (String)"DiyCostDriverEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showConfirm(ResManager.loadKDString((String)String.format(tipMsg, currentPeriod.getString("name")), (String)"DiyCostDriverEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_BARITEM_EFFECT, (IFormPlugin)this));
                evt.setCancel(true);
            } else {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObject existDynamicObject = this.existsDiyCostDriver(dataEntity);
                if (existDynamicObject != null) {
                    String billNo = (String)existDynamicObject.get("billno");
                    DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
                    DynamicObject manuOrg = dataEntity.getDynamicObject("manuorg");
                    StringBuilder sbTip = new StringBuilder();
                    String tip = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010%1$s\u3011+\u3010%2$s\u3011", (String)"DiyCostDriverEditPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]), org.getString("name"), costAccount.getString("name"));
                    if (manuOrg != null) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011", (String)"DiyCostDriverEditPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]), tip, manuOrg.getString("name"));
                    }
                    if (costCenter != null) {
                        tip = String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011", (String)"DiyCostDriverEditPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]), tip, costCenter.getString("name"));
                    }
                    sbTip.append(tip);
                    List<String[]> errorList = this.buildEntryEntityDuplicateErrors(dataEntity, sbTip, billNo);
                    if (!CadEmptyUtils.isEmpty(errorList)) {
                        String operatorName = ResManager.loadKDString((String)"\u751f\u6548", (String)"DiyCostDriverEditPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]);
                        String title = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c", (String)"DiyCostDriverEditPlugin_21", (String)"macc-sca-form", (Object[])new Object[0]);
                        MessgeBoxUtils.showDetailsMessageBox((IFormView)this.getView(), (String)operatorName, (String)title, errorList);
                        evt.setCancel(true);
                    }
                }
            }
        }
    }

    private List<String[]> buildEntryEntityDuplicateErrors(DynamicObject dataEntity, StringBuilder prefixTip, String billNo) {
        ArrayList errorList = Lists.newArrayList();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject materialGroupStd = dataEntity.getDynamicObject("materialgroupstd");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        String allocClass = costDriver.getString("allocclass");
        Iterator iterator = entryEntity.iterator();
        switch (allocClass) {
            case "COSTCENTER": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverEditPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("benefcostcenter.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "MATERIAL": {
                while (iterator.hasNext()) {
                    DynamicObject auxPty;
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    Boolean isUseAuxpty = next.getBoolean("matnum.isuseauxpty");
                    HashSet<Long> allAuxptyId = new HashSet<Long>(10);
                    if (isUseAuxpty.booleanValue()) {
                        DynamicObjectCollection isaffectprice = next.getDynamicObjectCollection("matnum.auxptyentry");
                        for (DynamicObject isPrice : isaffectprice) {
                            allAuxptyId.add(isPrice.getLong("auxpty.id"));
                        }
                    }
                    if ((auxPty = next.getDynamicObject("matauxpty")) != null && !CadEmptyUtils.isEmpty(allAuxptyId)) {
                        String auxPtyInfo = CommonOp.getAuptyInfo(allAuxptyId, (String)auxPty.get(1));
                        errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011+\u3010%4$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%5$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverEditPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("matnum.name"), auxPtyInfo, billNo));
                    } else {
                        errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverEditPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("matnum.name"), billNo));
                    }
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "COSTOBJECT": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverEditPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("costobject.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "MATERIALGROUP": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011+\u3010%4$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%5$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverEditPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), materialGroupStd.getString("name"), next.getString("materialgroup.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
        }
        return errorList;
    }

    private DynamicObject existsDiyCostDriver(DynamicObject dataEntity) {
        QFilter[] filters = this.getQFilter(dataEntity, true);
        if (filters == null) {
            return null;
        }
        return this.removeNotDuplicateDiyCostDriver(dataEntity, filters);
    }

    private DynamicObject removeNotDuplicateDiyCostDriver(DynamicObject dataEntity, QFilter[] filters) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryEntity.iterator();
        DynamicObjectCollection existsDiyCostDrivers = QueryServiceHelper.query((String)"sca_diycostdriver", (String)"billno,entryentity.id,entryentity.benefcostcenter,entryentity.costobject,entryentity.matnum,entryentity.matauxpty,entryentity.materialgroup", (QFilter[])filters);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existsDiyCostDrivers)) {
            String allocClass;
            DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.benefcostcenter").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (benefitCostCenterIds.contains(next.getLong("benefcostcenter.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "MATERIAL": {
                    List materialIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.matnum").toString())).collect(Collectors.toList());
                    List matAuxPtyIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.matauxpty").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (materialIds.contains(next.get("matnum.id")) && matAuxPtyIds.contains(next.getLong("matauxpty.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.costobject").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (costObjectIds.contains(next.get("costobject.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.materialgroup").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (materialGroupIds.contains(next.get("materialgroup.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
            return (DynamicObject)existsDiyCostDrivers.get(0);
        }
        return null;
    }

    private QFilter[] getQFilter(DynamicObject dataEntity, boolean includeEntryEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        if (org == null || costAccount == null || costDriver == null) {
            return null;
        }
        DynamicObject manuOrg = dataEntity.getDynamicObject("manuorg");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "!=", dataEntity.getPkValue()));
        qFilters.add(new QFilter("org", "=", org.getPkValue()));
        qFilters.add(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
        qFilters.add(new QFilter("costaccount", "=", costAccount.getPkValue()));
        qFilters.add(new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()));
        qFilters.add(new QFilter("costdriver", "=", costDriver.getPkValue()));
        qFilters.add(new QFilter("effectstatus", "in", (Object)new String[]{"E"}));
        qFilters.add(new QFilter("appnum", "=", (Object)dataEntity.getString("appnum")));
        if (includeEntryEntity) {
            String allocClass;
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = entryEntity.stream().map(e -> Long.parseLong(e.get("benefcostcenter.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(benefitCostCenterIds)) break;
                    qFilters.add(new QFilter("entryentity.benefcostcenter", "in", benefitCostCenterIds));
                    break;
                }
                case "MATERIAL": {
                    List materialIds = entryEntity.stream().map(e -> Long.parseLong(e.get("matnum.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialIds)) break;
                    qFilters.add(new QFilter("entryentity.matnum", "in", materialIds));
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = entryEntity.stream().map(e -> Long.parseLong(e.get("costobject.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(costObjectIds)) break;
                    qFilters.add(new QFilter("entryentity.costobject", "in", costObjectIds));
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = entryEntity.stream().map(e -> Long.parseLong(e.get("materialgroup.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialGroupIds)) break;
                    qFilters.add(new QFilter("entryentity.materialgroup", "in", materialGroupIds));
                    break;
                }
            }
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private boolean isInCurrentPeriod(Long orgId, Long costAccountId, Long currentPeriodId, boolean includeEntryEntity) {
        DynamicObject costDriver = (DynamicObject)this.getModel().getValue("costdriver");
        if (costDriver == null) {
            return false;
        }
        Long currentId = (Long)this.getModel().getValue("id");
        DynamicObject manuOrg = (DynamicObject)this.getModel().getValue("manuorg");
        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "!=", (Object)currentId));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
        qFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        qFilters.add(new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()));
        qFilters.add(new QFilter("costdriver", "=", costDriver.getPkValue()));
        qFilters.add(new QFilter("effectperiod", "=", (Object)currentPeriodId));
        qFilters.add(new QFilter("expperiod", "=", (Object)0L));
        qFilters.add(new QFilter("effectstatus", "=", (Object)"E"));
        qFilters.add(new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNum((IFormView)this.getView())));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (includeEntryEntity) {
            String allocClass;
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = entryEntity.stream().map(e -> Long.parseLong(e.get("benefcostcenter.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(benefitCostCenterIds)) break;
                    qFilters.add(new QFilter("entryentity.benefcostcenter", "in", benefitCostCenterIds));
                    break;
                }
                case "MATERIAL": {
                    List materialIds = entryEntity.stream().map(e -> Long.parseLong(e.get("matnum.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialIds)) break;
                    qFilters.add(new QFilter("entryentity.matnum", "in", materialIds));
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = entryEntity.stream().map(e -> Long.parseLong(e.get("costobject.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(costObjectIds)) break;
                    qFilters.add(new QFilter("entryentity.costobject", "in", costObjectIds));
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = entryEntity.stream().map(e -> Long.parseLong(e.get("materialgroup.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialGroupIds)) break;
                    qFilters.add(new QFilter("entryentity.materialgroup", "in", materialGroupIds));
                    break;
                }
            }
        }
        return QueryServiceHelper.exists((String)"sca_diycostdriver", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"costcenter", "costdriver"});
                this.setEnable(true);
                break;
            }
            case "bar_copy": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"costdriver", "costcenter"});
                String recordSourceId = this.getView().getPageCache().get("sourceId");
                this.getModel().setValue("sourceid", (Object)Long.parseLong(recordSourceId));
                this.getModel().setValue("effectperiod", null);
                this.getModel().setValue("expperiod", null);
                this.getModel().setValue("effectdate", null);
                this.getModel().setValue("expdate", null);
                this.getModel().setValue("effectstatus", (Object)"A");
                this.setEnable(true);
                break;
            }
        }
    }

    private boolean isEnableEffectByOrg(Long orgId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"sca_diycostdriver");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.getPageCache().put("dataChanged", String.valueOf(dataChanged));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if ("save".equals(args.getOperateKey())) {
            String dataChanged = this.getPageCache().get("dataChanged");
            if (StringUtils.equals((CharSequence)"true", (CharSequence)dataChanged)) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.set("effectstatus", (Object)"A");
                dataEntity.set("effectdate", null);
                dataEntity.set("expdate", null);
                dataEntity.set("effectperiod", null);
                dataEntity.set("expperiod", null);
                SaveServiceHelper.update((DynamicObject)dataEntity);
            }
            this.initOrgAndCostcenter(os);
            this.setVisibleByAllocClass();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_EFFECT});
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (this.isEnableEffectByOrg(org.getLong("id"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_UNEFFECT});
            }
        } else if ("effect".equals(args.getOperateKey())) {
            this.initOrgAndCostcenter(os);
            this.getView().invokeOperation("refresh");
        }
    }

    private void setColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.setColumnProperty("benefcostcenter", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("orgdutyname", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("matnum", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("matname", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("matmodelnum", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("matauxpty", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("matversion", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("configuredcode", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("tracknumber", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("entryqty", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("costobject", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("materialgroup", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("material", "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty("modelnum", "isFixed", (Object)Boolean.TRUE);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "org": {
                this.getModel().setValue("manuorg", null);
                this.setManuorgMustInput();
                this.changManuorgStatus();
                break;
            }
            case "costcenter": {
                this.updateAccountorg();
                this.changeCostCenter(e);
                break;
            }
            case "benefcostcenter": {
                this.updateCostObject(rowIndex);
                break;
            }
            case "costobject": {
                this.updateMaterial(rowIndex);
                break;
            }
            case "costdriver": {
                this.getModel().setValue("costcenter", null);
                this.setVisibleByAllocClass();
                this.setBaseUnit();
                this.setManuorgMustInput();
                this.changManuorgStatus();
                this.changeCostDriver(e);
                break;
            }
            case "entryqty": {
                this.setQty();
                break;
            }
            case "manuorg": {
                this.changeManuOrg(e);
                break;
            }
            case "materialgroupstd": {
                this.changeMaterialGroupStd(e);
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if (StringUtils.isEmpty((CharSequence)appId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01", (String)"DiyCostDriverEditPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", appId);
        sourceData.put("effectperiod", null);
        sourceData.put("expperiod", null);
        sourceData.put("effectstatus", "A");
    }

    private void changeCostDriver(PropertyChangedArgs e) {
        DynamicObjectCollection dynamicObjects;
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        String oldId = "";
        if (oldValue != null) {
            oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
        }
        if ((dynamicObjects = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u52a8\u56e0\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u6e05\u7a7a\uff1f", (String)"DiyCostDriverEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(COST_DRIVER_CONFIRM), null, oldId);
        }
    }

    private void changeCostCenter(PropertyChangedArgs e) {
        DynamicObjectCollection dynamicObjects;
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        String oldId = "";
        if (oldValue != null) {
            oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
        }
        if ((dynamicObjects = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6210\u672c\u4e2d\u5fc3\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u6e05\u7a7a\uff1f", (String)"DiyCostDriverEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(COST_CENTER_CONFIRM), null, oldId);
        }
    }

    private void changeMaterialGroupStd(PropertyChangedArgs e) {
        DynamicObject costDriver = (DynamicObject)this.getModel().getValue("costdriver");
        if (costDriver != null) {
            if (!MATERIALGROUP.equals(costDriver.getString("allocclass"))) {
                return;
            }
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            ChangeData[] changeData = e.getChangeSet();
            Object oldValue = changeData[0].getOldValue();
            String oldId = "";
            if (oldValue != null) {
                oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
            }
            if (dynamicObjects.size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7269\u6599\u5206\u7c7b\u6807\u51c6\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u6e05\u7a7a\uff1f", (String)"DiyCostDriverEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(MANU_ORG_CONFIRM), null, oldId);
            }
        }
    }

    private void changeManuOrg(PropertyChangedArgs e) {
        DynamicObject costDriver = (DynamicObject)this.getModel().getValue("costdriver");
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null) {
            return;
        }
        if (changeData[0].getNewValue() != changeData[0].getOldValue()) {
            this.getModel().setValue("costcenter", null);
        }
        if (costDriver != null) {
            if (!COSTOBJECT.equals(costDriver.getString("allocclass"))) {
                return;
            }
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            Object oldValue = changeData[0].getOldValue();
            String oldId = "";
            if (oldValue != null) {
                oldId = String.valueOf(((DynamicObject)oldValue).getLong("id"));
            }
            if (dynamicObjects.size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u751f\u4ea7\u7ec4\u7ec7\u5c06\u6e05\u7a7a\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u6e05\u7a7a\uff1f", (String)"DiyCostDriverEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(MANU_ORG_CONFIRM), null, oldId);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MANU_ORG_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "manuorg");
        }
        if (COST_CENTER_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "costcenter");
        }
        if (COST_DRIVER_CONFIRM.equals(callBackId)) {
            this.confirmOrNot(messageBoxClosedEvent, "costdriver");
        }
        if (KEY_BARITEM_EFFECT.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getView().invokeOperation("effect");
        }
    }

    private void confirmOrNot(MessageBoxClosedEvent messageBoxClosedEvent, String field) {
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().deleteEntryData("entryentity");
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(field, (Object)(StringUtils.isEmpty((CharSequence)oldValue) ? null : Long.valueOf(oldValue)));
            this.getModel().endInit();
            this.getView().updateView(field);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String allocClass;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_EFFECT});
        DynamicObject costdriverObject = (DynamicObject)this.getModel().getValue("costdriver");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costdriverObject) && COSTOBJECT.equals(allocClass = costdriverObject.getString("allocclass"))) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            int index = dynamicObjects.size();
            DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
            if (costCenter != null) {
                this.getModel().setValue("benefcostcenter", (Object)costCenter.getLong("id"), index - 1);
                this.getView().setEnable(Boolean.valueOf(false), index - 1, new String[]{"benefcostcenter"});
            }
        }
    }

    private void updateCostObject(int index) {
        long benefCostCenterId;
        DynamicObject benefCostCenter = (DynamicObject)this.getModel().getValue("benefcostcenter", index);
        if (benefCostCenter == null) {
            this.getModel().setValue("costobject", null);
            return;
        }
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject", index);
        if (costObject == null) {
            return;
        }
        long costCenterId = costObject.getLong("costcenter.id");
        if (costCenterId == (benefCostCenterId = benefCostCenter.getLong("id"))) {
            return;
        }
        this.getModel().setValue("costobject", null);
    }

    private void setBaseUnit() {
        DynamicObject costdriver = (DynamicObject)this.getModel().getValue("costdriver");
        if (CadEmptyUtils.isEmpty((DynamicObject)costdriver)) {
            this.getModel().setValue("costbaseunit", null);
            return;
        }
        this.getModel().setValue("costbaseunit", (Object)costdriver.getLong("unit.id"));
    }

    private void setQty() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject dynamicObject : entryEntity) {
            BigDecimal entryQty = dynamicObject.getBigDecimal("entryqty");
            sum = sum.add(entryQty);
        }
        this.getModel().setValue("qty", (Object)sum);
    }

    private void setManuorgMustInput() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        boolean enableMulFactory = false;
        if (accountorg != null) {
            enableMulFactory = CostAccountHelper.isOrgEnableMulFactory((Long)accountorg.getLong("id"), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        }
        BasedataEdit manuorgInput = (BasedataEdit)this.getControl("manuorg");
        manuorgInput.setMustInput(enableMulFactory);
    }

    private void setVisibleByAllocClass() {
        DynamicObject costdriver = (DynamicObject)this.getModel().getValue("costdriver");
        Boolean isCostObject = Boolean.TRUE;
        Boolean isMaterial = Boolean.FALSE;
        Boolean isMaterialGroup = Boolean.FALSE;
        if (CadEmptyUtils.isEmpty((DynamicObject)costdriver)) {
            this.setMaterialVisible(false);
            isCostObject = Boolean.FALSE;
        } else {
            switch (costdriver.getString("allocclass")) {
                case "COSTCENTER": {
                    isCostObject = Boolean.FALSE;
                    break;
                }
                case "MATERIAL": {
                    isCostObject = Boolean.FALSE;
                    isMaterial = Boolean.TRUE;
                    break;
                }
                case "MATERIALGROUP": {
                    isCostObject = Boolean.FALSE;
                    isMaterial = Boolean.FALSE;
                    isMaterialGroup = Boolean.TRUE;
                }
            }
        }
        this.getView().setVisible(isCostObject, new String[]{"costobject", "cbmanuorg"});
        BasedataEdit costObjectInput = (BasedataEdit)this.getView().getControl("costobject");
        costObjectInput.setMustInput(isCostObject.booleanValue());
        this.getView().setVisible(isCostObject, new String[]{"material"});
        this.getView().setVisible(isCostObject, new String[]{"modelnum"});
        this.getView().setVisible(isCostObject, new String[]{"baseunit"});
        this.getView().setVisible(isCostObject, new String[]{"auxpty"});
        this.getView().setVisible(isCostObject, new String[]{"version"});
        this.getView().setVisible(isCostObject, new String[]{"sotype"});
        this.getView().setVisible(isCostObject, new String[]{"srcbillnumber"});
        this.getView().setVisible(isCostObject, new String[]{"srcbillrow"});
        this.getView().setVisible(Boolean.valueOf(isMaterial == false && isMaterialGroup == false), new String[]{"benefcostcenter"});
        this.getView().setVisible(Boolean.valueOf(isMaterial == false && isMaterialGroup == false), new String[]{"orgdutyname"});
        BasedataEdit costcenter = (BasedataEdit)this.getView().getControl("costcenter");
        costcenter.setMustInput(isCostObject.booleanValue());
        this.getModel().getValue("effectstatus");
        String effectStatus = (String)this.getModel().getValue("effectstatus");
        boolean isNotEffect = "A".equals(effectStatus);
        this.getView().setEnable(Boolean.valueOf(isNotEffect && isMaterialGroup == false), new String[]{"costcenter"});
        this.setMaterialVisible(isMaterial);
        this.getView().setVisible(isMaterialGroup, new String[]{"materialgroupstd", "materialgroup"});
        BasedataEdit materialGroupStd = (BasedataEdit)this.getView().getControl("materialgroupstd");
        materialGroupStd.setMustInput(isMaterialGroup.booleanValue());
        BasedataEdit benefCostCenter = (BasedataEdit)this.getView().getControl("benefcostcenter");
        benefCostCenter.setMustInput(isMaterial == false);
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())) && Boolean.TRUE.equals(isCostObject)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"material"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modelnum"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"cbmanuorg"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"auxpty"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"version"});
        }
    }

    private void setMaterialVisible(boolean isVisible) {
        boolean isSca = AppIdHelper.isSCA((IFormView)this.getView());
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"matnum"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"matname"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"matmodelnum"});
        this.getView().setVisible(Boolean.valueOf(isVisible && isSca), new String[]{"configuredcode"});
        this.getView().setVisible(Boolean.valueOf(isVisible && isSca), new String[]{"tracknumber"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"matauxpty"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"matversion"});
    }

    private void updateMaterial(int changeRowIndex) {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject", changeRowIndex);
        if (!CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
            this.getModel().setValue("material", (Object)costObject.getLong("material.id"), changeRowIndex);
            this.getModel().setValue("auxpty", (Object)costObject.getLong("auxpty.id"), changeRowIndex);
            this.getModel().setValue("benefcostcenter", (Object)costObject.getLong("costcenter.id"), changeRowIndex);
        } else {
            this.getModel().setValue("material", null, changeRowIndex);
            this.getModel().setValue("auxpty", null, changeRowIndex);
        }
    }

    private void initOrgAndCostcenter(OperationStatus os) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean isEnableEffect = org == null ? false : this.isEnableEffectByOrg(org.getLong("id"));
        this.getView().setVisible(Boolean.valueOf(isEnableEffect), new String[]{"effectperiod", "expperiod"});
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String costAccountId = (String)fsp.getCustomParam("costaccount");
            if (StringUtils.isNotBlank((CharSequence)costAccountId)) {
                this.getModel().setValue("costaccount", (Object)Long.parseLong(costAccountId));
            }
            Object costcenter = fsp.getCustomParam("costcenter");
            String manuorg = (String)fsp.getCustomParam("manuorg");
            if (StringUtils.isNotBlank((CharSequence)manuorg)) {
                this.getModel().setValue("manuorg", (Object)Long.parseLong(manuorg));
            }
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getModel().setValue("costcenter", costcenter);
                this.updateAccountorg();
            }
        } else {
            String effectStatus;
            switch (effectStatus = (String)this.getModel().getValue("effectstatus")) {
                case "A": {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"remark", "costdriver", "costcenter", "entryentity", "bar_newentry", "bar_deleteentry", "bar_configure"});
                    if (isEnableEffect && !CadEmptyUtils.isEmpty((Long)((Long)this.getModel().getValue("sourceid")))) {
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"costdriver", "costcenter"});
                    }
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_SAVE, KEY_BARITEM_EFFECT, KEY_BARITEM_DELETE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_COPY, KEY_BARITEM_UNEFFECT});
                    break;
                }
                case "E": {
                    if (isEnableEffect) {
                        this.setEnable(false);
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_BARITEM_COPY, KEY_BARITEM_EFFECT});
                    } else {
                        this.getView().setEnable(Boolean.valueOf(true), new String[]{"entryentity", "bar_newentry", "bar_deleteentry", "bar_configure"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_COPY, KEY_BARITEM_EFFECT});
                    }
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno", "remark", "costdriver", "costcenter"});
                    this.getView().setVisible(Boolean.valueOf(!isEnableEffect), new String[]{KEY_BARITEM_SAVE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_DELETE});
                    break;
                }
                case "F": {
                    this.setEnable(false);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"remark", "costdriver", "costcenter"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARITEM_EFFECT, KEY_BARITEM_UNEFFECT, KEY_BARITEM_DELETE, KEY_BARITEM_SAVE, KEY_BARITEM_COPY});
                }
            }
        }
    }

    private void setEnable(Boolean enable) {
        this.getView().setEnable(enable, new String[]{"billno", "manuorg", "remark", "entryentity", "bar_newentry", "bar_deleteentry", "bar_configure"});
    }

    private void updateAccountorg() {
        FormShowParameter fsp;
        Object accountorg;
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costcenter != null && ((accountorg = (fsp = this.getView().getFormShowParameter()).getCustomParam("costcenter")) == null || "".equals(accountorg.toString()))) {
            long accountorgid = costcenter.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject query = QueryServiceHelper.queryOne((String)BOS_COSTCENTER, (String)"accountorg", (QFilter[])new QFilter[]{costcenterFilter});
            this.getModel().setValue("org", query.get(0));
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<Long> getCostCenterByUser() {
        List accountOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        ArrayList<Long> ids = new ArrayList<Long>(accountOrgs.size());
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Object[] costCenter = BusinessDataServiceHelper.load((String)BOS_COSTCENTER, (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

