/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MessgeBoxUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.servicehelper.DiyCostDriverServiceHelper;
import kd.macc.sca.formplugin.base.BaseListPlugin;
import kd.macc.sca.opplugin.utils.CommonOp;

public class DiyCostDriverListPlugin
extends BaseListPlugin {
    private static final Log logger = LogFactory.getLog(DiyCostDriverListPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String ACCTORG = "org";
    private static final String COSTCENTER = "costcenter";
    private static final String[] STATUS = new String[]{"E", "F"};
    private static final String closeBack_importResult = "importResult";
    private volatile boolean orgClick = false;

    @Override
    protected List<ComboItem> getCostCenterComboItemListBy(String orgId) {
        QFilter enableFilter;
        QFilter filter = !StringUtils.isEmpty((String)orgId) && !"0".equals(orgId) ? new QFilter("accountorg", "=", (Object)Long.valueOf(orgId)) : new QFilter("accountorg", ">", (Object)0L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectDataList;
        boolean unique;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("effect".equals(operateKey) && !this.isEnableEffectByOrg(Long.parseLong(this.getPageCache().get(ACCTORG))) && !(unique = this.validateUnique(selectDataList = args.getListSelectedData()))) {
            args.setCancel(true);
        }
    }

    private boolean validateUnique(ListSelectedRowCollection selectDataList) {
        Object[] projectIdArray = selectDataList.stream().map(selectRow -> selectRow.getPrimaryKeyValue()).toArray();
        DynamicObject[] projectArray = BusinessDataServiceHelper.load((Object[])projectIdArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_diycostdriver"));
        ArrayList<String[]> errorList = new ArrayList<String[]>(10);
        for (DynamicObject dynamicObject : projectArray) {
            DynamicObject existDynamicObject = this.existsDiyCostDriver(dynamicObject);
            if (existDynamicObject == null) continue;
            String billNo = (String)existDynamicObject.get("billno");
            DynamicObject accountOrg = dynamicObject.getDynamicObject(ACCTORG);
            DynamicObject costAccount = dynamicObject.getDynamicObject("costaccount");
            DynamicObject costCenter = dynamicObject.getDynamicObject(COSTCENTER);
            DynamicObject manuOrg = dynamicObject.getDynamicObject("manuorg");
            StringBuilder sbTip = new StringBuilder();
            String tip = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3010%1$s\u3011+\u3010%2$s\u3011", (String)"DiyCostDriverListPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]), accountOrg.getString("name"), costAccount.getString("name"));
            if (manuOrg != null) {
                tip = String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011", (String)"DiyCostDriverListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), tip, manuOrg.getString("name"));
            }
            if (costCenter != null) {
                tip = String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011", (String)"DiyCostDriverListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), tip, costCenter.getString("name"));
            }
            sbTip.append(tip);
            List<String[]> perDataErrorList = this.buildEntryEntityDuplicateErrors(dynamicObject, sbTip, billNo);
            errorList.addAll(perDataErrorList);
        }
        if (!CadEmptyUtils.isEmpty(errorList)) {
            String operatorName = ResManager.loadKDString((String)"\u751f\u6548", (String)"DiyCostDriverListPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]);
            String title = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c", (String)"DiyCostDriverListPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]);
            MessgeBoxUtils.showDetailsMessageBox((IFormView)this.getView(), (String)operatorName, (String)title, errorList);
            return false;
        }
        return true;
    }

    private DynamicObject existsDiyCostDriver(DynamicObject dataEntity) {
        QFilter[] filters = this.getQFilter(dataEntity, true);
        if (filters == null) {
            return null;
        }
        return this.removeNotDuplicateDiyCostDriver(dataEntity, filters);
    }

    private QFilter[] getQFilter(DynamicObject dataEntity, boolean includeEntryEntity) {
        DynamicObject org = dataEntity.getDynamicObject(ACCTORG);
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        if (org == null || costAccount == null || costDriver == null) {
            return null;
        }
        DynamicObject manuOrg = dataEntity.getDynamicObject("manuorg");
        DynamicObject costCenter = dataEntity.getDynamicObject(COSTCENTER);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "!=", dataEntity.getPkValue()));
        qFilters.add(new QFilter(ACCTORG, "=", org.getPkValue()));
        qFilters.add(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
        qFilters.add(new QFilter("costaccount", "=", costAccount.getPkValue()));
        qFilters.add(new QFilter(COSTCENTER, "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()));
        qFilters.add(new QFilter("costdriver", "=", costDriver.getPkValue()));
        qFilters.add(new QFilter("effectstatus", "in", (Object)new String[]{"E"}));
        qFilters.add(new QFilter("appnum", "=", (Object)dataEntity.getString("appnum")));
        if (includeEntryEntity) {
            String allocClass;
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = entryEntity.stream().map(e -> Long.parseLong(e.get("benefcostcenter.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(benefitCostCenterIds)) break;
                    qFilters.add(new QFilter("entryentity.benefcostcenter", "in", benefitCostCenterIds));
                    break;
                }
                case "MATERIAL": {
                    List materialIds = entryEntity.stream().map(e -> Long.parseLong(e.get("matnum.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialIds)) break;
                    qFilters.add(new QFilter("entryentity.matnum", "in", materialIds));
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = entryEntity.stream().map(e -> Long.parseLong(e.get("costobject.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(costObjectIds)) break;
                    qFilters.add(new QFilter("entryentity.costobject", "in", costObjectIds));
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = entryEntity.stream().map(e -> Long.parseLong(e.get("materialgroup.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialGroupIds)) break;
                    qFilters.add(new QFilter("entryentity.materialgroup", "in", materialGroupIds));
                    break;
                }
            }
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private DynamicObject removeNotDuplicateDiyCostDriver(DynamicObject dataEntity, QFilter[] filters) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryEntity.iterator();
        DynamicObjectCollection existsDiyCostDrivers = QueryServiceHelper.query((String)"sca_diycostdriver", (String)"billno,entryentity.id,entryentity.benefcostcenter,entryentity.costobject,entryentity.matnum,entryentity.matauxpty,entryentity.materialgroup", (QFilter[])filters);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existsDiyCostDrivers)) {
            String allocClass;
            DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.benefcostcenter").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (benefitCostCenterIds.contains(next.getLong("benefcostcenter.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "MATERIAL": {
                    List materialIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.matnum").toString())).collect(Collectors.toList());
                    List matAuxPtyIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.matauxpty").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (materialIds.contains(next.get("matnum.id")) && matAuxPtyIds.contains(next.getLong("matauxpty.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.costobject").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (costObjectIds.contains(next.get("costobject.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = existsDiyCostDrivers.stream().map(e -> Long.parseLong(e.get("entryentity.materialgroup").toString())).collect(Collectors.toList());
                    while (iterator.hasNext()) {
                        DynamicObject next = (DynamicObject)iterator.next();
                        if (materialGroupIds.contains(next.get("materialgroup.id"))) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
            return (DynamicObject)existsDiyCostDrivers.get(0);
        }
        return null;
    }

    private List<String[]> buildEntryEntityDuplicateErrors(DynamicObject dataEntity, StringBuilder prefixTip, String billNo) {
        ArrayList errorList = Lists.newArrayList();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject materialGroupStd = dataEntity.getDynamicObject("materialgroupstd");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        String allocClass = costDriver.getString("allocclass");
        Iterator iterator = entryEntity.iterator();
        switch (allocClass) {
            case "COSTCENTER": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("benefcostcenter.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "MATERIAL": {
                while (iterator.hasNext()) {
                    DynamicObject auxPty;
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    Boolean isUseAuxpty = next.getBoolean("matnum.isuseauxpty");
                    HashSet<Long> allAuxptyId = new HashSet<Long>(10);
                    if (isUseAuxpty.booleanValue()) {
                        DynamicObjectCollection isaffectprice = next.getDynamicObjectCollection("matnum.auxptyentry");
                        for (DynamicObject isPrice : isaffectprice) {
                            allAuxptyId.add(isPrice.getLong("auxpty.id"));
                        }
                    }
                    if ((auxPty = next.getDynamicObject("matauxpty")) != null && !CadEmptyUtils.isEmpty(allAuxptyId)) {
                        String auxPtyInfo = CommonOp.getAuptyInfo(allAuxptyId, (String)auxPty.get(1));
                        errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011+\u3010%4$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%5$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("matnum.name"), auxPtyInfo, billNo));
                    } else {
                        errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("matnum.name"), billNo));
                    }
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "COSTOBJECT": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%4$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), next.getString("costobject.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
            case "MATERIALGROUP": {
                while (iterator.hasNext()) {
                    StringBuilder errorTip = new StringBuilder();
                    DynamicObject next = (DynamicObject)iterator.next();
                    errorTip.append(String.format(ResManager.loadKDString((String)"%1$s+\u3010%2$s\u3011+\u3010%3$s\u3011+\u3010%4$s\u3011\u7684\u751f\u6548\u5355\u636e\u3010%5$s\u3011\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u751f\u6548", (String)"DiyCostDriverListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]), prefixTip, costDriver.getString("name"), materialGroupStd.getString("name"), next.getString("materialgroup.name"), billNo));
                    String[] errorArr = new String[]{ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u751f\u6548", (String)"DiyCostDriverListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), "Error", errorTip.toString()};
                    errorList.add(errorArr);
                }
                break;
            }
        }
        return errorList;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        List filters = e.getQFilters();
        filters.add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        e.setOrderBy("effectperiod desc,billno ASC,costcenter.number ASC");
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClickEvent(args);
        this.filterContainerInit(args, null);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costcenter.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"manuorg.id");
        }
        if ((customfilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            String val;
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                String orgId = String.valueOf(vals.get(0));
                this.putOrgCache(orgId);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                val = String.valueOf(vals.get(0));
                this.checkAccountIsChange(e, val);
                this.getPageCache().put("costaccount", val);
                this.getPageCache().put("beforeCostAccount", val);
                this.filterContainerInit(this.filterContainerInitArgs, "period");
                this.filterContainerInit(this.filterContainerInitArgs, "manuorg");
            }
            if ("costcenter.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("mulcostcenter", SerializationUtils.toJsonString((Object)vals));
                this.getPageCache().put(COSTCENTER, String.valueOf(vals.get(0)));
            }
            if ("manuorg.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("manuorg", String.valueOf(vals.get(0)));
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!"period.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            val = String.valueOf(vals.get(0));
            this.getPageCache().put("period", val);
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        boolean enableEffectByOrg = false;
        if (!CadEmptyUtils.isEmpty((String)orgId)) {
            enableEffectByOrg = SysParamHelper.getEnableEffectByOrg((Long)Long.parseLong(orgId), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"sca_diycostdriver");
        }
        if (!enableEffectByOrg) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"effectperiod.name", "expperiod.name"}));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costAccount = this.getPageCache().get("costaccount");
        String costCenter = this.getPageCache().get(COSTCENTER);
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costaccount", (Object)costAccount);
        bsp.setCustomParam(COSTCENTER, (Object)costCenter);
        if (StringUtils.isNotEmpty((String)acctOrg) && OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(acctOrg))) {
            String manuOrg = this.getPageCache().get("manuorg");
            bsp.setCustomParam("manuorg", (Object)manuOrg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
            }
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String oldOrgId;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || !StringUtils.isNotEmpty((String)(oldOrgId = this.getPageCache().get(this.ORG_FIELD)))) continue;
            if (!defaultValue.equals(oldOrgId)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        Long orgId;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String org = this.getPageCache().get(this.ORG_FIELD);
        Long l = orgId = CadEmptyUtils.isEmpty((String)org) ? Long.valueOf(0L) : Long.valueOf(org);
        if (fieldName.startsWith("costaccount")) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(Collections.singletonList(orgId), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        } else if (fieldName.startsWith("manuorg")) {
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        } else if (fieldName.startsWith(COSTCENTER)) {
            String accountorgId = this.getPageCache().get(this.ORG_FIELD);
            if (!CadEmptyUtils.isEmpty((String)accountorgId)) {
                args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountorgId)).and(new QFilter("enable", "=", (Object)"1")));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    private void filterContainerInit(FilterContainerInitArgs args, String initName) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (StringUtils.isNotEmpty((String)initName) && !fieldName.contains(initName)) continue;
            if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD))) {
                if (CadEmptyUtils.isEmpty((String)orgId)) {
                    orgId = this.getCustomParam(ACCTORG);
                }
                this.resetOrg(commonFilterColumn, orgId);
            }
            if (fieldName.startsWith("costaccount.")) {
                this.resetCostAccount(commonFilterColumn, orgId);
            }
            if (fieldName.startsWith("costcenter.")) {
                List listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                String manuOrgId = this.getPageCache().get("manuorg");
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(orgId, manuOrgId);
                if (!CollectionUtils.isEmpty(comboItems)) {
                    commonFilterColumn.setComboItems(comboItems);
                }
            }
            if (fieldName.startsWith("period.")) {
                String costAccoutId = this.getPageCache().get("costaccount");
                this.resetPeriod(commonFilterColumn, costAccoutId);
            }
            if (!fieldName.startsWith("manuorg.")) continue;
            this.resetManuorg(commonFilterColumn, orgId);
        }
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, String orgId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> acctOrgs = this.getORGComboItemList();
        if (CadEmptyUtils.isEmpty(acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = acctOrgs.get(0);
        String defOrgId = StringUtils.isEmpty((String)orgId) ? item.getValue() : orgId;
        commonFilterColumn.setDefaultValue(defOrgId);
        this.putOrgCache(defOrgId);
    }

    public void resetManuorg(CommonFilterColumn commonFilterColumn, String orgId) {
        List comboItems;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (StringUtils.isNotEmpty((String)orgId) && !CollectionUtils.isEmpty((Collection)(comboItems = kd.macc.sca.common.helper.ImportServiceHelper.getPermProOrgsByAccOrg((Long)Long.parseLong(orgId))))) {
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = (ComboItem)comboItems.get(0);
            String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
        }
    }

    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, String orgId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (StringUtils.isNotEmpty((String)orgId)) {
            List<ComboItem> comboItems = this.getEnabledCostAccountComboItemListBy(Collections.singletonList(orgId));
            if (CollectionUtils.isEmpty(comboItems)) {
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = this.getCustomParam("costaccount");
            if (CadEmptyUtils.isEmpty((String)defVal)) {
                defVal = item.getValue();
            }
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("costaccount", defVal);
        }
    }

    private void checkAccountIsChange(FilterContainerSearchClickArgs e, String val) {
        String beforeAccount = this.getPageCache().get("beforeCostAccount");
        if (beforeAccount == null) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        } else if (!val.equals(beforeAccount)) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
    }

    private void putOrgCache(String orgId) {
        this.getPageCache().put(this.ORG_FIELD, orgId);
        this.getPageCache().remove("costaccount");
        this.getPageCache().remove(COSTCENTER);
        this.getPageCache().remove("mulcostcenter");
    }

    protected void resetPeriod(CommonFilterColumn commonFilterColumn, String costAccoutId) {
        List<ComboItem> comboItems;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long costAccout = 0L;
        if (StringUtils.isNotEmpty((String)costAccoutId)) {
            costAccout = Long.parseLong(costAccoutId);
        }
        if (CollectionUtils.isEmpty(comboItems = this.getPeriodComboItemsByLast(costAccout))) {
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        commonFilterColumn.setDefaultValue(comboItems.get(0).getValue());
        this.getPageCache().put("period", comboItems.get(0).getValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateAccuracy();
    }

    private void updateAccuracy() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        DynamicObject[] cols = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_diycostdriver"));
        HashMap<Object, String> costObjectMap = new HashMap<Object, String>();
        if (cols == null) {
            return;
        }
        for (DynamicObject item : cols) {
            DynamicObjectCollection entryentity;
            BigDecimal qty = item.getBigDecimal("qty");
            if (!CadEmptyUtils.isEmpty((BigDecimal)qty)) {
                String qtyStr = qty.stripTrailingZeros().toPlainString();
                costObjectMap.put(item.getPkValue(), qtyStr);
            }
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryentity = item.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject entry : entryentity) {
                BigDecimal entryQty = entry.getBigDecimal("entryqty");
                if (CadEmptyUtils.isEmpty((BigDecimal)entryQty)) continue;
                String entryQtyStr = entryQty.stripTrailingZeros().toPlainString();
                costObjectMap.put(entry.get("id"), entryQtyStr);
            }
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            Long id;
            Object primaryKeyValue = row.getPrimaryKeyValue();
            String qtyStr = (String)costObjectMap.get(primaryKeyValue);
            if (!CadEmptyUtils.isEmpty((String)qtyStr)) {
                billList.setCellFieldValue("qty", i, (Object)qtyStr);
            }
            if (CadEmptyUtils.isEmpty((Long)(id = (Long)row.getEntryPrimaryKeyValue()))) {
                ++i;
                continue;
            }
            String entryQtys = (String)costObjectMap.get(id);
            if (CadEmptyUtils.isEmpty((String)entryQtys)) {
                ++i;
                continue;
            }
            billList.setCellFieldValue("entryqty", i, (Object)entryQtys);
            ++i;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult != null && opResult.isSuccess() && (afterDoOperationEventArgs.getOperateKey().equals("effect") || afterDoOperationEventArgs.getOperateKey().equals("uneffect"))) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "tblnew": {
                List<ComboItem> orgComboItemList = this.getORGComboItemList();
                if (!CadEmptyUtils.isEmpty(orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "tbleffect": {
                DynamicObject currentPeriod;
                BillList selectList = (BillList)this.getView().getControl("billlistap");
                if (selectList == null) {
                    return;
                }
                Object[] primaryKeys = selectList.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeys == null || primaryKeys.length <= 0) break;
                String org = this.getPageCache().get(ACCTORG);
                String costAccount = this.getPageCache().get("costaccount");
                if (!this.isEnableEffectByOrg(Long.parseLong(org)) || (currentPeriod = PeriodHelper.getCurrentPeriod((Long)Long.parseLong(costAccount))) == null) break;
                this.getView().getPageCache().put("tbleffect", SerializationUtils.toJsonString((Object)primaryKeys));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u6548\u671f\u95f4\u4e3a\u201c%s\u201d\uff0c\u82e5\u5f53\u671f\u4fee\u6539\u751f\u6548\u540e\u5c06\u8986\u76d6\u539f\u5355\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u751f\u6548\u3002", (String)"DiyCostDriverListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), currentPeriod.getString("name")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("tbleffect", (IFormPlugin)this));
                evt.setCancel(true);
                break;
            }
            case "forcedelete": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                if (list == null) {
                    return;
                }
                Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DiyCostDriverListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                this.getView().getPageCache().put("forcedelete", SerializationUtils.toJsonString((Object)primaryKeyValues));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u6b21\u5220\u9664\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6709\u6548\u671f\u95f4\u4e0d\u8fde\u7eed\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DiyCostDriverListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("forcedelete", (IFormPlugin)this));
                break;
            }
            case "delete": {
                String acctOrg = this.getPageCache().get(this.ORG_FIELD);
                if (StringUtils.isEmpty((String)acctOrg) || !SysParamHelper.getEnableEffectByOrg((Long)Long.parseLong(acctOrg), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"sca_diycostdriver").booleanValue()) break;
                BillList billList = (BillList)this.getView().getControl("billlistap");
                if (billList == null) {
                    return;
                }
                Object[] primaryKeyValue = billList.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValue == null || primaryKeyValue.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DiyCostDriverListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValue);
                qFilter.and("effectstatus", "in", Arrays.asList(STATUS));
                boolean isExists = QueryServiceHelper.exists((String)"sca_diycostdriver", (QFilter[])qFilter.toArray());
                if (!isExists) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u751f\u6548/\u5931\u6548\u72b6\u6001\u7684\u5355\u636e\u3002", (String)"DiyCostDriverListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "sysimport": {
                List<ComboItem> orgComboItemList2 = this.getORGComboItemList();
                if (CadEmptyUtils.isEmpty(orgComboItemList2)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiyCostDriverListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.inSysImport();
                break;
            }
        }
    }

    private void inSysImport() {
        try {
            Map objRules;
            String acctOrg = this.getPageCache().get(this.ORG_FIELD);
            if (CadEmptyUtils.isEmpty((String)acctOrg)) {
                return;
            }
            long accountOrgId = Long.parseLong(acctOrg);
            String costAccount = this.getPageCache().get("costaccount");
            long costAccountId = costAccount == null || CadEmptyUtils.isEmpty((String)costAccount) ? 0L : Long.parseLong(costAccount);
            String costCenter = this.getPageCache().get("mulcostcenter");
            ArrayList<Long> costCenters = new ArrayList<Long>(10);
            if (!CadEmptyUtils.isEmpty((String)costCenter)) {
                List costCenterMultiSelect = (List)SerializationUtils.fromJsonString((String)costCenter, List.class);
                if (!CadEmptyUtils.isEmpty((List)costCenterMultiSelect) && costCenterMultiSelect.size() > 1) {
                    costCenterMultiSelect.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
                } else if (costCenterMultiSelect.size() == 1 && !CadEmptyUtils.isEmpty((String)String.valueOf(costCenterMultiSelect.get(0)))) {
                    costCenters.add(Long.parseLong(String.valueOf(costCenterMultiSelect.get(0))));
                }
            }
            if (CadEmptyUtils.isEmpty(costCenters)) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("accountorg", "=", (Object)accountOrgId));
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)true));
                List costCentersByOrg = QueryServiceHelper.queryPrimaryKeys((String)"bos_costcenter", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
                costCentersByOrg.forEach(s -> costCenters.add(Long.parseLong(String.valueOf(s))));
            }
            if (CadEmptyUtils.isEmpty((Map)(objRules = CostObjectHelper.getCostObjectRulesMap((Long)accountOrgId, costCenters)))) {
                this.getView().showTipNotification(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"DiyCostDriverListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CostObjectListPlugin_6"));
                return;
            }
            Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)accountOrgId, costCenters, (Map)objRules);
            List collConfigs = CommonCollConfigService.getCollConfigs((Long)Long.parseLong(acctOrg), (Long)costAccountId, (Set)calDimensionIds, (String)"sca_diycostdriver", (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u503c\u5f52\u96c6\u65b9\u6848\u3002", (String)"DiyCostDriverListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)accountOrgId);
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountOrgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
            }
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"DiyCostDriverListPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = DiyCostDriverServiceHelper.importDiyCostDriver((Long)accountOrgId, (Long)costAccountId, (List)costCenters, (List)manuOrgs, (String)appNum, (String)progressId, (String)"sca_diycostdriver");
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"DiyCostDriverListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    private boolean isEnableEffectByOrg(Long orgId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"sca_diycostdriver");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tblupdate".equals(itemKey)) {
            logger.info("\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            HashSet<Long> orgIds = new HashSet<Long>(16);
            QFilter qFilter = new QFilter("costaccount", "=", (Object)0L);
            qFilter.and("appnum", "=", (Object)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            DataSet orgDs = QueryServiceHelper.queryDataSet((String)"DiyCostDriverListPlugin.queryOrg", (String)"sca_diycostdriver", (String)ACCTORG, (QFilter[])qFilter.toArray(), null);
            for (Row row : orgDs) {
                orgIds.add(row.getLong(ACCTORG));
            }
            logger.info("\u9700\u8981\u5347\u7ea7\u5904\u7406\u7684\u6838\u7b97\u7ec4\u7ec7\u4e2a\u6570\u4e3a\uff1a{}", (Object)orgIds.size());
            int i = 0;
            String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
            Iterator iterator = orgIds.iterator();
            while (iterator.hasNext()) {
                long org = (Long)iterator.next();
                ++i;
                QFilter orgFilter = new QFilter(ACCTORG, "=", (Object)org);
                DynamicObject[] updateDatas = BusinessDataServiceHelper.load((String)"sca_diycostdriver", (String)"id,org,costaccount,effectdate,expdate,effectstatus,effectperiod,expperiod", (QFilter[])orgFilter.toArray());
                if (updateDatas == null || updateDatas.length == 0) continue;
                logger.info(String.format("\u5f53\u524d\u5904\u7406\u7b2c%s\u4e2a\u6838\u7b97\u7ec4\u7ec7:%s,\u5904\u7406\u5355\u636e\u6570\u91cf:%s", i, org, updateDatas.length));
                long costAccountId = OrgHelper.getCostAccountByOrg((Long)org, (String)appId);
                for (DynamicObject updateData : updateDatas) {
                    updateData.set("costaccount", (Object)costAccountId);
                    if (!StringUtils.isEmpty((String)updateData.getString("effectstatus"))) continue;
                    Date expDate = updateData.getDate("expdate");
                    Date effectDate = updateData.getDate("effectdate");
                    if (expDate == null || effectDate == null) continue;
                    if (DateUtils.getDeFaultExpDate().equals(expDate)) {
                        DynamicObject effectPeriod;
                        updateData.set("effectstatus", (Object)"E");
                        if (DateUtils.getDefaultEffectDate().equals(effectDate)) {
                            effectPeriod = PeriodHelper.getStartPeriod((Long)costAccountId);
                        } else {
                            effectPeriod = PeriodHelper.getPeriodByDate((Date)effectDate, (Long)costAccountId);
                            if (effectPeriod == null) {
                                effectPeriod = PeriodHelper.getStartPeriod((Long)costAccountId);
                            }
                        }
                        updateData.set("effectperiod", (Object)(effectPeriod == null ? 0L : effectPeriod.getLong("id")));
                        continue;
                    }
                    updateData.set("effectstatus", (Object)"F");
                }
                SaveServiceHelper.update((DynamicObject[])updateDatas);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"DiyCostDriverListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
        } else if ("searchconfig".equals(itemKey)) {
            this.searchConfig();
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)"sca_diycostdriver", (IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("forcedelete".equals(e.getCallBackId()) && MessageBoxResult.Yes == e.getResult()) {
            String forcedelete = this.getView().getPageCache().get("forcedelete");
            List deleteIds = (List)SerializationUtils.fromJsonString((String)forcedelete, List.class);
            if (CadEmptyUtils.isEmpty((List)deleteIds)) {
                logger.error("sca_matallocstd\u5f3a\u5236\u5220\u9664\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u9009\u4e2did");
                return;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)deleteIds)};
            DataSet rows = QueryServiceHelper.queryDataSet((String)"forcedeleteQuery", (String)"sca_diycostdriver", (String)"billno", (QFilter[])qFilters, null);
            String opType = ResManager.loadKDString((String)"\u5f3a\u5236\u5220\u9664\u64cd\u4f5c", (String)"DiyCostDriverListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]);
            StringBuilder stringBuilder = new StringBuilder();
            while (rows.hasNext()) {
                stringBuilder.append(rows.next().getString("billno")).append("\uff0c");
            }
            String checkType = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5f3a\u5236\u5220\u9664\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u81ea\u5b9a\u4e49\u6210\u672c\u52a8\u56e0\u6570\u636e\u3002", (String)"DiyCostDriverListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), stringBuilder.toString());
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"sca_diycostdriver", (String)this.getView().getFormShowParameter().getAppId());
            DeleteServiceHelper.delete((String)"sca_diycostdriver", (QFilter[])qFilters);
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list != null) {
                list.refresh();
            }
        }
        if ("tbleffect".equals(e.getCallBackId()) && MessageBoxResult.Yes == e.getResult()) {
            this.getView().invokeOperation("effect");
        }
    }
}

