/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.sca.common.enums.SysParamEnum;

public class ResourceUseBillEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costcent = (BasedataEdit)this.getControl("costcenter");
        costcent.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List<Object> ids = new ArrayList();
            String newType = "resourceusetype";
            qList.add(new QFilter("orgduty", "=", (Object)4));
            if (accountorg == null) {
                ids = this.getCostCenterByUser();
                QFilter costcenterFilter = new QFilter("id", "in", ids);
                qList.add(costcenterFilter);
            } else {
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            QFilter orgfilter = new QFilter("id", "=", (Object)0L);
            if (accountorg == null) {
                formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
                return;
            }
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId());
            orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)costcenter)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6210\u672c\u4e2d\u5fc3\u540e\u518d\u9009\u62e9\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"ResourceUseBillEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> costObjectId = new HashSet<Long>();
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                    for (DynamicObject dynamicObject : entryEntity) {
                        DynamicObject costObject = dynamicObject.getDynamicObject("costobject");
                        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) continue;
                        costObjectId.add(costObject.getLong("id"));
                    }
                }
                qList.add(new QFilter("id", "not in", costObjectId));
                if (!CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                    qList.add(new QFilter("costcenter.id", "in", this.getCostCenterByOrg(accountorg.getLong("id"))));
                }
                qList.add(new QFilter("producttype", "=", (Object)"C"));
                qList.add(new QFilter("costcenter.id", "=", (Object)costcenter.getLong("id")));
                qList.add(new QFilter("billstatus", "=", (Object)"C"));
                qList.add(new QFilter("bizstatus", "=", (Object)Character.valueOf('A')));
                long costAccountId = CostAccountHelper.getCostAccountByAccoutOrg((Long)accountorg.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
                DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                if (currentPeriod != null) {
                    Date endDate = currentPeriod.getDate("enddate");
                    qList.add(new QFilter("bookdate", "<=", (Object)DateUtils.getDayEndTime((Date)endDate)));
                }
            }
        });
        BasedataEdit workCenter = (BasedataEdit)this.getControl("workcenter");
        workCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            long manuOrgId = this.getModel().getDataEntity().getLong("manuorg.id");
            long costCenterId = this.getModel().getDataEntity().getLong("costcenter.id");
            qFilters.addAll(this.getWorkCenterFilter(orgId, manuOrgId, costCenterId));
        });
        BasedataEdit routeEdit = (BasedataEdit)this.getControl("route");
        routeEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ResourceUseBillEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Object manuOrg = this.getModel().getValue("manuorg");
            if (manuOrg == null) {
                List manuOrgIds = OrgHelper.getProOrgIdsByCalcOrg((Long)org.getLong("id"));
                QFilter orgCtrlQfilter = MatBaseDataFilterHelper.getOrgCtrlQfilter((List)manuOrgIds, (String)"pdm_route");
                qFilters.add(orgCtrlQfilter);
            } else {
                long manuOrgId = ((DynamicObject)manuOrg).getLong("id");
                QFilter orgCtrlQfilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(Collections.singletonList(manuOrgId), (String)"pdm_route");
                qFilters.add(orgCtrlQfilter);
            }
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
            qFilters.add(new QFilter("processtype", "in", (Object)new String[]{"A", "B"}));
            qFilters.add(new QFilter("processentry.machiningtype", "in", (Object)new String[]{"1002", "1003"}));
        });
    }

    private List<QFilter> getWorkCenterFilter(long orgId, long manuOrgId, long costCenterId) {
        List<Long> ids;
        ArrayList<QFilter> workCenterFilters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty((Long)costCenterId) && !(ids = this.getWorkCenter(costCenterId)).isEmpty()) {
            workCenterFilters.add(new QFilter("id", "in", ids));
        }
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workcentre", (Long)orgId);
            workCenterFilters.add(baseDataFilter);
        }
        if (!CadEmptyUtils.isEmpty((Long)manuOrgId)) {
            workCenterFilters.add(new QFilter("createorg", "=", (Object)manuOrgId));
        }
        return workCenterFilters;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String costCenter = (String)formShowParameter.getCustomParam("costcenter");
        String manuOrg = (String)formShowParameter.getCustomParam("manuorg");
        if (!StringUtils.isEmpty((Object)manuOrg) && !"0".equals(manuOrg)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"manuorg"});
            this.getModel().setValue("manuorg", (Object)manuOrg);
        }
        if ("0".equals(manuOrg)) {
            this.getModel().setValue("manuorg", null);
        }
        if (!StringUtils.isEmpty((Object)costCenter)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"costcenter"});
            this.getModel().setValue("costcenter", (Object)costCenter);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            int i = 0;
            ArrayList<Long> listId = new ArrayList<Long>();
            for (DynamicObject dynamicObject : entryEntity) {
                Object costobject = dynamicObject.getDynamicObject("costobject");
                if (!CadEmptyUtils.isEmpty((DynamicObject)costobject)) {
                    listId.add(costobject.getLong("id"));
                    Object[] costobject1 = BusinessDataServiceHelper.load((Object[])listId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costobject"));
                    listId.clear();
                    if (!CadEmptyUtils.isEmpty((Object[])costobject1)) {
                        costobject = costobject1[0];
                        this.getModel().setValue("sotype", (Object)costobject.getString("sotype"), i);
                        this.getModel().setValue("srcbillnumber", (Object)costobject.getString("srcbillnumber"), i);
                        this.getModel().setValue("srcbillrow", (Object)costobject.getBigDecimal("srcbillrow"), i);
                    }
                }
                ++i;
            }
        }
        this.initOrgAndCostcenter(os);
        String source = this.getModel().getDataEntity().getString("source");
        if (SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue().equals(source)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", "fieldsetpanelap", "advconap"});
        }
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equals(appNum)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"factuse", "factbatch"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pricedate"});
        }
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new"});
        }
        this.changManuorgStatus();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "costcenter": {
                this.updateAccountorg();
                this.clearEntity();
                this.updateWorkCenter();
                break;
            }
            case "costobject": {
                this.upMaterial(rowIndex);
                if (changeData.getOldValue() != null) break;
                this.setResourceUnitValue(rowIndex);
                break;
            }
            case "facthour": {
                this.setResourceUnitValue(-1);
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "workcenter": {
                this.updateCostCenter();
                break;
            }
            case "manuorg": {
                this.getModel().setValue("route", null);
                this.cleaRouteInfo();
                break;
            }
            case "route": {
                this.cleaRouteInfo();
            }
        }
    }

    private void cleaRouteInfo() {
        this.getModel().setValue("processseq", (Object)"");
        this.getModel().setValue("operationno", (Object)"");
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            List workCenterIds;
            List<QFilter> workCenterFilter;
            QFilter numberQFilter;
            List baseData = (List)entry.getValue();
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (CadEmptyUtils.isEmpty((List)baseData) || baseData.size() <= 1 || !"workcenter".equals(basedataItem.getFieldKey())) continue;
            Object source = e.getSource();
            Map sourceObj = ((RowMapper)source).getSourceObj();
            Map orgInfo = (Map)sourceObj.get("org");
            Map manuOrgInfo = (Map)sourceObj.get("manuorg");
            Map costCenterInfo = (Map)sourceObj.get("costcenter");
            long orgId = 0L;
            long manuOrgId = 0L;
            long costCenterId = 0L;
            if (!CadEmptyUtils.isEmpty((Map)orgInfo)) {
                if (orgInfo.get("id") != null) {
                    orgId = (Long)orgInfo.get("id");
                } else {
                    String orgNumber = String.valueOf(orgInfo.get("number"));
                    numberQFilter = new QFilter("number", "=", (Object)orgNumber);
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])numberQFilter.toArray());
                    if (org != null) {
                        orgId = org.getLong("id");
                    }
                }
            }
            if (!CadEmptyUtils.isEmpty((Map)manuOrgInfo)) {
                if (manuOrgInfo.get("id") != null) {
                    manuOrgId = (Long)manuOrgInfo.get("id");
                } else {
                    String manuOrgNumber = String.valueOf(manuOrgInfo.get("number"));
                    numberQFilter = new QFilter("number", "=", (Object)manuOrgNumber);
                    DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])numberQFilter.toArray());
                    if (manuOrg != null) {
                        manuOrgId = manuOrg.getLong("id");
                    }
                }
            }
            if (!CadEmptyUtils.isEmpty((Map)costCenterInfo)) {
                if (costCenterInfo.get("id") != null) {
                    costCenterId = (Long)costCenterInfo.get("id");
                } else {
                    DynamicObject costCenter;
                    String costCenterNumber = String.valueOf(costCenterInfo.get("number"));
                    numberQFilter = new QFilter("number", "=", (Object)costCenterNumber);
                    if (!CadEmptyUtils.isEmpty((Long)orgId)) {
                        numberQFilter.and("accountorg", "=", (Object)orgId);
                    }
                    if ((costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (String)"id", (QFilter[])numberQFilter.toArray())) != null) {
                        costCenterId = costCenter.getLong("id");
                    }
                }
            }
            if (CadEmptyUtils.isEmpty(workCenterFilter = this.getWorkCenterFilter(orgId, manuOrgId, costCenterId))) continue;
            if ("number".equals(basedataItem.getSearchKey())) {
                workCenterFilter.add(new QFilter("number", "=", (Object)basedataItem.getSearchValue()));
            }
            if (CadEmptyUtils.isEmpty((List)(workCenterIds = QueryServiceHelper.queryPrimaryKeys((String)basedataItem.getEntityNumber(), (QFilter[])workCenterFilter.toArray(new QFilter[0]), null, (int)-1)))) continue;
            baseData.retainAll(workCenterIds);
        }
    }

    private void updateCostCenter() {
        long costCenter = this.getModel().getDataEntity().getLong("costcenter.id");
        long workCenter = this.getModel().getDataEntity().getLong("workcenter.id");
        if (CadEmptyUtils.isEmpty((Long)costCenter) && !CadEmptyUtils.isEmpty((Long)workCenter)) {
            Date now = new Date();
            QFilter qFilter = new QFilter("entryentity.sourcedata", "=", (Object)workCenter);
            qFilter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            qFilter.and("effectdate", "<=", (Object)now);
            qFilter.and("expdate", ">", (Object)now);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_costcentersourcemap", (String)"costcenter", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject != null) {
                this.getModel().setValue("costcenter", (Object)dynamicObject.getLong("costcenter"));
            }
        }
    }

    private void updateWorkCenter() {
        List<Long> workCenter;
        this.getModel().beginInit();
        this.getModel().setValue("workcenter", null);
        long costCenter = this.getModel().getDataEntity().getLong("costcenter.id");
        if (!CadEmptyUtils.isEmpty((Long)costCenter) && !(workCenter = this.getWorkCenter(costCenter)).isEmpty()) {
            this.getModel().setValue("workcenter", (Object)workCenter.get(0));
        }
        this.getView().updateView("workcenter");
        this.getModel().endInit();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_new": {
                List orgComboItemList = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                if (!CadEmptyUtils.isEmpty((List)orgComboItemList)) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ResourceUseBillEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private String getInnerType(String newTypeKey) {
        String result = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object accountorg = fsp.getCustomParam("accountorg");
        Object costcenter = fsp.getCustomParam("costcenter");
        if (accountorg != null && !"".equals(accountorg.toString())) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(String.valueOf(accountorg))));
        }
        if (costcenter != null && !"".equals(costcenter.toString())) {
            filters.add(new QFilter("costcenter", "=", (Object)Long.valueOf(String.valueOf(costcenter))));
        }
        QFilter appnumFilter = null;
        if (this.getView().getFormShowParameter().getAppId() != null) {
            appnumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        }
        DynamicObject queryOne = null;
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 2) {
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if ((queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))) == null) {
                ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
                filters2.add(new QFilter("accountorg", "=", (Object)Long.valueOf(String.valueOf(accountorg))));
                filters2.add(new QFilter("costcenter", "=", (Object)0));
                if (appnumFilter != null) {
                    filters2.add(appnumFilter);
                }
                queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters2.toArray(new QFilter[0]));
            }
        }
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 1) {
            DynamicObjectCollection query;
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(query = QueryServiceHelper.query((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))))) {
                for (DynamicObject dynamicObject : query) {
                    if (!"MANUAL".equals(dynamicObject.getString(newTypeKey))) continue;
                    return "MANUAL";
                }
                queryOne = (DynamicObject)query.get(0);
            }
        }
        if (queryOne != null) {
            result = queryOne.getString(newTypeKey);
        }
        return result;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "searchup": {
                this.searchUpBill();
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((Object)appId)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165", (String)"ResourceUseBillEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map importData = e.getSourceData();
        Object bizdate = importData.get("bizdate");
        Object bookdate = importData.get("bookdate");
        if (bizdate != null && bookdate == null) {
            importData.put("bookdate", bizdate);
        }
        importData.put("appnum", appId);
    }

    private void searchUpBill() {
        Long srcBillId = (Long)this.getModel().getValue("srcbillid");
        if (CadEmptyUtils.isEmpty((Long)srcBillId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"ResourceUseBillEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        String source = ((DynamicObject)this.getModel().getValue("srcbilltype")).getString("id");
        if (CadEmptyUtils.isEmpty((String)source)) {
            QFilter[] srcBillIdQf = new QFilter[]{new QFilter("id", "=", (Object)srcBillId)};
            this.showSearchBill("sfc_processreportbill", srcBillIdQf);
            this.showSearchBill("sfc_reportresource_adjust", srcBillIdQf);
            this.showSearchBill("pom_mftorderreport", srcBillIdQf);
            this.showSearchBill("om_processreport", srcBillIdQf);
        } else {
            SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)source, Collections.singletonList(srcBillId));
        }
    }

    private void showSearchBill(String entity, QFilter[] srcBillIdQf) {
        DynamicObjectCollection srcBillIds = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])srcBillIdQf);
        if (!srcBillIds.isEmpty()) {
            SrcBillShowerUtils.showSearchUpBill((IFormView)this.getView(), (String)entity, (List)DynamicObjectHelper.getFieldList((DynamicObjectCollection)srcBillIds, (String)"id"));
        }
    }

    private void upMaterial(int changeRowIndex) {
        DynamicObject costObject;
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (changeRowIndex >= 0 && index != changeRowIndex) {
            index = changeRowIndex;
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costObject = (DynamicObject)this.getModel().getValue("costobject", index)))) {
            this.getModel().setValue("material", (Object)costObject.getLong("material.id"), index);
            this.getModel().setValue("sotype", (Object)costObject.getString("sotype"), index);
            this.getModel().setValue("srcbillnumber", (Object)costObject.getString("srcbillnumber"), index);
            this.getModel().setValue("srcbillrow", (Object)costObject.getBigDecimal("srcbillrow"), index);
            this.getModel().setValue("auxpty", (Object)costObject.getLong("auxpty.id"), index);
            this.getModel().setValue("version", (Object)costObject.getLong("bomversion.id"), index);
        } else {
            this.getModel().setValue("material", null, index);
            this.getModel().setValue("sotype", null, index);
            this.getModel().setValue("srcbillnumber", null, index);
            this.getModel().setValue("srcbillrow", null, index);
            this.getModel().setValue("auxpty", null, index);
            this.getModel().setValue("version", null, index);
        }
    }

    private void setResourceUnitValue(int changeRowIndex) {
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (changeRowIndex >= 0 && index != changeRowIndex) {
            index = changeRowIndex;
        }
        IDataModel model = this.getModel();
        if (this.getModel().getValue("workhour", index) == null) {
            model.setValue("workhour", (Object)10L, index);
        }
    }

    private void initOrgAndCostcenter(OperationStatus os) {
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Object accountorg = fsp.getCustomParam("accountorg");
            Object costcenter = fsp.getCustomParam("costcenter");
            if (accountorg != null && !"".equals(accountorg.toString())) {
                this.getModel().setValue("org", accountorg);
                this.getView().setEnable(Boolean.FALSE, new String[]{"accountorg"});
            } else {
                this.getModel().setValue("org", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"accountorg"});
            }
            if (costcenter != null && !"".equals(costcenter.toString())) {
                this.getModel().setValue("costcenter", costcenter);
                this.updateAccountorg();
            }
        }
    }

    private void updateAccountorg() {
        FormShowParameter fsp;
        Object accountorg;
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (costcenter != null && ((accountorg = (fsp = this.getView().getFormShowParameter()).getCustomParam("accountorg")) == null || "".equals(accountorg.toString()))) {
            long accountorgid = costcenter.getLong("id");
            QFilter costcenterFilter = new QFilter("id", "=", (Object)accountorgid);
            DynamicObject query = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"accountorg", (QFilter[])new QFilter[]{costcenterFilter});
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountorg"});
            this.getModel().setValue("org", query.get(0));
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountorg"});
        }
    }

    private void clearEntity() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object costcenter = fsp.getCustomParam("costcenter");
        if (costcenter == null || "".equals(costcenter.toString())) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            int[] entryRows = new int[entryRowCount];
            for (int i = 0; i < entryRowCount; ++i) {
                entryRows[i] = i;
            }
            this.getModel().deleteEntryRows("entryentity", entryRows);
            this.getModel().createNewEntryRow("entryentity");
        }
    }

    private List<Long> getCostCenterByUser() {
        List accountOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        ArrayList<Long> ids = new ArrayList<Long>(accountOrgs.size());
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private void setCostcenterBySysprop(List<QFilter> qList, DynamicObject accountorg, String newType) {
        DynamicObjectCollection costquery;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        HashSet<Long> costcentIds = new HashSet<Long>();
        if (accountorg != null) {
            filters.add(new QFilter("accountorg", "=", accountorg.getPkValue()));
        }
        if (!CadEmptyUtils.isEmpty((List)(costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)("accountorg,costcenter," + newType), (QFilter[])filters.toArray(new QFilter[0]))))) {
            Boolean hasNullCostcenter = Boolean.FALSE;
            int isManual = 0;
            long sysOrgId = 0L;
            ArrayList<String> manualList = new ArrayList<String>();
            manualList.add("");
            manualList.add("MANUAL");
            for (Object dynamicObject : costquery) {
                long long1 = dynamicObject.getLong("costcenter");
                if (long1 != 0L) continue;
                sysOrgId = dynamicObject.getLong("accountorg");
                hasNullCostcenter = Boolean.TRUE;
                String stNewType = dynamicObject.getString(newType);
                if (manualList.contains(stNewType)) {
                    isManual = 1;
                    continue;
                }
                isManual = 2;
            }
            if (hasNullCostcenter.booleanValue() && isManual == 2) {
                filters.add(new QFilter("costcenter", "!=", (Object)0));
                filters.add(new QFilter(newType, "in", manualList));
                costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
                costcentIds.clear();
                List<Long> costCenterByOrg = this.getCostCenterByOrg(sysOrgId);
                if (!CadEmptyUtils.isEmpty((List)costquery)) {
                    for (DynamicObject dynamicObject : costquery) {
                        long costcenterId = dynamicObject.getLong("costcenter");
                        if (costCenterByOrg == null) continue;
                        costCenterByOrg.remove(costcenterId);
                    }
                    QFilter costcenterIdFilter = new QFilter("id", "not in", (Object)costCenterByOrg);
                    qList.add(costcenterIdFilter);
                } else {
                    List<Long> costCenterByOrg1 = this.getCostCenterByOrg(sysOrgId);
                    QFilter costcenterIdFilter = new QFilter("id", "not in", costCenterByOrg1);
                    qList.add(costcenterIdFilter);
                }
            } else if (hasNullCostcenter.equals(Boolean.FALSE) || hasNullCostcenter.equals(Boolean.TRUE) && isManual == 1) {
                filters.add(new QFilter("costcenter", "!=", (Object)0));
                filters.add(new QFilter(newType, "not in", manualList));
                costquery = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])filters.toArray(new QFilter[0]));
                costcentIds.clear();
                if (!CadEmptyUtils.isEmpty((List)costquery)) {
                    for (Object dynamicObject : costquery) {
                        long costcenterId = dynamicObject.getLong("costcenter");
                        costcentIds.add(costcenterId);
                    }
                    QFilter costcenterIdFilter = new QFilter("id", "not in", costcentIds);
                    qList.add(costcenterIdFilter);
                }
            }
        }
    }

    private List<Long> getCostCenterByOrg(long org) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)org));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((Object[])costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    private List<Long> getWorkCenter(Long costCenter) {
        ArrayList<Long> list = new ArrayList<Long>(10);
        Date now = new Date();
        QFilter qFilter = new QFilter("costcenter", "=", (Object)costCenter);
        qFilter.and("effectdate", "<=", (Object)now);
        qFilter.and("expdate", ">", (Object)now);
        qFilter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"entryentity.sourcedata as workcenter", (QFilter[])new QFilter[]{qFilter});
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(r -> list.add(r.getLong("workcenter")));
        }
        return list;
    }
}

