/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.allocstd;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class WorkQtyCollecEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(WorkQtyCollecEditPlugin.class);
    private static final String ENTITY_CAD_COSTDRIVER = "cad_costdriver";
    private static final String baseproduction = "4";

    public void initialize() {
        super.initialize();
        this.initFilter();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void initFilter() {
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId());
            QFilter orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject accountorg = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (accountorg == null) {
                qFilters.clear();
                return;
            }
            qFilters.add(new QFilter("orgduty", "=", (Object)5));
            Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            manuOrgList.add(manuorgId);
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)accountorg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(costCenterIdFilter);
        });
        BasedataEdit benefcostcenterInput = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject accountorg = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (accountorg == null) {
                qFilters.clear();
                return;
            }
            qFilters.add(new QFilter("accountorg", "=", (Object)accountorg.getLong("id")));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            HashSet costCenterSet = new HashSet();
            entryEntity.forEach(o -> costCenterSet.add(o.getLong("benefcostcenter.id")));
            if (!CadEmptyUtils.isEmpty(costCenterSet)) {
                qFilters.add(new QFilter("id", "not in", costCenterSet));
            }
        });
        BasedataEdit costobjectInput = (BasedataEdit)this.getControl("costobject");
        costobjectInput.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject benefcostcenter = (DynamicObject)this.getModel().getValue("benefcostcenter", rowIndex);
            List<QFilter> qf = this.getInputQFilters(evt);
            qf.add(new QFilter("billstatus", "=", (Object)"C"));
            qf.add(new QFilter("bizstatus", "=", (Object)"A"));
            if (benefcostcenter == null) {
                return;
            }
            qf.add(new QFilter("costcenter", "=", (Object)benefcostcenter.getLong("id")));
        });
        BasedataEdit workActivityInput = (BasedataEdit)this.getControl("workactivity");
        workActivityInput.addBeforeF7SelectListener(evt -> {
            List<QFilter> qf = this.getInputQFilters(evt);
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                qf.add(new QFilter("createorg", "=", (Object)-1L));
                return;
            }
            QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_CAD_COSTDRIVER, (Long)org.getLong("id"));
            QFilter allocClassQf = new QFilter("allocclass", "=", (Object)"COSTCENTER");
            QFilter isrelatedworkQf = new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE);
            QFilter appQf = AppIdHelper.getAppIdFilter((IFormView)this.getView());
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)ENTITY_CAD_COSTDRIVER, (String)"id, workactivity", (QFilter[])new QFilter[]{allocClassQf, isrelatedworkQf, orgQf, appQf});
            HashSet workActivityIdsForCostCenterLv = new HashSet(16);
            costDrivers.forEach(e -> workActivityIdsForCostCenterLv.add(e.getLong("workactivity")));
            qf.add(new QFilter("id", "in", workActivityIdsForCostCenterLv));
        });
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    public void afterBindData(EventObject e) {
        logger.info("\u4f5c\u4e1a\u6570\u91cf\u5f52\u96c6afterBindData\u5f00\u59cb");
        this.setCostDriverMust();
        this.setCostObjectMust();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.intCostObjectEnable();
            this.setEntryMaterial();
        } else {
            this.initByListData();
            AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
            this.getModel().setDataChanged(false);
        }
        this.setManuorgMustInput();
        this.changManuorgStatus();
    }

    private void setManuorgMustInput() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg == null) {
            return;
        }
        BasedataEdit manuorgInput = (BasedataEdit)this.getControl("manuorg");
        manuorgInput.setMustInput(CostAccountHelper.isOrgEnableMulFactory((Long)accountorg.getLong("id"), (String)"sca"));
    }

    private void setCostDriverMust() {
        BasedataEdit costdriverInput = (BasedataEdit)this.getControl("costdriver");
        costdriverInput.setMustInput(true);
    }

    private void setCostObjectMust() {
        DynamicObject costdriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
        if (costdriver == null) {
            return;
        }
        String allocclass = costdriver.getString("allocclass");
        BasedataEdit costobjectInput = (BasedataEdit)this.getControl("costobject");
        boolean isCostObject = "COSTOBJECT".equalsIgnoreCase(allocclass);
        costobjectInput.setMustInput(isCostObject);
    }

    private void intCostObjectEnable() {
        if ("A".equals(this.getModel().getValue("billstatus"))) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entryentity) {
                DynamicObject benefcostcenter = entry.getDynamicObject("benefcostcenter");
                if (benefcostcenter == null) continue;
                String costcenterType = benefcostcenter.getDynamicObject("orgduty").getString("number");
                boolean isBaseProduction = baseproduction.equals(costcenterType);
                this.getView().setEnable(Boolean.valueOf(isBaseProduction), entry.getInt("seq"), new String[]{"costobject"});
            }
        }
    }

    private void initByListData() {
        String manuorgId;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costcenterId = (String)fsp.getCustomParam("costcenterId");
        if (costcenterId != null && !"".equals(costcenterId)) {
            this.getModel().setValue("costcenter", (Object)costcenterId);
        }
        if (!StringUtils.isBlank((String)(manuorgId = (String)fsp.getCustomParam("manuorgId")))) {
            this.getModel().setValue("manuorg", (Object)manuorgId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("deleteentry".equals(evt.getOperationKey())) {
            this.countQty();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("manuorg", null);
                this.setManuorgMustInput();
                this.changManuorgStatus();
                break;
            }
            case "workactivity": {
                DynamicObject workactivity = (DynamicObject)changeSet[0].getNewValue();
                this.setCostDriver(workactivity);
                this.setBaseUnit(workactivity);
                break;
            }
            case "costdriver": {
                this.setCostObjectMust();
                break;
            }
            case "entryqty": {
                this.countQty();
                break;
            }
            case "benefcostcenter": {
                DynamicObject benefcostcenter = (DynamicObject)changeSet[0].getNewValue();
                this.setCostObjectEnable(benefcostcenter, rowIndex);
                break;
            }
            case "manuorg": {
                ChangeData[] changeData = e.getChangeSet();
                if (changeData == null || changeData[0].getNewValue() == changeData[0].getOldValue()) break;
                this.getModel().setValue("costcenter", null);
                break;
            }
            case "costobject": {
                this.setMaterial(rowIndex);
                this.setCurrRowBenefCostCenter(rowIndex);
            }
        }
    }

    private void setCurrRowBenefCostCenter(int rowIndex) {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject", rowIndex);
        if (!CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
            this.getModel().setValue("benefcostcenter", costObject.get("costcenter.id"), rowIndex);
        }
    }

    private void setEntryMaterial() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount <= 0) {
            return;
        }
        for (int i = 0; i < entryRowCount; ++i) {
            this.setMaterial(i);
        }
    }

    private void setMaterial(int rowIndex) {
        DynamicObject costobject = (DynamicObject)this.getModel().getValue("costobject", rowIndex);
        if (costobject == null) {
            this.getModel().setValue("material", null, rowIndex);
            this.getModel().setValue("auxpty", null, rowIndex);
        } else {
            this.getModel().setValue("material", (Object)costobject.getLong("material.id"), rowIndex);
            this.getModel().setValue("auxpty", (Object)costobject.getLong("auxpty.id"), rowIndex);
        }
    }

    private void setCostObjectEnable(DynamicObject benefcostcenter, int rowIndex) {
        if (benefcostcenter == null) {
            return;
        }
        String costcenterType = benefcostcenter.getDynamicObject("orgduty").getString("number");
        boolean isBaseProduction = baseproduction.equals(costcenterType);
        this.getView().setEnable(Boolean.valueOf(isBaseProduction), rowIndex, new String[]{"costobject"});
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject", rowIndex);
        if (!CadEmptyUtils.isEmpty((DynamicObject)costObject) && benefcostcenter.getLong("id") == costObject.getLong("costcenter.id")) {
            return;
        }
        this.getModel().setValue("costobject", null, rowIndex);
    }

    private void countQty() {
        EntryGrid entrygrid = (EntryGrid)this.getControl("entryentity");
        BigDecimal qty = entrygrid.getSum("entryqty");
        this.getModel().setValue("qty", (Object)qty);
    }

    private void setBaseUnit(DynamicObject workactivity) {
        if (workactivity == null) {
            this.getModel().setValue("baseunit", null);
            return;
        }
        Object baseunitId = workactivity.get("unit.id");
        this.getModel().setValue("baseunit", baseunitId);
    }

    private void setCostDriver(DynamicObject workactivity) {
        if (workactivity == null) {
            this.getModel().setValue("costdriver", null);
            return;
        }
        QFilter workactivityQF = new QFilter("workactivity", "=", (Object)workactivity.getLong("id"));
        QFilter[] qf = new QFilter[]{workactivityQF, AppIdHelper.getAppIdFilter((IFormView)this.getView())};
        DynamicObject costdriver = QueryServiceHelper.queryOne((String)ENTITY_CAD_COSTDRIVER, (String)"id", (QFilter[])(qf = this.addCommonQF(qf)));
        if (costdriver == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4f5c\u4e1a\u6d3b\u52a8\u5bf9\u5e94\u7684\u6210\u672c\u52a8\u56e0\u3002", (String)"WorkQtyCollecEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            this.getModel().setValue("workactivity", null);
            this.getModel().setValue("costdriver", null);
            return;
        }
        this.getModel().setValue("costdriver", (Object)costdriver.getLong("id"));
    }

    private QFilter[] addCommonQF(QFilter[] qf) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        for (QFilter q : qf) {
            qfList.add(q);
        }
        qfList.add(new QFilter("status", "=", (Object)"C"));
        qfList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        return qfList.toArray(new QFilter[0]);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        if (sourceData.get("appnum") == null || StringUtils.isEmpty((String)((String)sourceData.get("appnum")))) {
            sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

