/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ExecuteTypeEnum;
import kd.macc.sca.common.helper.ScaAutoExecShemeHelper;

public class AutoExecSchemeListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isRealTime = (String)formShowParameter.getCustomParam("isRealTime");
        if (!CadEmptyUtils.isEmpty((String)isRealTime) && "true".equals(isRealTime)) {
            e.getQFilters().add(new QFilter("entryentity.businesstype", "=", (Object)"aca_realtimecalclog"));
            this.getPageCache().put("isRealTime", "true");
        }
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = null;
        String version = LicenseServiceHelper.getProductVersion();
        if ("1.0".equals(version) || "2.0".equals(version)) {
            return;
        }
        switch (version) {
            case "3.0": {
                checkResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.getOrCreate().getCurrUserId(), (Long)104L);
                break;
            }
            case "4.0": 
            case "5.0": {
                checkResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.getOrCreate().getCurrUserId(), (Long)401L);
                break;
            }
            default: {
                checkResult = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.getOrCreate().getCurrUserId(), (Long)401L);
            }
        }
        e.setCancel(checkResult.getHasLicense() == false);
        e.setCancelFormShowParameter(this.buildCancelFormShowParameter(checkResult));
    }

    private String buildCancelFormShowParameter(LicenseCheckResult checkResult) {
        FormShowParameter licCheckLogShowParam = new FormShowParameter();
        licCheckLogShowParam.setFormId("lic_licchecknotice");
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)checkResult.getMsg());
        return licCheckLogShowParam.toString();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemKey = evt.getOperateKey();
        if ("manualexecute".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows().getBillListSelectedRowCollection();
            if (selectedRows.isEmpty()) {
                return;
            }
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u8fdb\u884c\u624b\u5de5\u6267\u884c\u64cd\u4f5c\u3002", (String)"AutoExecSchemeListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Object schemeId = selectedRows.get(0).getPrimaryKeyValue();
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", schemeId), new QFilter("enable", "=", (Object)Boolean.FALSE)};
            if (QueryServiceHelper.exists((String)"sca_autoexecsheme", (QFilter[])filters)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002\u7981\u7528\u7684\u65b9\u6848\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"AutoExecSchemeListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Long userId = RequestContext.getOrCreate().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            ThreadPools.executeOnce((String)"AutoExecSchemeListPlugin.execute", () -> ScaAutoExecShemeHelper.executeSchemeById(ExecuteTypeEnum.EXEC_MANUAL, schemeId, userId, appId));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u7ed3\u679c\u3002", (String)"AutoExecSchemeListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String isRealTime = this.getPageCache().get("isRealTime");
        if (!CadEmptyUtils.isEmpty((String)isRealTime) && "true".equals(isRealTime)) {
            bsp.setCustomParam("isRealTime", (Object)"true");
        }
    }
}

