/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class PlanCostCalcLogListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(PlanCostCalcLogListPlugin.class);

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("accountcosttype")) {
            args.getQfilters().add(new QFilter("type", "=", (Object)"0"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("logrelaunch".equals(operateKey) && e.getOperationResult().isSuccess()) {
            Set<Long> ids = this.getSelectIds();
            QFilter filter = new QFilter("id", "in", ids);
            filter.and("status", "=", (Object)"02");
            boolean exists = QueryServiceHelper.exists((String)"sca_plancostcalclog", (QFilter[])new QFilter[]{filter});
            if (exists) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmExec", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u884c\u5305\u542b\u6267\u884c\u72b6\u6001=\u6210\u529f\uff0c\u91cd\u65b0\u53d1\u8d77\u4f1a\u5c06\u4e0a\u6b21\u8ba1\u7b97\u7ed3\u679c\u5931\u6548\uff0c\u5e76\u8fdb\u884c\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PlanCostCalcLogListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.executePlanCostCalc();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmExec": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.executePlanCostCalc();
            }
        }
    }

    private void executePlanCostCalc() {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"PlanCostService", (String)"selCalc", (Object[])new Object[]{this.getSelectIds()});
        boolean flag = (Boolean)result.get("status");
        if (flag) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff01", (String)"PlanCostCalcLogListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u53d1\u751f\u5f02\u5e38\u3002", (String)"PlanCostCalcLogListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private Set<Long> getSelectIds() {
        HashSet<Long> ids = new HashSet<Long>(10);
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        ListSelectedRowCollection billSelect = selectedRows.getBillListSelectedRowCollection();
        for (ListSelectedRow listSelectedRow : billSelect) {
            ids.add(Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        return ids;
    }
}

