/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlanCostListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("dataupdate".equals(operateKey) && e.getOperationResult().isSuccess()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmExec", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4f1a\u5c06\u8868\u5934\u4e2d\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606fID\u5347\u7ea7\u4e3a\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PlanCostListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmExec": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.executePlanCostCalc();
            }
        }
    }

    private void executePlanCostCalc() {
        DataSet ds = QueryServiceHelper.queryDataSet((String)"PlanCostUpdate", (String)"sca_plancostcalcresult", (String)"material", (QFilter[])new QFilter[0], null);
        HashSet<Long> idSet = new HashSet<Long>();
        for (Row row : ds) {
            idSet.add(row.getLong("material"));
        }
        ArrayList idList = new ArrayList(idSet);
        List splitIdList = Lists.partition(idList, (int)1000);
        for (List list : splitIdList) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)list)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id,masterid", (QFilter[])filter);
            if (dynamicObjects.isEmpty()) continue;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                Object[] param = new Object[]{dynamicObject.getLong("masterid"), dynamicObject.getLong("id")};
                paramList.add(param);
            }
            this.executeBatchSql(paramList);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff01", (String)"PlanCostListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void executeBatchSql(List<Object[]> paramList) {
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)"update t_sca_plancostcalcresult set fmaterialid = ? where fmaterialid = ?", paramList);
    }
}

