/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections.CollectionUtils;

public class ScaAutoExecShemeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ScaAutoExecShemeEditPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.initBusinessTypeItems();
        this.initSysDataEnable();
        this.getModel().setDataChanged(false);
    }

    private void initSysDataEnable() {
        Boolean ispreset = (Boolean)this.getModel().getValue("ispreset");
        this.getView().setEnable(Boolean.valueOf(ispreset == false), new String[]{"advconap1", "number", "name", "remark", "appnum"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"scheduleplan"});
        this.addClickListeners(new String[]{"addcard", "addimg", "addlabel", "modifycard"});
        this.addClickListeners(new String[]{"deleteoper"});
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit autoexecoper = (BasedataEdit)this.getControl("autoexecoper");
        autoexecoper.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObject scheduleInfo;
        String actionId = closedCallBackEvent.getActionId();
        Object rtn = closedCallBackEvent.getReturnData();
        if (rtn == null) {
            return;
        }
        if ("newshedule".equals(actionId) && rtn != null && (scheduleInfo = (DynamicObject)rtn) != null) {
            String planid = (String)scheduleInfo.get("id");
            this.getModel().setValue("sheduleplanid", (Object)planid);
            String txtdesc = (String)scheduleInfo.get("txtdesc");
            txtdesc = txtdesc.replaceAll("[\r\n]", "");
            this.getModel().setValue("scheduleplan", (Object)txtdesc);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("scheduleplan".equals(key)) {
            Object sehmeName = this.getModel().getValue("name");
            String name = null;
            if (sehmeName instanceof ILocaleString) {
                name = ((ILocaleString)sehmeName).getLocaleValue();
            }
            if (CadEmptyUtils.isEmpty(name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u201c\u540d\u79f0\u201d\u3002", (String)"ScaAutoExecShemeEditPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            this.skiptoSchedulePlan(name);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String message;
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) && StringUtils.isNotBlank((CharSequence)(message = this.checkAutoFinish()))) {
            this.getView().showTipNotification(message);
            evt.setCancel(true);
        }
    }

    private String checkAutoFinish() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (entryentity != null && !entryentity.isEmpty()) {
            boolean flag = false;
            for (DynamicObject temp : entryentity) {
                if (!"sca_finishcalwizards".equals(temp.getString("businesstype"))) continue;
                flag = true;
                break;
            }
            if (flag) {
                DynamicObjectCollection orgentry = this.getModel().getEntryEntity("orgentry");
                if (orgentry != null && !orgentry.isEmpty()) {
                    int i = 1;
                    for (DynamicObject temp : orgentry) {
                        DynamicObject org = temp.getDynamicObject("org");
                        DynamicObject costaccount = temp.getDynamicObject("costaccount");
                        if (org == null || org.getLong("masterid") == 0L) {
                            return String.format(ResManager.loadKDString((String)"\u6267\u884c\u4fe1\u606f\u7684\u4e1a\u52a1\u7c7b\u578b\u5305\u542b\u6709\u201c\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u201d,\u7b2c%s\u884c\u9002\u7528\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScaAutoExecShemeEditPlugin_24", (String)"macc-sca-form", (Object[])new Object[0]), i);
                        }
                        if (costaccount == null || costaccount.getLong("masterid") == 0L) {
                            return String.format(ResManager.loadKDString((String)"\u6267\u884c\u4fe1\u606f\u7684\u4e1a\u52a1\u7c7b\u578b\u5305\u542b\u6709\u201c\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u201d\uff0c\u7b2c%s\u884c\u9002\u7528\u7ec4\u7ec7\u7684\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScaAutoExecShemeEditPlugin_25", (String)"macc-sca-form", (Object[])new Object[0]), i);
                        }
                        ++i;
                    }
                } else {
                    return ResManager.loadKDString((String)"\u6267\u884c\u4fe1\u606f\u7684\u4e1a\u52a1\u7c7b\u578b\u5305\u542b\u6709\u201c\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u201d,\u9002\u7528\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ScaAutoExecShemeEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            Long executor = this.getModel().getDataEntity().getLong("executor.id");
            String shedulePlanId = this.getModel().getDataEntity().getString("sheduleplanid");
            this.updateSchemePlannExtor(shedulePlanId, executor);
        }
        if (args.getSource() instanceof Save && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("autoexecoper".equals(name)) {
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            String businesstype = (String)this.getModel().getValue("businesstype", this.getModel().getEntryCurrentRowIndex("entryentity"));
            if (CadEmptyUtils.isEmpty((String)businesstype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ScaAutoExecShemeEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qFilters.add(this.getFiltersByType(businesstype));
        } else if ("org".equals(name)) {
            DynamicObject exector = this.getModel().getDataEntity().getDynamicObject("executor");
            if (exector == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6267\u884c\u4eba\u201d\u3002", (String)"ScaAutoExecShemeEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)exector.getLong("id")).getHasPermOrgs();
            List hasPermAccountOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)hasPermAccountOrgIds)) {
                hasPermAccountOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
            }
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            if (hasPermAccountOrgIds.isEmpty()) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            } else {
                qFilters.add(new QFilter("id", "in", (Object)hasPermAccountOrgIds));
            }
        } else if ("costaccount".equals(name)) {
            Object org = this.getModel().getValue("org", beforeF7SelectEvent.getRow());
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ScaAutoExecShemeEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
            QFilter filter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((DynamicObject)org).getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            QFilter selectedFilter = this.getSelectedCountsFilter();
            qFilters.add(filter);
            if (selectedFilter != null) {
                qFilters.add(selectedFilter);
            }
        }
    }

    private void updateSchemePlannExtor(String shedulePlanId, Long executor) {
        try {
            DynamicObject schSchedule = BusinessDataServiceHelper.loadSingle((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)shedulePlanId)});
            String jobId = schSchedule.getString("job.id");
            DynamicObject schJob = BusinessDataServiceHelper.loadSingle((String)"sch_job", (String)"id,runbyuser", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobId)});
            schJob.set("runbyuser", (Object)executor);
            SaveServiceHelper.update((DynamicObject)schJob);
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.afterUpdateJob(schJob.getString("id"));
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8c03\u5ea6\u4f5c\u4e1a\u6267\u884c\u4eba\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void initBusinessTypeItems() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CadEmptyUtils.isEmpty((String)appId)) {
            return;
        }
        String isRealTimeStr = (String)this.getView().getFormShowParameter().getCustomParam("isRealTime");
        boolean isRealTime = isRealTimeStr != null && "true".equals(isRealTimeStr);
        ComboEdit businesstype = (ComboEdit)this.getControl("businesstype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        switch (appId) {
            case "sca": {
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672cBOM", (String)"ScaAutoExecShemeEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0])), "cad_costbom"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672cBOM\u8bbe\u7f6e", (String)"ScaAutoExecShemeEditPlugin_21", (String)"macc-sca-form", (Object[])new Object[0])), "cad_bomsetting"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf", (String)"ScaAutoExecShemeEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0])), "cad_router"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e", (String)"ScaAutoExecShemeEditPlugin_22", (String)"macc-sca-form", (Object[])new Object[0])), "cad_routersetting"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"ScaAutoExecShemeEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0])), "cad_costobject"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0])), "cad_plannedoutputbill"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0])), "cad_factnedoutputbill"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0])), "sca_resourceuse"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0])), "sca_matusecollect"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0])), "sca_mfgfeebill"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"ScaAutoExecShemeEditPlugin_14", (String)"macc-sca-form", (Object[])new Object[0])), "sca_matalloc"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97", (String)"ScaAutoExecShemeEditPlugin_15", (String)"macc-sca-form", (Object[])new Object[0])), "sca_finishcalwizards"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeEditPlugin_26", (String)"macc-sca-form", (Object[])new Object[0])), "sca_plancostcalclog"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5377\u7b97", (String)"ScaAutoExecShemeEditPlugin_27", (String)"macc-sca-form", (Object[])new Object[0])), "sca_salorderstdcalclog_CALC"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u66f4\u65b0", (String)"ScaAutoExecShemeEditPlugin_28", (String)"macc-sca-form", (Object[])new Object[0])), "sca_salorderstdcalclog_UPDATE"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u6807\u51c6\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeEditPlugin_36", (String)"macc-sca-form", (Object[])new Object[0])), "cad_purprices"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5916\u534f\u8d44\u6e90\u6807\u51c6\u8d39\u7387\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeEditPlugin_37", (String)"macc-sca-form", (Object[])new Object[0])), "cad_resourceout"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ea7\u54c1\u59d4\u5916\u6807\u51c6\u4ef7\u76ee\u8868", (String)"ScaAutoExecShemeEditPlugin_31", (String)"macc-sca-form", (Object[])new Object[0])), "cad_outsourceprice"));
                break;
            }
            case "aca": {
                if (!isRealTime) {
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"ScaAutoExecShemeEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0])), "cad_costobject"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0])), "cad_plannedoutputbill"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0])), "cad_factnedoutputbill"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0])), "sca_resourceuse"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0])), "aca_matusecollect"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0])), "aca_mfgfeebill"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d", (String)"ScaAutoExecShemeEditPlugin_14", (String)"macc-sca-form", (Object[])new Object[0])), "aca_matalloc"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeEditPlugin_17", (String)"macc-sca-form", (Object[])new Object[0])), "aca_terminalcalwizards"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f52\u96c6\u62a5\u544a", (String)"ScaAutoExecShemeEditPlugin_38", (String)"macc-sca-form", (Object[])new Object[0])), "colreport"));
                    items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"ScaAutoExecShemeEditPlugin_39", (String)"macc-sca-form", (Object[])new Object[0])), "calcreport"));
                }
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u65f6\u6210\u672c\u8ba1\u7b97", (String)"ScaAutoExecShemeEditPlugin_35", (String)"macc-sca-form", (Object[])new Object[0])), "aca_realtimecalclog"));
                break;
            }
            case "eca": {
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"ScaAutoExecShemeEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0])), "cad_costobject"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0])), "aca_matalloc"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6", (String)"ScaAutoExecShemeEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0])), "cad_mfgfeebill"));
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d", (String)"ScaAutoExecShemeEditPlugin_19", (String)"macc-sca-form", (Object[])new Object[0])), "cad_mfgfeeallocco"));
                break;
            }
        }
        businesstype.setComboItems(items);
    }

    private QFilter getFiltersByType(String businesstype) {
        ArrayList<String> numberList = new ArrayList<String>(10);
        switch (businesstype) {
            case "cad_costbom": {
                numberList.add("COSTBOM");
                break;
            }
            case "cad_bomsetting": {
                numberList.add("REFRESHBOM");
                break;
            }
            case "cad_router": {
                numberList.add("ROUTER");
                break;
            }
            case "cad_routersetting": {
                numberList.add("REFRESHROUTE");
                break;
            }
            case "cad_costobject": 
            case "aca_matusecollect": 
            case "sca_matusecollect": 
            case "sca_resourceuse": 
            case "cad_plannedoutputbill": 
            case "cad_factnedoutputbill": 
            case "sca_mfgfeebill": 
            case "aca_mfgfeebill": 
            case "cad_mfgfeebill": {
                numberList.add("SYSIMPORT");
                break;
            }
            case "sca_matalloc": 
            case "aca_matalloc": 
            case "eca_workhoursfee": 
            case "cad_mfgfeeallocco": {
                numberList.add("IMPORT");
                break;
            }
            case "aca_mfgfeealloccc": 
            case "sca_mfgfeealloc": 
            case "aca_mfgfeeallocco": {
                numberList.add("ALLOC");
                break;
            }
            case "sca_purchpricediff": {
                numberList.add("IMPORT");
                break;
            }
            case "sca_finishcalwizards": {
                numberList.add("AUTOCALC");
                numberList.add("FINISH_CALC");
                break;
            }
            case "sca_plancostcalclog": {
                numberList.add("PLANCOSTCALC");
                break;
            }
            case "sca_salorderstdcalclog_CALC": {
                numberList.add("STDCOSTCALC");
                break;
            }
            case "cad_autocalcmatrangelog": {
                numberList.add("AUTO_CALCULATION_ALL");
                numberList.add("AUTO_CALCULATION_ALL_RETRY");
                numberList.add("AUTO_CALCULATION_UNDO");
                numberList.add("AUTO_IMPORT_MATERIAL");
                break;
            }
            case "sca_salorderstdcalclog_UPDATE": {
                numberList.add("STDCOSTUPDATE");
                break;
            }
            case "cad_purprices": 
            case "cad_resourceout": 
            case "cad_outsourceprice": {
                numberList.add("PURCHASEPRICING");
                break;
            }
            case "aca_realtimecalclog": {
                numberList.add("REALTIMECALC");
                break;
            }
            case "aca_terminalcalwizards": {
                numberList.add("ACTCOSTCALC");
                break;
            }
            case "colreport": 
            case "calcreport": {
                numberList.add("CLEAR_DATA");
            }
        }
        return new QFilter("number", "in", numberList);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        DynamicObject scheme;
        boolean exists;
        Object id = this.getModel().getValue("id");
        String shedulePlanId = this.getModel().getDataEntity().getString("sheduleplanid");
        if (StringUtils.isNotBlank((CharSequence)shedulePlanId) && !(exists = QueryServiceHelper.exists((String)"sca_autoexecsheme", (QFilter[])new QFilter[]{new QFilter("id", "=", id)})) && (scheme = QueryServiceHelper.queryOne((String)"sch_schedule", (String)"job", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)shedulePlanId)})) != null) {
            String jobId = scheme.getString("job");
            DeleteServiceHelper.delete((String)"sch_schedule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)shedulePlanId)});
            DeleteServiceHelper.delete((String)"sch_job", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobId)});
        }
    }

    private void skiptoSchedulePlan(String name) {
        IBillModel billmodel = (IBillModel)this.getModel();
        long id = (Long)billmodel.getValue("id");
        if (StringUtils.isBlank((Object)id) || id == 0L) {
            String tableName = billmodel.getDataEntityType().getAlias();
            long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
            id = ids[0];
            billmodel.getDataEntity().set("id", (Object)id);
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sch_schedule");
        String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
        QFilter qFilter = new QFilter("id", "=", (Object)scheduleId);
        DynamicObject schedulePlan = QueryServiceHelper.queryOne((String)"sch_schedule", (String)"id,number", (QFilter[])qFilter.toArray());
        if (scheduleId == null || scheduleId.trim().length() == 0 || schedulePlan == null) {
            parameter.setStatus(OperationStatus.ADDNEW);
            String appId = this.getView().getFormShowParameter().getAppId();
            String idJson = "{\"schemeId\":" + id + ", \"appId\":\"" + appId + "\"}";
            parameter.setCustomParam("paramjsonstr", (Object)idJson);
            parameter.setCustomParam("taskclassname", (Object)"kd.macc.sca.business.task.ScaAutoExecSchemeTask");
            switch (appId) {
                case "aca": {
                    parameter.setCustomParam("taskname", (Object)String.format(ResManager.loadKDString((String)"%s_\u5b9e\u9645\u6210\u672c\u6838\u7b97\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"ScaAutoExecShemeEditPlugin_32", (String)"macc-sca-form", (Object[])new Object[0]), name));
                    parameter.setCustomParam("taskdefineid", (Object)"14IEF8L39FK=");
                    break;
                }
                case "sca": {
                    parameter.setCustomParam("taskdefineid", (Object)"0X5HC+L4=/63");
                    parameter.setCustomParam("taskname", (Object)String.format(ResManager.loadKDString((String)"%s_\u6807\u51c6\u6210\u672c\u6838\u7b97\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"ScaAutoExecShemeEditPlugin_33", (String)"macc-sca-form", (Object[])new Object[0]), name));
                    break;
                }
                case "eca": {
                    parameter.setCustomParam("taskdefineid", (Object)"2MNPRD=O/27R");
                    parameter.setCustomParam("taskname", (Object)String.format(ResManager.loadKDString((String)"%s_\u670d\u52a1\u6210\u672c\u6838\u7b97\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u8ba1\u5212", (String)"ScaAutoExecShemeEditPlugin_34", (String)"macc-sca-form", (Object[])new Object[0]), name));
                    break;
                }
            }
            parameter.setCustomParam("schedulename", parameter.getCustomParam("taskname"));
            parameter.setCustomParam("tasknumber", (Object)(appId + "_autocreate" + System.currentTimeMillis()));
            parameter.setCustomParam("taskappnumber", (Object)appId);
            DynamicObject executor = (DynamicObject)billmodel.getValue("executor");
            if (executor != null) {
                parameter.setCustomParam("executor", executor.get("id"));
            }
        } else {
            parameter.setPkId((Object)scheduleId);
            parameter.setStatus(OperationStatus.EDIT);
        }
        parameter.setHasRight(true);
        parameter.setCustomParam("frombiz", (Object)"true");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (name) {
            case "businesstype": {
                String type = (String)this.getModel().getValue("businesstype", index);
                if (CadEmptyUtils.isEmpty((String)type)) {
                    this.getModel().setValue("autoexecoper", null, index);
                }
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)"sca_autoexecoper", (String)"id", (QFilter[])new QFilter[]{this.getFiltersByType(type)});
                this.getModel().setValue("autoexecoper", queryOne == null ? null : Long.valueOf(queryOne.getLong("id")), index);
                this.getView().updateView("entryentity.autoexecoper", index);
                break;
            }
            case "org": {
                this.updateCostAccount(rowIndex);
                break;
            }
        }
    }

    private void updateCostAccount(int rowIndex) {
        this.getModel().setValue("costaccount", null, rowIndex);
    }

    private QFilter getSelectedCountsFilter() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("orgentry");
        Set costAccounts = entry.stream().filter(e -> {
            DynamicObject costAccount = e.getDynamicObject("costaccount");
            return costAccount != null;
        }).map(e -> e.getDynamicObject("costaccount").getPkValue()).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(costAccounts)) {
            return new QFilter("id", "not in", costAccounts);
        }
        return null;
    }
}

