/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.autoexec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.AutoCalcStatusEnum;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.sca.servicehelper.CostCalcServiceHelper;

public class ScaAutologListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final Log logger = LogFactory.getLog(ScaAutologListPlugin.class);
    private static final String OP_RELAUNCH = "logrelaunch";
    private static final String OP_RECANCEL = "recancel";
    private static final String OP_LINKREPORT = "linkreport";
    private static final String UPDATE_AUTOCALC_CANCEL_LOG = "update t_sca_autocalclog set fstatus='05',foperatorid=?,foperdate=? where fid in(%s)";
    private static final String UPDATE_LOG_SQL = "UPDATE t_sca_autocalclog SET fsyncdate=?,fstatus=?,flastexecdate=?,foperatorid=?,foperdate=?,ftrytimes=?,fexeclog=? WHERE fid=?";

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemKey = evt.getOperateKey();
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRow = listview.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectedRow) {
            ids.add((Long)row.getPrimaryKeyValue());
        }
        switch (itemKey) {
            case "logrelaunch": {
                this.logReLaunch(ids);
                break;
            }
            case "recancel": {
                this.logCancel(ids, " ");
                break;
            }
            case "linkreport": {
                this.linkReport(ids);
            }
        }
    }

    private void linkReport(List<Long> ids) {
        String selectMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"ScaAutologListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]);
        if (CadEmptyUtils.isEmpty(ids)) {
            this.getView().showTipNotification(selectMsg);
            return;
        }
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("calcreportid", ">", (Object)0L);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"autocalclog", (String)"sca_autocalclog", (String)"calcreportid", (QFilter[])filter.toArray(), null);
        if (ds.isEmpty()) {
            this.getView().showTipNotification(selectMsg);
            return;
        }
        HashSet<Long> reportIds = new HashSet<Long>(10);
        for (Object row : ds) {
            reportIds.add(row.getLong("calcreportid"));
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Long reportId : reportIds) {
            linkQueryPkIdCollection.addLinkQueryPkId((Object)reportId);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("sca_calcreport");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void logReLaunch(List<Long> ids) {
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("id", "in", ids));
        QFilter statusFilter = new QFilter("costaccount", "=", (Object)0L);
        filters.add(statusFilter);
        if (QueryServiceHelper.exists((String)"sca_autocalclog", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6210\u672c\u8d26\u8584\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ScaAutologListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList logParamObjs = Lists.newArrayListWithExpectedSize((int)ids.size());
        DataSet ds = this.getSelectDs(ids);
        final HashMap<Long, Set> orgAccountMap = new HashMap<Long, Set>(16);
        Long operator = RequestContext.get().getCurrUserId();
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u53d1\u8d77\u3002", (String)"ScaAutologListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]);
        for (Row row : ds) {
            Long orgId = row.getLong("org");
            Long costaccountId = row.getLong("costaccount");
            if (!CadEmptyUtils.isEmpty((Long)orgId) && !CadEmptyUtils.isEmpty((Long)costaccountId)) {
                orgAccountMap.computeIfAbsent(orgId, t -> new HashSet()).add(costaccountId);
            }
            Object[] param = this.getParam(AutoCalcStatusEnum.NOT_EXECUTE.getValue(), operator, 0, msg, row.getLong("id"));
            logParamObjs.add(param);
        }
        if (!logParamObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)UPDATE_LOG_SQL, (List)logParamObjs);
        }
        ThreadPools.executeOnce((String)"autocalc", (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean isMutex = ScaAutologListPlugin.this.callService(orgAccountMap);
                if (isMutex) {
                    logger.error("\u81ea\u52a8\u7ed3\u7b97\u91cd\u65b0\u53d1\u8d77-\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                }
            }
        });
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d1\u8d77\u6210\u529f\uff0c\u8bf7\u5237\u65b0\u540e\u67e5\u8be2\u6267\u884c\u72b6\u6001\u3002", (String)"ScaAutologListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
        ((IListView)this.getView()).refresh();
    }

    private boolean callService(Map<Long, Set<Long>> orgAccountMap) {
        boolean isMutex = false;
        if (orgAccountMap.isEmpty()) {
            return isMutex;
        }
        String operKey = "PAGEAUTOCALC";
        for (Map.Entry<Long, Set<Long>> entry : orgAccountMap.entrySet()) {
            String result = CostCalcServiceHelper.autoFinishCalc((Long)entry.getKey(), new ArrayList(entry.getValue()), (String)operKey);
            if (StringUtils.isEmpty((String)result) || !result.contains("mutex")) continue;
            isMutex = true;
        }
        return isMutex;
    }

    private Object[] getParam(String status, Long operator, int trytimes, String log, Long logid) {
        return new Object[]{new Date(), status, null, operator, new Date(), trytimes, log, logid};
    }

    private DataSet getSelectDs(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return QueryServiceHelper.queryDataSet((String)"scaautocalclog", (String)"sca_autocalclog", (String)"id,orderentryid,manuorg,orderno,orderentryseq,status,biztype,org,costaccount,syncdate", (QFilter[])filter.toArray(), null);
    }

    private void logCancel(List<Long> ids, String log) {
        if (this.existsRow(ids, new String[]{AutoCalcStatusEnum.NOT_EXECUTE.getValue(), AutoCalcStatusEnum.FAIL.getValue(), AutoCalcStatusEnum.BUSINESS_FAIL.getValue()})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5fd7\u72b6\u6001\u4e3a\u672a\u6267\u884c\u6216\u6267\u884c\u5931\u8d25\u7684\u884c\u3002", (String)"ScaAutologListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        StringBuilder sb = new StringBuilder();
        int size = 0;
        Object[] paramArray = new Object[]{RequestContext.get().getCurrUserId(), new Date()};
        for (Long billId : ids) {
            sb.append(billId).append(",");
            if (++size <= 50) continue;
            String sql = String.format(UPDATE_AUTOCALC_CANCEL_LOG, sb.toString().substring(0, sb.length() - 1));
            this.doSqlExecute(DBRoute.of((String)"cal"), sql, paramArray);
            sb.delete(0, sb.length());
            size = 0;
        }
        if (sb.length() > 0) {
            String sql = String.format(UPDATE_AUTOCALC_CANCEL_LOG, sb.toString().substring(0, sb.length() - 1));
            this.doSqlExecute(DBRoute.of((String)"cal"), sql, paramArray);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"ScaAutologListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        ((IListView)this.getView()).refresh();
    }

    private void doSqlExecute(DBRoute cal, String sql, Object[] paramArray) {
        DB.execute((DBRoute)cal, (String)sql, (Object[])paramArray);
    }

    public void packageData(PackageDataEvent evt) {
        Long calcreportid;
        super.packageData(evt);
        if (evt.getRowData() != null && evt.getRowData().containsProperty("calcreportid") && CadEmptyUtils.isEmpty((Long)(calcreportid = Long.valueOf(evt.getRowData().getLong("calcreportid"))))) {
            evt.getNoLinkKey().add(((ColumnDesc)evt.getSource()).getFieldKey());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        e.setCancel(true);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
        ListSelectedRow currentRow = clickEvent.getCurrentRow();
        String fieldName = e.getFieldName();
        if ("execlog".equals(fieldName)) {
            long calcreportid;
            Object entryPrimaryKeyValue = currentRow.getPrimaryKeyValue();
            if (entryPrimaryKeyValue == null) {
                return;
            }
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(entryPrimaryKeyValue.toString()));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"sca_autocalclog", (String)"calcreportid", (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null && !CadEmptyUtils.isEmpty((Long)(calcreportid = dynamicObject.getLong("calcreportid")))) {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("sca_calcreport");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setPkId((Object)calcreportid);
                formShowParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private boolean existsRow(List<Long> ids, String[] status) {
        QFilter filter = new QFilter("id", "in", ids);
        filter.and("status", "not in", (Object)status);
        return QueryServiceHelper.exists((String)"sca_autocalclog", (QFilter[])filter.toArray());
    }
}

