/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseListPlugin;

public abstract class BaseOrgAndCostCenterFilterList
extends BaseListPlugin {
    protected static final String COSTCENTER = "costcenter";
    protected static final String ACCTORG = "org";
    protected static final String MANUORG = "manuorg";
    private volatile boolean orgClick = false;

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter.")) {
            QFilter filter;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
                String manuOrgId = this.getPageCache().get(MANUORG);
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                    manuOrgList.add(Long.parseLong(manuOrgId));
                }
                filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            } else {
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                filter = new QFilter("accountorg", "in", (Object)orgIds);
            }
            String entityId = this.getBillEntityId();
            if (!"sca_mfgfeeallocstdnew".equals(entityId) && !"sca_diycostdriver".equals(entityId)) {
                filter.and("orgduty", "=", (Object)4L);
            }
            args.getQfilters().add(filter);
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            ComboItem item;
            CommonFilterColumn commonFilterColumn;
            String fieldName;
            String orgId = this.getPageCache().get(this.ORG_FIELD);
            if (StringUtils.isEmpty((String)orgId) && CadEmptyUtils.isEmpty((String)(orgId = this.getCustomParam(ACCTORG)))) {
                long currentOrgId = RequestContext.getOrCreate().getOrgId();
                boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
                Long userId = RequestContext.get().getCurrUserId();
                String appInnerId = AppMetadataCache.getAppInfo((String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())).getId();
                int hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)currentOrgId, (String)appInnerId, (String)this.getBillEntityId(), (String)"47150e89000000ac");
                if (isaccount && hasPermissin == 1) {
                    orgId = String.valueOf(currentOrgId);
                }
            }
            if ((fieldName = (commonFilterColumn = (CommonFilterColumn)filterColumn).getFieldName()).startsWith(String.format("%s.", this.ORG_FIELD))) {
                List listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                List<ComboItem> acctOrgs = this.getORGComboItemList();
                if (!CollectionUtils.isEmpty(acctOrgs)) {
                    commonFilterColumn.setComboItems(acctOrgs);
                    item = acctOrgs.get(0);
                    String string = orgId = StringUtils.isEmpty((String)orgId) ? item.getValue() : orgId;
                }
                if (StringUtils.isNotEmpty((String)orgId)) {
                    commonFilterColumn.setDefaultValue(orgId);
                    this.getPageCache().put(this.ORG_FIELD, orgId);
                    this.getPageCache().remove(COSTCENTER);
                }
            }
            if (fieldName.startsWith("costcenter.")) {
                List listcomitem = commonFilterColumn.getComboItems();
                listcomitem.clear();
                String manuOrgId = this.getPageCache().get(MANUORG);
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(orgId, manuOrgId);
                if (!CollectionUtils.isEmpty(comboItems)) {
                    commonFilterColumn.setComboItems(comboItems);
                    ComboItem item2 = comboItems.get(0);
                    String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item2.getValue();
                    commonFilterColumn.setDefaultValue(defVal);
                    this.getPageCache().put(COSTCENTER, defVal);
                }
            }
            if (!fieldName.startsWith("manuorg.")) continue;
            if (StringUtils.isEmpty((String)orgId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u6743\u9650\u3002", (String)"BaseOrgAndCostCenterFilterList_0", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> comboItems = this.getManuOrgComboItemsList(Long.valueOf(orgId));
            if (CollectionUtils.isEmpty(comboItems)) continue;
            commonFilterColumn.setComboItems(comboItems);
            item = comboItems.get(0);
            String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
            commonFilterColumn.setDefaultValue(defVal);
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costcenter.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        if ((customfilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                String orgId = String.valueOf(vals.get(0));
                this.getPageCache().put(this.ORG_FIELD, StringUtils.isEmpty((String)orgId) ? "0" : orgId);
                this.getPageCache().remove(COSTCENTER);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if ("costcenter.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put(COSTCENTER, String.valueOf(vals.get(0)));
            }
            if (!"manuorg.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put(MANUORG, String.valueOf(vals.get(0)));
            this.filterContainerInit(this.filterContainerInitArgs);
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get(this.ORG_FIELD);
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get(COSTCENTER);
        String manuorg = this.getPageCache().get(MANUORG);
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam(COSTCENTER, (Object)costCenter);
        bsp.setCustomParam(MANUORG, (Object)manuorg);
    }

    protected QFilter getCostCenterFilter() {
        String orgId;
        List<ComboItem> costCenterComboItems;
        QFilter qfCostCenter = null;
        String costCenterId = this.getPageCache().get(COSTCENTER);
        if (StringUtils.isEmpty((String)costCenterId) && !CollectionUtils.isEmpty(costCenterComboItems = this.getCostCenterComboItemListBy(orgId = this.getPageCache().get(this.ORG_FIELD)))) {
            List costCenterIds = costCenterComboItems.stream().map(s -> Long.parseLong(s.getValue())).collect(Collectors.toList());
            costCenterIds.add(0L);
            qfCostCenter = new QFilter(COSTCENTER, "in", costCenterIds);
        }
        return qfCostCenter;
    }

    protected QFilter getManuOrgQFilter() {
        Long orgIdL;
        String orgId;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get(MANUORG);
        if (StringUtils.isEmpty((String)manuOrgId) && !StringUtils.isEmpty((String)(orgId = this.getPageCache().get(this.ORG_FIELD))) && OrgHelper.isOrgEnableMultiFactory((Long)(orgIdL = Long.valueOf(orgId)))) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgIdL, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter(MANUORG, "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter(MANUORG, "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    protected QFilter getManuorgFilter() {
        List<ComboItem> manuorgIdComboItems;
        String orgId;
        QFilter qfManuorg = null;
        String manuorgId = this.getPageCache().get(MANUORG);
        if (StringUtils.isEmpty((String)manuorgId) && !CadEmptyUtils.isEmpty((String)(orgId = this.getPageCache().get(this.ORG_FIELD))) && !CollectionUtils.isEmpty(manuorgIdComboItems = this.getManuOrgComboItemsList(Long.valueOf(orgId)))) {
            ArrayList<Long> manuorgIds = new ArrayList<Long>(16);
            for (ComboItem combo : manuorgIdComboItems) {
                manuorgIds.add(Long.valueOf(combo.getValue()));
            }
            manuorgIds.add(0L);
            qfManuorg = new QFilter(MANUORG, "in", manuorgIds);
        }
        return qfManuorg;
    }

    protected List<ComboItem> getCostCenterComboItemList(String orgId) {
        return this.getCostCenterComboItemListBy(orgId);
    }

    protected List<ComboItem> getManuOrgComboItemsList(Long orgId) {
        return ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
    }
}

