/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AbsorbCostAdjustEditPlugin
extends AbstractBillPlugIn {
    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            listFilterParameter.setFilter(orgIdsFilter);
        });
        BasedataEdit center = (BasedataEdit)this.getControl("costcenter");
        center.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            this.checkOrg(beforeF7SelectEvent);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbsorbCostAdjustEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
            Long orgId = this.getModel().getDataEntity().getLong("org.id");
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            manuOrgList.add(manuorgId);
            QFilter costFilter = new QFilter("orgduty", "=", (Object)4L);
            costFilter.and(new QFilter("enable", "=", (Object)"1"));
            costFilter.and(new QFilter("accountorg", "=", (Object)orgId));
            if (manuorgId != 0L) {
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                costFilter.and(costCenterIdFilter);
            }
            formShowParameter.getListFilterParameter().getQFilters().add(costFilter);
        });
        center.addAfterF7SelectListener(afterF7SelectEvent -> this.setManuorgValueByCostcenter());
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            this.checkOrg(beforeF7SelectEvent);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbsorbCostAdjustEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId());
            QFilter orgFilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
        });
        BasedataEdit costAccountEdit = (BasedataEdit)this.getControl("costaccount");
        costAccountEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            this.checkOrg(beforeF7SelectEvent);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbsorbCostAdjustEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)AppIdHelper.getCurAppNum((IFormView)this.getView())));
        });
        BasedataEdit elementCtrl = (BasedataEdit)this.getControl("element");
        elementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject subElement = (DynamicObject)this.getModel().getValue("subelement", beforeF7SelectEvent.getRow());
            if (subElement != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)this.getElement(subElement.getLong("id"))));
            }
        });
        BasedataEdit subElementCtrl = (BasedataEdit)this.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Set<Long> subElement;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject element = (DynamicObject)this.getModel().getValue("element", beforeF7SelectEvent.getRow());
            if (element != null) {
                QFilter qfElement = new QFilter("element", "=", (Object)element.getLong("id"));
                DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement});
                if (dyElementRelation == null) {
                    return;
                }
                HashSet<Long> eleIds = new HashSet<Long>();
                for (DynamicObject subElement2 : dyElementRelation) {
                    eleIds.add(subElement2.getLong("subelement"));
                }
                qList.add(new QFilter("id", "in", eleIds));
            }
            if ((subElement = this.getNotSubElement()).size() > 0) {
                qList.add(new QFilter("id", "not in", subElement));
            }
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            this.checkOrg(beforeF7SelectEvent);
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"AbsorbCostAdjustEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
        BasedataEdit costObjectEdit = (BasedataEdit)this.getControl("costobject");
        costObjectEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbsorbCostAdjustEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costcenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
            this.checkOrg(beforeF7SelectEvent);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String manu = (String)formShowParameter.getCustomParam("manuorg");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            if (!StringUtils.isEmpty((Object)manu)) {
                orgFilter = orgFilter.and(new QFilter("manuorg", "=", (Object)Long.valueOf(manu)));
            }
            orgFilter.and("producttype", "=", (Object)"C");
            filterParameter.getQFilters().add(orgFilter);
            if (null != costcenter) {
                QFilter costcenterFilter = new QFilter("costcenter", "=", costcenter.getPkValue());
                filterParameter.getQFilters().add(costcenterFilter);
            }
        });
        costObjectEdit.addAfterF7SelectListener(new AfterF7SelectListener(){

            public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
                AbsorbCostAdjustEditPlugin.this.setManuorgValue();
            }
        });
    }

    private void setManuorgValueByCostcenter() {
        DynamicObject costCenter = (DynamicObject)this.getModel().getValue("costcenter");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (costCenter != null) {
            Long costCenterId = costCenter.getLong("id");
            Long orgId = org.getLong("id");
            QFilter qFilter = new QFilter("entryentity.costcenter", "=", (Object)costCenterId);
            qFilter.and("org", "=", (Object)orgId);
            Date nowTime = new Date();
            qFilter.and("effectdate", "<=", (Object)nowTime);
            qFilter.and("expdate", ">", (Object)nowTime);
            DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id,manuorg,entryentity.costcenter costcenter", (QFilter[])qFilter.toArray());
            if (result != null && result.size() == 1) {
                DynamicObject costCenterAndManuOrg = (DynamicObject)result.get(0);
                Long manuOrgId = costCenterAndManuOrg.getLong("manuorg");
                this.getView().getModel().setValue("manuorg", (Object)manuOrgId);
            }
        }
    }

    private void setManuorgValue() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("costobject");
        if (value != null) {
            Long manuorgid = value.getLong("manuorg.id");
            this.getModel().beginInit();
            this.getView().getModel().setValue("manuorg", null);
            this.getView().getModel().setValue("manuorg", (Object)manuorgid);
            this.getModel().endInit();
            this.getView().updateView("manuorg");
        }
    }

    private void checkOrg(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AbsorbCostAdjustEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
    }

    private Set<Long> getNotSubElement() {
        HashSet<Long> subElement = new HashSet<Long>();
        DynamicObjectCollection entry = this.getView().getModel().getEntryEntity("entryentity");
        if (entry.size() == 0) {
            return subElement;
        }
        for (DynamicObject en : entry) {
            if (en.get("subelement") == null) continue;
            subElement.add(en.getLong("subelement.id"));
        }
        return subElement;
    }

    private void setDefaultSubElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject ele = (DynamicObject)this.getView().getModel().getValue("element", rowIndex);
        if (ele == null) {
            return;
        }
        long elementId = ele.getLong("id");
        QFilter qfElement = new QFilter("id", "=", (Object)elementId);
        DynamicObject dyElement = QueryServiceHelper.queryOne((String)"cad_element", (String)"elementtype.id", (QFilter[])new QFilter[]{qfElement});
        long elementTypeId = dyElement.getLong("elementtype.id");
        qfElement = new QFilter("element", "=", (Object)elementId);
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        DynamicObjectCollection dyElementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{qfElement, qfElementType});
        if (dyElementRelation == null) {
            return;
        }
        HashSet<Long> eleIds = new HashSet<Long>();
        for (DynamicObject subElement : dyElementRelation) {
            eleIds.add(subElement.getLong("subelement"));
        }
        QFilter qfDefault = new QFilter("defaultvalue", "=", (Object)true);
        QFilter qfSubElement = new QFilter("id", "in", eleIds);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfSubElement, qfDefault});
        if (dySubElement != null) {
            this.getView().getModel().setValue("subelement", (Object)dySubElement.getLong("id"), rowIndex);
        }
    }

    private void setElement(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("subelement", rowIndex);
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getView().getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    private long getElement(long subElementId) {
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        return dySubElement != null ? dySubElement.getLong("element") : 0L;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"period"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String manuOrg = (String)formShowParameter.getCustomParam("manuorg");
        if (!StringUtils.isEmpty((Object)manuOrg) && !"0".equals(manuOrg)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"manuorg"});
            this.getModel().setValue("manuorg", (Object)manuOrg);
        }
        if ("0".equals(manuOrg)) {
            this.getModel().setValue("manuorg", null);
        }
        this.getModel().setDataChanged(false);
        this.changManuorgStatus();
    }

    public void afterCreateNewData(EventObject e) {
        String manuorg;
        String costAcc;
        List orgList;
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String org = (String)fsp.getCustomParam("org");
        if (!CadEmptyUtils.isEmpty((String)org) && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)org, List.class)))) {
            this.getModel().setValue("org", orgList.get(0));
        }
        if (!"null".equals(costAcc = (String)fsp.getCustomParam("costaccount"))) {
            this.getModel().setValue("costaccount", (Object)costAcc);
        }
        if (!CadEmptyUtils.isEmpty((String)(manuorg = (String)fsp.getCustomParam("manuorg")))) {
            this.getModel().setValue("manuorg", (Object)manuorg);
        }
        this.initData();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("source", (Object)"0");
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("save") || operateKey.equals("submit")) {
            this.cleanBlankRows(args);
        }
    }

    private void cleanBlankRows(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (entrys.size() == 1 && (((DynamicObject)entrys.get(0)).getBigDecimal("amount") == null || ((DynamicObject)entrys.get(0)).getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u91d1\u989d\u3002", (String)"AbsorbCostAdjustEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (entrys.size() > 1) {
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            for (DynamicObject entry : entrys) {
                if (entry.getBigDecimal("amount") != null && entry.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) continue;
                indexList.add(entry.getInt("seq") - 1);
            }
            if (indexList.isEmpty()) {
                return;
            }
            int[] indexs = new int[indexList.size()];
            for (int i = 0; i < indexs.length; ++i) {
                indexs[i] = (Integer)indexList.get(i);
            }
            this.getModel().deleteEntryRows("entryentity", indexs);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.changManuorgStatus();
                if (null == newValue) break;
                this.setCostAccount(((DynamicObject)newValue).getLong("id"));
                break;
            }
            case "costaccount": {
                this.setCurrency();
                this.setPeriod();
                break;
            }
            case "costcenter": {
                this.getModel().setValue("costobject", null);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String manu = (String)formShowParameter.getCustomParam("manuorg");
                if (!StringUtils.isEmpty((Object)manu)) break;
                this.getModel().setValue("manuorg", null);
                break;
            }
            case "element": {
                this.setDefaultSubElement(e);
                break;
            }
            case "subelement": {
                this.setElement(e);
            }
        }
    }

    protected void initData() {
        Long accountOrgId = this.getDefaultOrg();
        this.getModel().setValue("org", (Object)accountOrgId);
        this.setCostAccountAndCurr(accountOrgId);
    }

    private void setCostAccountAndCurr(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return;
        }
        this.setCurrency();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            this.setPeriod();
        }
    }

    private void setCostAccount(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(orgId);
        if (mainBookId != null && mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getView().updateView("period");
        }
        this.getView().updateView("costaccount");
        this.setCurrency();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            this.setPeriod();
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(accountOrgId);
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)accountOrgId);
        QFilter enable = new QFilter("enable", "=", (Object)true);
        QFilter filter = StartCostHelper.getEnabledCostAccountIdsFilter(orgIdList, (String)"sca");
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name,ismainaccount", (QFilter[])new QFilter[]{accountorgQF, filter, enable}, null);
        if (result != null && result.size() != 0) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        return 0L;
    }

    private Long getDefaultOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return org.getLong("masterid");
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            return currentOrgId;
        }
        return 0L;
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

