/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CadUserDataRecordHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FinshCalcCheck;
import kd.macc.sca.algox.utils.FinishCalcHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.algox.wip.input.CalcDataArgs;
import kd.macc.sca.common.enums.ScaCheckerWayEnum;
import net.sf.json.JSONObject;

public class FinishCalWizardsEditPlugin
extends AbstractBillPlugIn {
    protected static final Log logger = LogFactory.getLog(FinishCalWizardsEditPlugin.class);
    private boolean calcScopeiniting = false;
    private static final String CALC_PERM = "4730fc9f000025ae";

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)CALC_PERM);
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            listFilterParameter.setFilter(orgIdsFilter);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("costobject");
        mat.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            ArrayList<Long> selectedCostObjectIds = new ArrayList<Long>();
            DynamicObjectCollection costObjectinfos = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < costObjectinfos.size() && costObjectinfos.size() < 1000; ++index) {
                DynamicObject rowobject = (DynamicObject)costObjectinfos.get(index);
                DynamicObject costObjectInfo = (DynamicObject)rowobject.get("costobject");
                if (CadEmptyUtils.isEmpty((DynamicObject)costObjectInfo)) continue;
                selectedCostObjectIds.add(costObjectInfo.getLong("id"));
            }
            QFilter selectedCostObjectFilter = new QFilter("id", "not in", (Object)selectedCostObjectIds.toArray());
            filters.add(selectedCostObjectFilter);
            Set<Long> costObjectSet = this.getCostObjectRange();
            QFilter matFilter = new QFilter("id", "in", costObjectSet);
            filters.add(matFilter);
            filterParameter.setQFilters(filters);
        });
        BasedataEdit center = (BasedataEdit)this.getControl("costcenter");
        center.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("accountorg", "!=", (Object)0L));
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org != null) {
                ArrayList<Long> manuOrgList = new ArrayList<Long>(this.getManuorgSet());
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                qList.add(costCenterIdFilter);
            }
            qList.add(new QFilter("orgduty", "=", (Object)4L));
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishCalWizardsEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca"));
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List manuIdList = Lists.newArrayList();
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishCalWizardsEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)CALC_PERM, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            qList.add(new QFilter("id", "in", (Object)manuIdList));
        });
    }

    private void initCalpolicy() {
        DynamicObject dyo = (DynamicObject)this.getModel().getValue("org");
        if (dyo != null) {
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            if (OrgHelper.isOrgEnableMultiFactory((Long)dyo.getLong("id"))) {
                manuorgEdit.setMustInput(true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
            } else {
                manuorgEdit.setMustInput(false);
                this.getModel().setValue("manuorg", null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initCondition();
        this.initCalpolicy();
        this.setManuorg();
        this.initCalcScope();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "manuorg": {
                this.initCalcScope();
                break;
            }
            case "org": {
                this.initCondition();
                this.initCalpolicy();
                this.setManuorg();
                this.initCalcScope();
                break;
            }
            case "costcenter": {
                if (this.isOverMaxNum(e)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u591a\u9009\u6846\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc730\u4e2a\u3002", (String)"FinishCalWizardsEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                this.initCalcScope();
                break;
            }
            case "costaccount": {
                this.setOrgByCostAccount();
                this.setCurrency();
                this.setPeriod();
                this.initCalcScope();
                break;
            }
            case "costobject": {
                if (e.getChangeSet()[0].getNewValue() == null) break;
                this.setRelatedInfo(e);
            }
        }
    }

    private boolean isOverMaxNum(PropertyChangedArgs e) {
        DynamicObjectCollection dyColl;
        if (e.getChangeSet() != null && e.getChangeSet()[0] != null && (dyColl = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue()) != null && dyColl.size() > 30) {
            this.getView().getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "calc": {
                    this.doCalc();
                    break;
                }
                case "check": {
                    this.doCheck();
                }
            }
        }
    }

    private Set<Long> getManuorgSet() {
        HashSet<Long> manuorgSet = new HashSet<Long>(16);
        DynamicObjectCollection manuorgs = this.getModel().getDataEntity().getDynamicObjectCollection("manuorg");
        if (manuorgs == null) {
            return manuorgSet;
        }
        for (DynamicObject row : manuorgs) {
            DynamicObject manuOrgDyn = row.getDynamicObject("fbasedataid");
            manuorgSet.add(manuOrgDyn.getLong("masterid"));
        }
        return manuorgSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCalcScope() {
        logger.info("initCalcScope 0");
        if (this.calcScopeiniting) {
            return;
        }
        try {
            this.calcScopeiniting = true;
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                return;
            }
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                return;
            }
            DynamicObject period = (DynamicObject)this.getModel().getValue("period");
            if (period == null) {
                return;
            }
            this.getModel().beginInit();
            logger.info("initCalcScope entryentity");
            this.getModel().deleteEntryData("entryentity");
            logger.info("initCalcScope getCostObjectRange");
            Set<Long> noCalCcSet = this.getCostObjectRange();
            logger.info("initCalcScope getCostObjectRelateInfo");
            DataSet calcDataSet = this.getCostObjectRelateInfo(noCalCcSet);
            if (calcDataSet == null || calcDataSet.isEmpty()) {
                this.getModel().batchCreateNewEntryRow("entryentity", 1);
            } else {
                TableValueSetter vs = this.getTableValueSetter();
                IDataModel dataModel = this.getModel();
                AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
                for (Row row : calcDataSet) {
                    Object[] container = new Object[vs.getFields().size()];
                    int index = 0;
                    container[index++] = row.get("costcenterid");
                    container[index++] = row.get("costobjectid");
                    container[index++] = row.get("matmasterid");
                    container[index++] = row.get("baseunit");
                    container[index++] = row.get("auxpty");
                    container[index++] = row.getBigDecimal("qty");
                    container[index] = row.getBigDecimal("totalinqty");
                    vs.addRow(container);
                    if (vs.getCount() < 1000) continue;
                    model.batchCreateNewEntryRow("entryentity", vs);
                    vs = this.getTableValueSetter();
                }
                if (vs.getCount() > 0) {
                    model.batchCreateNewEntryRow("entryentity", vs);
                }
            }
            logger.info("initCalcScope createNewEntryRow");
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        finally {
            this.calcScopeiniting = false;
        }
        logger.info("initCalcScope end");
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("subcostcenter", new Object[0]);
        vs.addField("costobject", new Object[0]);
        vs.addField("matnumber", new Object[0]);
        vs.addField("baseunit", new Object[0]);
        vs.addField("auxpty", new Object[0]);
        vs.addField("planyqyt", new Object[0]);
        vs.addField("factnedqty", new Object[0]);
        return vs;
    }

    private void initCondition() {
        logger.info("initCondition");
        Long accountOrgId = this.getDefaultOrg();
        this.getModel().setValue("org", (Object)accountOrgId);
        boolean flag = false;
        Long costAccountId = this.getCostAccountByAccoutOrg(accountOrgId);
        if (!CadEmptyUtils.isEmpty((Long)costAccountId)) {
            flag = true;
            this.getModel().setValue("costaccount", (Object)costAccountId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("manuorg", null);
        }
        if (flag) {
            DynamicObject periodId = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (periodId == null) {
                return;
            }
            this.getModel().setValue("period", (Object)periodId.getLong("id"));
            this.setCurrency();
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter calorg = new QFilter("org", "=", (Object)accountOrgId);
        QFilter appnum = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        QFilter isStartStdCostFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        isStartStdCostFilter.and("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection cal_bd_costaccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{calorg, isStartStdCostFilter, appnum});
        Long costaccountId = null;
        if (cal_bd_costaccounts.size() == 1) {
            costaccountId = ((DynamicObject)cal_bd_costaccounts.get(0)).getLong("costaccount");
        } else if (cal_bd_costaccounts.size() > 1) {
            for (DynamicObject cal_bd_costaccount : cal_bd_costaccounts) {
                if (!cal_bd_costaccount.getBoolean("ismainaccount")) continue;
                costaccountId = cal_bd_costaccount.getLong("costaccount");
                break;
            }
        }
        return costaccountId;
    }

    private Long getDefaultOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return org.getLong("masterid");
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            return currentOrgId;
        }
        return 0L;
    }

    private void doCalc() {
        if (!this.calcParaVilidator()) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        String costAccName = costAccount.getLocaleString("name").getLocaleValue();
        Long costTypeId = costAccount.getLong("id");
        Set<Long> manuorgSet = this.getManuorgSet();
        if (!CadEmptyUtils.isEmpty(manuorgSet)) {
            for (Long manuOrgId : manuorgSet) {
                if (!CostCloseAccountHelper.checkIsCloseAccount((Long)org.getLong("id"), (Long)manuOrgId, (Long)costTypeId, (Long)this.getModel().getDataEntity().getDynamicObject("period").getLong("id"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u671f\u672b\u6210\u672c\u8ba1\u7b97\u3002", (String)"FinishCalWizardsEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
        }
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costTypeId);
        try {
            String calcParam = this.buildCalcParam(ScaCheckerWayEnum.CHECKERWAY_BEFORECALC);
            if (CadEmptyUtils.isEmpty((String)calcParam)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5b8c\u5de5\u7ed3\u7b97\u3002", (String)"FinishCalWizardsEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            JSONObject calcParamJs = JSONObject.fromObject((Object)calcParam);
            Long calcTaskConfigId = FinshCalcCheck.CALCTASKID;
            calcParamJs.accumulate("checkConfigId", (Object)FinshCalcCheck.CALCCHECKCONFIGID);
            String lockErrStr = CalcMutexHelper.checkMutexAndLock((String)"finish", (boolean)enableMulFactory, (Long)costTypeId, manuorgSet);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                String costaccountTip = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f", (String)"FinishCalWizardsEditPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(lockErrStr, lockErrStr.contains(costaccountTip) ? costAccName : orgName));
                return;
            }
            TaskHelper.startTask((IFormView)this.getView(), (IDataModel)this.getModel(), (Long)calcTaskConfigId, (String)calcParamJs.toString(), (String)"2");
        }
        catch (Exception e) {
            CalcMutexHelper.releaseMuteFromSet((String)"finish", (boolean)enableMulFactory, (Long)costTypeId, manuorgSet);
            throw new KDBizException(e.getMessage());
        }
    }

    private void doCheck() {
        if (!this.checkParaVilidator()) {
            return;
        }
        String checkParam = this.buildCalcParam(ScaCheckerWayEnum.CHECKERWAY_ONlY);
        if (CadEmptyUtils.isEmpty((String)checkParam)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6210\u672c\u5bf9\u8c61\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"FinishCalWizardsEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("cad_checktasksetting");
        lsp.setCustomParam("checktype", (Object)2);
        lsp.setCustomParam("calcParam", (Object)checkParam);
        lsp.setCustomParam("calType", (Object)"sca_finishcalwizards");
        lsp.setCaption(ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"FinishCalWizardsEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(lsp);
    }

    private String buildCalcParam(ScaCheckerWayEnum checkWay) {
        JSONObject calcParamJs = new JSONObject();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        calcParamJs.accumulate("org", org.getLong("masterid"));
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        calcParamJs.accumulate("costaccount", costAccount.getLong("masterid"));
        String calcVersion = (String)this.getModel().getValue("calcversion");
        calcParamJs.accumulate("calcVersion", (Object)calcVersion);
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            calcParamJs.accumulate("period", period.getLong("id"));
            calcParamJs.accumulate("startDate", (Object)TimeUtils.formatDate((Date)period.getDate("begindate"), (String)"yyyy-MM-dd HH:mm:ss"));
            calcParamJs.accumulate("endDate", (Object)TimeUtils.formatDate((Date)period.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        calcParamJs.accumulate("currencyId", currency.getLong("masterid"));
        Set<Long> costCenterSet = this.getCostCenterSet();
        Set<Long> manuorgSet = this.getManuorgSet();
        calcParamJs.accumulate("manuOrgIds", manuorgSet);
        List manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)CALC_PERM, (String)this.getView().getFormShowParameter().getAppId());
        calcParamJs.accumulate("manuOrgList", (Object)manuIdList);
        calcParamJs.accumulate("costcenters", costCenterSet);
        calcParamJs.accumulate("entrycostcenters", new HashSet(1));
        Set<Long> calcCostObjects = this.getCostObjectIds();
        if (CadEmptyUtils.isEmpty(calcCostObjects)) {
            return null;
        }
        calcParamJs.accumulate("costobjects", calcCostObjects);
        Map<String, Long> ccAndCoInfos = this.getCCAndCoInfos();
        calcParamJs.accumulate("ccAndCoInfos", ccAndCoInfos);
        calcParamJs.accumulate("checkway", (Object)checkWay.getValue());
        calcParamJs.accumulate("matCalType", (Object)"3");
        calcParamJs.accumulate("mfgCalType", (Object)"4");
        calcParamJs.accumulate("costtypeid", (Object)CalcMutexHelper.getCostTypeIdBy((Object)costAccount.getLong("masterid")));
        calcParamJs.accumulate("maxDiffRate", this.getModel().getValue("maxrate"));
        calcParamJs.accumulate("minDiffRate", this.getModel().getValue("minrate"));
        return calcParamJs.toString();
    }

    private Set<Long> getCostCenterSet() {
        HashSet costCenterSet = Sets.newHashSet();
        DynamicObjectCollection costCenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
            for (DynamicObject row : costCenters) {
                DynamicObject costcenter = row.getDynamicObject("fbasedataid");
                costCenterSet.add(costcenter.getLong("masterid"));
            }
        }
        return costCenterSet;
    }

    private Set<Long> getCostObjectIds() {
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObjectCollection costobjectinfos = this.getModel().getEntryEntity("entryentity");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costobjectinfos)) {
            for (int index = 0; index < costobjectinfos.size(); ++index) {
                DynamicObject rowobject = (DynamicObject)costobjectinfos.get(index);
                DynamicObject costobjectitem = (DynamicObject)rowobject.get("costobject");
                if (costobjectitem == null) continue;
                ids.add(costobjectitem.getLong("id"));
            }
        } else {
            return null;
        }
        return ids;
    }

    private Map<String, Long> getCCAndCoInfos() {
        HashMap<String, Long> ccAndcoInfos = new HashMap<String, Long>();
        DynamicObjectCollection costobjectinfos = this.getModel().getEntryEntity("entryentity");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costobjectinfos)) {
            for (int index = 0; index < costobjectinfos.size(); ++index) {
                DynamicObject rowobject = (DynamicObject)costobjectinfos.get(index);
                DynamicObject costcenteritem = (DynamicObject)rowobject.get("subcostcenter");
                if (CadEmptyUtils.isEmpty((DynamicObject)costcenteritem)) continue;
                if (!ccAndcoInfos.containsKey(costcenteritem.getString("masterid"))) {
                    ccAndcoInfos.put(costcenteritem.getString("masterid"), 1L);
                    continue;
                }
                Long costObjectCount = (Long)ccAndcoInfos.get(costcenteritem.getString("masterid"));
                costObjectCount = costObjectCount + 1L;
                ccAndcoInfos.put(costcenteritem.getString("masterid"), costObjectCount);
            }
        }
        return ccAndcoInfos;
    }

    private List<Long> getCostCenterIds(DynamicObjectCollection costcenters) {
        ArrayList<Long> costCenterIds = new ArrayList<Long>();
        for (DynamicObject row : costcenters) {
            DynamicObject costcenter = row.getDynamicObject("fbasedataid");
            costCenterIds.add(costcenter.getLong("masterid"));
        }
        return costCenterIds;
    }

    private void setCurrency() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private void setPeriod() {
        QFilter costaccountQF;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccount.getLong("id"))});
        if (sysCtrlEntity != null) {
            this.getModel().setValue("period", (Object)sysCtrlEntity.getLong("currentperiod"));
        }
    }

    private void setRelatedInfo(PropertyChangedArgs e) {
        DynamicObject costObject = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
            return;
        }
        int curIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject material = costObject.getDynamicObject("material");
        DynamicObject costcenter = costObject.getDynamicObject("costcenter");
        this.getModel().setValue("subcostcenter", (Object)costcenter, curIndex);
        material = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getLong("masterid"), (String)"bd_material");
        this.getModel().setValue("matnumber", (Object)material, curIndex);
        this.getModel().setValue("baseunit", (Object)material.getDynamicObject("baseunit"), curIndex);
        HashSet<Long> costObjectIds = new HashSet<Long>();
        costObjectIds.add(costObject.getLong("id"));
        DataSet costObjectInfos = this.getCostObjectRelateInfo(costObjectIds);
        for (Row row : costObjectInfos) {
            this.getModel().setValue("auxpty", (Object)row.getLong("auxpty"), curIndex);
            this.getModel().setValue("factnedqty", (Object)row.getBigDecimal("totalinqty"), curIndex);
            this.getModel().setValue("planyqyt", (Object)row.getBigDecimal("qty"), curIndex);
        }
    }

    private boolean conditionVilidator(String operName) {
        BigDecimal maxRate;
        QFilter costaccountQF;
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"FinishCalWizardsEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"FinishCalWizardsEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        DynamicObject period = this.getModel().getDataEntity().getDynamicObject("period");
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6838\u7b97\u671f\u95f4\u201d\u3002", (String)"FinishCalWizardsEditPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF = new QFilter("entry.costaccount", "=", (Object)costAccount.getLong("id"))});
        if (sysCtrlEntity != null && sysCtrlEntity.getLong("currentperiod") != period.getLong("id")) {
            this.getModel().setValue("period", (Object)sysCtrlEntity.getLong("currentperiod"));
            this.initCalcScope();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u671f\u95f4\u201d\u975e\u201c\u6210\u672c\u8d26\u8584\u201d\u7684\u5f53\u524d\u671f\u95f4\uff0c\u5237\u65b0\u6210\u5f53\u671f\u671f\u95f4\u5e76\u786e\u8ba4\u8ba1\u7b97\u8303\u56f4\u540e\u518d\u70b9\u51fb\u8ba1\u7b97\u3002", (String)"FinishCalWizardsEditPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccount.getLong("id"), (String)"cal_bd_costaccount");
        if (costaccountDyn == null || !costaccountDyn.getBoolean("enable")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FinishCalWizardsEditPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        boolean isInit = StartCostHelper.isInit((Long)((Long)costAccount.getPkValue()), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (!isInit) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u8d26\u7c3f\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"FinishCalWizardsEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entryentity"))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u201c\u6838\u7b97\u8303\u56f4\u201d\u6838\u7b97\u8303\u56f4\u65e0\u6570\u636e\u3002", (String)"FinishCalWizardsEditPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        BigDecimal minRate = this.getModel().getDataEntity().getBigDecimal("minrate");
        if (minRate.compareTo(maxRate = this.getModel().getDataEntity().getBigDecimal("maxrate")) > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u201c\u5dee\u5f02\u7387\u8303\u56f4\u201d\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"FinishCalWizardsEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), operName));
            return false;
        }
        return true;
    }

    private boolean checkParaVilidator() {
        String operName = ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002", (String)"FinishCalWizardsEditPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName);
    }

    private boolean calcParaVilidator() {
        if ("9999999999.0000".equals(this.getModel().getValue("minrate").toString())) {
            this.openTarskRecord();
            return false;
        }
        String operName = ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"FinishCalWizardsEditPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]);
        return this.conditionVilidator(operName);
    }

    private Set<Long> getCostObjectRange() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return null;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            return null;
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period == null) {
            return null;
        }
        DynamicObjectCollection costcenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
        List<Long> costCenters = this.getCostCenterIds(costcenters);
        CalcDataArgs args = new CalcDataArgs();
        args.setOrgId(org.get("id"));
        args.setCostAcctId(costAccount.getPkValue());
        args.setCostCenterIds(costCenters);
        Set<Long> manuorgSet = this.getManuorgSet();
        boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (enableMulFactory && CadEmptyUtils.isEmpty(this.getManuorgSet())) {
            return null;
        }
        args.setManuOrgIds(manuorgSet.size() > 0 ? manuorgSet : null);
        args.setPeriodId(period.get("id"));
        return FinishCalcHelper.getFinishedCostObject((CalcDataArgs)args);
    }

    private DataSet getCostObjectRelateInfo(Set<Long> costObjects) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return null;
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ArrayList<Long> costObjectListIds = null;
        costObjectListIds = costObjects != null ? new ArrayList<Long>(costObjects) : new ArrayList(1);
        Long orgId = org.getLong("masterid");
        QFilter coFilter = new QFilter("org", "=", (Object)orgId);
        coFilter.and("billstatus", "=", (Object)"C");
        DataSet csDataSet = InFilterHelper.queryDataSetIn((String)"cad_costobject", (String)"org,costcenter costcenterid,id costobjectid,material matmasterid,auxpty", (QFilter)coFilter, (String)"id", costObjectListIds);
        QFilter planFilter = new QFilter("accountorg", "=", (Object)orgId);
        planFilter.and("billstatus", "=", (Object)"C");
        planFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        planFilter.and("bizdate", "<=", (Object)period.getDate("enddate"));
        DataSet plannedDataSet = InFilterHelper.queryDataSetIn((String)"cad_plannedoutputbill", (String)"costobject,baseunit,qty", (QFilter)planFilter, (String)"costobject", costObjectListIds);
        plannedDataSet = plannedDataSet.groupBy(new String[]{"costobject"}).max("baseunit").sum("qty").finish();
        csDataSet = csDataSet.leftJoin(plannedDataSet).on("costobjectid", "costobject").select(new String[]{"org", "costcenterid", "costobjectid", "matmasterid", "auxpty"}, new String[]{"baseunit", "qty"}).finish();
        QFilter factFilter = new QFilter("org", "=", (Object)orgId);
        factFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        factFilter.and("billstatus", "=", (Object)"C");
        factFilter.and("bookdate", "<=", (Object)period.getDate("enddate"));
        DataSet factnedDataSet = InFilterHelper.queryDataSetIn((String)"cad_factnedoutputbill", (String)"entryentity.costobject costobject,entryentity.qty totalinqty", (QFilter)factFilter, (String)"entryentity.costobject", costObjectListIds);
        factnedDataSet = factnedDataSet.groupBy(new String[]{"costobject"}).sum("totalinqty").finish();
        csDataSet = csDataSet.leftJoin(factnedDataSet).on("costobjectid", "costobject").select(new String[]{"org", "costcenterid", "costobjectid", "matmasterid", "baseunit", "auxpty", "qty"}, new String[]{"totalinqty"}).finish();
        logger.info("\u5b8c\u5de5\u8ba1\u7b97-\u83b7\u53d6\u5b8c\u5de5\u8303\u56f4\u5bf9\u5e94\u7684\u8ba1\u5212\u548c\u5b8c\u5de5\u6570\u91cf\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return csDataSet;
    }

    private void loadUserSetting() {
        Map map;
        String josnStr;
        int length;
        String userId = RequestContext.get().getUserId();
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(userId))};
        DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"finishcalwizardsrate,condition", (QFilter[])filters);
        if (userDataRecord == null || userDataRecord.getString("finishcalwizardsrate").trim().isEmpty()) {
            return;
        }
        String rate = userDataRecord.getString("finishcalwizardsrate");
        String[] rates = rate.split(",");
        if (rates.length == (length = 2)) {
            this.getModel().setValue("minrate", (Object)rates[0]);
            this.getModel().setValue("maxrate", (Object)rates[1]);
        }
        if (StringUtils.isNotEmpty((String)(josnStr = userDataRecord.getString("condition"))) && (map = CadUserDataRecordHelper.fromJSONString((String)josnStr)).get("orgId") != null) {
            List ids;
            Long orgId = (Long)map.get("orgId");
            DynamicObject orgDyo = (DynamicObject)this.getModel().getValue("org");
            if (orgDyo != null && orgDyo.getLong("id") == orgId.longValue() && map.get("costCenterIds") != null && (ids = (List)map.get("costCenterIds")).size() > 0) {
                this.getModel().setValue("costcenter", (Object)ids.toArray());
            }
        }
    }

    private void saveUserSetting() {
        try {
            BigDecimal minRate = this.getModel().getDataEntity().getBigDecimal("minrate");
            BigDecimal maxRate = this.getModel().getDataEntity().getBigDecimal("maxrate");
            if (minRate != null && maxRate != null) {
                String finishCalWizardsRate = String.format("%s,%s", minRate.toString(), maxRate.toString());
                QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())};
                DynamicObject idInfo = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"id", (QFilter[])filters);
                Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
                DynamicObjectCollection costcenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
                List<Long> costCenterIds = this.getCostCenterIds(costcenters);
                Set<Long> manuorgSet = this.getManuorgSet();
                Map saveMap = CadUserDataRecordHelper.toMap((Long)orgId, costCenterIds, new ArrayList<Long>(manuorgSet));
                String saveJson = CadUserDataRecordHelper.toJSONString((Map)saveMap);
                if (idInfo == null) {
                    DynamicObject userDataRecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_userdatarecord");
                    userDataRecord.set("modifytime", (Object)new Date());
                    userDataRecord.set("user", (Object)RequestContext.get().getUserId());
                    userDataRecord.set("finishcalwizardsrate", (Object)finishCalWizardsRate);
                    userDataRecord.set("condition", (Object)saveJson);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userDataRecord});
                    return;
                }
                DynamicObject userDataRecord = BusinessDataServiceHelper.loadSingle((Object)idInfo.getLong("id"), (String)"cad_userdatarecord");
                userDataRecord.set("finishcalwizardsrate", (Object)finishCalWizardsRate);
                userDataRecord.set("condition", (Object)saveJson);
                SaveServiceHelper.update((DynamicObject)userDataRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u6570\u636e\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    private void setOrgByCostAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        DynamicObject account = (DynamicObject)this.getModel().getValue("costaccount");
        if (account == null) {
            return;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle((Object)account.getPkValue(), (String)"cal_bd_costaccount");
        this.getModel().setValue("org", costAccount != null ? Long.valueOf(costAccount.getLong("calorg.id")) : null);
    }

    private void openTarskRecord() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId("sca_taskrecord");
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void setManuorg() {
        Object accountorg = this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)((DynamicObject)accountorg).getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
            List manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)((DynamicObject)accountorg).getPkValue()), (String)this.getBillEntityId(), (String)CALC_PERM, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            if (!CadEmptyUtils.isEmpty((List)manuIdList)) {
                this.getModel().setValue("manuorg", (Object)manuIdList.toArray());
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            this.getModel().setValue("manuorg", null);
        }
    }
}

