/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.card;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Button;
import kd.bos.form.control.Vector;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.sca.common.helper.FinishCardHelper;

abstract class AbstractSubeleOffsetCardPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(AbstractSubeleOffsetCardPlugin.class);
    protected String diffType;

    AbstractSubeleOffsetCardPlugin() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{"setting", "cancel", "save"});
    }

    public void click(EventObject e) {
        super.click(e);
        if (e.getSource() instanceof Vector) {
            this.toggleSetFlex();
        } else if (e.getSource() instanceof Button) {
            Button btn = (Button)e.getSource();
            switch (btn.getKey()) {
                case "cancel": {
                    this.toggleSetFlex();
                    break;
                }
                case "save": {
                    this.save();
                }
            }
        }
    }

    protected void toggleSetFlex() {
        boolean show = true;
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("setflex"))) {
            this.getPageCache().remove("setflex");
            show = false;
        } else {
            this.getPageCache().put("setflex", "1");
        }
        this.getView().setVisible(Boolean.valueOf(show), new String[]{"setflex"});
        this.getView().setEnable(Boolean.valueOf(!show), new String[]{"content", "datetype", "daterange"});
    }

    private boolean check() {
        DynamicObject item = this.getModel().getDataEntity();
        BigDecimal leftOffset = item.getBigDecimal("leftoffset");
        if (leftOffset == null || leftOffset.doubleValue() > 0.0 || leftOffset.doubleValue() < -1.0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u7387\u504f\u5dee\u8303\u56f4\u5de6\u8f93\u5165\u503c\u533a\u95f4\u4e3a\u3010-1,0\u3011", (String)(((Object)((Object)this)).getClass().getSimpleName() + "AbstractSubeleOffsetCardPlugin_0"), (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        BigDecimal rightOffset = item.getBigDecimal("rightoffset");
        if (rightOffset == null || rightOffset.doubleValue() > 1.0 || rightOffset.doubleValue() < 0.0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u7387\u504f\u5dee\u8303\u56f4\u53f3\u8f93\u5165\u503c\u533a\u95f4\u4e3a\u30100,1\u3011", (String)(((Object)((Object)this)).getClass().getSimpleName() + "AbstractSubeleOffsetCardPlugin_1"), (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        BigDecimal offsetRate = item.getBigDecimal("offsetrate");
        if (offsetRate == null || offsetRate.doubleValue() > 2.0 || offsetRate.doubleValue() < 0.0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76d1\u63a7\u6bd4\u4f8b\u8f93\u5165\u503c\u533a\u95f4\u4e3a\u30100,2\u3011", (String)(((Object)((Object)this)).getClass().getSimpleName() + "AbstractSubeleOffsetCardPlugin_2"), (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void save() {
        if (!this.check()) {
            return;
        }
        QFilter filter = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        filter.and("difftype", "=", (Object)this.diffType);
        DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"sca_userfinishoffset", (String)"id,user,difftype,leftoffset,rightoffset,offsetrate", (QFilter[])new QFilter[]{filter});
        if (item == null) {
            item = BusinessDataServiceHelper.newDynamicObject((String)"sca_userfinishoffset");
        }
        item.set("user", (Object)RequestContext.get().getUserId());
        item.set("leftoffset", this.getModel().getValue("leftoffset"));
        item.set("rightoffset", this.getModel().getValue("rightoffset"));
        item.set("offsetrate", this.getModel().getValue("offsetrate"));
        item.set("difftype", (Object)this.diffType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{item});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)(((Object)((Object)this)).getClass().getSimpleName() + "AbstractSubeleOffsetCardPlugin_3"), (String)"macc-sca-form", (Object[])new Object[0]));
        this.toggleSetFlex();
        this.getView().invokeOperation("refresh");
    }

    public void afterCreateNewData(EventObject e) {
        this.initOffsetInfo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"daterange", "setflex"});
        this.query("2");
    }

    protected void initOffsetInfo() {
        DynamicObject item = FinishCardHelper.getUserOffset(this.diffType);
        if (item != null) {
            this.getModel().setValue("leftoffset", (Object)item.getBigDecimal("leftoffset"));
            this.getModel().setValue("rightoffset", (Object)item.getBigDecimal("rightoffset"));
            this.getModel().setValue("offsetrate", (Object)item.getBigDecimal("offsetrate"));
        } else {
            this.getModel().setValue("leftoffset", (Object)new BigDecimal("-0.03"));
            this.getModel().setValue("rightoffset", (Object)new BigDecimal("0.03"));
            this.getModel().setValue("offsetrate", (Object)new BigDecimal("0.06"));
        }
    }

    protected void drawpie(String chartAp, ItemValue item, String chartName) {
        PieChart pieChart = (PieChart)this.getControl(chartAp);
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(chartName);
        ItemValue[] items = new ItemValue[]{item};
        series.setData(items);
        pieChart.setShowTitle(false);
        pieChart.setShowLegend(false);
        pieChart.setLegendVertical(false);
        pieChart.setTitlePropValue("x", (Object)200);
        pieChart.setTitlePropValue("y", (Object)3);
        Label label = new Label();
        label.setFormatter("{b}:{c}({d}%)");
        label.setPosition(Position.insideTopRight);
        label.setShow(false);
        series.setLabel(label);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#7F93BC");
        map.put("fontSize", 20);
        map.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", map);
        map = new HashMap();
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>();
        map.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map);
        int[] points = new int[]{200, 400};
        series.setRadius("55");
        pieChart.setLegendPropValue("right", (Object)"20");
        pieChart.setLegendPropValue("top", (Object)"30");
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.bindData((BindingContext)null);
    }

    protected List<QFilter> getOrgFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        try {
            DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
            DynamicObject org = parentData.getDynamicObject("org");
            if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
                filters.add(new QFilter("org", "=", org.getPkValue()));
            } else {
                filters.add(new QFilter("org", "=", (Object)-1));
            }
            DynamicObject acct = parentData.getDynamicObject("costaccount");
            if (!CadEmptyUtils.isEmpty((DynamicObject)acct)) {
                filters.add(new QFilter("costaccount", "=", acct.getPkValue()));
            } else {
                filters.add(new QFilter("costaccount", "=", (Object)-1));
            }
            DynamicObject cc = parentData.getDynamicObject("costcenter");
            if (!CadEmptyUtils.isEmpty((DynamicObject)cc)) {
                filters.add(new QFilter("costcenter", "=", cc.getPkValue()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return filters;
    }

    protected abstract DataSet queryData(String var1);

    private void query(String dateType) {
        DataSet dataSet = this.queryData(dateType);
        dataSet = dataSet.groupBy("costobject".split(",")).sum("totalamount").sum("stdamount").finish();
        BigDecimal leftOffset = this.getModel().getDataEntity().getBigDecimal("leftoffset");
        BigDecimal rightOffset = this.getModel().getDataEntity().getBigDecimal("rightoffset");
        BigDecimal offsetRate = this.getModel().getDataEntity().getBigDecimal("offsetrate");
        int red = 0;
        int yellow = 0;
        int green = 0;
        for (Row row : dataSet) {
            BigDecimal totalAmount = row.getBigDecimal("totalamount");
            BigDecimal stdAmount = row.getBigDecimal("stdamount");
            if (stdAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal diffRate = totalAmount.subtract(stdAmount).divide(stdAmount, 4).setScale(2, 4);
            double diff = 0.0;
            double diffRateValue = diffRate.doubleValue();
            if (diffRateValue < 0.0) {
                diff = diffRateValue - leftOffset.doubleValue();
                diff = diff > 0.0 ? 0.0 : Math.abs(diff);
            } else {
                diff = diffRateValue - rightOffset.doubleValue();
                double d = diff = diff < 0.0 ? 0.0 : diff;
            }
            if (BigDecimal.valueOf(diff).compareTo(BigDecimal.ZERO) == 0) {
                ++green;
                continue;
            }
            if (diff >= offsetRate.doubleValue()) {
                ++red;
                continue;
            }
            ++yellow;
        }
        ItemValue item1 = new ItemValue(ResManager.loadKDString((String)"\u4e25\u91cd\u504f\u5dee", (String)"AbstractSubeleOffsetCardPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), (Number)red, "#FB2323");
        ItemValue item2 = new ItemValue(ResManager.loadKDString((String)"\u8f7b\u5ea6\u504f\u5dee", (String)"AbstractSubeleOffsetCardPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), (Number)yellow, "#FF991C");
        ItemValue item3 = new ItemValue(ResManager.loadKDString((String)"\u65e0\u504f\u5dee", (String)"AbstractSubeleOffsetCardPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), (Number)green, "#1BA854");
        this.drawpie("piechartap", item1, "");
        this.drawpie("piechartap1", item2, "");
        this.drawpie("piechartap2", item3, "");
        double total = red + green + yellow;
        if (BigDecimal.valueOf(total).compareTo(BigDecimal.ZERO) == 0) {
            total = 1.0;
        }
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getControl("labelap");
        label.setText(String.format("%s\uff08%.2f%%\uff09", red, (double)red / total * 100.0));
        kd.bos.form.control.Label label1 = (kd.bos.form.control.Label)this.getControl("labelap1");
        label1.setText(String.format("%s\uff08%.2f%%\uff09", yellow, (double)yellow / total * 100.0));
        kd.bos.form.control.Label label2 = (kd.bos.form.control.Label)this.getControl("labelap2");
        label2.setText(String.format("%s\uff08%.2f%%\uff09", green, (double)green / total * 100.0));
    }

    protected Map<String, Object> getDateRange(String dateType) {
        Date startDay = null;
        Date endDay = null;
        switch (dateType) {
            case "1": {
                Date lastDay = DateUtils.getLastDay((Date)new Date());
                startDay = DateUtils.getDayStartTime((Date)lastDay);
                endDay = DateUtils.getDayEndTime((Date)lastDay);
                break;
            }
            case "2": {
                Date currDay = new Date();
                startDay = DateUtils.getDayStartTime((Date)currDay);
                endDay = DateUtils.getDayEndTime((Date)currDay);
                break;
            }
            case "3": {
                startDay = DateUtils.getDayStartTime((Date)DateUtils.getThisMonthFirstDay());
                endDay = DateUtils.getDayEndTime((Date)DateUtils.getThisMonthEndDay());
                break;
            }
            case "4": {
                Date sd = this.getModel().getDataEntity().getDate("daterange_startdate");
                Date ed = this.getModel().getDataEntity().getDate("daterange_enddate");
                startDay = DateUtils.getDayStartTime((Date)sd);
                endDay = DateUtils.getDayEndTime((Date)ed);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("start", startDay);
        map.put("end", endDay);
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (proName = e.getProperty().getName()) {
            case "datetype": {
                String str = (String)newValue;
                if (!"4".equals(str)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"daterange"});
                    this.query(str);
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"daterange"});
                break;
            }
            case "daterange_startdate": {
                this.query("4");
                break;
            }
            case "daterange_enddate": {
                this.query("4");
            }
        }
    }
}

