/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.card;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeMenu;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeMenuClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AppHomePlugin
extends AbstractFormPlugin
implements TabSelectListener,
TreeMenuClickListener {
    public void initialize() {
        Tab tab;
        super.initialize();
        Tab apptabs = (Tab)this.getView().getControl("_submaintab_");
        if (apptabs != null) {
            apptabs.addTabSelectListener((TabSelectListener)this);
        }
        if ((tab = (Tab)this.getView().getParentView().getControl("tabap")) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            List<Long> orgList = this.getCurrAccountOrg();
            qList.add(new QFilter("id", "in", orgList));
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"AppHomePlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                qList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
                qList.add(new QFilter("calorg", "=", (Object)accountorg.getLong("id")));
                qList.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)Long.valueOf(accountorg.getPkValue().toString()), (String)this.getView().getFormShowParameter().getAppId()));
            }
        });
        BasedataEdit costcent = (BasedataEdit)this.getControl("costcenter");
        costcent.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountorg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u6210\u672c\u4e2d\u5fc3\u3002", (String)"AppHomePlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter costcenterFilter = new QFilter("accountorg", "=", (Object)accountorg.getLong("id"));
                qList.add(costcenterFilter);
            }
        });
        TreeMenu tree = (TreeMenu)this.getView().getControl("navigationbar");
        tree.addTreeMenuClickListener((TreeMenuClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
            Long orgId = RequestContext.get().getOrgId();
            if (!CadEmptyUtils.isEmpty((List)hasPermOrgIdsByOrgViewType) && hasPermOrgIdsByOrgViewType.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
            }
            this.setCostaccount();
            this.getModel().setValue("costcenter", null);
        }
    }

    private List<Long> getCurrAccountOrg() {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty((List)permOrgIds) && CadEmptyUtils.isEmpty((List)orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        return orgIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "org": {
                this.setCostaccount();
                this.getModel().setValue("costcenter", null);
                this.refreshView();
                break;
            }
            case "costaccount": {
                this.refreshView();
                break;
            }
            case "costcenter": {
                this.refreshView();
            }
        }
    }

    private void setCostaccount() {
        IDataModel model = this.getModel();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        model.setValue("costcenter", null);
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        Long orgId = org.getLong("id");
        model.setValue("costaccount", (Object)StartCostHelper.getCostAccountByAccoutOrg((Long)orgId, (String)this.getView().getFormShowParameter().getAppId()));
        this.getView().updateView("costaccount");
    }

    public void tabSelected(TabSelectEvent event) {
        if (event.getTabKey().equals("appmiantab") || event.getTabKey().equals("tabpageap")) {
            this.refreshView();
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap(16);
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void treeMenuClick(TreeNodeEvent arg0) {
    }

    public void treeMenuDoubleClick(TreeNodeEvent arg0) {
    }
}

