/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.card;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class GardHomePlugin
extends AbstractFormPlugin {
    public static final String ACCOUNTORG = "accountorg";
    public static final String CLOSESTATU = "closestatu";
    public static final String COSTSTATUS = "costobject.bizstatus";
    public static final String ALLOCSTATUS = "allocstatus";

    protected DynamicObject getCostAccount() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        if (!parentView.getModel().getDataEntity().containsProperty("costaccount")) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("costaccount");
    }

    protected DynamicObject getOrg() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        if (!parentView.getModel().getDataEntity().containsProperty("org")) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("org");
    }

    protected DynamicObject getCostCenter() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        if (!parentView.getModel().getDataEntity().containsProperty("costcenter")) {
            return null;
        }
        return (DynamicObject)parentView.getModel().getValue("costcenter");
    }

    protected int getCount(String entityName, List<QFilter> qFilters) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)query)) {
            return 0;
        }
        return query.size();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        this.showVoucherList(this.getEntityName(key), key);
    }

    private String getEntityName(String key) {
        String entityName = "";
        switch (key) {
            case "monthnewnum": 
            case "unauditnum": 
            case "unaccountnum": {
                if ("sca_finishprodcard".equals(this.getView().getFormShowParameter().getFormId()) || "aca_finishprodcard".equals(this.getView().getFormShowParameter().getFormId())) {
                    entityName = "cad_factnedoutputbill";
                    break;
                }
                entityName = "cad_plannedoutputbill";
                break;
            }
            case "accountnum": {
                entityName = "sca_costconfirm";
                break;
            }
            case "unconfirmnum": 
            case "unallocnum": {
                if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
                    entityName = "aca_matalloc";
                    break;
                }
                entityName = "sca_matalloc";
                break;
            }
            case "unfeeallocnum": 
            case "unfeeconfirmnum": {
                entityName = "cad_mfgfeeallocco";
            }
        }
        return entityName;
    }

    protected void showVoucherList(String entityName, String type) {
        DynamicObject costCenter;
        DynamicObject costAccount;
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(entityName);
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        para.setCustomParam("source", (Object)"GardHomePlugin");
        DynamicObject org = this.getOrg();
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            para.setCustomParam("org", org.getPkValue());
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getCostAccount()))) {
            para.setCustomParam("costaccount", costAccount.getPkValue());
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costCenter = this.getCostCenter()))) {
            para.setCustomParam("costcenter", costCenter.getPkValue());
        }
        switch (type) {
            case "monthnewnum": {
                para.setCustomParam("bizdate", (Object)"63");
                break;
            }
            case "unconfirmnum": 
            case "unfeeconfirmnum": {
                para.setCustomParam(ALLOCSTATUS, (Object)new String[]{"0", "1"});
                break;
            }
            case "unallocnum": 
            case "unfeeallocnum": {
                para.setCustomParam(ALLOCSTATUS, (Object)new String[]{"0"});
                break;
            }
            case "accountnum": {
                para.setCustomParam("bizstatus", (Object)"A");
            }
        }
        para.setCustomParam("filter", (Object)this.getFilters(entityName, type).toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    protected void setValue(String type) {
        Label label = new Label();
        label = (Label)this.getView().getControl(type);
        String entityName = this.getEntityName(type);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(this.getFilters(entityName, type));
        int count = this.getCount(entityName, qFilters);
        label.setText(Integer.toString(count));
    }

    protected QFilter getFilters(String entityName, String type) {
        DynamicObject org = this.getOrg();
        DynamicObject costCenter = this.getCostCenter();
        DynamicObject costAccount = this.getCostAccount();
        QFilter baseFilter = null;
        QFilter accountOrgFilter = null;
        QFilter baseBillCostCenterFilter = null;
        QFilter baseBillOrgFilter = null;
        QFilter baseBillCostAccountFilter = null;
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            accountOrgFilter = new QFilter(ACCOUNTORG, "=", org.getPkValue());
            baseBillOrgFilter = new QFilter("org", "=", org.getPkValue());
        } else {
            accountOrgFilter = new QFilter(ACCOUNTORG, "=", (Object)-1L);
            baseBillOrgFilter = new QFilter("org", "=", (Object)-1L);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
            baseBillCostCenterFilter = new QFilter("costcenter", "=", costCenter.getPkValue());
        }
        baseBillCostAccountFilter = !CadEmptyUtils.isEmpty((DynamicObject)costAccount) ? new QFilter("costaccount", "=", costAccount.getPkValue()) : new QFilter("costaccount", "=", (Object)-1L);
        Long orgId = org == null ? 0L : org.getLong("id");
        Long costAccountId = costAccount == null ? 0L : costAccount.getLong("id");
        switch (type) {
            case "monthnewnum": {
                Long curPeriod = this.getCurPeriod(orgId, costAccountId);
                Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)curPeriod);
                if ("cad_plannedoutputbill".equals(entityName)) {
                    baseFilter = new QFilter("bizdate", "<=", dates == null ? null : dates[1]);
                    baseFilter = baseFilter.and(new QFilter("bizdate", ">=", dates == null ? null : dates[0]));
                    baseFilter = baseFilter.and(accountOrgFilter);
                } else {
                    baseFilter = new QFilter("bookdate", "<=", dates == null ? null : dates[1]);
                    baseFilter = baseFilter.and(new QFilter("bookdate", ">=", dates == null ? null : dates[0]));
                    baseFilter = baseFilter.and(baseBillOrgFilter);
                }
                if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    baseFilter = baseFilter.and(baseBillCostCenterFilter);
                }
                baseFilter.and(appNumFilter);
                break;
            }
            case "unauditnum": {
                Long curPeriod = this.getCurPeriod(orgId, costAccountId);
                Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)curPeriod);
                if ("cad_plannedoutputbill".equals(entityName)) {
                    baseFilter = new QFilter("bizdate", "<=", dates == null ? null : dates[1]);
                    baseFilter = baseFilter.and(new QFilter("bizdate", ">=", dates == null ? null : dates[0]));
                    baseFilter = baseFilter.and(accountOrgFilter);
                } else {
                    baseFilter = new QFilter("bookdate", "<=", dates == null ? null : dates[1]);
                    baseFilter = baseFilter.and(new QFilter("bookdate", ">=", dates == null ? null : dates[0]));
                    baseFilter = baseFilter.and(baseBillOrgFilter);
                }
                if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    baseFilter = baseFilter.and(baseBillCostCenterFilter);
                }
                baseFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
                baseFilter.and(appNumFilter);
                break;
            }
            case "unaccountnum": {
                baseFilter = new QFilter(COSTSTATUS, "=", (Object)"A").and(new QFilter(CLOSESTATU, "=", (Object)Boolean.FALSE));
                baseFilter = baseFilter.and(accountOrgFilter);
                if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    baseFilter = baseFilter.and(baseBillCostCenterFilter);
                }
                baseFilter.and(appNumFilter);
                break;
            }
            case "accountnum": {
                baseFilter = new QFilter("bizstatus", "=", (Object)"A");
                baseFilter = baseFilter.and(baseBillOrgFilter);
                baseFilter = baseFilter.and(baseBillCostAccountFilter);
                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) break;
                baseFilter = baseFilter.and(baseBillCostCenterFilter);
                break;
            }
            case "unconfirmnum": {
                baseFilter = new QFilter(ALLOCSTATUS, "!=", (Object)"2");
                baseFilter = baseFilter.and(baseBillOrgFilter);
                baseFilter = baseFilter.and(baseBillCostAccountFilter);
                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) break;
                baseFilter = baseFilter.and(baseBillCostCenterFilter);
                break;
            }
            case "unallocnum": {
                baseFilter = new QFilter(ALLOCSTATUS, "=", (Object)"0");
                baseFilter = baseFilter.and(baseBillOrgFilter);
                baseFilter = baseFilter.and(baseBillCostAccountFilter);
                if (CadEmptyUtils.isEmpty((DynamicObject)costCenter)) break;
                baseFilter = baseFilter.and(baseBillCostCenterFilter);
                break;
            }
            case "unfeeallocnum": {
                baseFilter = new QFilter(ALLOCSTATUS, "=", (Object)"0");
                baseFilter = baseFilter.and(baseBillOrgFilter);
                baseFilter = baseFilter.and(baseBillCostAccountFilter);
                if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    baseFilter = baseFilter.and(new QFilter("benefcostcenter", "=", costCenter.getPkValue()));
                }
                baseFilter.and(appNumFilter);
                break;
            }
            case "unfeeconfirmnum": {
                baseFilter = new QFilter(ALLOCSTATUS, "!=", (Object)"2");
                baseFilter = baseFilter.and(baseBillOrgFilter);
                baseFilter = baseFilter.and(baseBillCostAccountFilter);
                if (!CadEmptyUtils.isEmpty((DynamicObject)costCenter)) {
                    baseFilter = baseFilter.and(new QFilter("benefcostcenter", "=", costCenter.getPkValue()));
                }
                baseFilter.and(appNumFilter);
            }
        }
        return baseFilter;
    }

    private Long getCurPeriod(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("entry.costaccount", "=", (Object)costAccountId);
        filter.and(new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("entry.startperiod", "!=", (Object)0L));
        filter.and(new QFilter("entry.startperiod", "is not null", (Object)"null"));
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])new QFilter[]{filter});
        if (curPeriod == null) {
            return 0L;
        }
        return curPeriod.getLong("currentperiod");
    }
}

