/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.checkdata;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;

public class CheckDataTaskFormPlugin
extends AbstractFormPlugin {
    private Long[] ownAutoCreate = new Long[]{926865302531120128L, 926865987427408896L, 926866951244913664L, 926869120564108288L, 932490687176303616L, 932491990497551360L};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initNumber();
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit checkItem = (BasedataEdit)this.getControl("checkitem");
        checkItem.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
            Set<Object> itemIds = this.getExistsCheckItem();
            if (itemIds.size() > 0) {
                qList.add(new QFilter("id", "not in", itemIds));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "checkitem": {
                this.updateLevel(e);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("bar_run".equals(evt.getItemKey()) && "0".equals(this.getModel().getValue("status"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u68c0\u67e5\u4efb\u52a1\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u8fd0\u884c\u3002", (String)"CheckDataTaskFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_viewresult".equals(key)) {
            this.showResultView();
        }
    }

    private void updateLevel(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject checkItem = (DynamicObject)this.getModel().getValue("checkitem", rowIndex);
        if (checkItem == null) {
            return;
        }
        Long itemId = (Long)checkItem.getPkValue();
        List<Long> ownCreate = Arrays.asList(this.ownAutoCreate);
        if (!ownCreate.contains(itemId)) {
            this.getModel().setValue("level", (Object)"A", rowIndex);
        }
    }

    private void showResultView() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_list");
        param.setBillFormId("sca_datacheckresult");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("planids", (Object)new Object[]{this.getModel().getValue("id")});
        this.getView().showForm((FormShowParameter)param);
    }

    private Set<Object> getExistsCheckItem() {
        HashSet<Object> itemIds = new HashSet<Object>();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject en : entry) {
            DynamicObject item = en.getDynamicObject("checkitem");
            if (item == null) continue;
            itemIds.add(item.getPkValue());
        }
        return itemIds;
    }

    private void initNumber() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            DynamicObject dataCheckTask = BusinessDataServiceHelper.newDynamicObject((String)"sca_datachecktask");
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"sca_datachecktask", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_datachecktask"), null);
            if (codeRuleInfo != null) {
                this.getModel().setValue("number", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dataCheckTask));
            }
        }
    }
}

