/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.closeaccount;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.param.AppParam;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.business.account.CostCloseAccountFacade;
import kd.macc.sca.common.closeaccount.CostCloseAccountParam;

public class CostCloseAccountPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CostCloseAccountPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
        toolbarap.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        switch (itemKey) {
            case "btn_closeaccount": {
                if (selectedRowIndexs.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"CostCloseAccountPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "btn_uncloseaccount": {
                if (selectedRowIndexs.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"CostCloseAccountPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_closeaccount": {
                if (!this.isHasPermission("/O6GR+6VXPQ2")) {
                    return;
                }
                this.closeAccount();
                break;
            }
            case "btn_uncloseaccount": {
                if (!this.isHasPermission("/O6GVID5/Q7Z")) {
                    return;
                }
                this.undoCloseAccount();
                break;
            }
            case "btn_refresh": {
                this.initData(null);
            }
        }
    }

    private boolean isHasPermission(String permItem) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"sca_closeaccount", (String)permItem);
        if (orgPermission == null) {
            return true;
        }
        return orgPermission.size() != 0 && orgPermission.contains(RequestContext.get().getOrgId());
    }

    private void closeAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        CostCloseAccountParam[] params = this.buildCloseAccountParams(selectedRowIndexs);
        CostCloseAccountFacade costCloseAccountFacade = new CostCloseAccountFacade();
        Map resultMap = costCloseAccountFacade.doCloseAccount(params);
        this.updateEntryResult(selectedRowIndexs, resultMap, true);
    }

    private void undoCloseAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        CostCloseAccountParam[] params = this.buildCloseAccountParams(selectedRowIndexs);
        CostCloseAccountFacade costCloseAccountFacade = new CostCloseAccountFacade();
        Map resultMap = costCloseAccountFacade.undoCloseAccount(params);
        this.updateEntryResult(selectedRowIndexs, resultMap, false);
    }

    private void updateEntryResult(int[] selectedRowIndexs, Map<String, String> resultMap, boolean isClose) {
        String successResult = "A";
        String failResult = "B";
        if (!isClose) {
            successResult = "C";
            failResult = "D";
        }
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndexs[i]);
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg", selectedRowIndexs[i]);
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndexs[i]);
            String key = calorg.getString("id") + "&" + manuorg.getString("id") + "&" + costaccount.getString("id");
            if (resultMap.containsKey(key)) {
                this.getModel().setValue("result", (Object)failResult, selectedRowIndexs[i]);
                this.getModel().setValue("log", (Object)resultMap.get(key), selectedRowIndexs[i]);
                continue;
            }
            if (isClose) {
                this.getModel().setValue("closeperiod", this.getModel().getValue("currentperiod", selectedRowIndexs[i]), selectedRowIndexs[i]);
            } else {
                this.getModel().setValue("closeperiod", null, selectedRowIndexs[i]);
            }
            this.getModel().setValue("result", (Object)successResult, selectedRowIndexs[i]);
            this.getModel().setValue("log", null, selectedRowIndexs[i]);
        }
    }

    private CostCloseAccountParam[] buildCloseAccountParams(int[] selectedRowIndexs) {
        CostCloseAccountParam[] params = new CostCloseAccountParam[selectedRowIndexs.length];
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            CostCloseAccountParam ccp = new CostCloseAccountParam();
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndexs[i]);
            ccp.setCalorg(calorg != null ? Long.valueOf(calorg.getLong("id")) : null);
            ccp.setCalorgName(calorg != null ? calorg.getString("name") : null);
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg", selectedRowIndexs[i]);
            ccp.setManuorg(manuorg != null ? Long.valueOf(manuorg.getLong("id")) : null);
            ccp.setManuorgName(manuorg != null ? manuorg.getString("name") : null);
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndexs[i]);
            ccp.setCostaccount(costaccount != null ? Long.valueOf(costaccount.getLong("id")) : null);
            ccp.setCostaccountName(costaccount != null ? costaccount.getString("name") : null);
            DynamicObject currentperiod = (DynamicObject)this.getModel().getValue("currentperiod", selectedRowIndexs[i]);
            ccp.setCloseperiod(currentperiod != null ? Long.valueOf(currentperiod.getLong("id")) : null);
            params[i] = ccp;
        }
        return params;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<Long> enableMultiFactoryOrgs = this.getEnableMultiFactoryOrgs();
        if (CadEmptyUtils.isEmpty(enableMultiFactoryOrgs)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u591a\u5de5\u5382\u6838\u7b97\uff0c\u4e0d\u9700\u8981\u5904\u7406\u6210\u672c\u5173\u8d26\u3002", (String)"CostCloseAccountPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.initData(enableMultiFactoryOrgs);
    }

    private void initData(List<Long> orgList) {
        Long currAcctOrg = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)currAcctOrg);
        if (orgList == null) {
            orgList = this.getEnableMultiFactoryOrgs();
        }
        if (CadEmptyUtils.isEmpty(orgList)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        DataSet costAccountDs = this.getStartCostAccountDs(orgList, "sca");
        long ds1EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e00\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds1EndTime - startTime));
        DataSet curPeriodDs = this.getCostAccountCurPeriod(orgList);
        long ds2EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e8c\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds2EndTime - ds1EndTime));
        DataSet produceOrgDs = this.getProduceOrgDs(orgList);
        long ds3EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e09\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds3EndTime - ds2EndTime));
        DataSet closeAccountTabDs = this.getCloseAccountTabDs(orgList);
        long ds4EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u56db\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds4EndTime - ds3EndTime));
        DataSet orgCostAccCurPeriodDs = costAccountDs.join(curPeriodDs).on("calorg", "calorg").on("costaccount", "costaccount").select(costAccountDs.getRowMeta().getFieldNames(), new String[]{"currentperiod"}).finish();
        DataSet tempDs = orgCostAccCurPeriodDs.join(produceOrgDs).on("calorg", "calorg").select(orgCostAccCurPeriodDs.getRowMeta().getFieldNames(), new String[]{"manuorg", "manuorgnum"}).finish();
        DataSet resultDs = tempDs.leftJoin(closeAccountTabDs).on("calorg", "calorg").on("manuorg", "manuorg").on("costaccount", "costaccount").select(tempDs.getRowMeta().getFieldNames(), new String[]{"closeperiod"}).finish().orderBy(new String[]{"org.number asc", "entryentity.costaccount.number asc", "manuorgnum asc"});
        long dsJoinEndTime = System.currentTimeMillis();
        logger.info(String.format("DataSet\u5173\u8054\u8017\u65f6(\u6beb\u79d2)\uff1a%d", dsJoinEndTime - ds4EndTime));
        this.initListData(resultDs);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u5217\u8868\u6570\u636e\u521d\u59cb\u5316\u8017\u65f6(\u6beb\u79d2)\uff1a%d", endTime - dsJoinEndTime));
    }

    private List<Long> getEnableMultiFactoryOrgs() {
        List<Long> orgList = new ArrayList<Long>(10);
        List<Long> permOrgIds = this.getAllPermOrgs();
        if (CadEmptyUtils.isEmpty(permOrgIds)) {
            return orgList;
        }
        orgList = OrgUnitServiceHelper.filterOrgDuty(permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty(orgList)) {
            return orgList;
        }
        QFilter orgFilter = new QFilter("org", "in", orgList);
        orgFilter.and(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"initData", (String)"sca_startstdcost", (String)"org", (QFilter[])new QFilter[]{orgFilter}, null);
        orgList.clear();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            orgList.add(row.getLong("org"));
        }
        if (CadEmptyUtils.isEmpty(orgList)) {
            return orgList;
        }
        AppParam appParam = new AppParam();
        appParam.setAppId("/KIUHEXROK3D");
        appParam.setViewType("10");
        Map orgEnableMultiFactoryMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, orgList);
        Iterator<Long> orgListIterator = orgList.iterator();
        while (orgListIterator.hasNext()) {
            Long orgId = orgListIterator.next();
            Map paramMap = (Map)orgEnableMultiFactoryMap.get(String.valueOf(orgId));
            if (paramMap != null && paramMap.get("multifactoryaccount") != null && ((Boolean)paramMap.get("multifactoryaccount")).booleanValue()) continue;
            orgListIterator.remove();
        }
        return orgList;
    }

    private void initListData(DataSet dataSet) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Iterator ite = dataSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            vs.set("calorg", (Object)row.getLong("calorg"), i);
            vs.set("manuorg", (Object)row.getLong("manuorg"), i);
            vs.set("costaccount", (Object)row.getLong("costaccount"), i);
            vs.set("currentperiod", (Object)row.getLong("currentperiod"), i);
            vs.set("closeperiod", (Object)row.getLong("closeperiod"), i);
            ++i;
        }
        if (vs.getCount() > 0) {
            this.getModel().deleteEntryData("entryentity");
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        }
    }

    private List<Long> getAllPermOrgs() {
        String appId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)"sca_closeaccount", (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            List permCalOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
            return permCalOrgIds;
        }
        return rs.getHasPermOrgs();
    }

    public DataSet getStartCostAccountDs(List<Long> orgList, String appNum) {
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{appNumQF, orgFilter, isEnabledFilter, isInitFilter, enable};
        return QueryServiceHelper.queryDataSet((String)"CostCloseAccountPlugin.getStartCostAccountDs", (String)"sca_startstdcost", (String)"org as calorg,org.number,entryentity.costaccount as costaccount,entryentity.costaccount.number", (QFilter[])filters, (String)"org.number asc,entryentity.costaccount.number asc");
    }

    private DataSet getCostAccountCurPeriod(List<Long> orgList) {
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter[] filters = new QFilter[]{orgFilter};
        String selectedFields = "org as calorg,entry.costaccount as costaccount,entry.currentperiod as currentperiod";
        return QueryServiceHelper.queryDataSet((String)"CostCloseAccountPlugin.getCostAccountCurPeriod", (String)"cal_sysctrlentity", (String)selectedFields, (QFilter[])filters, null);
    }

    private DataSet getProduceOrgDs(List<Long> orgList) {
        DataSet produceOrgDs = null;
        for (int i = 0; i < orgList.size(); ++i) {
            boolean isProduce;
            Long orgId = orgList.get(i);
            List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)(isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04")));
            if (CadEmptyUtils.isEmpty((List)productOrgs)) continue;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CostCloseAccountPlugin.getProduceOrgDs", (String)"bos_org", (String)(orgId + " as calorg,id as manuorg,number as manuorgnum"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)productOrgs)}, null);
            produceOrgDs = produceOrgDs == null ? dataSet : produceOrgDs.union(dataSet);
        }
        return produceOrgDs;
    }

    private DataSet getCloseAccountTabDs(List<Long> orgList) {
        QFilter orgFilter = new QFilter("calorg", "in", orgList);
        return QueryServiceHelper.queryDataSet((String)"CostCloseAccountPlugin.getCloseAccountTabDs", (String)"sca_closeaccounttable", (String)"calorg,manuorg,costaccount,closeperiod", (QFilter[])orgFilter.toArray(), null);
    }
}

