/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.costreduction;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.constants.FactCostReductCalcCheck;
import kd.macc.sca.algox.utils.FactCostReductTaskHelper;
import kd.macc.sca.algox.utils.TaskHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class FinishFactCostReductPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FinishFactCostReductPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkresult", "btncalcrpt", "btnreductlevel", "btnreductitem"});
    }

    public void beforeBindData(EventObject e) {
        JSONArray calcManuOrgIds;
        super.beforeBindData(e);
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (CadEmptyUtils.isEmpty((String)customParam)) {
            return;
        }
        JSONObject json = JSONObject.fromObject((Object)customParam);
        Label labtime = (Label)this.getControl("labtime");
        Label labTimeText = (Label)this.getControl("labtimetext");
        long spendTimeOnSeconds = json.getLong("time");
        if (spendTimeOnSeconds >= 0L && spendTimeOnSeconds < 60L) {
            labtime.setText(String.valueOf(spendTimeOnSeconds));
            labTimeText.setText(ResManager.loadKDString((String)"\u79d2", (String)"FinishFactCostReductPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            labtime.setText(String.valueOf(spendTimeOnSeconds / 60L));
            labTimeText.setText(ResManager.loadKDString((String)"\u5206\u949f", (String)"FinishFactCostReductPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        Label labfailcount = (Label)this.getControl("labfailcount");
        labfailcount.setText(json.getString("failOrgCnt"));
        Label labcheckfail = (Label)this.getControl("labcheckfail");
        labcheckfail.setText(json.getString("checkFailCount"));
        Label labchecktip = (Label)this.getControl("labchecktip");
        labchecktip.setText(json.getString("checkTipCount"));
        Label labsuccesscount = (Label)this.getControl("labsuccesscount");
        labsuccesscount.setText(json.getString("sucOrgCnt"));
        Label labsuccesscocount = (Label)this.getControl("labsuccesscocount");
        labsuccesscocount.setText(json.getString("sucPrdCnt"));
        if ("0".equals(json.getString("checkFailCount")) && "0".equals(json.getString("checkTipCount")) && "0".equals(json.getString("failOrgCnt"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        if (!"0".equals(json.getString("failOrgCnt"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
        }
        if (CadEmptyUtils.isEmpty((String)json.getString("sucPrdCnt"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7"});
        }
        this.getModel().setValue("org", (Object)json.getLong("orgId"));
        JSONArray array = json.getJSONArray("relaCostAccountIds");
        if (array != null && array.size() > 0) {
            Object[] vals = new Object[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                vals[i] = array.getLong(i);
            }
            Map costaccountMaps = BusinessDataServiceHelper.loadFromCache((Object[])vals, (String)"cal_bd_costaccount");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject obj : costaccountMaps.values()) {
                sb.append(obj.getString("name")).append(";");
            }
            this.getModel().setValue("relacostaccount", (Object)sb.toString());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"relacostflexpanelap"});
        }
        this.getModel().setValue("costaccount", (Object)json.getLong("costAccountId"));
        this.getModel().setValue("period", (Object)json.getLong("periodId"));
        this.getPageCache().put("checkResultId", json.getString("checkResultId"));
        this.getPageCache().put("calcReportId", json.getString("calcReportId"));
        Long prdOrg = json.getLong("prdOrg");
        if (!CadEmptyUtils.isEmpty((Long)prdOrg)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap141"});
            this.getModel().setValue("manuorg", (Object)prdOrg);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap141"});
        }
        if (json.getInt("failOrgCnt") == 0 && !CadEmptyUtils.isEmpty((Long)prdOrg) && json.containsKey((Object)"calcManuOrgIds") && json.get("calcManuOrgIds") != JSONNull.getInstance() && (calcManuOrgIds = json.getJSONArray("calcManuOrgIds")).size() > 1) {
            ArrayList<Long> calcManuOrgIdList = new ArrayList<Long>(10);
            for (int i = 0; i < calcManuOrgIds.size(); ++i) {
                if (calcManuOrgIds.getLong(i) == prdOrg.longValue()) continue;
                calcManuOrgIdList.add(calcManuOrgIds.getLong(i));
            }
            if (!calcManuOrgIdList.isEmpty()) {
                this.calcReduct(json.getLong("orgId"), json.getLong("costAccountId"), json.getLong("prdOrg"), json.getLong("periodId"), json.getLong("currencyId"), calcManuOrgIdList);
            }
        }
    }

    public void click(EventObject evt) {
        String btnKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (btnKey = source.getKey()) {
            case "checkresult": {
                this.openReportResult("checkResultId");
                break;
            }
            case "btncalcrpt": {
                this.openReportResult("calcReportId");
                break;
            }
            case "btnreductlevel": {
                this.showRptFormNew("sca_costredlevelrptnew", ResManager.loadKDString((String)"\u6210\u672c\u8fd8\u539f\u5206\u7ea7\u8868", (String)"FinishFactCostReductPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "btnreductitem": {
                this.showRptFormNew("sca_costreditemrptnew", ResManager.loadKDString((String)"\u6210\u672c\u8fd8\u539f\u5206\u9879\u8868", (String)"FinishFactCostReductPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void openReportResult(String key) {
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("sca_reductreport");
        JSONObject custparamJs = new JSONObject();
        String resultType = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)resultType) || "null".equals(resultType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u751f\u6210\u68c0\u67e5\u62a5\u544a", (String)"FinishFactCostReductPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        custparamJs.accumulate("checkResultId", (Object)resultType);
        lsp.setPkId((Object)resultType);
        lsp.setCustomParam("custparam", (Object)custparamJs.toString());
        switch (key) {
            case "checkResultId": {
                lsp.setCaption(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"FinishFactCostReductPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "calcReportId": {
                lsp.setCaption(ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u62a5\u544a", (String)"FinishFactCostReductPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showRptFormNew(String rprEntityName, String reportName) {
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId(rprEntityName);
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        JSONObject json = JSONObject.fromObject((Object)customParam);
        long calcReportId = json.getLong("calcReportId");
        Set prdSet = FactCostReductTaskHelper.getPrdSetByCalcReportId((Long)calcReportId);
        JSONObject custom = new JSONObject();
        custom.put((Object)"orgId", (Object)json.getLong("orgId"));
        custom.put((Object)"costaccountId", (Object)json.getLong("costAccountId"));
        DynamicObject currency = FactCostReductTaskHelper.getCurrency((Long)json.getLong("costAccountId"));
        if (currency != null) {
            custom.put((Object)"currency", (Object)currency.getLong("currency"));
        }
        custom.put((Object)"periodId", (Object)json.getLong("periodId"));
        custom.put((Object)"materials", (Object)prdSet);
        custom.put((Object)"appnum", (Object)this.getView().getFormShowParameter().getAppId());
        rsp.getShowParameter().setCustomParam("hpParam", (Object)custom.toString());
        if (!StringUtils.isEmpty((String)reportName)) {
            rsp.setCaption(reportName);
        }
        this.getView().showForm((FormShowParameter)rsp);
    }

    private void calcReduct(Long orgId, Long costAccountId, Long manuorgId, Long periodId, Long currencyId, List<Long> calcManuOrgIdList) {
        JSONObject recoveryParam = this.getCostRecoveryParam(orgId, costAccountId, manuorgId, periodId, currencyId);
        if (recoveryParam == null) {
            return;
        }
        DynamicObject costParam = FinishFactCostReductPlugin.getCostParam(orgId, costAccountId, "aca");
        if (costParam == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5728\u201c\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u201d\u8fdb\u884c\u7ef4\u62a4", (String)"FinishFactCostReductPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        String calRange = costParam.getString("restorecalcrange");
        String calDimenSion = costParam.getString("restoredimension");
        recoveryParam.accumulate("calRange", (Object)calRange);
        recoveryParam.accumulate("calDimension", (Object)calDimenSion);
        List permOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)"sca_factcostreduction", (String)this.getView().getFormShowParameter().getAppId(), (String)"4730fc9f000025ae");
        if (!permOrgIds.contains(orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinishFactCostReductPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        String costAccStr = String.valueOf(costAccountId);
        try {
            boolean mutexFlag;
            String lockErrAcct = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
            if (StringUtils.isNotEmpty((String)lockErrAcct)) {
                this.getView().showErrorNotification(lockErrAcct);
                return;
            }
            if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(calDimenSion)) {
                recoveryParam.accumulate("manuOrgId", (Object)calcManuOrgIdList.get(0));
                recoveryParam.accumulate("calcManuOrgIds", calcManuOrgIdList);
                costAccStr = costAccStr + calcManuOrgIdList.get(0);
            }
            if (!(mutexFlag = MutexHelper.require((String)"sca_factcostreduction", (Object)costAccStr.hashCode(), (String)"reductcalc", (boolean)true, (StringBuilder)new StringBuilder()))) {
                String accountName = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)}).getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"FinishFactCostReductPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]), accountName));
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
                return;
            }
            TaskHelper.startTaskForCostReduct((IFormView)this.getView(), (Long)FactCostReductCalcCheck.CALCTASKID, (String)recoveryParam.toString());
        }
        catch (Exception ex) {
            logger.error("\u8ba1\u7b97\u5b8c\u6210\u6267\u884c\u6210\u672c\u8fd8\u539f\u62a5\u9519\uff1a", (Throwable)ex);
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
            MutexHelper.release((String)"sca_factcostreduction", (String)"reductcalc", (String)String.valueOf(costAccStr.hashCode()));
        }
    }

    private JSONObject getCostRecoveryParam(Long orgId, Long costAccountId, Long manuorgId, Long periodId, Long currencyId) {
        if (orgId == null || costAccountId == null || periodId == null) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.accumulate("calOrgId", (Object)orgId);
        jsonObj.accumulate("costAccountId", (Object)costAccountId);
        jsonObj.accumulate("periodId", (Object)periodId);
        jsonObj.accumulate("currency", (Object)currencyId);
        jsonObj.accumulate("taskId", 0);
        jsonObj.accumulate("usePreConstr", false);
        jsonObj.accumulate("checkMaterial", false);
        jsonObj.accumulate("checkConfigId", 1386108939132735488L);
        jsonObj.accumulate("periodIsCurrent", true);
        HashSet<Long> allOrgIds = new HashSet<Long>(16);
        HashSet<Long> allCostAccounts = new HashSet<Long>(16);
        allOrgIds.add(orgId);
        allCostAccounts.add(costAccountId);
        jsonObj.accumulate("relationCalOrgIds", allOrgIds);
        jsonObj.accumulate("relationCostAccountIds", allCostAccounts);
        JSONObject relaOrgCostAccountMap = new JSONObject();
        relaOrgCostAccountMap.accumulate(String.valueOf(orgId), (Object)costAccountId);
        jsonObj.accumulate("relaOrgCostAccountMap", (Object)relaOrgCostAccountMap);
        jsonObj.accumulate("appnum", (Object)"aca");
        return jsonObj;
    }

    public static DynamicObject getCostParam(Long orgId, Long costaccountId, String appNum) {
        Map params;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("costaccount", "=", (Object)costaccountId));
        qFilter.and(new QFilter("tab", "=", (Object)"costaccounttabpage"));
        if (!StringUtils.isEmpty((String)appNum)) {
            qFilter.and(new QFilter("appnum", "=", (Object)appNum));
        }
        if ((params = BusinessDataServiceHelper.loadFromCache((String)"cad_sysparam", (QFilter[])qFilter.toArray())).size() > 0) {
            return (DynamicObject)params.values().iterator().next();
        }
        return null;
    }
}

