/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaDiffRuleEnum;

public class DiffRuleSettingEditPlugin
extends AbstractFormPlugin {
    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void initialize() {
        super.initialize();
        this.initFilter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (proName = e.getProperty().getName()) {
            case "org": {
                this.cleanCostCenter(rowIndex);
                break;
            }
            case "costcenter": {
                if (newValue == null) break;
                DynamicObject costcenter = (DynamicObject)newValue;
                DynamicObject org = costcenter.getDynamicObject("accountorg");
                this.getModel().setValue("org", org != null ? org.getPkValue() : null, rowIndex);
                break;
            }
            case "carryoverbill": {
                String carryoverbills = (String)newValue;
                if (CadEmptyUtils.isEmpty((String)carryoverbills)) break;
                this.setDiffRule(carryoverbills);
                break;
            }
            case "diffrule": {
                String diffRule = (String)newValue;
                this.setRateAble(diffRule);
            }
        }
    }

    private void cleanCostCenter(int rowIndex) {
        this.getModel().setValue("costcenter", null, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String oprKey = operate.getOperateKey();
        if ("op_save".equals(oprKey)) {
            this.checkOnly(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String oprKey = e.getOperateKey();
        Boolean isSuccess = Optional.ofNullable(e.getOperationResult()).map(OperationResult::isSuccess).orElseGet(() -> Boolean.TRUE);
        if (isSuccess.booleanValue() && "op_save".equals(oprKey)) {
            this.save();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillForm();
        this.setInputProp();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void setInputProp() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("paramlist");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        for (DynamicObject row : entryEntity) {
            this.setRateAble(row.getString("diffrule"), row.getInt("seq") - 1);
        }
    }

    private void setRateAble(String diffRule) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("paramlist");
        this.setRateAble(diffRule, rowIndex);
    }

    private void setRateAble(String diffRule, int rowIndex) {
        if (CadEmptyUtils.isEmpty((String)diffRule)) {
            this.getModel().setValue("rate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"rate"});
            return;
        }
        boolean isManual = ScaDiffRuleEnum.DIFFRULE_MANUAL.getValue().equals(diffRule);
        this.getView().setEnable(Boolean.valueOf(isManual), rowIndex, new String[]{"rate"});
        if (!isManual) {
            this.getModel().setValue("rate", null, rowIndex);
        }
    }

    private void setDiffRule(String carryoverbills) {
        String[] carryoverBillArr;
        boolean hasUnabsorbDiff = false;
        for (String carryoverBill : carryoverBillArr = carryoverbills.split(",")) {
            if (ScaDiffRuleEnum.CARRYOVERBILL_UNABSORBDIFF.getValue().equals(carryoverBill)) break;
        }
        if (!hasUnabsorbDiff) {
            return;
        }
    }

    private void checkOnly(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("paramlist");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        HashMap<Integer, List<String>> repeatDateMap = new HashMap<Integer, List<String>>();
        HashMap<Integer, DynamicObject> rowMap = new HashMap<Integer, DynamicObject>();
        for (DynamicObject row : rows) {
            Object[] carryoverbillArr;
            DynamicObject costcenter = row.getDynamicObject("costcenter");
            DynamicObject org = row.getDynamicObject("org");
            String carryoverbills = row.getString("carryoverbill");
            if (org == null || CadEmptyUtils.isEmpty((String)carryoverbills) || CadEmptyUtils.isEmpty((Object[])(carryoverbillArr = carryoverbills.split(",")))) continue;
            rowMap.put(row.getInt("seq"), row);
            for (Object carryoverbill : carryoverbillArr) {
                if (CadEmptyUtils.isEmpty((String)carryoverbill)) continue;
                String key = this.getKey(org, costcenter, (String)carryoverbill);
                if (set.contains(key)) {
                    repeatDateMap.computeIfAbsent(row.getInt("seq"), s -> new ArrayList()).add(carryoverbill);
                    continue;
                }
                set.add(key);
            }
        }
        if (CadEmptyUtils.isEmpty(repeatDateMap)) {
            return;
        }
        e.setCancel(true);
        this.showTip(rowMap, repeatDateMap);
    }

    private void showTip(Map<Integer, DynamicObject> rowMap, Map<Integer, List<String>> repeatDateMap) {
        if (repeatDateMap.size() == 1) {
            this.getView().showTipNotification(this.getFalseTip(rowMap, repeatDateMap));
        } else if (repeatDateMap.size() > 1) {
            this.getView().showMessage(this.getFalseTip(rowMap, repeatDateMap));
        }
    }

    private String getFalseTip(Map<Integer, DynamicObject> rowMap, Map<Integer, List<String>> repeatDateMap) {
        StringBuilder tipSb = new StringBuilder();
        tipSb.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DiffRuleSettingEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
        tipSb.append("\r\n");
        for (Map.Entry<Integer, List<String>> entry : repeatDateMap.entrySet()) {
            DynamicObject row = rowMap.get(entry.getKey());
            List<String> repeatBillList = entry.getValue();
            DynamicObject org = row.getDynamicObject("org");
            DynamicObject costcenter = row.getDynamicObject("costcenter");
            tipSb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u6838\u7b97\u7ec4\u7ec7\uff1a%2$s + ", (String)"DiffRuleSettingEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), entry.getKey(), org.getString("name")));
            if (costcenter != null) {
                tipSb.append(String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\uff1a%s + ", (String)"DiffRuleSettingEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), costcenter.getString("name")));
            }
            tipSb.append(ResManager.loadKDString((String)"\u53c2\u4e0e\u7ed3\u8f6c\u5355\u636e\uff1a", (String)"DiffRuleSettingEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            for (String repeatBill : repeatBillList) {
                tipSb.append(ScaDiffRuleEnum.getName(repeatBill));
                tipSb.append(' ');
            }
            tipSb.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u3002", (String)"DiffRuleSettingEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            tipSb.append("\r\n");
        }
        return tipSb.toString();
    }

    private String getKey(DynamicObject org, DynamicObject costcenter, String carryoverbill) {
        StringBuilder sb = new StringBuilder();
        sb.append(org.getLong("id")).append('_');
        if (costcenter != null) {
            sb.append(costcenter.getLong("id")).append('_');
        }
        sb.append(carryoverbill);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("paramlist");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            DeleteServiceHelper.delete((String)"sca_diffrule", null);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DiffRuleSettingEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject row : rows) {
            DynamicObject diffRule = BusinessDataServiceHelper.newDynamicObject((String)"sca_diffrule");
            diffRule.set("org", row.get("org"));
            diffRule.set("costcenter", row.get("costcenter"));
            diffRule.set("carryoverbill", row.get("carryoverbill"));
            diffRule.set("diffrule", row.get("diffrule"));
            diffRule.set("rate", row.get("rate"));
            diffRule.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            diffRule.set("modifydate", (Object)new Date());
            list.add(diffRule);
        }
        try (TXHandle txHandle = TX.required();){
            DeleteServiceHelper.delete((String)"sca_diffrule", null);
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DiffRuleSettingEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void fillForm() {
        this.getModel().deleteEntryData("paramlist");
        DynamicObjectCollection diffRules = this.queryDiffRule();
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)diffRules)) {
            return;
        }
        this.getModel().beginInit();
        this.setCommonValue(diffRules);
        this.getModel().endInit();
        this.getView().updateView("paramlist");
    }

    private void setCommonValue(DynamicObjectCollection diffRules) {
        int[] indexs;
        IDataModel m = this.getModel();
        for (int index : indexs = m.batchCreateNewEntryRow("paramlist", diffRules.size())) {
            m.setValue("org", ((DynamicObject)diffRules.get(index)).get("org"), index);
            m.setValue("costcenter", ((DynamicObject)diffRules.get(index)).get("costcenter"), index);
            m.setValue("carryoverbill", ((DynamicObject)diffRules.get(index)).get("carryoverbill"), index);
            m.setValue("diffrule", ((DynamicObject)diffRules.get(index)).get("diffrule"), index);
            m.setValue("rate", ((DynamicObject)diffRules.get(index)).get("rate"), index);
        }
    }

    private DynamicObjectCollection queryDiffRule() {
        String fields = "org,costcenter,carryoverbill,diffrule,rate";
        DynamicObjectCollection diffRules = QueryServiceHelper.query((String)"sca_diffrule", (String)fields, null);
        return diffRules;
    }

    private void initFilter() {
        List acctOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("id", "in", (Object)acctOrgIds));
        });
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("costcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("paramlist");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", rowIndex);
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(new QFilter("accountorg", "in", (Object)acctOrgIds));
            qFilters.add(new QFilter("orgduty.number", "=", (Object)"4"));
            if (org != null) {
                qFilters.add(new QFilter("accountorg", "=", (Object)org.getLong("id")));
            }
        });
    }
}

