/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.ILogService;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class ProductDiffTransferListPlugin
extends AbstractListPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private FilterContainerInitArgs filterContainerInitArgs = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblcarrydiff"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "tblcarrydiff": {
                String orgId = this.getPageCache().get("orgId");
                if (!StringUtils.isEmpty((String)orgId)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProductDiffTransferListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "tblcarrydiff": {
                this.dealDiff();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("period.name,costaccount.name,costcenter.name,billno asc");
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        String orgId = this.getPageCache().get("orgId");
        if (orgId == null || "".equals(orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccounting) {
                orgId = currAcctOrg + "";
            } else {
                ComboItem comboItem = (ComboItem)acctOrgs.get(0);
                orgId = comboItem.getValue();
            }
            this.getPageCache().put("orgId", orgId);
        }
        List costaccountItems = StartCostHelper.getCostAccountItems((Long)(StringUtils.isEmpty((String)orgId) ? 0L : Long.parseLong(orgId)), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List listcomitem = commonFilterColumn.getComboItems();
            switch (fieldName) {
                case "org.id": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(acctOrgs);
                    commonFilterColumn.setDefaultValue(orgId);
                    break;
                }
                case "costaccount.name": {
                    listcomitem.clear();
                    commonFilterColumn.setComboItems(costaccountItems);
                    if (costaccountItems == null || costaccountItems.size() <= 0) break;
                    commonFilterColumn.setDefaultValue(((ComboItem)costaccountItems.get(0)).getValue());
                    this.getPageCache().put("costaccountId", ((ComboItem)costaccountItems.get(0)).getValue());
                }
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String orgId = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            Map filter = (Map)customfilter.get(i);
            List listFieldName = (List)filter.get("FieldName");
            List listValue = (List)filter.get("Value");
            if (CadEmptyUtils.isEmpty((List)listValue)) continue;
            block9: for (int j = 0; j < listFieldName.size(); ++j) {
                String fieldName;
                switch (fieldName = (String)listFieldName.get(j)) {
                    case "org.id": {
                        orgId = (String)listValue.get(j);
                        this.getPageCache().put("orgId", orgId);
                        this.getPageCache().put("costaccountId", "");
                        this.filterContainerInit(this.filterContainerInitArgs);
                        continue block9;
                    }
                    case "costaccount.id": {
                        String costaccountId = (String)listValue.get(j);
                        this.getPageCache().put("costaccountId", costaccountId);
                    }
                }
            }
        }
    }

    private void dealDiff() {
        String org = this.getPageCache().get("orgId");
        if (StringUtils.isEmpty((String)org)) {
            return;
        }
        Long orgId = Long.valueOf(org);
        Set<Object> costAccountIds = new HashSet<Long>();
        String costAccountId = this.getPageCache().get("costaccountId");
        if (StringUtils.isEmpty((String)costAccountId)) {
            costAccountIds = this.getCostAccount(orgId);
        } else {
            costAccountIds.add(Long.valueOf(costAccountId));
        }
        if (costAccountIds.size() == 0) {
            return;
        }
        Set<Long> periodIds = this.getPeriod(orgId, costAccountIds);
        Set<Long> costCenterIds = this.getCostCenter(orgId);
        Map<String, Long> proDiff = this.getExistsProDiffBill(orgId, costAccountIds, costCenterIds);
        Map<String, BigDecimal> allTransferRate = this.getDiffRule(orgId);
        if (this.isExistsTransferRate(allTransferRate.keySet(), "UNABSORBDIFF").booleanValue()) {
            this.dealUnAborbDiff(orgId, costAccountIds, periodIds, costCenterIds, proDiff, allTransferRate);
        }
        if (this.isExistsTransferRate(allTransferRate.keySet(), "FINISHDIFFBILL").booleanValue()) {
            this.dealFinishDiff(orgId, costAccountIds, periodIds, costCenterIds, proDiff, allTransferRate);
        }
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7ed3\u8f6c\u5dee\u5f02", (String)"ProductDiffTransferListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), (String)"ProductDiffTransferListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u751f\u4ea7\u6210\u672c\u5dee\u5f02\u7ed3\u8f6c\u5355", (String)"ProductDiffTransferListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), (String)"ProductDiffTransferListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_prodiffbill", (IDataModel)this.getModel());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u8f6c\u5dee\u5f02\u64cd\u4f5c\u5df2\u5b8c\u6210\u3002", (String)"ProductDiffTransferListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private Boolean isExistsTransferRate(Set<String> keys, String source) {
        for (String key : keys) {
            Object[] arr = key.split("@");
            if (CadEmptyUtils.isEmpty((Object[])arr) && arr.length == 4 || !source.equals(arr[2])) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Set<Long> getCostAccount(long orgId) {
        HashSet<Long> costAccountIds = new HashSet<Long>();
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)orgId);
        QFilter enablestdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        String orderby = "enablestandardcost DESC, number ASC";
        DynamicObjectCollection costAccount = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF}, (String)orderby);
        costAccount.forEach(p -> costAccountIds.add(p.getLong("id")));
        return costAccountIds;
    }

    private Set<Long> getPeriod(Long orgId, Set<Long> costAccountIds) {
        HashSet<Long> periodIds = new HashSet<Long>(16);
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection sysCtrlEntity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id costaccountid,entry.currentperiod curperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        for (DynamicObject sysCtrl : sysCtrlEntity) {
            periodIds.add(sysCtrl.getLong("curperiod"));
        }
        return periodIds;
    }

    private Map<String, Long> getAllPeriod(Long orgId, Set<Long> costAccountIds) {
        HashMap<String, Long> periodIds = new HashMap<String, Long>();
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection sysCtrlEntity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org,entry.costaccount costaccount,entry.currentperiod curperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        for (DynamicObject sysCtrl : sysCtrlEntity) {
            periodIds.put(sysCtrl.getString("org") + "@" + sysCtrl.getString("costaccount"), sysCtrl.getLong("curperiod"));
        }
        return periodIds;
    }

    private Set<Long> getCostCenter(Long orgId) {
        HashSet<Long> costCenterIds = new HashSet<Long>();
        QFilter qfAccountOrg = new QFilter("accountorg", "=", (Object)orgId);
        QFilter QForgDuty = new QFilter("orgduty.number", "=", (Object)"4");
        DynamicObjectCollection costCenter = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{qfAccountOrg, QForgDuty});
        costCenter.forEach(p -> costCenterIds.add(p.getLong("id")));
        return costCenterIds;
    }

    private Map<String, BigDecimal> getDiffRule(Long orgId) {
        HashMap<String, BigDecimal> diffRate = new HashMap<String, BigDecimal>();
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection diffRule = QueryServiceHelper.query((String)"sca_diffrule", (String)"org,costcenter,carryoverbill,diffrule,rate", (QFilter[])new QFilter[]{qfOrg});
        for (DynamicObject rule : diffRule) {
            String[] bills;
            String carryoverbill = rule.getString("carryoverbill");
            if (StringUtils.isEmpty((String)carryoverbill)) continue;
            for (String bill : bills = carryoverbill.split(",")) {
                if (StringUtils.isEmpty((String)bill)) continue;
                diffRate.put(rule.getString("org") + "@" + rule.getString("costcenter") + "@" + bill + "@" + rule.getString("diffrule"), rule.getBigDecimal("rate"));
            }
        }
        return diffRate;
    }

    private Set<Long> getPrePeriodIds(Set<Long> periodIds) {
        HashSet<Long> prePeriodIds = new HashSet<Long>(16);
        for (Long id : periodIds) {
            prePeriodIds.add(id - 10L);
        }
        return prePeriodIds;
    }

    private DynamicObjectCollection getPreProductDiff(Long orgId, Set<Long> costAccountIds, Set<Long> periodIds, Set<Long> costCenterIds, String sourcebill) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("period", "in", periodIds));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        filters.add(new QFilter("sourcebill", "=", (Object)sourcebill));
        String selectFields = "org,costaccount,period,costcenter,entryentity.entrysourcebill entrysourcebill,entryentity.subelement subelement,entryentity.sumrate sumrate,entryentity.entryendamt entryendamt";
        DynamicObjectCollection unAborbDiff = QueryServiceHelper.query((String)"sca_prodiffbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        return unAborbDiff;
    }

    private Map<String, BigDecimal> getPreProductTransfer(DynamicObjectCollection unAborbDiff, String key) {
        HashMap<String, BigDecimal> preDiff = new HashMap<String, BigDecimal>();
        for (DynamicObject diff : unAborbDiff) {
            String diffKey = diff.getString("org") + diff.getString("costaccount") + diff.getString("period") + diff.getString("costcenter") + diff.getString("entrysourcebill") + diff.getString("subelement");
            if (!key.equals(diffKey)) continue;
            preDiff.put("sumrate", diff.getBigDecimal("sumrate"));
            preDiff.put("entryendamt", diff.getBigDecimal("entryendamt"));
        }
        return preDiff;
    }

    private void dealUnAborbDiff(Long orgId, Set<Long> costAccountIds, Set<Long> periodIds, Set<Long> costCenterIds, Map<String, Long> proDiff, Map<String, BigDecimal> allTransferRate) {
        String algoKey = "ProductDiffTransferListPlugin.getData";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        String selectFields = "billno,org,costaccount,period,costcenter,difftype,entryentity.element element,entryentity.subelement subelement,entryentity.amount amount";
        DataSet unAborbDiff = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)"sca_unabsorbdiff", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        Set<Long> prePeriodIds = this.getPrePeriodIds(periodIds);
        DynamicObjectCollection preProductTransfer = this.getPreProductDiff(orgId, costAccountIds, prePeriodIds, costCenterIds, "1");
        ArrayList<DynamicObject> needSaveProDiffBill = new ArrayList<DynamicObject>();
        Map<String, Long> costAccountPeriod = this.getAllPeriod(orgId, costAccountIds);
        Map<String, DataSet> groupUnAborbDiff = this.initGroupDiffBill(unAborbDiff);
        HashSet<Long> needDeleteProDiff = new HashSet<Long>();
        for (Map.Entry<String, DataSet> entryForSet : groupUnAborbDiff.entrySet()) {
            BigDecimal carryrate;
            DataSet curEntryData;
            String[] info = entryForSet.getKey().split("@");
            if (info.length != 4 || (curEntryData = entryForSet.getValue()) == null) continue;
            DynamicObject proDiffBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_prodiffbill");
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"sca_prodiffbill", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_prodiffbill"), (String)"");
            proDiffBill.set("billno", (Object)(codeRuleInfo != null ? CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proDiffBill) : entryForSet.getKey()));
            proDiffBill.set("org", (Object)info[0]);
            proDiffBill.set("costaccount", (Object)info[1]);
            String periodKey = info[0] + "@" + info[1];
            Long periodId = costAccountPeriod.get(periodKey);
            proDiffBill.set("period", (Object)periodId);
            proDiffBill.set("costcenter", (Object)info[3]);
            proDiffBill.set("sourcebill", (Object)"1");
            proDiffBill.set("diffrule", (Object)"MANUAL");
            proDiffBill.set("billstatus", (Object)"C");
            proDiffBill.set("creator", (Object)RequestContext.get().getUserId());
            proDiffBill.set("createtime", (Object)TimeServiceHelper.now());
            BigDecimal startamt = BigDecimal.ZERO;
            BigDecimal curdiffamt = BigDecimal.ZERO;
            BigDecimal curcarryamt = BigDecimal.ZERO;
            BigDecimal endamt = BigDecimal.ZERO;
            String carryRateKey = info[0] + "@" + info[3] + "@UNABSORBDIFF@MANUAL";
            BigDecimal bigDecimal = carryrate = allTransferRate.get(carryRateKey) != null ? allTransferRate.get(carryRateKey) : allTransferRate.get(info[0] + "@0@UNABSORBDIFF@MANUAL");
            if (carryrate == null) continue;
            DynamicObjectCollection entryCollection = proDiffBill.getDynamicObjectCollection("entryentity");
            Iterator it = curEntryData.iterator();
            StringBuilder sg = new StringBuilder();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                sg = new StringBuilder();
                sg.append(String.valueOf(periodId));
                sg.append('@');
                sg.append(info[0]);
                sg.append('@');
                sg.append(info[1]);
                sg.append('@');
                sg.append(info[3]);
                sg.append('@');
                sg.append('1');
                sg.append('@');
                sg.append(row.getString("billno"));
                Long val = proDiff.get(sg.toString());
                if (val != null) {
                    if (val == 0L) continue;
                    if (val > 0L) {
                        needDeleteProDiff.add(val);
                    }
                }
                DynamicObject entry = entryCollection.addNew();
                entry.set("entrysourcebill", (Object)row.getString("billno"));
                entry.set("carryrate", (Object)carryrate);
                String preDiffKey = info[0] + info[1] + info[2] + info[3] + row.getString("billno") + row.getString("subelement");
                Map<String, BigDecimal> preDiffTransfer = this.getPreProductTransfer(preProductTransfer, preDiffKey);
                BigDecimal preSumRate = preDiffTransfer.get("sumrate") == null ? BigDecimal.ZERO : preDiffTransfer.get("sumrate");
                BigDecimal preEntryEndAmt = preDiffTransfer.get("entryendamt") == null ? BigDecimal.ZERO : preDiffTransfer.get("entryendamt");
                BigDecimal entrycurcarryamt = BigDecimal.ZERO;
                BigDecimal oneRate = new BigDecimal(1);
                if (preSumRate.add(carryrate).compareTo(oneRate) <= 0) {
                    entry.set("exerate", (Object)carryrate);
                    entry.set("sumrate", (Object)preSumRate.add(carryrate));
                    entrycurcarryamt = row.getBigDecimal("amount").multiply(carryrate);
                } else {
                    entry.set("exerate", (Object)oneRate.subtract(preSumRate));
                    entry.set("sumrate", (Object)oneRate);
                    entrycurcarryamt = oneRate.subtract(preSumRate).multiply(row.getBigDecimal("amount"));
                }
                entry.set("difftype", (Object)row.getString("difftype"));
                entry.set("element", (Object)row.getLong("element"));
                entry.set("subelement", (Object)row.getLong("subelement"));
                entry.set("entrystartamt", (Object)preEntryEndAmt);
                startamt = startamt.add(preEntryEndAmt);
                BigDecimal entrycurdiffamt = periodId.equals(row.getLong("period")) ? row.getBigDecimal("amount") : BigDecimal.ZERO;
                entry.set("entrycurdiffamt", (Object)entrycurdiffamt);
                curdiffamt = curdiffamt.add(entrycurdiffamt);
                entry.set("entrycurcarryamt", (Object)entrycurcarryamt);
                curcarryamt = curcarryamt.add(entrycurcarryamt);
                BigDecimal entryendamt = preEntryEndAmt.add(entrycurdiffamt).subtract(entrycurcarryamt);
                entry.set("entryendamt", (Object)entryendamt);
                endamt = endamt.add(entryendamt);
            }
            proDiffBill.set("startamt", (Object)startamt);
            proDiffBill.set("curdiffamt", (Object)curdiffamt);
            proDiffBill.set("curcarryamt", (Object)curcarryamt);
            proDiffBill.set("endamt", (Object)endamt);
            if (entryCollection.size() <= 0) continue;
            needSaveProDiffBill.add(proDiffBill);
        }
        if (needDeleteProDiff.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_prodiffbill"), (Object[])needDeleteProDiff.toArray(new Long[0]));
        }
        if (needSaveProDiffBill.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needSaveProDiffBill.toArray(new DynamicObject[0]));
        }
    }

    private void dealFinishDiff(Long orgId, Set<Long> costAccountIds, Set<Long> periodIds, Set<Long> costCenterIds, Map<String, Long> proDiff, Map<String, BigDecimal> allTransferRate) {
        String algoKey = "ProductDiffTransferListPlugin.dealFinishDiff";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        String selectFields = "billno,org,costaccount,period,costcenter,costobject,material,unit,auxpty,entryentity.difftype difftype,entryentity.element element,entryentity.subelement subelement,entryentity.amount amount";
        DataSet finishDiff = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)"sca_finishdiffbill", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        Set<Long> prePeriodIds = this.getPrePeriodIds(periodIds);
        DynamicObjectCollection preProductTransfer = this.getPreProductDiff(orgId, costAccountIds, prePeriodIds, costCenterIds, "0");
        Set<Long> materialIds = this.getMaterialIds(finishDiff.copy());
        Map<String, BigDecimal> productRate = this.getStockDetailData(orgId, costAccountIds, materialIds);
        ArrayList<DynamicObject> needSaveProDiffBill = new ArrayList<DynamicObject>();
        Map<String, Long> costAccountPeriod = this.getAllPeriod(orgId, costAccountIds);
        Map<String, DataSet> groupFinishDiff = this.initGroupDiffBill(finishDiff);
        HashSet<Long> needDeleteProDiff = new HashSet<Long>();
        for (Map.Entry<String, DataSet> entrySet : groupFinishDiff.entrySet()) {
            DataSet curEntryData;
            String[] info = entrySet.getKey().split("@");
            if (info.length != 4 || (curEntryData = entrySet.getValue()) == null) continue;
            DynamicObject proDiffBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_prodiffbill");
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"sca_prodiffbill", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_prodiffbill"), (String)"");
            proDiffBill.set("billno", (Object)(codeRuleInfo != null ? CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proDiffBill) : entrySet.getKey()));
            proDiffBill.set("org", (Object)info[0]);
            proDiffBill.set("costaccount", (Object)info[1]);
            String periodKey = info[0] + "@" + info[1];
            Long periodId = costAccountPeriod.get(periodKey);
            proDiffBill.set("period", (Object)periodId);
            proDiffBill.set("costcenter", (Object)info[3]);
            proDiffBill.set("sourcebill", (Object)"0");
            proDiffBill.set("billstatus", (Object)"C");
            proDiffBill.set("creator", (Object)RequestContext.get().getUserId());
            proDiffBill.set("createtime", (Object)TimeServiceHelper.now());
            BigDecimal startamt = BigDecimal.ZERO;
            BigDecimal curdiffamt = BigDecimal.ZERO;
            BigDecimal curcarryamt = BigDecimal.ZERO;
            BigDecimal endamt = BigDecimal.ZERO;
            BigDecimal carryrate = BigDecimal.ZERO;
            String carryRateManual = info[0] + "@" + info[3] + "@FINISHDIFFBILL@MANUAL";
            String carryRateManualNoCenter = info[0] + "@0@FINISHDIFFBILL@MANUAL";
            String carryRateProduct = info[0] + "@" + info[3] + "@FINISHDIFFBILL@PRODINPUTAMT";
            String carryRateProductNoCenter = info[0] + "@0@FINISHDIFFBILL@PRODINPUTAMT";
            String carryRateMult = info[0] + "@" + info[3] + "@FINISHDIFFBILL@MULTIINPUTAMT";
            String carryRateMultNoCenter = info[0] + "@0@FINISHDIFFBILL@MULTIINPUTAMT";
            if (allTransferRate.containsKey(carryRateManual)) {
                proDiffBill.set("diffrule", (Object)"MANUAL");
                carryrate = allTransferRate.get(carryRateManual);
            } else if (allTransferRate.containsKey(carryRateManualNoCenter)) {
                proDiffBill.set("diffrule", (Object)"MANUAL");
                carryrate = allTransferRate.get(carryRateManualNoCenter);
            } else if (allTransferRate.containsKey(carryRateMult) || allTransferRate.containsKey(carryRateMultNoCenter)) {
                proDiffBill.set("diffrule", (Object)"MULTIINPUTAMT");
            }
            if (carryrate == null) continue;
            DynamicObjectCollection entryCollection = proDiffBill.getDynamicObjectCollection("entryentity");
            Iterator it = curEntryData.iterator();
            StringBuilder sg = new StringBuilder();
            while (it.hasNext()) {
                Row row = (Row)it.next();
                sg = new StringBuilder();
                sg.append(String.valueOf(periodId));
                sg.append('@');
                sg.append(info[0]);
                sg.append('@');
                sg.append(info[1]);
                sg.append('@');
                sg.append(info[3]);
                sg.append('@');
                sg.append('0');
                sg.append('@');
                sg.append(row.getString("billno"));
                Long val = proDiff.get(sg.toString());
                if (val != null) {
                    if (val == 0L) continue;
                    if (val > 0L) {
                        needDeleteProDiff.add(val);
                    }
                }
                if (allTransferRate.containsKey(carryRateProduct) || allTransferRate.containsKey(carryRateProductNoCenter)) {
                    proDiffBill.set("diffrule", (Object)"PRODINPUTAMT");
                    String productKey = info[0] + "@" + periodId + "@" + row.getLong("material");
                    carryrate = productRate.get(productKey);
                }
                if (carryrate == null) continue;
                DynamicObject entry = entryCollection.addNew();
                entry.set("costobject", (Object)row.getLong("costobject"));
                entry.set("material", (Object)row.getLong("material"));
                entry.set("unit", (Object)row.getLong("unit"));
                entry.set("auxpty", (Object)row.getLong("auxpty"));
                entry.set("entrysourcebill", (Object)row.getString("billno"));
                entry.set("carryrate", (Object)carryrate);
                String preDiffKey = info[0] + info[1] + info[2] + info[3] + row.getString("billno") + row.getString("subelement");
                Map<String, BigDecimal> preDiffTransfer = this.getPreProductTransfer(preProductTransfer, preDiffKey);
                BigDecimal preSumRate = preDiffTransfer.get("sumrate") == null ? BigDecimal.ZERO : preDiffTransfer.get("sumrate");
                BigDecimal preEntryEndAmt = preDiffTransfer.get("entryendamt") == null ? BigDecimal.ZERO : preDiffTransfer.get("entryendamt");
                BigDecimal entrycurcarryamt = BigDecimal.ZERO;
                BigDecimal oneRate = new BigDecimal(1);
                if (preSumRate.add(carryrate).compareTo(oneRate) <= 0) {
                    entry.set("exerate", (Object)carryrate);
                    entry.set("sumrate", (Object)preSumRate.add(carryrate));
                    entrycurcarryamt = row.getBigDecimal("amount").multiply(carryrate);
                } else {
                    entry.set("exerate", (Object)oneRate.subtract(preSumRate));
                    entry.set("sumrate", (Object)oneRate);
                    entrycurcarryamt = oneRate.subtract(preSumRate).multiply(row.getBigDecimal("amount"));
                }
                entry.set("difftype", (Object)row.getString("difftype"));
                entry.set("element", (Object)row.getLong("element"));
                entry.set("subelement", (Object)row.getLong("subelement"));
                entry.set("entrystartamt", (Object)preEntryEndAmt);
                startamt = startamt.add(preEntryEndAmt);
                BigDecimal entrycurdiffamt = periodId.equals(row.getLong("period")) ? row.getBigDecimal("amount") : BigDecimal.ZERO;
                entry.set("entrycurdiffamt", (Object)entrycurdiffamt);
                curdiffamt = curdiffamt.add(entrycurdiffamt);
                entry.set("entrycurcarryamt", (Object)entrycurcarryamt);
                curcarryamt = curcarryamt.add(entrycurcarryamt);
                BigDecimal entryendamt = preEntryEndAmt.add(entrycurdiffamt).subtract(entrycurcarryamt);
                entry.set("entryendamt", (Object)entryendamt);
                endamt = endamt.add(entryendamt);
            }
            proDiffBill.set("startamt", (Object)startamt);
            proDiffBill.set("curdiffamt", (Object)curdiffamt);
            proDiffBill.set("curcarryamt", (Object)curcarryamt);
            proDiffBill.set("endamt", (Object)endamt);
            if (entryCollection.size() <= 0) continue;
            needSaveProDiffBill.add(proDiffBill);
        }
        if (needDeleteProDiff.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_prodiffbill"), (Object[])needDeleteProDiff.toArray(new Long[0]));
        }
        if (needSaveProDiffBill.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needSaveProDiffBill.toArray(new DynamicObject[0]));
        }
    }

    private Set<Long> getMaterialIds(DataSet data) {
        HashSet<Long> materialIds = new HashSet<Long>();
        for (Row row : data) {
            materialIds.add(row.getLong("material"));
        }
        return materialIds;
    }

    private Map<String, DataSet> initGroupDiffBill(DataSet diffBillData) {
        HashMap<String, DataSet> groupDiffBill = new HashMap<String, DataSet>();
        DataSet data = diffBillData.copy();
        DataSet groupData = data.executeSql("select org,costaccount,period,costcenter group by org,costaccount,period,costcenter");
        for (Row row : groupData) {
            DataSet newGroupData = diffBillData.copy();
            String exp = "org = " + row.getLong("org") + " and costaccount = " + row.getLong("costaccount") + " and period = " + row.getLong("period") + " and costcenter = " + row.getLong("costcenter");
            String key = row.getString("org") + "@" + row.getString("costaccount") + "@" + row.getString("period") + "@" + row.getString("costcenter");
            DataSet newData = newGroupData.filter(exp);
            groupDiffBill.put(key, newData);
        }
        return groupDiffBill;
    }

    private Map<String, Long> getExistsProDiffBill(Long orgId, Set<Long> costAccountIds, Set<Long> costCenterIds) {
        HashMap<String, Long> existsProDiff = new HashMap<String, Long>();
        String algoKey = "ProductDiffTransferListPlugin.getExistsProDiffBill";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        String selectField = "id,vouchernum,period,org,costaccount,costcenter,sourcebill,entryentity.entrysourcebill entrysourcebill";
        DataSet data = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_prodiffbill", (String)selectField, (QFilter[])filters.toArray(new QFilter[0]), null);
        Iterator it = data.iterator();
        StringBuilder sg = new StringBuilder();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            sg = new StringBuilder();
            sg.append(row.getString("period"));
            sg.append('@');
            sg.append(row.getString("org"));
            sg.append('@');
            sg.append(row.getString("costaccount"));
            sg.append('@');
            sg.append(row.getString("costcenter"));
            sg.append('@');
            sg.append(row.getString("sourcebill"));
            sg.append('@');
            sg.append(row.getString("entrysourcebill"));
            existsProDiff.put(sg.toString(), StringUtils.isEmpty((String)row.getString("vouchernum")) ? row.getLong("id") : 0L);
        }
        return existsProDiff;
    }

    private Map<String, BigDecimal> getStockDetailData(Long orgId, Set<Long> costAccountIds, Set<Long> materialIds) {
        HashSet<Long> periodIds = new HashSet<Long>();
        Map<String, Long> curPeriodIds = this.getAllPeriod(orgId, costAccountIds);
        curPeriodIds.values().forEach(p -> periodIds.add((Long)p));
        Set<Long> prePeriodIds = this.getPrePeriodIds(periodIds);
        periodIds.addAll(prePeriodIds);
        DataSet dataSet = this.getCostRecordDataSet(costAccountIds, materialIds, periodIds);
        dataSet = dataSet.union(this.getCostAdjustDataSet(costAccountIds, materialIds, periodIds));
        dataSet = this.unionPeriodBeginDataSet(dataSet, costAccountIds, materialIds, periodIds);
        dataSet = this.calPeriodEndDataSet(dataSet);
        dataSet = this.unionTotalDataSet(dataSet, costAccountIds, materialIds);
        dataSet = dataSet.select(this.getFinalSelects().split(","));
        Map<String, BigDecimal> prePeriodData = this.preBeginAmout(dataSet.copy());
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        for (Row row : dataSet) {
            Long prePeriod = row.getLong("periodid") - 10L;
            String preKey = row.getString("calorg") + "@" + row.getString("materialid") + "@" + prePeriod;
            BigDecimal preEndData = prePeriodData.get(preKey) == null ? BigDecimal.ZERO : prePeriodData.get(preKey);
            BigDecimal curData = preEndData.add(row.getBigDecimal("periodinamount"));
            result.put(row.getString("calorg") + "@" + row.getString("periodid") + "@" + row.getString("materialid"), BigDecimal.ZERO.compareTo(curData) != 0 ? row.getBigDecimal("periodoutamount").divide(curData) : BigDecimal.ZERO);
        }
        return result;
    }

    private Map<String, BigDecimal> preBeginAmout(DataSet data) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        for (Row row : data) {
            result.put(row.getString("calorg") + "@" + row.getString("materialid") + "@" + row.getString("periodid"), row.getBigDecimal("periodendamount"));
        }
        return result;
    }

    private String getFinalSelects() {
        StringBuilder select = new StringBuilder();
        select.append("calorg,periodid,year,case when period = 99 then 0 else period end as period,bizdate,audittime,");
        select.append("billno,calbilltype,billtype,");
        select.append("assist as assistproperty,projectnumber,");
        select.append("periodinamount,periodoutamount,periodendamount,");
        select.append("billid,bizentityobject,materialid");
        return select.toString();
    }

    private DataSet unionTotalDataSet(DataSet dataSet, Set<Long> costAccountIds, Set<Long> materialIds) {
        DataSet periodTotalDataSet = dataSet.copy().groupBy(new String[]{"calorg", "periodid", "year", "period", "materialid"}).sum("periodinamount").sum("periodoutamount").minP("ordercol_second", "periodendamount").finish().select(new String[]{"calorg", "periodid", "materialid", "year", "period", "periodinamount", "periodoutamount", "periodendamount+periodinamount-periodoutamount as periodendamount"}).select(this.getPeriodTotalFinalSelects().split(","));
        return dataSet.addField("0", "ordercol_first").union(periodTotalDataSet.addField("1", "ordercol_second").addField("1", "ordercol_first"));
    }

    private String getPeriodTotalFinalSelects() {
        String s = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"ProductDiffTransferListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("calorg,periodid,year as year,period as period,null as bizdate,null as audittime,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,materialid,");
        select.append("null as assist,null as projectnumber,null as entryid,null as srcobject,");
        select.append("periodinamount as periodinamount,");
        select.append("periodoutamount as periodoutamount,");
        select.append("periodendamount as periodendamount,");
        select.append("0 as billid,null as bizentityobject");
        return select.toString();
    }

    private DataSet calPeriodEndDataSet(DataSet dataSet) {
        String[] selectFields = (this.getTempSelects() + ",PreRowValue(periodendamount) + periodinamountbak - periodoutamount as periodendamount,billid,bizentityobject,ordercol_second").split(",");
        return dataSet.orderBy(new String[]{"year", "period", "ordercol_second", "bizdate", "audittime"}).select(selectFields);
    }

    private String getTempSelects() {
        StringBuilder select = new StringBuilder();
        select.append("calorg,periodid,year,period,bizdate,audittime,");
        select.append("billno,calbilltype,billtype,materialid,");
        select.append("assist,projectnumber,entryid,srcobject,");
        select.append("periodinamount,periodoutamount");
        return select.toString();
    }

    private DataSet unionPeriodBeginDataSet(DataSet dataSet, Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        DataSet data = this.getPeriodBeginDataSet(costAccountIds, materialIds, periodIds).addField("0", "ordercol_second");
        return dataSet.addField("1", "ordercol_second").union(data);
    }

    private DataSet getPeriodBeginDataSet(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_balance", (String)"calorg,periodid,year,month,material as materialid,periodbeginqty,periodbeginactualcost", (QFilter[])new QFilter[]{this.getPeriodBeginBalFilter(costAccountIds, materialIds)}, null).groupBy(new String[]{"calorg", "periodid", "year", "month", "materialid"}).sum("periodbeginqty").sum("periodbeginactualcost").finish();
        return dataSet.select(this.getPeriodBeginFinalSelects().split(","));
    }

    private String getPeriodBeginFinalSelects() {
        String s = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"ProductDiffTransferListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("calorg,periodid,year as year,month as period,null as bizdate,null as audittime,");
        select.append("null as billno,null as calbilltype,'");
        select.append(s);
        select.append("' as billtype,materialid,");
        select.append("null as assist,null as projectnumber,");
        select.append("0 as periodinamount,");
        select.append("0 as periodoutamount,");
        select.append("0 as periodendamount,");
        select.append("periodbeginactualcost as periodinamountbak,");
        select.append("0 as billid,null as bizentityobject,null as entryid,null as srcobject");
        return select.toString();
    }

    private DataSet getCostRecordDataSet(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costrecord", (String)this.getCostRecordSelects(), (QFilter[])new QFilter[]{this.getCostRecordFilter(costAccountIds, materialIds, periodIds)}, null);
    }

    private DataSet getCostAdjustDataSet(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_costadjustbill", (String)this.getCostAdjustSelects(), (QFilter[])new QFilter[]{this.getCostAdjustFilter(costAccountIds, materialIds, periodIds)}, null);
    }

    private String getCostAdjustSelects() {
        String s = ResManager.loadKDString((String)"\u6210\u672c\u8c03\u6574\u5355", (String)"ProductDiffTransferListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]);
        StringBuilder select = new StringBuilder();
        select.append("calorg,period.id as periodid,period.periodyear as year,period.periodnumber as period,bizdate as bizdate,auditdate as audittime,");
        select.append("billno as billno,case when biztype = 'A' then 'IN' else 'OUT' end as calbilltype,'");
        select.append(s);
        select.append("' as billtype,entryentity.material.id as materialid,");
        select.append("entryentity.assist as assist,entryentity.project.number as projectnumber,");
        select.append("case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamount,");
        select.append("case when biztype = 'B' then entryentity.adjustamt else 0 end as periodoutamount,");
        select.append("0 as periodendamount,");
        select.append("case when biztype = 'A' then entryentity.adjustamt else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costadjust_subentity' as bizentityobject,entryentity.id as entryid,'costadjustbill' as srcobject");
        return select.toString();
    }

    private String getCostRecordSelects() {
        StringBuilder select = new StringBuilder();
        select.append("calorg,period.id as periodid,period.periodyear as year,period.periodnumber as period,bizdate as bizdate,auditdate as audittime,");
        select.append("billno as billno,calbilltype as calbilltype,billtype.name as billtype,entry.material.id as materialid,");
        select.append("entry.assist as assist,entry.project.number as projectnumber,");
        select.append("case when calbilltype = 'IN' then entry.actualcost else 0 end as periodinamount,");
        select.append("case when calbilltype = 'OUT' then entry.actualcost else 0 end as periodoutamount,");
        select.append("0 as periodendamount,");
        select.append("case when calbilltype = 'IN' then entry.actualcost else 0 end as periodinamountbak,");
        select.append("id as billid,'cal_costrecord_subentity' as bizentityobject,entry.id as entryid,'costrecord' as srcobject");
        return select.toString();
    }

    private QFilter getCostRecordFilter(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("period", "in", periodIds);
        q.and("entry.material", "in", materialIds);
        q.and("issplitcreate", "=", (Object)Boolean.FALSE);
        q.and("isinitbill", "=", (Object)Boolean.FALSE);
        return q;
    }

    private QFilter getCostAdjustFilter(Set<Long> costAccountIds, Set<Long> materialIds, Set<Long> periodIds) {
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("period", "in", periodIds);
        q.and("entryentity.material", "in", materialIds);
        q.and("billstatus", "=", (Object)"C");
        q.and("createtype", "not in", (Object)new String[]{"G", "H", "K"});
        return q;
    }

    private QFilter getPeriodBeginBalFilter(Set<Long> costAccountIds, Set<Long> materialIds) {
        QFilter q = new QFilter("costaccount", "in", costAccountIds);
        q.and("material", "in", materialIds);
        q.and("period", "=", (Object)0);
        return q;
    }
}

