/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.formplugin.difftransfer.DiffTransferCommon;

public class UnabsorbdiffBillEditPlugin
extends AbstractBillPlugIn {
    private static final String BAR_TRACK = "bar_track";
    private static final String SOURCEBILL = "sourcebill";
    private static final String ENTRYSOURCEBILL = "entryentity.entrysourcebill";
    private static final String RD_TRACKDOWN = "rd_trackdown";

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        itemKey.getClass();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "rd_trackdown": {
                this.track();
            }
        }
    }

    private void track() {
        String billno = (String)this.getModel().getValue("billno");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entryentity.srcbillnum", "=", (Object)billno));
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        if (costAdjusts != null && !costAdjusts.isEmpty()) {
            HashSet<Long> pkIds = new HashSet<Long>();
            costAdjusts.forEach(t -> pkIds.add(t.getLong("id")));
            DiffTransferCommon.showBillByPkId(this.getView(), "cal_stdcostdiffbill", pkIds, qfList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u67e5\u7684\u5355\u636e\u3002", (String)"UnabsorbdiffBillEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillMaterAuxpty();
        this.setEntryOrder();
        this.changManuorgStatus();
    }

    private void fillMaterAuxpty() {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
        this.getModel().setValue("material", costObject == null ? null : Long.valueOf(costObject.getLong("material.id")));
        this.getModel().setValue("auxpty", costObject == null || costObject.getDynamicObject("auxpty") == null ? null : costObject.getDynamicObject("auxpty").get("id"));
    }

    private void setEntryOrder() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        TreeMap<String, DynamicObject> map = new TreeMap<String, DynamicObject>(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                return obj1.compareTo(obj2);
            }
        });
        for (DynamicObject en : entry) {
            map.put(en.getString("element.number") + "_" + en.getString("subelement.number"), en);
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection newEntry = this.getModel().getEntryEntity("entryentity");
        for (Map.Entry mapEntry : map.entrySet()) {
            DynamicObject val = (DynamicObject)mapEntry.getValue();
            if (val == null) continue;
            DynamicObject row = newEntry.addNew();
            row.set("element", (Object)val.getDynamicObject("element"));
            row.set("subelement", (Object)val.getDynamicObject("subelement"));
            row.set("amount", (Object)val.getBigDecimal("amount"));
        }
        this.getView().updateView("entryentity");
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

