/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.difftransfer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.sca.formplugin.difftransfer.DiffTransferCommon;

public class UnabsorbdiffBillListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final String TBLTRACK = "tbltrack";
    private static final String SOURCEBILL = "sourcebill";
    private static final String ENTRYSOURCEBILL = "entryentity.entrysourcebill";
    private static final String RD_TRACKDOWN = "rd_trackdown";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{TBLTRACK});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        evt.getItemKey().getClass();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "rd_trackdown": {
                this.track();
            }
        }
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (!CadEmptyUtils.isEmpty(orgId)) {
            Long id = Long.valueOf(orgId.get(0).toString());
            return StartCostHelper.getCostAccountItems((Long)id, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        }
        return new ArrayList<ComboItem>();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("billno desc");
    }

    private void track() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u67e5\u7684\u6570\u636e\u3002", (String)"UnabsorbdiffBillListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        HashSet<String> billnoList = new HashSet<String>();
        for (ListSelectedRow row : selectedRows) {
            billnoList.add(row.getBillNo());
        }
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entryentity.srcbillnum", "in", billnoList));
        DynamicObjectCollection costAdjusts = QueryServiceHelper.query((String)"cal_stdcostdiffbill", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        if (costAdjusts != null && !costAdjusts.isEmpty()) {
            HashSet<Long> pkIds = new HashSet<Long>();
            costAdjusts.forEach(t -> pkIds.add(t.getLong("id")));
            DiffTransferCommon.showBillByPkId(this.getView(), "cal_stdcostdiffbill", pkIds, qfList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u67e5\u7684\u5355\u636e\u3002", (String)"UnabsorbdiffBillListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }
}

