/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.FillBatchHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocStdEditPlugin
extends AbstractBillPlugIn {
    private static final String ACCTORG = "org";
    public static final String BATCHFILL = "batchfillentry";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctOrg = (String)formShowParameter.getCustomParam(ACCTORG);
        if (acctOrg != null) {
            this.getModel().setValue(ACCTORG, (Object)acctOrg);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"effectdate"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"expdate"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billno = this.getModel().getDataEntity().getString("billno");
        this.getPageCache().put("billno", billno);
        Long org = this.getModel().getDataEntity().getLong("org.id");
        if (org != null && OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(String.valueOf(org)))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"manuorg"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("allocentry");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryentity.get(i);
                DynamicObject material = row.getDynamicObject("bmaterial");
                DynamicObject materialgroup = row.getDynamicObject("materialgroup");
                this.changeFileEnableStatus(i, material, materialgroup);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String appId = fsp.getAppId();
        this.getModel().setValue("appnum", (Object)appId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        BasedataEdit costdriver = (BasedataEdit)this.getControl("costdriver");
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(evt -> {
            List manuOrgs;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue(ACCTORG);
            if (createorg != null) {
                manuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)createorg.getPkValue()), (String)this.getBillEntityId());
                DynamicObject nowOrg = (DynamicObject)this.getModel().getValue("manuorg");
                if (!ObjectUtils.isEmpty((Object)nowOrg) && !CollectionUtils.isEmpty((Collection)manuOrgs)) {
                    manuOrgs.remove((Long)nowOrg.getPkValue());
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocStdEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)manuOrgs));
        });
        costcenter.addBeforeF7SelectListener(evt -> {
            DynamicObject createorg = (DynamicObject)this.getModel().getValue(ACCTORG);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocStdEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("accountorg", "=", createorg.getPkValue()));
            qFilters.add(new QFilter("orgduty", "=", (Object)4L));
        });
        if (material != null) {
            material.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                    boolean canSelect = MatAllocStdEditPlugin.this.isMaterialSelect();
                    if (!canSelect) {
                        MatAllocStdEditPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u6807\u51c6\u5206\u5f55\u4e2d\u6210\u672c\u4e2d\u5fc3\u4e0d\u4e3a\u7a7a\u7684\u4e00\u6761\u5206\u5f55\u3002", (String)"MatAllocStdEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                        beforeF7SelectEvent.setCancel(true);
                    }
                    QFilter[] filters = MatAllocStdEditPlugin.this.getMaterialFilter();
                    ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    formShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
                    ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
                    List qFilters = filterParameter.getQFilters();
                    qFilters.addAll(Arrays.asList(filters));
                }
            });
        }
        costdriver.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter appnumFilter = new QFilter("appnum", "=", (Object)MatAllocStdEditPlugin.this.getAppnum());
                listShowParameter.getListFilterParameter().getQFilters().add(appnumFilter);
            }
        });
        BasedataEdit bmaterial = (BasedataEdit)this.getControl("bmaterial");
        bmaterial.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue(ACCTORG);
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocStdEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qfMat = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)createorg.getLong("id"));
            qFilters.add(qfMat);
        });
        BasedataEdit matversion = (BasedataEdit)this.getControl("matversion");
        matversion.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            int row = evt.getRow();
            DynamicObject materialDy = (DynamicObject)this.getModel().getValue("bmaterial", row);
            if (materialDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u586b\u5199\u7269\u6599\u7f16\u7801\u3002", (String)"MatAllocStdEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("material", "=", materialDy.getPkValue()));
        });
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue(ACCTORG);
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MatAllocStdEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList<Long> orgList = new ArrayList<Long>();
            orgList.add(createorg.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgList, null, true});
            qFilters.add(serviceResponse);
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setF7QFilter(List<QFilter> qFilters, String f7Key) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("allocentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
            return;
        }
        HashSet existsSet = new HashSet(8);
        entryentity.forEach(r -> {
            DynamicObject matDyn = r.getDynamicObject(f7Key);
            if (matDyn != null) {
                existsSet.add(matDyn.getLong("id"));
            }
        });
        if (existsSet.size() >= 1) {
            qFilters.add(new QFilter("id", "not in", existsSet));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchfillentry": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"allocentry", (String[])new String[]{"costdriver"});
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        String orgNumber = ((JSONObject)sourceData.get(ACCTORG)).getString("number");
        String manuOrgNumber = "";
        if (sourceData.get("manuorg") != null) {
            manuOrgNumber = ((JSONObject)sourceData.get("manuorg")).getString("number");
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        String msg = null;
        if (org != null && !OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id")) && !CadEmptyUtils.isEmpty((String)manuOrgNumber)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u53ef\u5f55\u3002", (String)"MatAllocStdEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(msg);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_save": {
                Object billno = this.getModel().getValue("billno");
                if (billno != null && !CadEmptyUtils.isEmpty((String)billno.toString())) break;
                this.getModel().setValue("billno", (Object)this.getPageCache().get("billno"));
            }
        }
    }

    private QFilter[] getMaterialFilter() {
        String costcentid = this.getPageCache().get("currentcostcentid");
        DynamicObjectCollection products = QueryServiceHelper.query((String)"cad_costobject", (String)"material", (QFilter[])new QFilter[]{new QFilter("costcenter", "=", (Object)(CadEmptyUtils.isEmpty((String)costcentid) ? 0L : Long.parseLong(costcentid)))});
        ArrayList ids = new ArrayList();
        ArrayList<Object> existIds = new ArrayList<Object>();
        products.forEach(e -> ids.add(e.get("material")));
        int entryRowCount = this.getModel().getEntryRowCount("productsubentry");
        for (int row = 0; row < entryRowCount; ++row) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
            if (material == null) continue;
            existIds.add(material.getPkValue());
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter existFilter = new QFilter("id", "not in", existIds);
        return new QFilter[]{idFilter, existFilter};
    }

    private boolean isMaterialSelect() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("allocentry");
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter", currentRowIndex);
        if (costcenter == null) {
            return false;
        }
        this.getPageCache().put("currentcostcentid", costcenter.getString("id"));
        return true;
    }

    private String getAppnum() {
        return (String)this.getModel().getValue("appnum");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "audit": 
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "newentry": {
                int i = this.getModel().getEntryCurrentRowIndex("allocentry");
                if (i < 0) {
                    return;
                }
                DynamicObject material = (DynamicObject)this.getModel().getValue("bmaterial", i);
                DynamicObject materialgroup = (DynamicObject)this.getModel().getValue("materialgroup", i);
                this.changeFileEnableStatus(i, material, materialgroup);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "costcenter": {
                DynamicObjectCollection productsubentry = this.getModel().getEntryEntity("productsubentry");
                if (productsubentry.size() <= 0) break;
                this.getModel().deleteEntryData("productsubentry");
                break;
            }
            case "bmaterial": {
                FlexEdit auxpty = (FlexEdit)this.getControl("auxpty");
                Boolean flag = false;
                Boolean isenablematerialversion = false;
                if (newValue != null) {
                    DynamicObject materialData = (DynamicObject)newValue;
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialgroup"});
                    isenablematerialversion = materialData.getBoolean("isenablematerialversion");
                    flag = materialData.getBoolean("isuseauxpty");
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialgroup"});
                }
                this.getModel().setValue("matversion", null, rowIndex);
                this.getModel().setValue("auxpty", null, rowIndex);
                this.getView().setEnable(flag, rowIndex, new String[]{"auxpty"});
                this.getView().setEnable(isenablematerialversion, rowIndex, new String[]{"matversion"});
                break;
            }
            case "materialgroup": {
                if (newValue != null) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"bmaterial"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"bmaterial"});
                }
                int count = this.getModel().getEntryRowCount("allocentry");
                for (int i = 0; i < count; ++i) {
                    DynamicObject material = (DynamicObject)this.getModel().getValue("bmaterial", i);
                    DynamicObject materialgroup = (DynamicObject)this.getModel().getValue("materialgroup", i);
                    this.changeFileEnableStatus(i, material, materialgroup);
                }
                break;
            }
        }
    }

    private void changeFileEnableStatus(int i, DynamicObject material, DynamicObject materialgroup) {
        Boolean isenablematerialversion = false;
        Boolean isuseauxptyFlag = false;
        if (material != null) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialgroup"});
            isenablematerialversion = material.getBoolean("isenablematerialversion");
            isuseauxptyFlag = material.getBoolean("isuseauxpty");
        } else {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"materialgroup"});
        }
        this.getView().setEnable(isenablematerialversion, i, new String[]{"matversion"});
        this.getView().setEnable(isuseauxptyFlag, i, new String[]{"auxpty"});
        if (materialgroup != null) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"bmaterial"});
        } else {
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"bmaterial"});
        }
    }
}

