/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class MatAllocateImportEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(MatAllocateImportEditPlugin.class);
    private static final String COSTACCOUNTLIST = "costaccountlist";
    private static final String CAL_SYSCTRLENTITY = "cal_sysctrlentity";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List orgId = (List)fsp.getCustomParam("org");
        Long costaccount = (Long)fsp.getCustomParam("costaccount");
        Long planscheme = (Long)fsp.getCustomParam("planscheme");
        String type = (String)fsp.getCustomParam("type");
        if ("1".equals(type)) {
            if (CadEmptyUtils.isEmpty((Long)costaccount) || CadEmptyUtils.isEmpty((Long)planscheme)) {
                return;
            }
            this.planFeeAllocSelectSet(costaccount, planscheme);
        } else {
            if (CadEmptyUtils.isEmpty((List)orgId)) {
                return;
            }
            this.matAllocSelectSet(orgId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String type = (String)fsp.getCustomParam("type");
        if ("1".equals(type)) {
            Long costaccount = (Long)fsp.getCustomParam("costaccount");
            if (CadEmptyUtils.isEmpty((Long)costaccount)) {
                return;
            }
            try {
                this.userLastPeriodSelect(costaccount);
            }
            catch (Exception ex) {
                logger.error("\u83b7\u53d6\u7528\u6237\u9009\u62e9\u7684\u6570\u636e\u5931\u8d25\uff1a", (Throwable)ex);
            }
            BasedataEdit control = (BasedataEdit)this.getControl("currentperiod");
            control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4", (String)"MatAllocateImportEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0])));
        }
    }

    private void userLastPeriodSelect(Long costaccount) {
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccount, (String)"cal_bd_costaccount");
        if (costaccountDyn == null) {
            return;
        }
        ArrayList<Long> lastIds = new ArrayList<Long>(10);
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())};
        DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"id,planperiodsel", (QFilter[])filters);
        if (userDataRecord != null && !StringUtils.isEmpty((CharSequence)userDataRecord.getString("planperiodsel"))) {
            String jsonStr = userDataRecord.getString("planperiodsel");
            this.getPageCache().put("lastSelect", jsonStr);
            JSONArray json = JSON.parseArray((String)jsonStr);
            if (json != null) {
                for (int i = 0; i < json.size(); ++i) {
                    lastIds.add(json.getLong(i));
                }
            }
        }
        DynamicObjectCollection costaccountlist = this.getModel().getDataEntity().getDynamicObjectCollection(COSTACCOUNTLIST);
        ArrayList<Integer> selectIds = new ArrayList<Integer>(10);
        int currIndex = 0;
        for (DynamicObject dyn : costaccountlist) {
            if (lastIds.contains(dyn.getLong("currentperiod.id"))) {
                selectIds.add(currIndex);
            }
            ++currIndex;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(COSTACCOUNTLIST);
        if (!selectIds.isEmpty()) {
            int[] selectIndex = new int[selectIds.size()];
            for (int i = 0; i < selectIds.size(); ++i) {
                selectIndex[i] = (Integer)selectIds.get(i);
            }
            grid.selectRows(selectIndex, 0);
        }
    }

    private void planFeeAllocSelectSet(Long costaccount, Long planscheme) {
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccount, (String)"cal_bd_costaccount");
        if (costaccountDyn == null) {
            return;
        }
        Long orgId = costaccountDyn.getLong("calorg.id");
        IDataModel model = this.getModel();
        if (model.getEntryRowCount(COSTACCOUNTLIST) > 0) {
            model.deleteEntryData(COSTACCOUNTLIST);
        }
        model.setValue("showorg", (Object)orgId);
        List periods = PlanFeeAllocHelper.getPlanStartPeriods((Long)planscheme);
        if (CadEmptyUtils.isEmpty((List)periods)) {
            return;
        }
        int currIndex = 0;
        for (int i = 0; i < periods.size(); ++i) {
            model.createNewEntryRow(COSTACCOUNTLIST);
            model.setValue("org", (Object)orgId, currIndex);
            model.setValue("costaccount", (Object)costaccount, currIndex);
            model.setValue("currentperiod", periods.get(i), currIndex);
            ++currIndex;
        }
    }

    private void matAllocSelectSet(List<Object> orgId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection costaccounts = this.getCostaccount(orgId);
        int entrySize = costaccounts.size();
        if (entrySize <= 0) {
            return;
        }
        if (model.getEntryRowCount(COSTACCOUNTLIST) > 0) {
            model.deleteEntryData(COSTACCOUNTLIST);
        }
        int currIndex = 0;
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject costaccount = (DynamicObject)costaccounts.get(i);
            Long costaccountId = costaccount.getLong("costaccount");
            Long periodId = this.getPeriod(costaccount.getLong("org"), costaccountId);
            if (periodId == null) continue;
            model.createNewEntryRow(COSTACCOUNTLIST);
            model.setValue("org", (Object)costaccount.getLong("org"), currIndex);
            model.setValue("costaccount", (Object)costaccountId, currIndex);
            model.setValue("currentperiod", (Object)periodId, currIndex);
            ++currIndex;
        }
        model.setValue("showorg", (Object)((DynamicObject)costaccounts.get(0)).getLong("org"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "confirm": {
                EntryGrid entrygrid = (EntryGrid)this.getControl(COSTACCOUNTLIST);
                int[] selectRows = entrygrid.getSelectRows();
                if (selectRows == null || selectRows.length == 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u540e\u518d\u786e\u8ba4\u3002", (String)"MatAllocateImportEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Integer> selectList = new ArrayList<Integer>(10);
                int[] nArray = selectRows;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer rowIndex = nArray[i];
                    selectList.add(rowIndex);
                }
                Boolean errorMsg = Boolean.FALSE;
                ArrayList<DynamicObject> selectData = new ArrayList<DynamicObject>();
                DynamicObjectCollection rows = this.getModel().getEntryEntity(COSTACCOUNTLIST);
                ArrayList<Long> selectIds = new ArrayList<Long>();
                for (DynamicObject row : rows) {
                    if (!selectList.contains(row.getInt("seq") - 1)) continue;
                    Long periodId = row.getLong("currentperiod.id");
                    if (CadEmptyUtils.isEmpty((Long)periodId)) {
                        errorMsg = Boolean.TRUE;
                        break;
                    }
                    selectIds.add(periodId);
                    selectData.add(row);
                }
                if (errorMsg.booleanValue()) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u5f53\u524d\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatAllocateImportEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter fsp = this.getView().getFormShowParameter();
                String type = (String)fsp.getCustomParam("type");
                if (!selectIds.isEmpty() && "1".equals(type)) {
                    String lastStr = this.getPageCache().get("lastSelect");
                    String nextStr = JSON.toJSONString(selectIds);
                    if (!nextStr.equals(lastStr)) {
                        MatAllocateImportEditPlugin.saveUserSetting(this.getModel().getDataEntity(), nextStr);
                    }
                }
                this.getView().returnDataToParent(selectData);
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    private static synchronized void saveUserSetting(DynamicObject dataEntity, String ids) {
        try {
            Long orgId = dataEntity.getLong("showorg.id");
            String userId = RequestContext.get().getUserId();
            QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(userId))};
            DynamicObject userDataRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"id,planperiodsel", (QFilter[])filters);
            if (userDataRecord == null) {
                userDataRecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_userdatarecord");
                userDataRecord.set("modifytime", (Object)new Date());
                userDataRecord.set("user", (Object)RequestContext.get().getUserId());
                userDataRecord.set("planperiodsel", (Object)ids);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userDataRecord});
                return;
            }
            userDataRecord = BusinessDataServiceHelper.loadSingle((Object)userDataRecord.getLong("id"), (String)"cad_userdatarecord");
            userDataRecord.set("planperiodsel", (Object)ids);
            SaveServiceHelper.update((DynamicObject)userDataRecord);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237\u6570\u636e\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\u3002", (Throwable)e);
        }
    }

    private Long getPeriod(Long orgId, Long costaccountId) {
        if (orgId == null || costaccountId == null) {
            return null;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)CAL_SYSCTRLENTITY, (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res == null || res.size() == 0) {
            return null;
        }
        return ((DynamicObject)res.get(0)).getLong("currentperiod");
    }

    private DynamicObjectCollection getCostaccount(List<Object> orgIdList) {
        String selectFields = "id AS costaccount, calorg As org";
        String orderby = "enablestandardcost DESC, number ASC";
        QFilter filter = StartCostHelper.getEnabledFilter(orgIdList, (String)(this.getView().getFormShowParameter().getAppId() == null ? "sca" : this.getView().getFormShowParameter().getAppId()));
        QFilter isEnabledFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{filter, isEnabledFilter}, (String)orderby);
        return result;
    }
}

