/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.SysImpEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.cad.common.utils.MsgUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import kd.macc.sca.common.helper.MatUseHelper;
import kd.macc.sca.formplugin.base.BaseOrgAndCostCenterFilterList;

public class MatUseCollectListPlugin
extends BaseOrgAndCostCenterFilterList {
    private static final Log logger = LogFactory.getLog(MatUseCollectListPlugin.class);
    private static final String PAGECACHE_COSTCENTERSET = "costcenterset";
    private static final String closeBack_importResult = "importResult";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "importdata", "importdetails"});
        } else if ("aca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())) && CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "sysimport_aca", "tbldel", "tblsubmit", "tblcheck", "colreport", "tbl_traceup", "baritemap", "tblrefresh"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblnew", "sysimport", "tbl_traceup", "sysimport_aca"});
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        String accountorgId = this.getPageCache().get("org");
        if (fieldName.startsWith("costcenter")) {
            args.getQfilters().add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountorgId)).and(new QFilter("enable", "=", (Object)"1")));
        }
        if (fieldName.startsWith("manuorg")) {
            if (!CadEmptyUtils.isEmpty((String)accountorgId)) {
                List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(accountorgId), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        ArrayList toFixedColList = Lists.newArrayList((Object[])new String[]{"org.number", "org.name", "costcenter.number", "costcenter.name", "billno"});
        listColumns.forEach(e -> {
            String fieldKey = e.getListFieldKey();
            if (toFixedColList.contains(fieldKey)) {
                e.setFixed(true);
            }
        });
        if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"productgroup.name", "productgroup.number"}));
        } else {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"srcauditdate"}));
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter manuOrgQFilter;
        String orgId;
        super.setFilter(e);
        QFilter costCenterFilter = this.getCostCenterFilter();
        if (costCenterFilter != null) {
            e.getQFilters().add(costCenterFilter);
        }
        if (!CadEmptyUtils.isEmpty((String)(orgId = this.getPageCache().get(this.ORG_FIELD))) && OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId)) && (manuOrgQFilter = this.getManuOrgQFilter()) != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String acctOrgId = this.getPageCache().get("org");
        String orgId = "0".equals(acctOrgId) ? "" : acctOrgId;
        String costCenterId = this.getPageCache().get("costcenter");
        switch (itemKey) {
            case "tblnew": {
                break;
            }
            case "importdata": {
                break;
            }
        }
    }

    private boolean checkPerm() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityNum = "aca_matusecollect";
        if ("sca".equals(appId)) {
            entityNum = "sca_matusecollect";
        }
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.getOrCreate().getCurrUserId(), (String)appId, (String)entityNum, (String)"47156aff000000ac");
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "sysimport": 
            case "sysimport_aca": {
                boolean hasPrem = this.checkPerm();
                if (!hasPrem) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6750\u6599\u8017\u7528\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MatUseCollectListPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                this.fromInnerSysImport(SysImpEnum.SYSIMPORT.getValue());
                break;
            }
            case "sysimportcover": {
                boolean hasPremSca = this.checkPerm();
                if (!hasPremSca) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6750\u6599\u8017\u7528\u5f52\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MatUseCollectListPlugin_23", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                this.fromInnerSysImport(SysImpEnum.SYSIMPORTCOVER.getValue());
                break;
            }
            case "tbl_traceup": {
                this.traceUpSourceBill();
                break;
            }
            case "colreport": {
                this.viewColReport();
                break;
            }
            case "searchconfig": {
                this.searchConfig();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        this.getView().hideLoading();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "importResult": {
                BillList billList = (BillList)this.getControl("billlistap");
                String responseInfoStr = this.getPageCache().get("responseInfo");
                if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                    return;
                }
                Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                if ("confirm".equals(responseInfo.get("type"))) {
                    billList.refresh();
                    this.getView().showConfirm((String)responseInfo.get("msg"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("showReport", (IFormPlugin)this));
                    break;
                }
                MsgUtils.showMsgAndRefresh((Map)responseInfo, (IFormView)this.getView(), (BillList)billList);
                break;
            }
        }
    }

    private void searchConfig() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() == 0) {
            return;
        }
        ImportServiceHelper.seachConfig((Object[])rows.getPrimaryKeyValues(), (String)this.getBillEntityId(), (IFormView)this.getView());
    }

    private void viewColReport() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"cad_colreport", (boolean)true, (int)1, (boolean)false);
        String acctOrgId = this.getPageCache().get("org");
        listShowParameter.setCustomParam("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        listShowParameter.setCustomParam("org", (Object)acctOrgId);
        listShowParameter.setCustomParam("colobj", (Object)CollectObjectEnum.MAT_USE.getObj());
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u62a5\u544a", (String)"MatUseCollectListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        BillList billlist = (BillList)this.getControl("billlistap");
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            switch (callBackId) {
                case "isDelete": {
                    ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)MatUseHelper.getEntity(this.getView().getFormShowParameter().getAppId()), (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
                    if (operationResult.isSuccess()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MatUseCollectListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showOperationResult(operationResult);
                    break;
                }
                case "showReport": {
                    String responseInfoStr = this.getPageCache().get("responseInfo");
                    if (CadEmptyUtils.isEmpty((String)responseInfoStr)) {
                        return;
                    }
                    Map responseInfo = (Map)SerializationUtils.fromJsonString((String)responseInfoStr, Map.class);
                    this.showColReport((String)responseInfo.get("colReportId"));
                    break;
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String appNum = this.getView().getFormShowParameter().getAppId();
        if ("aca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "importdata", "importdetails", "exportdata", "exportdata_expt"});
        }
        if ("sca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sysimport_aca"});
        }
    }

    private boolean isSysImport(String orgId, String costCenterId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CadEmptyUtils.isEmpty((String)costCenterId)) {
            List costCenterIdList = SysParamHelper.getSysParamCostCenter((String)orgId, (String)"matcollectway", (String)"INNERSYSIMPORT", (String)appId);
            if (CadEmptyUtils.isEmpty((List)costCenterIdList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u53c2\u6570\u201d\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\uff0c\u6750\u6599\u8017\u7528\u5f52\u96c6\u4e0d\u5b58\u5728\u201c\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u201d\u7684\u65b0\u589e\u65b9\u5f0f\u3002", (String)"MatUseCollectListPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        String addType = SysParamHelper.getScaSysParamAddType((String)orgId, (String)costCenterId, (String)"matcollectway", (String)appId);
        if (StringUtils.isNotEmpty((String)addType)) {
            if ("INNERSYSIMPORT".equals(addType)) {
                return true;
            }
            switch (addType) {
                case "TPLIMPORT": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u6a21\u677f\u5bfc\u5165\u3002", (String)"MatUseCollectListPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                case "APIINTERFACE": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3aAPI\u63a5\u53e3\u3002", (String)"MatUseCollectListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                case "MANUALENTER": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u3002", (String)"MatUseCollectListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u3002", (String)"MatUseCollectListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        return false;
    }

    private boolean isModelImport(String orgId, String costCenterId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (CadEmptyUtils.isEmpty((String)costCenterId)) {
            List costCenterIdList = SysParamHelper.getSysParamCostCenter((String)orgId, (String)"matcollectway", (String)"TPLIMPORT", (String)appId);
            if (CadEmptyUtils.isEmpty((List)costCenterIdList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u53c2\u6570\u201d\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\uff0c\u6750\u6599\u8017\u7528\u5f52\u96c6\u4e0d\u5b58\u5728\u201c\u6a21\u677f\u5bfc\u5165\u201d\u7684\u65b0\u589e\u65b9\u5f0f\u3002", (String)"MatUseCollectListPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        String addType = SysParamHelper.getScaSysParamAddType((String)orgId, (String)costCenterId, (String)"matcollectway", (String)appId);
        if (StringUtils.isNotEmpty((String)addType)) {
            if ("TPLIMPORT".equals(addType)) {
                return true;
            }
            switch (addType) {
                case "INNERSYSIMPORT": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u3002", (String)"MatUseCollectListPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                case "APIINTERFACE": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3aAPI\u63a5\u53e3\u3002", (String)"MatUseCollectListPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
                case "MANUALENTER": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u3002", (String)"MatUseCollectListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5bfc\u5165\u3002\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u3002", (String)"MatUseCollectListPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        return false;
    }

    private void fromInnerSysImport(String impType) {
        try {
            String orgId = this.getPageCache().get("org");
            if (CadEmptyUtils.isEmpty((String)orgId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MatUseCollectListPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> costCenterIds = new ArrayList<Long>(10);
            List selectedCenterIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("multiselectcostcenters"), List.class);
            String costCenterId = this.getPageCache().get("costcenter");
            if (!CadEmptyUtils.isEmpty((List)selectedCenterIds)) {
                costCenterIds.addAll(selectedCenterIds);
            } else if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
                costCenterIds.add(Long.parseLong(costCenterId));
            } else {
                boolean isEnableMultiFactory;
                String manuOrgId = this.getPageCache().get("manuorg");
                List<ComboItem> comboItems = this.getCostCenterComboItemListByManuOrg(orgId, manuOrgId);
                if (!CadEmptyUtils.isEmpty(comboItems)) {
                    comboItems.forEach(p -> costCenterIds.add(Long.parseLong(p.getValue())));
                }
                if ((isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId))) && CadEmptyUtils.isEmpty(comboItems)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"MatUseCollectListPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
            }
            List enableCostCenters = ImportServiceHelper.getCostCenterByDataRule((Long)RequestContext.get().getCurrUserId(), Collections.singletonList(Long.parseLong(orgId)), (Set)Sets.newHashSet(costCenterIds), (String)MatUseHelper.getEntity(this.getView().getFormShowParameter().getAppId()), (String)this.getView().getFormShowParameter().getAppId());
            Map objRules = CostObjectHelper.getCostObjectRulesMap((Long)Long.parseLong(orgId), (List)enableCostCenters);
            if (CadEmptyUtils.isEmpty((Map)objRules)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"MatUseCollectListPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            if (ImportServiceHelper.isStartCollConfigScheme().booleanValue()) {
                Set calDimensionIds = CostObjectHelper.getCalDimensionIds((Long)Long.parseLong(orgId), costCenterIds, (Map)objRules);
                List collConfigs = ImportServiceHelper.getCollConfigs((Long)Long.parseLong(orgId), null, (Set)calDimensionIds, (String)MatUseHelper.getEntity(this.getView().getFormShowParameter().getAppId()), (String)this.getView().getFormShowParameter().getAppId());
                if (CadEmptyUtils.isEmpty((List)collConfigs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b9\u6848\u3002", (String)"MatUseCollectListPlugin_19", (String)"macc-sca-form", (Object[])new Object[0]));
                    return;
                }
            }
            Boolean isOrgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId));
            ArrayList<Long> manuOrgs = new ArrayList<Long>(10);
            if (isOrgEnableMultiFactory.booleanValue() && CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                List userHasPermManuOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                manuOrgs.addAll(userHasPermManuOrgs);
            } else if (isOrgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((String)this.getPageCache().get("manuorg"))) {
                manuOrgs.add(Long.parseLong(this.getPageCache().get("manuorg")));
            }
            String progressId = UUID.randomUUID().toString();
            ProgressHelper.excute((IFormView)this.getView(), (String)progressId, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"MatUseCollectListPlugin_21", (String)"macc-sca-form", (Object[])new Object[0]), () -> {
                Map responseInfo = new HashMap(2);
                try {
                    responseInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"matUseService", (String)"importMatUse", (Object[])new Object[]{null, null, Long.parseLong(orgId), costCenterIds, manuOrgs, this.getView().getFormShowParameter().getAppId(), this.getBillEntityId(), progressId});
                }
                catch (Exception e) {
                    MsgUtils.putMsg2Map((String)"error", (String)e.toString(), responseInfo);
                    MsgUtils.putMsg2Map((String)"error", (String)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"MatUseCollectListPlugin_22", (String)"macc-sca-form", (Object[])new Object[0]), e.toString()), responseInfo);
                    ProgressHelper.showError((String)progressId, (String)e.getMessage());
                }
                String responseInfoStr = SerializationUtils.toJsonString(responseInfo);
                this.getPageCache().put("responseInfo", responseInfoStr);
            }, (CloseCallBack)new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_importResult));
        }
        catch (Exception ex) {
            logger.error("\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u62a5\u9519\uff1a", (Throwable)ex);
            throw ex;
        }
    }

    private void showColReport(String colReportId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_colreport");
        billShowParameter.setCustomParam("id", (Object)colReportId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u62a5\u544a", (String)"MatUseCollectListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (!CadEmptyUtils.isEmpty((String)this.getPageCache().get("org"))) {
            List multiCostCenters = CadUtils.getMultiCostCentersByFilterName((FilterContainerSearchClickArgs)args, (String)"costcenter.id", (Long)Long.parseLong(this.getPageCache().get("org")));
            this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString((Object)multiCostCenters));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn("costcenter.name");
        List comboItems = filterColumn.getComboItems();
        HashSet<String> costCenterSet = new HashSet<String>(10);
        for (ComboItem comboItem : comboItems) {
            costCenterSet.add(comboItem.getValue());
        }
        this.getPageCache().put(PAGECACHE_COSTCENTERSET, SerializationUtils.toJsonString(costCenterSet));
        this.getPageCache().put("multiselectcostcenters", SerializationUtils.toJsonString(new ArrayList()));
    }

    private boolean isManualNewAdd(String acctOrgId, String costCenterId) {
        QFilter orgFilter = null;
        QFilter costCenterFilter = null;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.isEmpty((String)acctOrgId) && StringUtils.isEmpty((String)costCenterId)) {
            return true;
        }
        if (!StringUtils.isEmpty((String)acctOrgId)) {
            QFilter qFilter = MatUseHelper.getCostCenterQFilter(acctOrgId, "matcollectway", this.getView().getFormShowParameter().getAppId());
            boolean exists = QueryServiceHelper.exists((String)"bos_costcenter", (QFilter[])new QFilter[]{qFilter});
            if (!exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u7684\u6210\u672c\u4e2d\u5fc3\u3002", (String)"MatUseCollectListPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]));
                return false;
            }
            orgFilter = new QFilter("accountorg", "=", (Object)Long.valueOf(acctOrgId));
            filters.add(orgFilter);
        }
        if (!StringUtils.isEmpty((String)costCenterId)) {
            costCenterFilter = new QFilter("costcenter", "=", (Object)Long.valueOf(costCenterId));
            filters.add(costCenterFilter);
        }
        filters.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"matcollectway", (QFilter[])filters.toArray(new QFilter[0]));
        if (sysParam == null) {
            return true;
        }
        switch (sysParam.getString("matcollectway")) {
            case "TPLIMPORT": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u6a21\u677f\u5bfc\u5165\u3002", (String)"MatUseCollectListPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "APIINTERFACE": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3aAPI\u63a5\u53e3\u3002", (String)"MatUseCollectListPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "INNERSYSIMPORT": {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u3002\u6210\u672c\u53c2\u6570\u4e2d\u6750\u6599\u8017\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\u3002", (String)"MatUseCollectListPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]));
                break;
            }
            case "MANUALENTER": {
                return true;
            }
        }
        return false;
    }

    private void traceUpSourceBill() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (selectedRows.size() > 0) {
            Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
            Map<String, List<Object>> probillEntryIdMap = this.getProbillEntryIds(primaryKeys);
            if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u662f\u4ece\u5185\u90e8\u7cfb\u7edf\u5bfc\u5165\uff0c\u4e0d\u80fd\u4e0a\u67e5\u3002", (String)"MatUseCollectListPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            for (Map.Entry<String, List<Object>> probill : probillEntryIdMap.entrySet()) {
                String source = probill.getKey();
                SrcBillShowerUtils.showSearchUpBillOrList((IFormView)this.getView(), (String)source, probill.getValue(), null);
            }
        }
    }

    private Map<String, List<Object>> getProbillEntryIds(Object[] objIds) {
        HashMap<String, List<Object>> probillEntryIdMap = new HashMap<String, List<Object>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filter.and(new QFilter("sourcebillid", ">", (Object)0L));
        String appNum = this.getView().getFormShowParameter().getAppId();
        DynamicObjectCollection rows = QueryServiceHelper.query((String)MatUseHelper.getEntity(appNum), (String)"id,sourcebillid,srcbilltype", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            String srcbilltype = row.getString("srcbilltype");
            probillEntryIdMap.computeIfAbsent(srcbilltype, p -> new ArrayList(10)).add(row.getLong("sourcebillid"));
        }
        return probillEntryIdMap;
    }
}

