/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaAllocEnum;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class MfgFeeAllocListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        this.linkStartAlloc(e);
    }

    private void linkStartAlloc(HyperLinkClickArgs e) {
        BillList billList = (BillList)e.getHyperLinkClickEvent().getSource();
        Object pkVal = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (pkVal == null) {
            return;
        }
        QFilter filter = new QFilter("id", "=", pkVal);
        filter.and(QFilter.of((String)"allocstatus = ? or usetype = ? or alloctype = ?", (Object[])new Object[]{ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue(), ScaAllocEnum.USETYPE_DRIECT.getValue(), ScaAllocEnum.ALLOCTYPE_MANUAL.getValue()}));
        if (QueryServiceHelper.exists((String)"sca_mfgfeealloc", (QFilter[])new QFilter[]{filter})) {
            return;
        }
        this.getPageCache().put("donothing", "pass");
        this.getView().invokeOperation("donothing");
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        Long periodId = 0L;
        for (QFilter filter : filters) {
            if (!"costaccount.id".equals(filter.getProperty())) continue;
            periodId = this.getPeriodBy(filter.getValue().toString());
            break;
        }
        e.getQFilters().add(QFilter.of((String)"period = ?", (Object[])new Object[]{CadEmptyUtils.isEmpty((Long)periodId) ? Long.valueOf(0L) : periodId}));
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        super.beforeItemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "alloc": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.size() > 0) {
                    return;
                }
                billList.selectAllRows();
                this.getView().invokeOperation("donothing");
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        BillList billList = (BillList)this.getControl("billlistap");
        String allocTag = this.getPageCache().get("donothing");
        if ("donothing".equals(e.getOperateKey())) {
            if (!"pass".equalsIgnoreCase(allocTag)) {
                billList.clearSelection();
                this.getView().updateView("billlistap");
            }
            this.getPageCache().remove("donothing");
        }
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
    }

    private DynamicObjectCollection getVouchers(ListSelectedRowCollection rows) {
        List<Object> pks = Arrays.asList(rows.getPrimaryKeyValues());
        QFilter filter = new QFilter("sourcebillid", "in", pks);
        filter.and(QFilter.of((String)"sourcebill =?", (Object[])new Object[]{"sca_mfgfeealloc"}));
        DynamicObjectCollection aiBizVouchers = QueryServiceHelper.query((String)"ai_bizvoucher", (String)"glvoucherid", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)aiBizVouchers)) {
            return null;
        }
        ArrayList vouIds = new ArrayList();
        aiBizVouchers.forEach(s -> vouIds.add(s.get("glvoucherid")));
        QFilter voucherFilter = new QFilter("id", "in", vouIds);
        return QueryServiceHelper.query((String)"gl_voucher", (String)"id,sourcebill,billno", (QFilter[])new QFilter[]{voucherFilter});
    }

    private void addVoucherNum(DynamicObjectCollection vouchers) {
        DynamicObject[] saveItems;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)vouchers)) {
            return;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_mfgfeealloc");
        HashMap map = new HashMap();
        vouchers.forEach(s -> map.computeIfAbsent(s.getLong("sourcebill"), ss -> s.getString("billno")));
        for (DynamicObject saveItem : saveItems = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(new Object[0]), (DynamicObjectType)type)) {
            saveItem.set("vouchernum", map.get(saveItem.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])saveItems);
    }

    private void removeVoucherNum(ListSelectedRowCollection rows, DynamicObjectCollection vouchers) {
        DynamicObject[] delItems;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_mfgfeealloc");
        HashMap notDelMap = new HashMap();
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)vouchers)) {
            vouchers.forEach(s -> notDelMap.computeIfAbsent(s.getLong("sourcebill"), ss -> s.getString("billno")));
        }
        for (DynamicObject item : delItems = BusinessDataServiceHelper.load((Object[])rows.getPrimaryKeyValues(), (DynamicObjectType)type)) {
            if (notDelMap.containsKey(item.getPkValue()) || StringUtils.isEmpty((String)item.getString("vouchernum"))) continue;
            item.set("vouchernum", null);
        }
        SaveServiceHelper.save((DynamicObject[])delItems);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.size() < 1) {
            return;
        }
        HashSet ids = new HashSet();
        rows.forEach(s -> ids.add(s.getPrimaryKeyValue()));
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"sca_mfgfeealloc", (String)"id,baseunit.precision precision,entryentity.id entryid,entryentity.allocvalue allocvalue", (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (DynamicObject entry : entrys) {
            int precision = entry.getInt("precision");
            precision = precision == 0 ? 4 : precision;
            BigDecimal val = entry.getBigDecimal("allocvalue").setScale(precision, 4);
            if (val.compareTo(BigDecimal.ZERO) == 0) {
                map.put(entry.getLong("entryid"), "");
                continue;
            }
            map.put(entry.getLong("entryid"), val.toString());
        }
        int i = 0;
        for (ListSelectedRow row : rows) {
            billList.setCellFieldValue("allocvalue", i, map.get(row.getEntryPrimaryKeyValue()));
            ++i;
        }
    }
}

