/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.FillBatchHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.enums.AllocMoldEnum;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MfgFeeAllocStdEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    protected static final String ISINITED = "isInited";

    public void afterCreateNewData(EventObject e) {
        this.setAllocMold();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private void setAllocMold() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costCenterId = (String)fsp.getCustomParam("costcenter");
        if (!CadEmptyUtils.isEmpty((String)costCenterId)) {
            DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"orgduty.id orgduty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(costCenterId))});
            long orgDutyId = costCenter.getLong("orgduty");
            if (DutyIdConstants.ASSIST_PRODUCT_ID.equals(orgDutyId)) {
                this.getModel().setValue("allocmold", (Object)AllocMoldEnum.ASSIST_PRODUCT_ALLOC.getValue());
            } else if (DutyIdConstants.BASIC_PRODUCT_ID.equals(orgDutyId)) {
                this.getModel().setValue("allocmold", (Object)AllocMoldEnum.BASIC_PRODUCT_ALLOC.getValue());
            } else {
                this.getModel().setValue("allocmold", (Object)AllocMoldEnum.NON_PRODUCT_ALLOC.getValue());
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((CharSequence)appid)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01", (String)"MfgFeeAllocStdEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", appid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1"});
        EntryGrid entryList = (EntryGrid)this.getView().getControl("entryentity");
        entryList.addRowClickListener((RowClickEventListener)this);
        this.setCostCenterFilter();
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection subEntryEntity;
        this.hideSubEntryEdit();
        boolean isBeneficiary = (Boolean)this.getModel().getValue("isbeneficiary");
        if (!isBeneficiary && (subEntryEntity = this.getModel().getEntryEntity("subentryentity")) != null && subEntryEntity.size() > 1) {
            this.getModel().deleteEntryData("subentryentity");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
    }

    public void initialize() {
        super.initialize();
        this.addListener();
    }

    protected void addListener() {
        List permCalOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", (Object)permCalOrgIds));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)(accountorg == null ? 0L : accountorg.getLong("id")), (String)this.getBillEntityId());
            QFilter orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject manuOrg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            if (acctOrg != null) {
                QFilter appnumFilter;
                QFilter billStatusFilter;
                QFilter manuorgFilter;
                QFilter orgFilter = new QFilter("org", "=", acctOrg.getPkValue());
                DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"sca_mfgfeeallocstdnew", (String)"costcenter", (QFilter[])new QFilter[]{orgFilter, manuorgFilter = new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()), billStatusFilter = new QFilter("billstatus", "!=", (Object)"A"), appnumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId())});
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
                    Set costCenterIds = costCenters.stream().map(item -> item.getLong("costcenter")).collect(Collectors.toSet());
                    filters.add(new QFilter("id", "not in", costCenterIds));
                }
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)acctOrg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                filters.add(costCenterIdFilter);
            } else {
                filters.add(new QFilter("accountorg", ">", (Object)0L));
            }
            filterParameter.setQFilters(filters);
        });
        this.f7FilterCostCenterGroup("costcentergroup");
        this.f7FilterSelectedItems("expenseitem");
        this.f7FilterSelectedItems("subelement");
        BasedataEdit centerGroupEdit = (BasedataEdit)this.getControl("centergroup");
        centerGroupEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (acctOrg != null) {
                QFilter qFilter = new QFilter("org", "=", acctOrg.getPkValue());
                filters.add(qFilter);
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            filters.add(dateFilter);
            filterParameter.setQFilters(filters);
        });
        BasedataEdit costDriver = (BasedataEdit)this.getControl("costdriver");
        costDriver.addAfterF7SelectListener(afterF7SelectEvent -> this.deleteEntryrow());
        costDriver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String allocMold;
            Set<Long> filterCostDriverIds;
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)"1"));
            qList.add(new QFilter("status", "=", (Object)"C"));
            qList.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
            qList.add(new QFilter("allocclass", "not in", (Object)new String[]{"MATERIAL", "MATERIALGROUP"}));
            List<Long> matQuotaCostDriverIds = this.getMatQuotaDriverIds();
            if (!CadEmptyUtils.isEmpty(matQuotaCostDriverIds)) {
                qList.add(new QFilter("id", "not in", matQuotaCostDriverIds));
            }
            if (!CadEmptyUtils.isEmpty(filterCostDriverIds = this.getFilterCostDriverIds())) {
                qList.add(new QFilter("id", "not in", filterCostDriverIds));
            }
            if ((allocMold = this.getModel().getDataEntity().getString("allocmold")) != null) {
                if (AllocMoldEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                    qList.add(new QFilter("isrelatedwork", "=", (Object)Boolean.FALSE));
                }
                if (AllocMoldEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                    qList.add(new QFilter("allocclass", "=", (Object)"COSTCENTER"));
                }
            }
        });
        BasedataEdit benfCostCenterEdit = (BasedataEdit)this.getControl("benefcostcenter");
        benfCostCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (acctOrg != null) {
                filters.add(new QFilter("accountorg", "=", acctOrg.getPkValue()));
            }
            ArrayList<Long> selectedItemIds = new ArrayList<Long>();
            DynamicObjectCollection subEntryInfos = this.getModel().getEntryEntity("subentryentity");
            for (int index = 0; index < subEntryInfos.size(); ++index) {
                DynamicObject rowObject = (DynamicObject)subEntryInfos.get(index);
                DynamicObject benfCostCenter = (DynamicObject)rowObject.get("benefcostcenter");
                if (benfCostCenter == null) continue;
                selectedItemIds.add(benfCostCenter.getLong("masterid"));
            }
            filters.add(new QFilter("masterid", "not in", (Object)selectedItemIds.toArray()));
            filterParameter.setQFilters(filters);
        });
    }

    private Set<Long> getFilterCostDriverIds() {
        HashSet<Long> filterCostDriverIds = new HashSet<Long>(16);
        QFilter commonQFilter = new QFilter("enable", "=", (Object)"1");
        commonQFilter.and("status", "=", (Object)"C");
        commonQFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter qFilter = new QFilter("iscomplexcd", "=", (Object)false);
        qFilter.and("islinkresource", "=", (Object)false);
        qFilter.and("isrelatedwork", "=", (Object)false);
        qFilter.and("allocclass", "=", (Object)"COSTOBJECT");
        qFilter.and("issys", "=", (Object)false);
        qFilter.and("srccostdriver", "=", (Object)0L);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostDriverIds", (String)"cad_costdriver", (String)"id", (QFilter[])new QFilter[]{qFilter, commonQFilter}, null);
        HashSet<Long> costObjectCostDriverIds = new HashSet<Long>(16);
        rows.forEach(s -> costObjectCostDriverIds.add(s.getLong("id")));
        if (!CadEmptyUtils.isEmpty(costObjectCostDriverIds)) {
            filterCostDriverIds.addAll(costObjectCostDriverIds);
            QFilter complexFilter = new QFilter("iscomplexcd", "=", (Object)true);
            DataSet comRows = QueryServiceHelper.queryDataSet((String)"getComCostDriverIds", (String)"cad_costdriver", (String)"id,formula", (QFilter[])new QFilter[]{commonQFilter, complexFilter}, null);
            for (Row row : comRows) {
                String formula = row.getString("formula");
                List<Long> costDriverIds = MfgFeeAllocStdEditPlugin.getCostDriverIds(formula);
                if (costDriverIds == null || !this.isContainCostDriver(costObjectCostDriverIds, costDriverIds)) continue;
                filterCostDriverIds.add(row.getLong("id"));
            }
        }
        return filterCostDriverIds;
    }

    private boolean isContainCostDriver(Set<Long> costObjectCostDriverIds, List<Long> costDriverIds) {
        if (CadEmptyUtils.isEmpty(costDriverIds)) {
            return false;
        }
        for (Long costDriverId : costDriverIds) {
            if (!costObjectCostDriverIds.contains(costDriverId)) continue;
            return true;
        }
        return false;
    }

    private List<Long> getMatQuotaDriverIds() {
        ArrayList<Long> matQuotaCostDriverIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter complexFilter = new QFilter("iscomplexcd", "=", (Object)true);
        DynamicObjectCollection complexCostDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,formula", (QFilter[])new QFilter[]{qFilter, complexFilter});
        for (DynamicObject costDriver : complexCostDrivers) {
            String formula = costDriver.getString("formula");
            List<Long> costDriverIds = MfgFeeAllocStdEditPlugin.getCostDriverIds(formula);
            if (costDriverIds == null || !costDriverIds.contains(CostDriverIdConstant.MAT_QUOTA_ACA)) continue;
            matQuotaCostDriverIds.add(costDriver.getLong("id"));
        }
        return matQuotaCostDriverIds;
    }

    private static List<Long> getCostDriverIds(String formula) {
        String[] formulaArr;
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return null;
        }
        String formulaString = formula.replaceAll("\\s*", "");
        ArrayList<Long> costDriverIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)formulaString) && (formulaArr = formulaString.split("\\D")) != null) {
            for (String id : formulaArr) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                costDriverIds.add(Long.valueOf(id));
            }
        }
        return costDriverIds;
    }

    private void f7FilterCostCenterGroup(String costCenterGroup) {
        BasedataEdit centerGroupEdit = (BasedataEdit)this.getControl(costCenterGroup);
        centerGroupEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject manuOrg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            if (acctOrg != null) {
                boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrg.getLong("id"));
                QFilter qFilter = new QFilter("org", "=", acctOrg.getPkValue());
                if (isEnableMultiFactory) {
                    qFilter.and(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
                }
                filters.add(qFilter);
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            filters.add(dateFilter);
            filterParameter.setQFilters(filters);
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchfillentry": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"entryentity", (String[])new String[]{"costdriver"});
                break;
            }
            case "addentryrow": 
            case "delentryrow": 
            case "addsubentry": {
                this.hideSubEntryEdit();
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long id = this.getModel().getDataEntity().getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id) && CadEmptyUtils.isEmpty((String)this.getPageCache().get(ISINITED))) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String costCenterId = (String)fsp.getCustomParam("costcenter");
            this.getModel().setValue("costcenter", (Object)costCenterId);
            String manuorgId = (String)fsp.getCustomParam("manuorg");
            if (StringUtils.isNotEmpty((CharSequence)manuorgId)) {
                this.getModel().setValue("manuorg", (Object)Long.valueOf(manuorgId));
            }
            this.getPageCache().put(ISINITED, "true");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideFields();
        this.hideCenterGroupFields();
        this.hideEntryFields();
        this.hideSubEntryFields();
        this.hideSubEntryEdit();
        this.enableManuOrg();
        this.changManuorgStatus();
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.setDefaultValueOnAdd();
        this.getModel().setDataChanged(false);
    }

    private void setDefaultValueOnAdd() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.getModel().setValue("issender", (Object)true);
            this.getModel().setValue("isexpense", (Object)true);
            String allocMold = this.getModel().getDataEntity().getString("allocmold");
            if ("B".equals(allocMold)) {
                this.getModel().setValue("isbeneficiary", (Object)false);
            } else {
                this.getModel().setValue("isbeneficiary", (Object)true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "allocmold": {
                this.getModel().setValue("costcenter", (Object)"");
                this.getModel().setValue("allocdim", null);
                this.deleteEntryEntityAndAddNewRow();
                this.hideFields();
                break;
            }
            case "org": {
                this.enableManuOrg();
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costcenter", null);
                this.getModel().setValue("costcentergroup", null);
                break;
            }
            case "issender": {
                this.hideCenterGroupFields();
                break;
            }
            case "isexpense": {
                this.deleteEntryEntityAndAddNewRow();
                this.hideEntryFields();
                break;
            }
            case "isbeneficiary": {
                this.hideSubEntryFields();
                this.getModel().deleteEntryData("subentryentity");
                this.hideSubEntryEdit();
                break;
            }
        }
    }

    private void hideSubEntryEdit() {
        DynamicObjectCollection subEntryEntity;
        boolean isBeneficiary = (Boolean)this.getModel().getValue("isbeneficiary");
        boolean isEnable = true;
        if (!isBeneficiary && (subEntryEntity = this.getModel().getEntryEntity("subentryentity")).size() > 0) {
            isEnable = false;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"addsubentry", "deletesubentry"});
    }

    private void hideSubEntryFields() {
        boolean isBeneficiary = (Boolean)this.getModel().getValue("isbeneficiary");
        this.getView().setVisible(Boolean.valueOf(isBeneficiary), new String[]{"benefcostcenter", "benfcostcentername"});
        this.getView().setVisible(Boolean.valueOf(!isBeneficiary), new String[]{"centergroup", "centergroupname"});
    }

    private void hideEntryFields() {
        boolean isExpense = (Boolean)this.getModel().getValue("isexpense");
        this.getView().setVisible(Boolean.valueOf(isExpense), new String[]{"expenseitem"});
        this.getView().setVisible(Boolean.valueOf(!isExpense), new String[]{"subelement"});
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        BasedataEdit subElement = (BasedataEdit)this.getControl("subelement");
        expenseItem.setMustInput(isExpense);
        subElement.setMustInput(!isExpense);
    }

    private void hideCenterGroupFields() {
        boolean isBeneFiciary = (Boolean)this.getModel().getValue("issender");
        if (isBeneFiciary) {
            this.getModel().setValue("costcentergroup", null);
        } else {
            this.getModel().setValue("costcenter", null);
        }
        this.getView().setVisible(Boolean.valueOf(isBeneFiciary), new String[]{"costcenter"});
        this.getView().setVisible(Boolean.valueOf(!isBeneFiciary), new String[]{"costcentergroup"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private int getEnableMulFactory(Long orgId) {
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)true, (String)this.getView().getFormShowParameter().getAppId());
        int i = 0;
        for (DynamicObject obj : costAccounts) {
            if (!CostAccountHelper.isEnableMulFactory((Long)obj.getLong("id"))) continue;
            ++i;
        }
        if (i == costAccounts.size()) {
            i = Integer.MAX_VALUE;
        }
        return i;
    }

    private void deleteEntryEntityAndAddNewRow() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity");
        if (subEntryEntity != null) {
            this.getModel().deleteEntryData("subentryentity");
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryEntity.addNew();
        this.getView().updateView("entryentity");
    }

    private void f7FilterSelectedItems(String controlName) {
        BasedataEdit productGroupEdit = (BasedataEdit)this.getControl(controlName);
        productGroupEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> productGroupFilters = new ArrayList<QFilter>();
            ArrayList<Long> selectedExpenseItemIds = new ArrayList<Long>();
            DynamicObjectCollection entryInfos = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryInfos.size(); ++index) {
                DynamicObject rowObject = (DynamicObject)entryInfos.get(index);
                DynamicObject productGroup = (DynamicObject)rowObject.get(controlName);
                if (productGroup == null) continue;
                selectedExpenseItemIds.add(productGroup.getLong("masterid"));
            }
            QFilter selectedExpenseItemFilter = new QFilter("masterid", "not in", (Object)selectedExpenseItemIds.toArray());
            if ("productgroup".equals(controlName)) {
                QFilter otherFilter = new QFilter("grouptype", "=", (Object)"3");
                productGroupFilters.add(otherFilter);
            }
            if ("expenseitem".equals(controlName)) {
                QFilter isleafFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
                productGroupFilters.add(isleafFilter);
            }
            productGroupFilters.add(selectedExpenseItemFilter);
            filterParameter.setQFilters(productGroupFilters);
        });
        productGroupEdit.addAfterF7SelectListener(evt -> this.deleteEntryrow());
    }

    private void hideFields() {
        Boolean isAssistProduct;
        HashMap<String, LocaleString> itemMap = new HashMap<String, LocaleString>(3);
        itemMap.put("A", new LocaleString(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d", (String)"MfgFeeAllocStdEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0])));
        itemMap.put("B", new LocaleString(ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7\u5206\u914d", (String)"MfgFeeAllocStdEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0])));
        itemMap.put("C", new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d", (String)"MfgFeeAllocStdEditPlugin_3", (String)"macc-sca-form", (Object[])new Object[0])));
        this.ecaHideItem(itemMap, "B", "allocmold");
        itemMap.clear();
        itemMap.put("NO_WORK", new LocaleString(ResManager.loadKDString((String)"\u5f53\u671f\u65e0\u5de5\u65f6\u6295\u5165\u6267\u884c", (String)"MfgFeeAllocStdEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0])));
        itemMap.put("NO_COM", new LocaleString(ResManager.loadKDString((String)"\u5f53\u671f\u65e0\u5b8c\u5de5\u6267\u884c\u3002", (String)"MfgFeeAllocStdEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0])));
        this.ecaHideItem(itemMap, "NO_COM", "execondition");
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (allocMold == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"noproduction"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"execondition"});
            return;
        }
        Boolean isBasicProduct = ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold);
        if (!isBasicProduct.booleanValue()) {
            this.getModel().setValue("execondition", null);
        }
        if ((isAssistProduct = Boolean.valueOf(ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold))).booleanValue()) {
            this.getModel().setValue("issender", (Object)Boolean.TRUE);
        }
        this.getView().setVisible(Boolean.valueOf(isAssistProduct == false), new String[]{"isbeneficiary"});
        if (isAssistProduct.booleanValue()) {
            this.getModel().setValue("isexpense", (Object)Boolean.TRUE);
            this.getModel().setValue("isbeneficiary", null);
        }
        this.getView().setVisible(Boolean.valueOf(isAssistProduct == false), new String[]{"issender", "isexpense"});
        this.getView().setEnable(Boolean.valueOf(isAssistProduct == false), new String[]{"issender"});
        this.getView().setVisible(isBasicProduct, new String[]{"noproduction"});
        this.getView().setVisible(isBasicProduct, new String[]{"execondition"});
        Boolean isAuxProduct = ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold);
        this.getView().setVisible(Boolean.valueOf(isAuxProduct == false), new String[]{"benifitcostcenterplane"});
        this.getView().setEnable(Boolean.valueOf(isAuxProduct == false), new String[]{"addentryrow"});
        this.getView().setEnable(Boolean.valueOf(isAuxProduct == false), new String[]{"delentryrow"});
        this.getView().setEnable(Boolean.valueOf(isAuxProduct == false), new String[]{"batchfillentry"});
        this.getView().setVisible(Boolean.valueOf(!AppIdHelper.isSCA((IFormView)this.getView()) && isAuxProduct == false), new String[]{"allocdim"});
    }

    private void ecaHideItem(Map<String, LocaleString> itemMap, String field, String key) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(itemMap.size());
        for (Map.Entry<String, LocaleString> entry : itemMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            item.setItemVisible(!field.equals(entry.getKey()) || !"eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView())));
            comboItems.add(item);
        }
        ComboEdit allocMoldCom = (ComboEdit)this.getControl(key);
        allocMoldCom.setComboItems(comboItems);
    }

    private void deleteEntryrow() {
        DynamicObjectCollection entityCols;
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        Boolean isAuxProduct = ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold);
        if (isAuxProduct.booleanValue() && (entityCols = this.getModel().getEntryEntity("entryentity")).size() > 1) {
            for (int i = entityCols.size() - 1; i > 0; --i) {
                entityCols.remove(i);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void enableManuOrg() {
        DynamicObject obj = this.getModel().getDataEntity().getDynamicObject("org");
        if (obj == null) {
            return;
        }
        Long orgId = obj.getLong("id");
        boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!enableMultiFactory) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            this.getModel().setValue("manuorg", null);
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            manuorgEdit.setMustInput(false);
        } else {
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            manuorgEdit.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"manuorg"});
        }
    }

    private void setCostCenterFilter() {
        Object allocMold = this.getModel().getDataEntity().get("allocmold");
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            if (ScaAllocEnum.NON_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "not in", Arrays.asList(DutyIdConstants.BASIC_PRODUCT_ID, DutyIdConstants.ASSIST_PRODUCT_ID)));
            }
            if (ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.ASSIST_PRODUCT_ID));
            }
            if (ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.BASIC_PRODUCT_ID));
            }
        });
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

